/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.cnes.backend.controller;

import br.com.elotech.websaude.integracao.cnes.backend.model.dao.Conexao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MicroareaController {
    PreparedStatement pstmt;

    public void inativarTodos() throws SQLException {
        Conexao.CONN.prepareStatement("UPDATE microarea SET ativo = false").executeUpdate();
    }

    public void cadastrarMicroarea(int co_seq_equipe, String microarea, int usr_codigo, boolean ativo) throws SQLException {
        int mic_codigo = this.verificaSeExiste(co_seq_equipe, microarea, usr_codigo);
        String sql = "INSERT INTO microarea(mic_descricao,co_seq_equipe,mic_responsavel,ativo) VALUES(?,?,?,?)";
        if (mic_codigo == 0) {
            this.pstmt = Conexao.CONN.prepareStatement(sql);
        } else {
            sql = "UPDATE microarea SET mic_descricao=?,co_seq_equipe=?,mic_responsavel=?,ativo=? WHERE mic_codigo=?";
            this.pstmt = Conexao.CONN.prepareStatement(sql);
            this.pstmt.setInt(5, mic_codigo);
        }
        this.pstmt.setString(1, microarea);
        this.pstmt.setInt(2, co_seq_equipe);
        this.pstmt.setInt(3, usr_codigo);
        this.pstmt.setBoolean(4, ativo);
        this.pstmt.executeUpdate();
        Conexao.CONN.commit();
    }

    private int verificaSeExiste(int co_seq_equipe, String microarea, int usr_codigo) throws SQLException {
        this.pstmt = Conexao.CONN.prepareStatement("SELECT mic_codigo FROM microarea WHERE co_seq_equipe=? AND mic_responsavel=? AND mic_descricao=?");
        this.pstmt.setInt(1, co_seq_equipe);
        this.pstmt.setInt(2, usr_codigo);
        this.pstmt.setString(3, microarea);
        ResultSet rs = this.pstmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("mic_codigo");
        }
        return 0;
    }
}

