/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.cnes.backend.controller;

import br.com.elotech.websaude.integracao.cnes.backend.controller.MedicoController;
import br.com.elotech.websaude.integracao.cnes.backend.controller.MicroareaController;
import br.com.elotech.websaude.integracao.cnes.backend.controller.TbEquipeController;
import br.com.elotech.websaude.integracao.cnes.backend.controller.UnidadeComplexidadeController;
import br.com.elotech.websaude.integracao.cnes.backend.controller.UsuariosEquipeController;
import br.com.elotech.websaude.integracao.cnes.backend.model.Estabelecimento;
import br.com.elotech.websaude.integracao.cnes.backend.model.dao.Conexao;
import br.com.elotech.websaude.integracao.cnes.backend.util.Ibge;
import br.com.elotech.websaude.integracao.cnes.ui.EstabelecimentoXML;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UnidadeController {
    PreparedStatement pstmt;

    public List<Estabelecimento> dadosGeraisEstabelecimentos(List<Estabelecimento> estabelecimentos, List<Estabelecimento> listaPrestadores) throws SQLException {
        HashMap mapaPrestador = new HashMap();
        TbEquipeController equipes = new TbEquipeController();
        equipes.inativarEquipes();
        UnidadeComplexidadeController unidadeComplexidade = new UnidadeComplexidadeController();
        unidadeComplexidade.inativaUnidadeComplexidade();
        UsuariosEquipeController usuariosEquipeController = new UsuariosEquipeController();
        usuariosEquipeController.excluirTodosCnes();
        MicroareaController microareaController = new MicroareaController();
        microareaController.inativarTodos();
        this.inativarUnidades();
        for (Estabelecimento e : estabelecimentos) {
            if (!listaPrestadores.contains(e)) {
                int uniCodigo = this.getUnidadeByCnes(e.cnes.trim());
                String sql = "";
                sql = uniCodigo > 0 ? "UPDATE unidade SET cnes_unidade_id=?, uni_cnes=?, cnes_cnpj_mant=?, cnes_pfpj_ind=?, cnes_nivel_dep=?, cnes_r_social=?, uni_desc=?, uni_endereco=?, uni_numero=?, cnes_complement=?, cnes_bairro=?, uni_cep=?, cnes_reg_saude=?, cnes_micro_reg=?, cnes_dist_sanit=?, cnes_dist_admin=?, cnes_telefone=?, cnes_fax=?, cnes_e_mail=?, cnes_cpf=?, uni_cnpj=?, cnes_cod_ativ=?, cnes_cod_client=?, cnes_num_alvara=?, cnes_data_exped=?, cnes_ind_orgexp=?, cnes_tp_unid_id=?, cnes_cod_turnat=?, cnes_sigestgest=?, cnes_codmungest=?, cnes_statusmov=?, cnes_data_atu=?, cnes_usuario=?, cnes_d_tercsih=?, uni_cnes_importacao=true,cnes_ativo='A',uni_codigo_ibge=?,uni_as='false' WHERE uni_codigo=" + uniCodigo : "INSERT INTO unidade(cnes_unidade_id, uni_cnes, cnes_cnpj_mant, cnes_pfpj_ind, cnes_nivel_dep, cnes_r_social, uni_desc, uni_endereco, uni_numero, cnes_complement, cnes_bairro, uni_cep, cnes_reg_saude, cnes_micro_reg, cnes_dist_sanit, cnes_dist_admin, cnes_telefone, cnes_fax, cnes_e_mail, cnes_cpf, uni_cnpj, cnes_cod_ativ, cnes_cod_client, cnes_num_alvara, cnes_data_exped, cnes_ind_orgexp, cnes_tp_unid_id, cnes_cod_turnat, cnes_sigestgest, cnes_codmungest, cnes_statusmov, cnes_data_atu, cnes_usuario, cnes_d_tercsih,uni_cnes_importacao,cnes_ativo,uni_tipo,uni_codigo_ibge,uni_as) VALUES( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,true,'A','U',?,'false')";
                this.pstmt = Conexao.CONN.prepareStatement(sql);
                this.pstmt.setString(1, Conexao.tratar((String)e.unidadeId, (int)31));
                this.pstmt.setInt(2, Conexao.tratarInt((String)e.cnes));
                this.pstmt.setString(3, Conexao.tratar((String)e.cnpjMant, (int)14));
                this.pstmt.setString(4, Conexao.tratar((String)e.pfpjInd, (int)1));
                this.pstmt.setString(5, Conexao.tratar((String)e.nivelDep, (int)1));
                this.pstmt.setString(6, Conexao.tratar((String)e.rSocial, (int)60));
                this.pstmt.setString(7, Conexao.tratar((String)e.nomeFanta, (int)60));
                this.pstmt.setString(8, e.logradouro);
                this.pstmt.setString(9, Conexao.tratar((String)e.numero, (int)5));
                this.pstmt.setString(10, Conexao.tratar((String)e.complement, (int)60));
                this.pstmt.setString(11, Conexao.tratar((String)e.bairro, (int)60));
                this.pstmt.setString(12, Conexao.tratar((String)e.codCep, (int)9));
                this.pstmt.setString(13, Conexao.tratar((String)e.regSaude, (int)4));
                this.pstmt.setString(14, Conexao.tratar((String)e.microReg, (int)6));
                this.pstmt.setString(15, Conexao.tratar((String)e.distSanit, (int)4));
                this.pstmt.setString(16, Conexao.tratar((String)e.distAdmin, (int)4));
                this.pstmt.setString(17, Conexao.tratar((String)e.telefone, (int)40));
                this.pstmt.setString(18, Conexao.tratar((String)e.fax, (int)60));
                this.pstmt.setString(19, Conexao.tratar((String)e.eMail, (int)60));
                this.pstmt.setString(20, Conexao.tratar((String)e.cpf, (int)11));
                this.pstmt.setString(21, Conexao.tratar((String)e.cnpj, (int)25));
                this.pstmt.setString(22, Conexao.tratar((String)e.codAtiv, (int)2));
                this.pstmt.setString(23, Conexao.tratar((String)e.codClient, (int)2));
                this.pstmt.setString(24, Conexao.tratar((String)e.numAlvara, (int)60));
                this.pstmt.setDate(25, Conexao.tratarDate((String)e.dataExped));
                this.pstmt.setString(26, Conexao.tratar((String)e.indOrgexp, (int)2));
                this.pstmt.setString(27, Conexao.tratar((String)e.tpUnidId, (int)2));
                this.pstmt.setString(28, Conexao.tratar((String)e.codTurnat, (int)2));
                this.pstmt.setString(29, Conexao.tratar((String)e.sigestgest, (int)2));
                this.pstmt.setString(30, Conexao.tratar((String)e.codmungest, (int)7));
                this.pstmt.setString(31, Conexao.tratar((String)e.statusmov, (int)1));
                this.pstmt.setDate(32, Conexao.tratarDate((String)e.dataAtu));
                this.pstmt.setString(33, Conexao.tratar((String)e.usuario, (int)12));
                this.pstmt.setString(34, Conexao.tratar((String)e.dTercsih, (int)1));
                this.pstmt.setString(35, Ibge.valida((String)Conexao.tratar((String)e.codmungest, (int)7)));
                this.pstmt.executeUpdate();
                Conexao.CONN.commit();
            }
            int uni_codigo = this.getUnidadeByCnes(e.cnes.trim());
            equipes.cadastraEquipe(e, uni_codigo);
        }
        MedicoController mc = new MedicoController();
        mc.prestadorDeServico(listaPrestadores);
        return listaPrestadores;
    }

    private void inativarUnidades() throws SQLException {
        Conexao.CONN.prepareStatement("UPDATE unidade SET cnes_ativo = 'I' WHERE uni_cnes_importador_ignorar=false AND uni_as <> true").executeUpdate();
    }

    public int getUnidadeByCnes(String cnes) throws SQLException {
        int result = 0;
        PreparedStatement pstmt = Conexao.CONN.prepareStatement("SELECT uni_codigo FROM unidade WHERE uni_cnes=" + cnes.trim() + " AND uni_cnes_importador_ignorar=false ORDER BY uni_codigo DESC LIMIT 1");
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            return rs.getInt("uni_codigo");
        }
        return result;
    }

    public List<EstabelecimentoXML> dadosEstabelecimentoXML(List<Estabelecimento> estabelecimentos) throws SQLException {
        ArrayList<EstabelecimentoXML> lista = new ArrayList<EstabelecimentoXML>();
        for (Estabelecimento e : estabelecimentos) {
            EstabelecimentoXML exml;
            this.pstmt = Conexao.CONN.prepareStatement("SELECT uni_codigo FROM unidade WHERE uni_cnes=? AND uni_cnes_importador_ignorar=false AND uni_cnes_importacao=false AND cnes_ativo is not null ORDER BY cnes_ativo,uni_codigo DESC LIMIT 1");
            this.pstmt.setInt(1, Integer.valueOf(e.cnes));
            ResultSet rs = this.pstmt.executeQuery();
            if (rs.next()) {
                exml = new EstabelecimentoXML();
                exml.setE(e);
                exml.setNomeFantasia(e.nomeFanta);
                exml.setRazaoSocial(e.rSocial);
                exml.setCnes(e.cnes);
                exml.setCnpj(e.cnpj);
                exml.setEhPrestador(false);
                lista.add(exml);
                continue;
            }
            this.pstmt = Conexao.CONN.prepareStatement("SELECT med_codigo FROM medico WHERE cnes=? AND (med_cnes_importacao = false OR med_cnes_importacao is null)");
            this.pstmt.setInt(1, Integer.valueOf(e.cnes));
            ResultSet rs1 = this.pstmt.executeQuery();
            if (rs.next()) {
                exml = new EstabelecimentoXML();
                exml.setE(e);
                exml.setNomeFantasia(e.nomeFanta);
                exml.setRazaoSocial(e.rSocial);
                exml.setCnpj(e.cnpj);
                exml.setCnes(e.cnes);
                exml.setEhPrestador(true);
                lista.add(exml);
                continue;
            }
            this.pstmt = Conexao.CONN.prepareStatement("SELECT uni_codigo FROM unidade WHERE uni_cnes=? AND uni_cnes_importador_ignorar=false AND uni_cnes_importacao=true");
            this.pstmt.setInt(1, Integer.valueOf(e.cnes));
            ResultSet rs2 = this.pstmt.executeQuery();
            if (rs2.next()) continue;
            this.pstmt = Conexao.CONN.prepareStatement("SELECT med_codigo,med_cnes_importacao FROM medico WHERE cnes=?");
            this.pstmt.setInt(1, Integer.valueOf(e.cnes));
            ResultSet rs3 = this.pstmt.executeQuery();
            if (rs3.next()) {
                if (rs3.getBoolean("med_cnes_importacao")) continue;
                exml = new EstabelecimentoXML();
                exml.setE(e);
                exml.setNomeFantasia(e.nomeFanta);
                exml.setRazaoSocial(e.rSocial);
                exml.setCnpj(e.cnpj);
                exml.setCnes(e.cnes);
                exml.setEhPrestador(true);
                lista.add(exml);
                continue;
            }
            this.pstmt = Conexao.CONN.prepareStatement("SELECT count(*) FROM medico WHERE cnes=" + e.cnes + " AND med_cnes_importacao<>true");
            rs3 = this.pstmt.executeQuery();
            if (!rs3.next()) continue;
            exml = new EstabelecimentoXML();
            exml.setE(e);
            exml.setNomeFantasia(e.nomeFanta);
            exml.setRazaoSocial(e.rSocial);
            exml.setCnpj(e.cnpj);
            exml.setCnes(e.cnes.trim());
            exml.setEhPrestador(true);
            lista.add(exml);
        }
        return lista;
    }

    public List<Estabelecimento> dadosPrestadoresExistentes(List<Estabelecimento> estabelecimentos) throws SQLException {
        ArrayList<Estabelecimento> est = new ArrayList<Estabelecimento>();
        for (Estabelecimento e : estabelecimentos) {
            this.pstmt = Conexao.CONN.prepareStatement("SELECT med.med_codigo FROM medico med WHERE med.cnes=? AND med.med_cnes_importacao=true");
            this.pstmt.setInt(1, Integer.valueOf(e.cnes));
            ResultSet rs = this.pstmt.executeQuery();
            if (!rs.next() || rs.getInt("med_codigo") <= 0) continue;
            est.add(e);
        }
        return est;
    }
}

