/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.cnes.backend.model.dao;

import com.vaadin.ui.Notification;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Conexao {
    public static Connection CONN;
    protected static final String DRIVER = "org.postgresql.Driver";

    public static synchronized boolean abrirConexao(String[] args) {
        try {
            Class.forName(DRIVER);
            CONN = DriverManager.getConnection("jdbc:postgresql://" + args[0] + "?currentSchema=social", args[1], args[2]);
            CONN.createStatement().execute("set search_path to 'social'");
            CONN.setAutoCommit(false);
            return true;
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(Conexao.class.getName()).log(Level.SEVERE, null, ex);
            Notification.show((String)"Ocorreu um erro!", (String)("Por favor, contacte o suporte para reportar.\n" + ex.getMessage()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return false;
        }
    }

    public static synchronized void fecharConexao() {
        if (CONN != null) {
            try {
                if (!CONN.isClosed()) {
                    CONN.close();
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Conexao.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static synchronized String tratar(String unidadeId, int par) {
        if (unidadeId == null) {
            return null;
        }
        if (unidadeId.length() > par) {
            unidadeId = unidadeId.substring(0, par);
        }
        return unidadeId;
    }

    public static synchronized int tratarInt(String cnes) {
        if (cnes == null) {
            return 0;
        }
        for (char c : cnes.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return 0;
        }
        if (cnes.length() > 0) {
            return Integer.parseInt(cnes);
        }
        return 0;
    }

    public static synchronized java.sql.Date tratarDate(String dataExped) {
        if (dataExped == null) {
            return null;
        }
        if (dataExped.length() != 10) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        try {
            Date utilDate = format.parse(dataExped);
            return new java.sql.Date(utilDate.getTime());
        }
        catch (ParseException e) {
            return null;
        }
    }
}

