/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.cnes.ui;

import br.com.elotech.websaude.integracao.cnes.backend.controller.UnidadeController;
import br.com.elotech.websaude.integracao.cnes.backend.controller.UsuariosController;
import br.com.elotech.websaude.integracao.cnes.backend.model.Estabelecimento;
import br.com.elotech.websaude.integracao.cnes.backend.model.Root;
import br.com.elotech.websaude.integracao.cnes.backend.model.dao.Conexao;
import br.com.elotech.websaude.integracao.cnes.ui.Application;
import br.com.elotech.websaude.integracao.cnes.ui.CnesUploader;
import br.com.elotech.websaude.integracao.cnes.ui.EloButton;
import br.com.elotech.websaude.integracao.cnes.ui.EstabelecimentoXML;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.data.ValueProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

/*
 * Exception performing whole class analysis ignored.
 */
@Title(value="Elotech - WebSocialSa\u00fade Integra\u00e7\u00e3o CNES")
@Theme(value="valo")
@SpringUI
public class MainUI
extends UI {
    private static final long serialVersionUID = 1L;
    private static Root root;
    public static Grid<EstabelecimentoXML> grid;
    protected static List<EstabelecimentoXML> prestadores;
    private Label instrucoes;
    private CnesUploader cnesUploader = new CnesUploader();
    private VerticalLayout layout = new VerticalLayout();
    private Button btnProcessar = new Button("Processar ...", (Resource)VaadinIcons.ARROW_DOWN);
    private Label label = new Label("Bem Vindo ao Assistente de Importa\u00e7\u00e3o do CNES!");
    private ProgressBar progresso = new ProgressBar();
    private Upload upload;
    private boolean status = false;

    protected void init(VaadinRequest request) {
        Application.args = new String[]{request.getParameter("url"), request.getParameter("u"), request.getParameter("s")};
        this.progresso.setVisible(false);
        this.progresso.setWidth(250.0f, Sizeable.Unit.PIXELS);
        this.layout.addComponent((Component)this.label);
        this.carregarUploadComponent();
        this.layout.addComponent((Component)this.upload);
        this.layout.addComponent((Component)this.progresso);
        this.instrucoes = new Label("<center>Ao aparecer a tabela, selecione a linha para obter a op\u00e7\u00e3o de editar o registro, <br/>indicando se \u00e9 ou n\u00e3o prestador determinada unidade, est\u00e1 op\u00e7\u00e3o estar\u00e1 dispon\u00edvel somente a primeira vez em que <br/>executar o importador ou quando possuir novas unidades v\u00ednculadas. <br/>Na pr\u00f3xima vez, que executar o mesmo n\u00e3o ir\u00e1 mais solicitar, carregando a op\u00e7\u00e3o desejada anteriormente automaticamente. <br/>Este passo \u00e9 obrigat\u00f3rio devido ao XML do CNES n\u00e3o exportar mais a informa\u00e7\u00e3o sobre quem \u00e9 ou n\u00e3o prestador. <br/>O arquivo XML deve ser gerado por meio do programa desktop do CNES.</center>");
        this.layout.addComponent((Component)this.instrucoes);
        this.instrucoes.setContentMode(ContentMode.HTML);
        this.layout.setComponentAlignment((Component)this.instrucoes, Alignment.TOP_CENTER);
        this.layout.setComponentAlignment((Component)this.upload, Alignment.TOP_CENTER);
        this.layout.setComponentAlignment((Component)this.progresso, Alignment.TOP_CENTER);
        this.layout.setComponentAlignment((Component)this.label, Alignment.TOP_CENTER);
        this.setContent((Component)this.layout);
        this.btnProcessar.addClickListener((Button.ClickListener & Serializable)e -> {
            this.btnProcessarAction();
            if (grid != null) {
                this.layout.removeComponent((Component)grid);
            }
            this.layout.removeComponent((Component)this.btnProcessar);
        });
    }

    private void carregarUploadComponent() {
        this.upload = new Upload("Upload do arquivo CNES XML", (Upload.Receiver)this.cnesUploader);
        this.upload.setStyleName("tiny");
        this.upload.setIcon((Resource)VaadinIcons.UPLOAD);
        this.upload.setImmediateMode(true);
        JavaScript.getCurrent().execute("document.getElementsByClassName('gwt-FileUpload')[0].setAttribute('accept', '.XML')");
        this.carregarUploadEvents(this.upload);
    }

    private void carregarUploadEvents(Upload upload) {
        upload.addStartedListener((Upload.StartedListener)new /* Unavailable Anonymous Inner Class!! */);
        upload.addProgressListener((Upload.ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
        upload.addSucceededListener((Upload.SucceededListener)new /* Unavailable Anonymous Inner Class!! */);
        upload.addFailedListener((Upload.FailedListener)new /* Unavailable Anonymous Inner Class!! */);
        upload.addFinishedListener((Upload.FinishedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void uploadExecutado(Upload.SucceededEvent event) {
        this.progresso.setCaption("Upload \"" + event.getFilename() + "\" realizado");
        this.progresso.setValue(1.0f);
        this.iniciarProcesso();
        if (this.status) {
            if (grid != null) {
                this.layout.addComponent((Component)grid);
                if (grid.getHeaderRowCount() < 1) {
                    this.btnProcessarAction();
                    if (grid != null) {
                        this.layout.removeComponent((Component)grid);
                    }
                    this.layout.removeComponent((Component)this.btnProcessar);
                }
            }
        } else {
            this.btnProcessarAction();
            if (grid != null) {
                this.layout.removeComponent((Component)grid);
            }
            this.layout.removeComponent((Component)this.btnProcessar);
        }
    }

    public Grid createEhPrestador(List<EstabelecimentoXML> items) {
        if (items != null && !items.isEmpty()) {
            grid = new Grid();
            grid.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
            grid.setItems(items);
            this.status = true;
            Grid.Column column = grid.addComponentColumn((ValueProvider & Serializable)p -> new EloButton(p.ehPrestador ? "Sim" : "N\u00e3o", (Button.ClickListener & Serializable)e -> {
                p.setEhPrestador(!p.ehPrestador);
                e.getButton().setCaption(p.ehPrestador ? "Sim" : "N\u00e3o");
            }));
            column.setCaption("Prestador?");
            grid.addColumn(EstabelecimentoXML::getCnes).setCaption("CNES");
            grid.addColumn(EstabelecimentoXML::getCnpj).setCaption("CNPJ");
            grid.addColumn(EstabelecimentoXML::getNomeFantasia).setCaption("Nome Fantasia");
            grid.addColumn(EstabelecimentoXML::getRazaoSocial).setCaption("Raz\u00e3o Social");
            grid.setStyleName("small");
            grid.setFrozenColumnCount(1);
            grid.getEditor().setEnabled(true);
            grid.getEditor().setSaveCaption("Salvar");
            grid.getEditor().setCancelCaption("Cancelar");
            grid.getEditor().setBuffered(false);
            return grid;
        }
        return null;
    }

    private void iniciarProcesso() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Root.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Root config = (Root)jaxbUnmarshaller.unmarshal(CnesUploader.file);
            Conexao.abrirConexao((String[])Application.args);
            prestadores = MainUI.preProcessar((Root)config);
            grid = this.createEhPrestador(prestadores);
            this.layout.addComponent((Component)this.btnProcessar);
            this.layout.setComponentAlignment((Component)this.btnProcessar, Alignment.TOP_CENTER);
            if (grid != null) {
                this.layout.addComponent((Component)grid);
            }
            Conexao.fecharConexao();
        }
        catch (Exception ex) {
            Conexao.fecharConexao();
            Logger.getLogger(MainUI.class.getName()).log(Level.SEVERE, null, ex);
            Notification.show((String)"Ocorreu um erro!", (String)("Por favor, contacte o suporte para reportar.\n" + ex.getMessage()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
        if (CnesUploader.file.exists()) {
            CnesUploader.file.delete();
        }
    }

    private static void processar(Root root) throws SQLException {
        if (root != null) {
            UsuariosController usuariosController = new UsuariosController();
            usuariosController.inativarUsuarios();
            UnidadeController estabelecimentoController = new UnidadeController();
            ArrayList<Estabelecimento> prestadores = new ArrayList<Estabelecimento>();
            if (MainUI.prestadores != null) {
                for (EstabelecimentoXML exml : MainUI.prestadores) {
                    if (!exml.isEhPrestador()) continue;
                    prestadores.add(exml.e);
                }
                prestadores.addAll(estabelecimentoController.dadosPrestadoresExistentes(MainUI.root.estabelecimentos));
                estabelecimentoController.dadosGeraisEstabelecimentos(root.estabelecimentos, prestadores);
                usuariosController.dadosProfissionais(MainUI.root.estabelecimentos, prestadores, 0);
            } else {
                Notification.show((String)"Arquivo XML Inv\u00e1lido ou N\u00e3o possu\u00ed Dados!", (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        }
    }

    private static List<EstabelecimentoXML> preProcessar(Root root) throws SQLException {
        if (root != null) {
            UnidadeController estabelecimentoController = new UnidadeController();
            MainUI.root = root;
            return estabelecimentoController.dadosEstabelecimentoXML(root.estabelecimentos);
        }
        return new ArrayList<EstabelecimentoXML>();
    }

    private void btnProcessarAction() {
        try {
            Conexao.abrirConexao((String[])Application.args);
            MainUI.processar((Root)root);
            Conexao.CONN.commit();
            Notification.show((String)"Importa\u00e7\u00e3o realizada com sucesso!", (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
            if (grid != null) {
                this.layout.removeComponent((Component)grid);
            }
            this.layout.removeComponent((Component)this.btnProcessar);
        }
        catch (SQLException ex) {
            Notification.show((String)"Ocorreu um erro!", (String)("Por favor, contacte o suporte para reportar.\n" + ex.getMessage()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            Logger.getLogger(MainUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            Conexao.fecharConexao();
        }
        this.layout.addComponent((Component)this.btnProcessar);
        this.layout.setComponentAlignment((Component)this.btnProcessar, Alignment.TOP_CENTER);
        if (grid != null) {
            this.layout.addComponent((Component)grid);
        }
        this.upload.setVisible(false);
        this.instrucoes.setValue("Processo Conclu\u00eddo!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MainUI)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MainUI that = (MainUI)o;
        if (this.instrucoes != null ? !this.instrucoes.equals((Object)that.instrucoes) : that.instrucoes != null) {
            return false;
        }
        return this.upload != null ? this.upload.equals((Object)that.upload) : that.upload == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.instrucoes != null ? this.instrucoes.hashCode() : 0);
        result = 31 * result + (this.cnesUploader != null ? this.cnesUploader.hashCode() : 0);
        result = 31 * result + (this.layout != null ? this.layout.hashCode() : 0);
        result = 31 * result + (this.btnProcessar != null ? this.btnProcessar.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.progresso != null ? this.progresso.hashCode() : 0);
        result = 31 * result + (this.upload != null ? this.upload.hashCode() : 0);
        result = 31 * result + (this.status ? 1 : 0);
        return result;
    }

    static /* synthetic */ ProgressBar access$000(MainUI x0) {
        return x0.progresso;
    }

    static /* synthetic */ void access$100(MainUI x0, Upload.SucceededEvent x1) {
        x0.uploadExecutado(x1);
    }

    static {
        grid = null;
    }
}

