/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.config;

import br.com.elotech.Main;
import br.com.elotech.config.ConnectionUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DadosBasicos {
    private static final int SEM_USUARIOS = 0;
    private String usuario;
    private String unidade;
    private String setor;
    private String especialidade;
    private String secretaria;
    private String prefeitura;
    private String endereco;
    private String cidade;

    public DadosBasicos() throws SQLException {
        StringBuilder sql = new StringBuilder();
        Integer usuario = Main.usrLogado;
        if (usuario != 0) {
            sql.append(" SELECT").append("   trim(usr.usr_nome) as usuario,").append("   UPPER(trim(uni.uni_desc)) as unidade,").append("   trim(coalesce(setor.set_nome, 'N\u00e3o informado')) as setor, ").append("   trim(coalesce(esp.esp_nome, 'N\u00e3o informado')) as especialidade, ").append("   UPPER(trim(sec.nome_secretaria)) as secretaria , ").append("   UPPER(trim(sec.nome_cidade)) as cidade , ").append("   UPPER(trim(sec.nome_prefeitura)) as prefeitura, ").append("   trim(concat(uni.uni_endereco, ', ', uni.uni_numero, ' ', uni.uni_bairro)) as endereco ").append(" FROM logon ").append("   JOIN usuarios usr ON usr.usr_codigo = logon.id_login ").append("   LEFT JOIN unidade uni ON uni.uni_codigo = logon.uni_codigo ").append("   LEFT JOIN setor ON setor.set_codigo = logon.cod_setor ").append("   LEFT JOIN especialidade esp ON esp.esp_codigo = logon.esp_codigo ").append("   LEFT JOIN secretaria sec ON sec.sec_as = uni.uni_as OR uni.uni_as IS NULL AND sec.sec_as IS FALSE ").append(" WHERE usr.usr_codigo = ").append(usuario.toString()).append(" ORDER BY id DESC ").append(" LIMIT 1");
        } else {
            sql.append("select UPPER(trim(sec.nome_secretaria)) as secretaria ,").append("       UPPER(trim(sec.nome_cidade)) as cidade ,").append("       UPPER(trim(sec.nome_prefeitura)) as prefeitura").append("  from secretaria sec").append(" where sec.sec_as is null or sec.sec_as is false;");
        }
        Connection conn = ConnectionUtil.getConnection();
        try (PreparedStatement pstm = conn.prepareStatement(sql.toString());){
            ResultSet rs = pstm.executeQuery();
            if (rs.next()) {
                if (usuario != 0) {
                    this.setUsuario(rs.getString("usuario"));
                    this.setUnidade(rs.getString("unidade"));
                    this.setSetor(rs.getString("setor"));
                    this.setEspecialidade(rs.getString("especialidade"));
                    this.setEndereco(rs.getString("endereco"));
                }
                this.setSecretaria(rs.getString("secretaria"));
                this.setPrefeitura(rs.getString("prefeitura"));
                this.setCidade(rs.getString("cidade"));
            }
        }
        catch (SQLException e) {
            throw new SQLException("Erro ao gerar os dados b\u00e1sicos: " + e.getMessage());
        }
    }

    public String getUsuario() {
        return this.usuario;
    }

    public String getUnidade() {
        return this.unidade;
    }

    public String getSetor() {
        return this.setor;
    }

    public String getEspecialidade() {
        return this.especialidade;
    }

    public String getSecretaria() {
        return this.secretaria;
    }

    public String getPrefeitura() {
        return this.prefeitura;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public void setUnidade(String unidade) {
        this.unidade = unidade;
    }

    public void setSetor(String setor) {
        this.setor = setor;
    }

    public void setEspecialidade(String especialidade) {
        this.especialidade = especialidade;
    }

    public void setSecretaria(String secretaria) {
        this.secretaria = secretaria;
    }

    public void setPrefeitura(String prefeitura) {
        this.prefeitura = prefeitura;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DadosBasicos)) {
            return false;
        }
        DadosBasicos other = (DadosBasicos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        String this$unidade = this.getUnidade();
        String other$unidade = other.getUnidade();
        if (this$unidade == null ? other$unidade != null : !this$unidade.equals(other$unidade)) {
            return false;
        }
        String this$setor = this.getSetor();
        String other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        String this$especialidade = this.getEspecialidade();
        String other$especialidade = other.getEspecialidade();
        if (this$especialidade == null ? other$especialidade != null : !this$especialidade.equals(other$especialidade)) {
            return false;
        }
        String this$secretaria = this.getSecretaria();
        String other$secretaria = other.getSecretaria();
        if (this$secretaria == null ? other$secretaria != null : !this$secretaria.equals(other$secretaria)) {
            return false;
        }
        String this$prefeitura = this.getPrefeitura();
        String other$prefeitura = other.getPrefeitura();
        if (this$prefeitura == null ? other$prefeitura != null : !this$prefeitura.equals(other$prefeitura)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        String this$cidade = this.getCidade();
        String other$cidade = other.getCidade();
        return !(this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DadosBasicos;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        String $unidade = this.getUnidade();
        result = result * 59 + ($unidade == null ? 43 : $unidade.hashCode());
        String $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        String $especialidade = this.getEspecialidade();
        result = result * 59 + ($especialidade == null ? 43 : $especialidade.hashCode());
        String $secretaria = this.getSecretaria();
        result = result * 59 + ($secretaria == null ? 43 : $secretaria.hashCode());
        String $prefeitura = this.getPrefeitura();
        result = result * 59 + ($prefeitura == null ? 43 : $prefeitura.hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        String $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        return result;
    }

    public String toString() {
        return "DadosBasicos(usuario=" + this.getUsuario() + ", unidade=" + this.getUnidade() + ", setor=" + this.getSetor() + ", especialidade=" + this.getEspecialidade() + ", secretaria=" + this.getSecretaria() + ", prefeitura=" + this.getPrefeitura() + ", endereco=" + this.getEndereco() + ", cidade=" + this.getCidade() + ")";
    }
}

