/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.dao.impl;

import br.com.elotech.config.ConnectionUtil;
import br.com.elotech.enuns.SistemaEnum;
import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.saude.dao.SaudeDao;
import br.com.elotech.saude.filters.FormatFilters;
import br.com.elotech.saude.model.agendamento.AgendamentoExternoMedico;
import br.com.elotech.saude.model.agendamento.AgendamentoExternoUnidade;
import br.com.elotech.saude.model.agendamento.AgendamentoPorProfissional;
import br.com.elotech.saude.model.agendamento.AgendamentoPorUnidade;
import br.com.elotech.saude.model.agendamento.ConsultasAgendadas;
import br.com.elotech.saude.model.agendamento.FilaDeEspera;
import br.com.elotech.saude.model.bpa.BpaIdade;
import br.com.elotech.saude.model.bpa.ProcedimentosGerais;
import br.com.elotech.saude.model.bpa.ProcedimentosUnidade;
import br.com.elotech.saude.model.farmacia.DispensacaoTipoReceita;
import br.com.elotech.saude.model.filters.EstatisticasAreaMicroAreaFilter;
import br.com.elotech.saude.model.filters.FilaDeEsperaFilter;
import br.com.elotech.saude.model.filters.GuiaEncaminhamentoExternoFilter;
import br.com.elotech.saude.model.filters.PacientesFaixaSexoFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoExternoMedicoFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoExternoUnidadeFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoPorProfissionalFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoPorUnidadeFilter;
import br.com.elotech.saude.model.filters.agendamento.ConsultasAgendadasFilter;
import br.com.elotech.saude.model.filters.bpa.BpaIdadeFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosGeraisFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosUnidadeFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoCriancaFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoFamiliarFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoGestantesPuerperasFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoHdiFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoSaudeBucalFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoSaudeMentalFilter;
import br.com.elotech.saude.model.filters.farmacia.DispensacaoTipoReceitaFilter;
import br.com.elotech.saude.model.filters.laboratorio.ExamesPorPrestadorFilter;
import br.com.elotech.saude.model.filters.materiais.InventarioFilter;
import br.com.elotech.saude.model.filters.materiais.MovimentoSaidaFilter;
import br.com.elotech.saude.model.filters.materiais.SaidaTransferenciaMateriaisFilter;
import br.com.elotech.saude.model.filters.prontuario.LaudoApacFilter;
import br.com.elotech.saude.model.filters.psf.BuscaAtivaFilter;
import br.com.elotech.saude.model.filters.psf.DomicilioVinculadoFilter;
import br.com.elotech.saude.model.filters.psf.VisitaDomiciliarFilter;
import br.com.elotech.saude.model.filters.transporte.ViagemFilter;
import br.com.elotech.saude.model.filters.transporte.ViagensFilter;
import br.com.elotech.saude.model.filters.vacinacao.CarteirinhaVacinacaoFilter;
import br.com.elotech.saude.model.filters.vacinas.AtestadoVacinaFilter;
import br.com.elotech.saude.model.filters.vacinas.ControleVacinadosPorVacinaFilter;
import br.com.elotech.saude.model.laboratorio.ExamesPorPrestador;
import br.com.elotech.saude.model.materiais.Inventario;
import br.com.elotech.saude.model.materiais.MovimentoSaida;
import br.com.elotech.saude.model.materiais.SaidaTransferenciaMateriais;
import br.com.elotech.saude.model.pacientes.PacientesFaixaSexo;
import br.com.elotech.saude.model.prontuario.GuiaEncaminhamentoExterno;
import br.com.elotech.saude.model.prontuario.LaudoApac;
import br.com.elotech.saude.model.psf.areamicroarea.EstatisticasAreaMicroArea;
import br.com.elotech.saude.model.psf.domiciliovinculado.DomicilioVinculado;
import br.com.elotech.saude.model.psf.domiciliovinculado.Participantes;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoCrianca;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoFamiliar;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoGestantesPuerperas;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoHdi;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoSaudeBucal;
import br.com.elotech.saude.model.psf.estratificacao.EstratificacaoSaudeMental;
import br.com.elotech.saude.model.psf.visitadomiciliar.BuscaAtiva;
import br.com.elotech.saude.model.psf.visitadomiciliar.Motivos;
import br.com.elotech.saude.model.psf.visitadomiciliar.VisitaDomiciliar;
import br.com.elotech.saude.model.transporte.Acompanhante;
import br.com.elotech.saude.model.transporte.ListaViagem;
import br.com.elotech.saude.model.transporte.Viagens;
import br.com.elotech.saude.model.vacinacao.Carteirinha;
import br.com.elotech.saude.model.vacinacao.CarteirinhaPaciente;
import br.com.elotech.saude.model.vacinacao.InformacoesCarteirinha;
import br.com.elotech.saude.model.vacinas.AtestadoVacina;
import br.com.elotech.saude.model.vacinas.ControleVacinadosPorVacina;
import br.com.elotech.saude.model.vacinas.VacinaAprazada;
import br.com.elotech.saude.scripts.AgendamentoScript;
import br.com.elotech.saude.scripts.AtestadoVacinaScript;
import br.com.elotech.saude.scripts.BpaScript;
import br.com.elotech.saude.scripts.BuscaAtivaScript;
import br.com.elotech.saude.scripts.CarteirinhaVacinacaoScript;
import br.com.elotech.saude.scripts.ControleVacinadosPorVacinaScript;
import br.com.elotech.saude.scripts.DispensacaoTipoReceitaScript;
import br.com.elotech.saude.scripts.DomicilioVinculadoScript;
import br.com.elotech.saude.scripts.EstatisticasAreaMicroAreaScript;
import br.com.elotech.saude.scripts.EstratificacaoRiscoScript;
import br.com.elotech.saude.scripts.ExamesPorPrestadorScript;
import br.com.elotech.saude.scripts.FilaDeEsperaScript;
import br.com.elotech.saude.scripts.GuiaEncaminhamentoExternoScript;
import br.com.elotech.saude.scripts.InventarioScript;
import br.com.elotech.saude.scripts.LaudoApacScript;
import br.com.elotech.saude.scripts.ListaViagemScript;
import br.com.elotech.saude.scripts.MateriaisScript;
import br.com.elotech.saude.scripts.PacientesFaixaSexoScript;
import br.com.elotech.saude.scripts.SaidaTransferenciaMateriaisScript;
import br.com.elotech.saude.scripts.ViagensScript;
import br.com.elotech.saude.scripts.VisitaDomiciliarScript;
import br.com.elotech.util.JasperCreator;
import br.com.elotech.util.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaudeDaoImpl
implements SaudeDao {
    private Connection conn;
    private ResultSet rs;
    private JasperCreator creator;
    private Map<String, Object> params = new HashMap<String, Object>();

    @Override
    public void agendamentoPorUnidade(AgendamentoPorUnidadeFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("uni_codigo", filter.getUnidade());
        }
        this.rs = Util.resolveResultSet(AgendamentoScript.getSqlAgendamentoPorUnidade(filter), this.params);
        ArrayList<AgendamentoPorUnidade> data = new ArrayList<AgendamentoPorUnidade>();
        while (this.rs.next()) {
            AgendamentoPorUnidade apu = new AgendamentoPorUnidade();
            apu.setUnidade(this.rs.getString("unidade"));
            switch (filter.getTpRel()) {
                case SINTETICO: {
                    apu.setTotal(this.rs.getInt("quantidade"));
                    break;
                }
                case ANALITICO: {
                    apu.setMedico(this.rs.getString("medico"));
                    apu.setPaciente(this.rs.getString("paciente"));
                    apu.setTelefone(this.rs.getString("telefone"));
                    apu.setData(this.rs.getString("data"));
                    apu.setHora(this.rs.getString("hora"));
                }
            }
            data.add(apu);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Agendamento por Unidade";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAgendamentoPorUnidade(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void filaDeEspera(FilaDeEsperaFilter filter) throws Exception {
        if (filter.getFilaCodigo() != null) {
            this.params.put("fila_codigo", filter.getFilaCodigo());
        }
        if (filter.getUsuCodigo() != null) {
            this.params.put("usu_codigo", filter.getUsuCodigo());
        }
        if (filter.getEspCodigo() != null) {
            this.params.put("esp_codigo", filter.getEspCodigo());
        }
        if (filter.getFitiCodigo() != null) {
            this.params.put("fiti_codigo", filter.getFitiCodigo());
        }
        if (filter.getFiprCodigo() != null) {
            this.params.put("fipr_codigo", filter.getFiprCodigo());
        }
        if (filter.getStatus() != null) {
            this.params.put("fiusu_status", filter.getStatus());
        }
        if (filter.getUniCodigo() != null) {
            this.params.put("uni_codigo", filter.getUniCodigo());
        }
        if (filter.getProcCodigo() != null) {
            this.params.put("proc_codigo", filter.getProcCodigo());
        }
        if (filter.getUsrCodigo() != null) {
            this.params.put("usr_codigo", filter.getUsrCodigo());
        }
        if (filter.getDataEntrada() != null) {
            this.params.put("fiusu_data_entrada", Util.dateToTimeStamp(filter.getDataEntrada()));
        }
        this.rs = Util.resolveResultSet(FilaDeEsperaScript.getSql(filter), this.params);
        ArrayList<FilaDeEspera> data = new ArrayList<FilaDeEspera>();
        while (this.rs.next()) {
            FilaDeEspera fe = new FilaDeEspera();
            fe.setFila(this.rs.getString("fila_nome"));
            fe.setOrdem(this.rs.getInt("fiusu_ordem"));
            fe.setUsuario(this.rs.getString("usu_nome"));
            fe.setCartaoSus(this.rs.getString("usu_cartao_sus"));
            fe.setCelular(this.rs.getString("usu_celular"));
            fe.setTelefone(this.rs.getString("usu_fone"));
            fe.setMedicoSolicitante(this.rs.getString("medico_solicitante"));
            fe.setAtendimento(this.rs.getString("fiti_nome"));
            fe.setPrioridade(this.rs.getString("fipr_nome"));
            fe.setDataEntrada(this.rs.getTimestamp("fiusu_data_entrada"));
            fe.setStatus(this.rs.getString("fiusu_status"));
            fe.setProcedimento(this.rs.getString("proc_nome"));
            fe.setEspecialidade(this.rs.getString("especialidade"));
            data.add(fe);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Filas de Espera";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterFilaDeEspera(filter));
        this.creator.addParameter("AGRUPAMENTO", filter.getAgrupamento());
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoHdi(EstratificacaoHdiFilter filter) throws Exception {
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getEquipe() != null) {
            this.params.put("equipe", filter.getEquipe());
        }
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getRisco() != null) {
            this.params.put("risco", filter.getRisco());
        }
        this.rs = Util.resolveResultSet(EstratificacaoRiscoScript.getSqlEstratificacaoHdi(filter), this.params);
        ArrayList<EstratificacaoHdi> data = new ArrayList<EstratificacaoHdi>();
        while (this.rs.next()) {
            EstratificacaoHdi hdi = new EstratificacaoHdi();
            hdi.setUnidade(this.rs.getString("unidade"));
            hdi.setIneEquipe(this.rs.getString("ineEquipe"));
            hdi.setNomeEquipe(this.rs.getString("nomeEquipe"));
            hdi.setMicroArea(this.rs.getString("microArea"));
            hdi.setTpRel(filter.getTpRel().name());
            hdi.setResponsavel(this.rs.getString("responsavel"));
            switch (filter.getTpRel()) {
                case SINTETICO: {
                    hdi.setQtdeHipertenso(this.rs.getInt("qtde_hipertenso"));
                    hdi.setQtdeDiabete(this.rs.getInt("qtde_diabetico"));
                    hdi.setQtdeIdoso(this.rs.getInt("qtde_idoso"));
                    hdi.setFiltroHipertenso(filter.getHipertenso());
                    hdi.setFiltroDiabete(filter.getDiabetico());
                    hdi.setFiltroIdoso(filter.getIdoso());
                    break;
                }
                case ANALITICO: {
                    hdi.setNome(this.rs.getString("nome"));
                    hdi.setDataNascimento(this.rs.getString("dataNascimento"));
                    hdi.setIdade(this.rs.getInt("idade"));
                    hdi.setCns(this.rs.getString("cns"));
                    if (hdi.getIdade() >= 60) {
                        hdi.setIdoso("t");
                    } else {
                        hdi.setIdoso("f");
                    }
                    hdi.setHipertensao(this.rs.getString("hipertenso"));
                    hdi.setDiabete(this.rs.getString("diabetico"));
                    hdi.setRiscoHipertensao(this.rs.getString("riscoHipertensao"));
                    hdi.setRiscoDiabete(this.rs.getString("riscoDiabetes"));
                    hdi.setRiscoIdoso(this.rs.getString("riscoIdoso"));
                    hdi.setFiltroHipertenso(filter.getHipertenso());
                    hdi.setFiltroDiabete(filter.getDiabetico());
                    hdi.setFiltroIdoso(filter.getIdoso());
                }
            }
            data.add(hdi);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name().toLowerCase());
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o Hipertensos, Diab\u00e9ticos e Idosos";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstratificacaoHdi(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoGestantesPuerperas(EstratificacaoGestantesPuerperasFilter filter) throws Exception {
        this.params.put("uni_codigo", filter.getUnidade());
        this.params.put("tipo_consulta", filter.getTpDados().getRet());
        if (filter.getEquipe() != null) {
            this.params.put("nu_equipe", filter.getEquipe());
        }
        if (filter.getProfissional() != null) {
            this.params.put("mic_responsavel", filter.getProfissional());
        }
        if (filter.getRisco() != null) {
            this.params.put("risco_gestacao", filter.getRisco());
        }
        this.rs = filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? Util.resolveResultSet(EstratificacaoRiscoScript.getSqlGestantesPuerperasSintetico(filter), this.params) : Util.resolveResultSet(EstratificacaoRiscoScript.getSqlGestantesPuerperasAnalitico(filter), this.params);
        ArrayList<EstratificacaoGestantesPuerperas> data = new ArrayList<EstratificacaoGestantesPuerperas>();
        while (this.rs.next()) {
            EstratificacaoGestantesPuerperas erf = new EstratificacaoGestantesPuerperas();
            erf.setRiscoGestacao(this.rs.getString("risco_gestacao"));
            erf.setMicroarea(this.rs.getString("microarea"));
            erf.setResponsavel(this.rs.getString("responsavel"));
            erf.setEquipe(this.rs.getString("equipe"));
            erf.setQtdeAtendimentoGestacao(this.rs.getInt("qtde_atendimentos_gestacao"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                erf.setCidadao(this.rs.getString("cidadao"));
                erf.setDtNascimento(this.rs.getDate("dt_nascimento"));
                erf.setIdade(this.rs.getInt("idade"));
                erf.setCns(this.rs.getString("cns"));
                erf.setAteCodigo(this.rs.getInt("ate_codigo"));
                erf.setTipoConsulta(this.rs.getString("tipo_consulta"));
                erf.setNumGestacao(this.rs.getInt("num_gestacao"));
                erf.setIdadeGestacional(this.rs.getInt("idade_gestacional"));
                erf.setDtProvavelParto(this.rs.getDate("dt_provavel_parto"));
                erf.setDtUltimoParto(this.rs.getDate("dt_ultimo_parto"));
            }
            data.add(erf);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name());
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o de Risco - Gestantes e Pu\u00e9rperas";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.addParameter("TP_DADOS", filter.getTpDados().name());
        this.creator.setFiltro(FormatFilters.filterEstratificacao(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoSaudeBucal(EstratificacaoSaudeBucalFilter filter) throws Exception {
        this.params.put("uni_codigo", filter.getUnidade());
        if (filter.getEquipe() != null) {
            this.params.put("nu_equipe", filter.getEquipe());
        }
        if (filter.getProfissional() != null) {
            this.params.put("mic_responsavel", filter.getProfissional());
        }
        if (filter.getRisco() != null) {
            this.params.put("risco", filter.getRisco());
        }
        String sql = filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? EstratificacaoRiscoScript.getSqlSaudeBucalSintetico(filter) : EstratificacaoRiscoScript.getSqlSaudeBucalAnalitico(filter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<EstratificacaoSaudeBucal> data = new ArrayList<EstratificacaoSaudeBucal>();
        while (this.rs.next()) {
            EstratificacaoSaudeBucal esb = new EstratificacaoSaudeBucal();
            esb.setRisco(this.rs.getString("risco"));
            esb.setEquipe(this.rs.getString("equipe"));
            esb.setMicroarea(this.rs.getString("microarea"));
            esb.setResponsavel(this.rs.getString("responsavel"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                esb.setQuantidade(this.rs.getInt("quantidade"));
            } else {
                esb.setCidadao(this.rs.getString("cidadao"));
                esb.setDtNascimento(this.rs.getDate("dt_nascimento"));
                esb.setIdade(this.rs.getInt("idade"));
                esb.setCns(this.rs.getString("cns"));
            }
            data.add(esb);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o de Risco - Sa\u00fade Bucal";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstratificacao(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoFamiliar(EstratificacaoFamiliarFilter familiarFilter) throws Exception {
        this.params.put("unidade", familiarFilter.getUnidade());
        if (familiarFilter.getEquipe() != null) {
            this.params.put("equipe", familiarFilter.getEquipe());
        }
        if (familiarFilter.getProfissional() != null) {
            this.params.put("profissional", familiarFilter.getProfissional());
        }
        if (familiarFilter.getRisco() != null && !familiarFilter.getRisco().contains("N")) {
            this.params.put("riscoFamiliar", familiarFilter.getRisco());
        }
        this.rs = familiarFilter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? Util.resolveResultSet(EstratificacaoRiscoScript.getSqlEstratificacaoFamiliarSintetico(familiarFilter), this.params) : Util.resolveResultSet(EstratificacaoRiscoScript.getSqlEstratificacaoFamiliarAnalitico(familiarFilter), this.params);
        ArrayList<EstratificacaoFamiliar> data = new ArrayList<EstratificacaoFamiliar>();
        while (this.rs.next()) {
            EstratificacaoFamiliar erf = new EstratificacaoFamiliar();
            erf.setUnidade(this.rs.getString("unidade"));
            erf.setNomeEquipe(this.rs.getString("nomeEquipe"));
            erf.setIneEquipe(this.rs.getString("ineEquipe"));
            erf.setMicroArea(this.rs.getString("microarea"));
            erf.setResponsavelMicroArea(this.rs.getString("profissional_responsavel"));
            erf.setRiscoFamiliar(this.rs.getString("estrat_risco_familiar"));
            if (familiarFilter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                erf.setResponsavelDomicilio(this.rs.getString("usuario_responsavel"));
                erf.setCns(this.rs.getString("cns"));
                erf.setEndereco(this.rs.getString("tipoLog").toUpperCase().concat(" ").concat(this.rs.getString("logradouro")).concat(", ").concat(this.rs.getString("numero").contentEquals("0") ? "S/N " : this.rs.getString("numero")).concat(this.rs.getString("complemento") != null ? ", " + this.rs.getString("complemento").toUpperCase() : ""));
                erf.setDomCodigo(this.rs.getInt("domCodigo"));
            } else {
                erf.setQtde(this.rs.getInt("qtde"));
            }
            data.add(erf);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(familiarFilter.getTpRel().name());
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o de Risco - Familiar";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, familiarFilter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstratificacao(familiarFilter));
        this.creator.gerarPdf();
    }

    @Override
    public void estatisticasAreaMicroArea(EstatisticasAreaMicroAreaFilter filter) throws Exception {
        this.params.put("uni_codigo", filter.getUnidade());
        if (filter.getEquipe() != null) {
            this.params.put("nu_equipe", filter.getEquipe());
        }
        if (filter.getMicroarea() != null) {
            this.params.put("mic_codigo", filter.getMicroarea());
        }
        String sql = filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? EstatisticasAreaMicroAreaScript.getSqlSintetico(filter) : EstatisticasAreaMicroAreaScript.getSqlAnalitico(filter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<EstatisticasAreaMicroArea> data = new ArrayList<EstatisticasAreaMicroArea>();
        while (this.rs.next()) {
            EstatisticasAreaMicroArea eam = new EstatisticasAreaMicroArea();
            eam.setEquipe(this.rs.getString("equipe"));
            eam.setMicroarea(this.rs.getString("microarea"));
            eam.setResponsavel(this.rs.getString("responsavel"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                eam.setHanseniaseSIM(this.rs.getInt("hanseniase_sim"));
                eam.setHanseniaseNAO(this.rs.getInt("hanseniase_nao"));
                eam.setHanseniaseNI(this.rs.getInt("hanseniase_ninformado"));
                eam.setTabagistaSIM(this.rs.getInt("tabagistas_sim"));
                eam.setTabagistaNAO(this.rs.getInt("tabagistas_nao"));
                eam.setTabagistaNI(this.rs.getInt("tabagistas_ninformado"));
                eam.setTuberculoseSIM(this.rs.getInt("tuberculose_sim"));
                eam.setTuberculoseNAO(this.rs.getInt("tuberculose_nao"));
                eam.setTuberculoseNI(this.rs.getInt("tuberculose_ninformado"));
            } else {
                eam.setCidadao(this.rs.getString("cidadao"));
                eam.setDtNascimento(this.rs.getDate("dt_nascimento"));
                eam.setIdade(this.rs.getInt("idade"));
                eam.setCns(this.rs.getString("cns"));
                eam.setHanseniase(this.rs.getString("hanseniase"));
                eam.setTabagista(this.rs.getString("tabagista"));
                eam.setTuberculose(this.rs.getString("tuberculose"));
            }
            data.add(eam);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name().toLowerCase());
        String titulo = "Relat\u00f3rio de Estat\u00edsticas de \u00c1rea e Micro-\u00c1rea";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstatistica(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoSaudeMental(EstratificacaoSaudeMentalFilter filter) throws Exception {
        this.params.put("uni_codigo", filter.getUnidade());
        if (filter.getEquipe() != null) {
            this.params.put("nu_equipe", filter.getEquipe());
        }
        if (filter.getProfissional() != null) {
            this.params.put("mic_responsavel", filter.getProfissional());
        }
        if (filter.getRisco() != null) {
            this.params.put("risco", filter.getRisco());
        }
        String sql = filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? EstratificacaoRiscoScript.getSqlSaudeMentalSintetico(filter) : EstratificacaoRiscoScript.getSqlSaudeMentalAnalitico(filter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<EstratificacaoSaudeMental> data = new ArrayList<EstratificacaoSaudeMental>();
        while (this.rs.next()) {
            EstratificacaoSaudeMental esb = new EstratificacaoSaudeMental();
            esb.setRisco(this.rs.getString("risco"));
            esb.setEquipe(this.rs.getString("equipe"));
            esb.setMicroarea(this.rs.getString("microarea"));
            esb.setResponsavel(this.rs.getString("responsavel"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                esb.setQuantidade(this.rs.getInt("quantidade"));
            } else {
                esb.setCidadao(this.rs.getString("cidadao"));
                esb.setCns(this.rs.getString("cns"));
                esb.setDtNascimento(this.rs.getDate("dt_nascimento"));
                esb.setIdade(this.rs.getInt("idade"));
                esb.setUsaAlcool(this.rs.getString("usa_alcool"));
                esb.setUsaFumante(this.rs.getString("usa_fumante"));
                esb.setUsaDrogas(this.rs.getString("usa_drogas"));
            }
            data.add(esb);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o de Risco - Sa\u00fade Mental";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstratificacao(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void estratificacaoCrianca(EstratificacaoCriancaFilter criancaFilter) throws Exception {
        Integer qtdeRiscoAlto = 0;
        Integer qtdeRiscoInt = 0;
        Integer qtdeRiscoHab = 0;
        Integer qtdeRiscoNaoEx = 0;
        if (criancaFilter.getUnidade() != null) {
            this.params.put("unidade", criancaFilter.getUnidade());
        }
        if (criancaFilter.getEquipe() != null) {
            this.params.put("equipe", criancaFilter.getEquipe());
        }
        if (criancaFilter.getProfissional() != null) {
            this.params.put("profissional", criancaFilter.getProfissional());
        }
        if (criancaFilter.getRisco() != null) {
            this.params.put("riscoCrianca", criancaFilter.getRisco());
        }
        String sql = criancaFilter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? EstratificacaoRiscoScript.getSqlEstratificacaoCriancaSintetico(criancaFilter) : EstratificacaoRiscoScript.getSqlEstratificacaoCriancaAnalitico(criancaFilter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<EstratificacaoCrianca> data = new ArrayList<EstratificacaoCrianca>();
        while (this.rs.next()) {
            EstratificacaoCrianca esc = new EstratificacaoCrianca();
            esc.setUnidade(this.rs.getString("unidade"));
            esc.setIneEquipe(this.rs.getString("ineEquipe"));
            esc.setNomeEquipe(this.rs.getString("nomeEquipe"));
            esc.setMicroArea(this.rs.getString("microArea"));
            esc.setResponsavel(this.rs.getString("profissional_responsavel"));
            esc.setIdade(this.rs.getInt("idade"));
            esc.setFaixaEtaria(this.rs.getString("faixaEtaria"));
            esc.setRiscoCrianca(this.rs.getString("risco"));
            if (criancaFilter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                esc.setQtde(this.rs.getInt("qtde"));
                switch (esc.getRiscoCrianca()) {
                    case "Alto": {
                        qtdeRiscoAlto = qtdeRiscoAlto + esc.getQtde();
                        break;
                    }
                    case "Intermedi\u00e1rio": {
                        qtdeRiscoInt = qtdeRiscoInt + esc.getQtde();
                        break;
                    }
                    case "Habitual": {
                        qtdeRiscoHab = qtdeRiscoHab + esc.getQtde();
                        break;
                    }
                    case "N\u00e3o Estratificado": {
                        qtdeRiscoNaoEx = qtdeRiscoNaoEx + esc.getQtde();
                    }
                }
            } else {
                esc.setNome(this.rs.getString("nome"));
                esc.setDataNascimento(this.rs.getString("dataNascimento"));
                esc.setIdade(this.rs.getInt("idade"));
                esc.setCns(this.rs.getString("cns"));
                switch (esc.getRiscoCrianca()) {
                    case "Alto": {
                        Integer n = qtdeRiscoAlto;
                        Integer n2 = qtdeRiscoAlto = Integer.valueOf(qtdeRiscoAlto + 1);
                        break;
                    }
                    case "Intermedi\u00e1rio": {
                        Integer n = qtdeRiscoInt;
                        Integer n2 = qtdeRiscoInt = Integer.valueOf(qtdeRiscoInt + 1);
                        break;
                    }
                    case "Habitual": {
                        Integer n = qtdeRiscoHab;
                        Integer n2 = qtdeRiscoHab = Integer.valueOf(qtdeRiscoHab + 1);
                        break;
                    }
                    case "N\u00e3o Estratificado": {
                        Integer n = qtdeRiscoNaoEx;
                        Integer n2 = qtdeRiscoNaoEx = Integer.valueOf(qtdeRiscoNaoEx + 1);
                    }
                }
            }
            esc.setQtdeRiscoAlto(qtdeRiscoAlto);
            esc.setQtdeRiscoInt(qtdeRiscoInt);
            esc.setQtdeRiscoHab(qtdeRiscoHab);
            esc.setQtdeRiscoNaoEx(qtdeRiscoNaoEx);
            data.add(esc);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(criancaFilter.getTpRel().name());
        String titulo = "Relat\u00f3rio de Estratifica\u00e7\u00e3o de Risco - Crian\u00e7a";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, criancaFilter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterEstratificacaoCrianca(criancaFilter));
        this.creator.gerarPdf();
    }

    @Override
    public void agendamentoPorProfissional(AgendamentoPorProfissionalFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("uni_codigo", filter.getUnidade());
        }
        if (filter.getProfissional() != null) {
            this.params.put("usr_codigo", filter.getProfissional());
        }
        if (filter.getSituacao() != null && filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
            switch (filter.getSituacao()) {
                case ATENDIDOS: {
                    this.params.put("age_atendido", "A");
                    break;
                }
                case FALTOSOS: {
                    this.params.put("age_atendido", "F");
                    break;
                }
                case FALTA_MEDICA: {
                    this.params.put("age_atendido", "M");
                }
            }
        }
        String sql = filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? AgendamentoScript.getSqlAgendamentoPorProfissionalSintetico(filter) : AgendamentoScript.getSqlAgendamentoPorProfissionalAnalitico(filter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<AgendamentoPorProfissional> data = new ArrayList<AgendamentoPorProfissional>();
        while (this.rs.next()) {
            AgendamentoPorProfissional app = new AgendamentoPorProfissional();
            app.setUnidade(this.rs.getString("unidade"));
            app.setProfissional(this.rs.getString("profissional"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                app.setQtdAgendado(this.rs.getInt("qtd_agendado"));
                app.setQtdAtendido(this.rs.getInt("qtd_atendido"));
                app.setQtdFaltoso(this.rs.getInt("qtd_faltoso"));
                app.setQtdFaltaMedica(this.rs.getInt("qtd_falta_medica"));
                app.setQtdOutros(this.rs.getInt("qtd_outros"));
                app.setQtdTotal(this.rs.getInt("qtd_total"));
            } else {
                app.setCidadao(this.rs.getString("cidadao"));
                app.setDtNascimento(this.rs.getDate("dt_nascimento"));
                app.setIdade(this.rs.getInt("idade"));
                app.setCartaoSus(this.rs.getString("cartao_sus"));
                app.setDtAgendamento(this.rs.getDate("dt_agendamento"));
                app.setHrAgendamento(this.rs.getTime("hr_agendamento"));
                app.setStatus(this.rs.getString("status"));
            }
            data.add(app);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Agendamento por Profissional";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAgendamentoPorMedico(filter));
        this.creator.addParameter("SITUACAO", filter.getSituacao() != null ? filter.getSituacao().name() : null);
        this.creator.gerarPdf();
    }

    @Override
    public void saidaTransferenciaMateriais(SaidaTransferenciaMateriaisFilter saidaFilter) throws Exception {
        this.params.put("setorOrigem", saidaFilter.getSetorOrigem());
        if (saidaFilter.getSetorDestino() != null) {
            this.params.put("setorDestino", saidaFilter.getSetorDestino());
        }
        if (saidaFilter.getDtInicial() != null) {
            this.params.put("dtInicial", Util.dateToSqlDate(saidaFilter.getDtInicial()));
        }
        if (saidaFilter.getDtFinal() != null) {
            this.params.put("dtFinal", Util.dateToSqlDate(saidaFilter.getDtFinal()));
        }
        if (saidaFilter.getGrupo() != null) {
            this.params.put("grupo", saidaFilter.getGrupo());
        }
        this.rs = Util.resolveResultSet(SaidaTransferenciaMateriaisScript.getSqlSaidaTransferenciaMateriais(saidaFilter), this.params);
        ArrayList<SaidaTransferenciaMateriais> saidaTransferenciaMateriais = new ArrayList<SaidaTransferenciaMateriais>();
        while (this.rs.next()) {
            SaidaTransferenciaMateriais mat = new SaidaTransferenciaMateriais();
            mat.setCodigo(this.rs.getInt("codigo"));
            mat.setProduto(this.rs.getString("nome"));
            mat.setCustoUnitario(this.rs.getDouble("custo_unitario"));
            if (saidaFilter.getSaida() != null) {
                mat.setSaida(this.rs.getInt("saida"));
            }
            if (saidaFilter.getPerda() != null) {
                mat.setPerda(this.rs.getInt("perda"));
            }
            if (saidaFilter.getTransferencia() != null) {
                mat.setTransferencia(this.rs.getInt("transferencia"));
            }
            mat.setLote(this.rs.getString("lote"));
            mat.setGrupo(this.rs.getString("grupo"));
            Double valorTotal = mat.getCustoUnitario() * (double)(saidaFilter.getSaida() != null ? mat.getSaida() : 0);
            valorTotal = valorTotal + mat.getCustoUnitario() * (double)(saidaFilter.getPerda() != null ? mat.getPerda() : 0);
            valorTotal = valorTotal + mat.getCustoUnitario() * (double)(saidaFilter.getTransferencia() != null ? mat.getTransferencia() : 0);
            mat.setValorTotal(valorTotal);
            if (saidaFilter.getSaida() != null && saidaFilter.getPerda() == null && saidaFilter.getTransferencia() == null) {
                if (mat.getSaida() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            if (saidaFilter.getPerda() != null && saidaFilter.getTransferencia() == null && saidaFilter.getSaida() == null) {
                if (mat.getPerda() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            if (saidaFilter.getTransferencia() != null && saidaFilter.getSaida() == null && saidaFilter.getPerda() == null) {
                if (mat.getTransferencia() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            if (saidaFilter.getSaida() != null && saidaFilter.getPerda() != null && saidaFilter.getTransferencia() == null) {
                if (mat.getSaida() > 0) {
                    saidaTransferenciaMateriais.add(mat);
                }
                if (mat.getPerda() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            if (saidaFilter.getSaida() != null && saidaFilter.getPerda() == null && saidaFilter.getTransferencia() != null) {
                if (mat.getSaida() > 0) {
                    saidaTransferenciaMateriais.add(mat);
                }
                if (mat.getTransferencia() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            if (saidaFilter.getSaida() == null && saidaFilter.getPerda() != null && saidaFilter.getTransferencia() != null) {
                if (mat.getPerda() > 0) {
                    saidaTransferenciaMateriais.add(mat);
                }
                if (mat.getTransferencia() <= 0) continue;
                saidaTransferenciaMateriais.add(mat);
                continue;
            }
            saidaTransferenciaMateriais.add(mat);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Sa\u00eddas e Transfer\u00eancias de Materiais";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, saidaTransferenciaMateriais, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterSaidaTransferenciaMateriais(saidaFilter));
        this.creator.gerarPdf();
    }

    @Override
    public void atestadoVacina(AtestadoVacinaFilter filter) throws Exception {
        this.params.put("usuCodigo", filter.getUsuCodigo());
        this.params.put("usrLogado", filter.getUsrLogado());
        ResultSet rsPaciente = Util.resolveResultSet(AtestadoVacinaScript.getDadosPaciente(filter), this.params);
        ResultSet rsUsrlogado = Util.resolveResultSet(AtestadoVacinaScript.getDadosUsrLogado(filter), this.params);
        ResultSet rsVacinaAprazada = Util.resolveResultSet(AtestadoVacinaScript.getVacinasAprazadas(), this.params);
        AtestadoVacina atestado = new AtestadoVacina();
        ArrayList<VacinaAprazada> vacinas = new ArrayList<VacinaAprazada>();
        if (rsPaciente.next()) {
            atestado.setUsuNome(rsPaciente.getString("nome"));
            atestado.setUsuProntuario(rsPaciente.getString("prontuario"));
            atestado.setUsuCartaoSus(rsPaciente.getString("cartaosus"));
            atestado.setUsuDataNascimento(rsPaciente.getDate("datanascimento"));
            atestado.setUsuIdade(rsPaciente.getInt("idade"));
            atestado.setUsuSexo(rsPaciente.getString("sexo"));
        }
        if (rsUsrlogado.next()) {
            atestado.setUsrLogadoNome(rsUsrlogado.getString("nome"));
            atestado.setUsrLogadoConselho(rsUsrlogado.getString("conselho"));
            atestado.setUsrLogadoEstado(rsUsrlogado.getString("estado"));
            atestado.setUsrLogadoNumeroConselho(rsUsrlogado.getString("numeroconselho"));
        }
        while (rsVacinaAprazada.next()) {
            VacinaAprazada vacina = new VacinaAprazada();
            vacina.setData(rsVacinaAprazada.getDate("data"));
            vacina.setVacina(rsVacinaAprazada.getString("vacina"));
            vacinas.add(vacina);
        }
        atestado.setVacinasAprazadas(vacinas);
        atestado.setDataValidade(filter.getDataAtestado());
        ArrayList<AtestadoVacina> atestadoVacinas = new ArrayList<AtestadoVacina>();
        atestadoVacinas.add(atestado);
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Atestado de Vacina\u00e7\u00e3o";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, atestadoVacinas, TipoRelEnum.SINTETICO);
        this.creator.setFiltro("");
        this.creator.gerarPdf();
    }

    @Override
    public void controleVacinadosPorVacina(ControleVacinadosPorVacinaFilter controleFilter) throws Exception {
        this.params.put("unidade", controleFilter.getUnidade());
        this.params.put("dt_inicial", Util.dateToTimeStamp(controleFilter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(controleFilter.getDtFinal()));
        if (controleFilter.getProfissional() != null) {
            this.params.put("profissional", controleFilter.getProfissional());
        }
        if (controleFilter.getVacina() != null) {
            this.params.put("vacina", controleFilter.getVacina());
        }
        this.rs = Util.resolveResultSet(ControleVacinadosPorVacinaScript.getSql(controleFilter), this.params);
        ArrayList<ControleVacinadosPorVacina> data = new ArrayList<ControleVacinadosPorVacina>();
        while (this.rs.next()) {
            ControleVacinadosPorVacina vacina = new ControleVacinadosPorVacina();
            vacina.setDataAplicacao(this.rs.getDate("data_aplicacao"));
            vacina.setPaciente(this.rs.getString("paciente"));
            vacina.setDataNascimento(this.rs.getDate("data_nascimento"));
            vacina.setIdade(this.rs.getInt("idade"));
            vacina.setGestante(this.rs.getString("gestante"));
            vacina.setPuerpera(this.rs.getString("puerpera"));
            vacina.setHanseniase(this.rs.getString("hanseniase"));
            vacina.setEstrategia(this.rs.getString("estrategia"));
            vacina.setLaboratorio(this.rs.getString("laboratorio"));
            vacina.setLote(this.rs.getString("lote"));
            vacina.setDose(this.rs.getInt("dose"));
            vacina.setVacina(this.rs.getString("vacina"));
            vacina.setProfissional(this.rs.getString("profissional"));
            vacina.setUnidade(this.rs.getString("unidade"));
            data.add(vacina);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Controle de Vacinados por Vacina";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterControleDeVacinadosPorVacina(controleFilter));
        this.creator.gerarPdf();
    }

    @Override
    public void consultasAgendadas(ConsultasAgendadasFilter consultasFilter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(consultasFilter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(consultasFilter.getDtFinal()));
        if (consultasFilter.getUnidade() != null) {
            this.params.put("uni_codigo", consultasFilter.getUnidade());
        }
        if (consultasFilter.getProfissional() != null) {
            this.params.put("usr_codigo", consultasFilter.getProfissional());
        }
        this.rs = Util.resolveResultSet(AgendamentoScript.getSqlConsultasAgendadas(consultasFilter), this.params);
        ArrayList<ConsultasAgendadas> data = new ArrayList<ConsultasAgendadas>();
        while (this.rs.next()) {
            ConsultasAgendadas consultas = new ConsultasAgendadas();
            consultas.setUnidade(this.rs.getString("unidade"));
            consultas.setProfissional(this.rs.getString("profissional"));
            consultas.setCidadao(this.rs.getString("cidadao"));
            consultas.setDtNascimento(this.rs.getDate("dt_nascimento"));
            consultas.setProntuario(this.rs.getString("prontuario"));
            consultas.setTelefone(this.rs.getString("telefone"));
            consultas.setCelular(this.rs.getString("celular"));
            consultas.setDtAgendamento(this.rs.getDate("dt_agendamento"));
            consultas.setHrAgendamento(this.rs.getTime("hr_agendamento"));
            data.add(consultas);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Listagem de Consultas Agendadas";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, consultasFilter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterConsultasAgendadas(consultasFilter));
        this.creator.gerarPdf();
    }

    @Override
    public void procedimentosGerais(ProcedimentosGeraisFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getProcedimento() != null) {
            this.params.put("procedimento", filter.getProcedimento());
        }
        this.rs = Util.resolveResultSet(BpaScript.getSqlProcedimentosGerais(filter), this.params);
        ArrayList<ProcedimentosGerais> data = new ArrayList<ProcedimentosGerais>();
        while (this.rs.next()) {
            ProcedimentosGerais proger = new ProcedimentosGerais();
            proger.setUnidade(this.rs.getString("unidade"));
            proger.setProfissional(this.rs.getString("profissional"));
            proger.setProcedimento(this.rs.getString("procedimento"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                proger.setCidadao(this.rs.getString("cidadao"));
                proger.setDtNascimento(this.rs.getDate("dtnascimento"));
                proger.setIdade(this.rs.getInt("idade"));
                proger.setCartaosus(this.rs.getString("cartaosus"));
                proger.setDtAtendimento(this.rs.getTimestamp("dtatendimento"));
            } else {
                proger.setTotal(this.rs.getInt("total"));
            }
            if (Util.existColumn(this.rs, "faixa")) {
                proger.setFaixa(this.rs.getString("faixa"));
            }
            data.add(proger);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Procedimentos Gerais";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterProcedimentosGerais(filter));
        if (filter.getFaixaEtaria() != null) {
            StringBuilder bd = new StringBuilder("Faixa Et\u00e1ria: ");
            for (String faixa : filter.getFaixaEtaria()) {
                if (faixa.contains("<")) {
                    bd.append(faixa.replace("<", "Menores que")).append(" anos | ");
                }
                if (faixa.contains("=")) {
                    bd.append(faixa.replace("=", "")).append(" anos | ");
                }
                if (faixa.contains("BETWEEN")) {
                    bd.append(faixa.replace("BETWEEN", "Entre").replace("AND", "e")).append(" anos | ");
                }
                if (!faixa.contains(">")) continue;
                bd.append(faixa.replace(">", "Maiores que")).append(" anos | ");
            }
            if (StringUtils.isNotBlank(bd)) {
                this.creator.addParameter("FAIXA_ETARIA", bd.replace(bd.length() - 3, bd.length(), "").toString());
            }
        }
        this.creator.gerarPdf();
    }

    @Override
    public void procedimentosUnidade(ProcedimentosUnidadeFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("unidade", filter.getUnidade());
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getProcedimento() != null) {
            this.params.put("procedimento", filter.getProcedimento());
        }
        this.rs = Util.resolveResultSet(BpaScript.getSqlProcedimentosUnidade(filter), this.params);
        ArrayList<ProcedimentosUnidade> data = new ArrayList<ProcedimentosUnidade>();
        while (this.rs.next()) {
            ProcedimentosUnidade proger = new ProcedimentosUnidade();
            proger.setUnidade(this.rs.getString("unidade"));
            proger.setProfissional(this.rs.getString("profissional"));
            proger.setProcedimento(this.rs.getString("procedimento"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                proger.setCidadao(this.rs.getString("cidadao"));
                proger.setDtNascimento(this.rs.getDate("dtnascimento"));
                proger.setIdade(this.rs.getInt("idade"));
                proger.setCartaosus(this.rs.getString("cartaosus"));
                proger.setDtAtendimento(this.rs.getTimestamp("dtatendimento"));
            } else {
                proger.setTotal(this.rs.getInt("total"));
            }
            if (Util.existColumn(this.rs, "faixa")) {
                proger.setFaixa(this.rs.getString("faixa"));
            }
            data.add(proger);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Procedimentos Unidade";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterProcedimentosUnidade(filter));
        if (filter.getFaixaEtaria() != null) {
            StringBuilder bd = new StringBuilder("Faixa Et\u00e1ria: ");
            for (String faixa : filter.getFaixaEtaria()) {
                if (faixa.contains("<")) {
                    bd.append(faixa.replace("<", "Menores que")).append(" anos | ");
                }
                if (faixa.contains("=")) {
                    bd.append(faixa.replace("=", "")).append(" anos | ");
                }
                if (faixa.contains("BETWEEN")) {
                    bd.append(faixa.replace("BETWEEN", "Entre").replace("AND", "e")).append(" anos | ");
                }
                if (!faixa.contains(">")) continue;
                bd.append(faixa.replace(">", "Maiores que")).append(" anos | ");
            }
            if (StringUtils.isNotBlank(bd)) {
                this.creator.addParameter("FAIXA_ETARIA", bd.replace(bd.length() - 3, bd.length(), "").toString());
            }
        }
        this.creator.gerarPdf();
    }

    @Override
    public void carteirinhaVacinacao(CarteirinhaVacinacaoFilter filter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        this.rs = Util.subResultSet(CarteirinhaVacinacaoScript.montaCarterinha(), this.params, this.conn);
        ArrayList<Carteirinha> data = new ArrayList<Carteirinha>();
        while (this.rs.next()) {
            Carteirinha carteirinha = new Carteirinha();
            carteirinha.setProduto(this.rs.getString("pro_nome"));
            carteirinha.setBoDose1(this.rs.getBoolean("dose_um"));
            carteirinha.setBoDose2(this.rs.getBoolean("dose_dois"));
            carteirinha.setBoDose3(this.rs.getBoolean("dose_tres"));
            carteirinha.setBoDose4(this.rs.getBoolean("dose_quatro"));
            carteirinha.setBoDose5(this.rs.getBoolean("dose_cinco"));
            carteirinha.setBoReforco(this.rs.getBoolean("reforco"));
            carteirinha.setBoReforco2(this.rs.getBoolean("reforco2"));
            HashMap<String, Object> pDados = new HashMap<String, Object>();
            pDados.put("pro_codigo", this.rs.getInt("pro_codigo"));
            pDados.put("usu_codigo", filter.getUsuario());
            ResultSet rsPaciente = Util.subResultSet(CarteirinhaVacinacaoScript.getDadosPaciente(), pDados, this.conn);
            if (rsPaciente.next()) {
                CarteirinhaPaciente paciente = new CarteirinhaPaciente();
                paciente.setPaciente(rsPaciente.getString("paciente"));
                paciente.setDtNascimento(rsPaciente.getDate("datanasc"));
                paciente.setCartaoSus(rsPaciente.getString("cartaosus"));
                paciente.setProntuario(rsPaciente.getString("prontuario"));
                paciente.setUsuarioMae(rsPaciente.getString("usu_mae"));
                carteirinha.setPaciente(paciente);
            }
            ResultSet rsDados = Util.subResultSet(CarteirinhaVacinacaoScript.sqlDadosCarteirinha(), pDados, this.conn);
            while (rsDados.next()) {
                InformacoesCarteirinha info = new InformacoesCarteirinha();
                info.setAcao(rsDados.getString("vac_acao"));
                info.setAplicado(rsDados.getBoolean("aplicado"));
                info.setLote(rsDados.getString("ite_lote"));
                info.setDtAplicacao(rsDados.getDate("vac_data"));
                info.setDtValidade(rsDados.getDate("ite_validade"));
                info.setUnidade(rsDados.getString("uni_desc"));
                info.setUsuario(rsDados.getString("usr_nome"));
                switch (rsDados.getInt("vac_dose")) {
                    case 1: {
                        carteirinha.setInfoDose1(info);
                        break;
                    }
                    case 2: {
                        carteirinha.setInfoDose2(info);
                        break;
                    }
                    case 3: {
                        carteirinha.setInfoDose3(info);
                        break;
                    }
                    case 4: {
                        carteirinha.setInfoDose4(info);
                        break;
                    }
                    case 5: {
                        carteirinha.setInfoDose5(info);
                        break;
                    }
                    case 6: {
                        carteirinha.setInfoReforco(info);
                        break;
                    }
                    case 7: {
                        carteirinha.setInfoReforco2(info);
                    }
                }
            }
            data.add(carteirinha);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Carteirinha de Vacina\u00e7\u00e3o";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, null);
        this.creator.gerarPdf();
    }

    @Override
    public void guiaEncaminhamentoExterno(GuiaEncaminhamentoExternoFilter guiaFilter) throws Exception {
        this.params.put("codigo", guiaFilter.getCodigo());
        this.rs = Util.resolveResultSet(GuiaEncaminhamentoExternoScript.getSql(guiaFilter), this.params);
        ArrayList<GuiaEncaminhamentoExterno> guia = new ArrayList<GuiaEncaminhamentoExterno>();
        if (this.rs.next()) {
            GuiaEncaminhamentoExterno g = new GuiaEncaminhamentoExterno();
            g.setDataCadastro(this.rs.getDate("dataCadastro"));
            g.setAgendadoPara(this.rs.getString("agendadoPara"));
            g.setContato(this.rs.getString("contato"));
            g.setDataAgendamento(this.rs.getDate("dataAgendamento"));
            g.setHoraAgendamento(this.rs.getString("horaAgendamento"));
            g.setInternacao(this.rs.getBoolean("internacao"));
            g.setUrgencia(this.rs.getBoolean("urgencia"));
            g.setDescricao(Util.removeHtmlFrom(this.rs.getString("descricao")));
            g.setUnidade(this.rs.getString("unidade"));
            g.setCnes(this.rs.getString("cnes"));
            g.setProfissional(this.rs.getString("profissional"));
            g.setConselho(this.rs.getString("conselho"));
            g.setEstado(this.rs.getString("estado"));
            g.setNumeroConselho(this.rs.getString("numeroConselho"));
            g.setNome(this.rs.getString("nome"));
            g.setCns(this.rs.getString("cns"));
            g.setDataNascimento(this.rs.getDate("dataNascimento"));
            g.setIdade(this.rs.getInt("idade"));
            g.setProntuario(this.rs.getString("prontuario"));
            g.setSexo(this.rs.getString("sexo"));
            g.setNomeMae(this.rs.getString("mae"));
            g.setCelular(this.rs.getString("celular"));
            g.setMunicipioNascimento(this.rs.getString("cidade"));
            g.setEstadoNascimento(this.rs.getString("estadoNascimento"));
            g.setContraReferencia(guiaFilter.getContraReferencia());
            g.setEspecialidade(this.rs.getString("especialidade"));
            g.setRg(this.rs.getString("rg"));
            g.setDataEmissao(this.rs.getDate("dataEmissao"));
            g.setCpf(this.rs.getString("cpf"));
            guia.add(g);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Guia de Encaminhamento Externo";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, guia, TipoRelEnum.SINTETICO);
        this.creator.gerarPdf();
    }

    @Override
    public void pacientesFaixaSexo(PacientesFaixaSexoFilter pacientesFaixaSexoFilter) throws Exception {
        if (pacientesFaixaSexoFilter.getUnidade() != null) {
            this.params.put("unidade", pacientesFaixaSexoFilter.getUnidade());
        }
        if (pacientesFaixaSexoFilter.getEquipe() != null) {
            this.params.put("equipe", pacientesFaixaSexoFilter.getEquipe());
        }
        if (pacientesFaixaSexoFilter.getProfissional() != null) {
            this.params.put("profissional", pacientesFaixaSexoFilter.getProfissional());
        }
        if (pacientesFaixaSexoFilter.getSexo() != null) {
            this.params.put("sexo", pacientesFaixaSexoFilter.getSexo());
        }
        this.rs = Util.resolveResultSet(PacientesFaixaSexoScript.getSql(pacientesFaixaSexoFilter), this.params);
        ArrayList<PacientesFaixaSexo> pac = new ArrayList<PacientesFaixaSexo>();
        while (this.rs.next()) {
            PacientesFaixaSexo p = new PacientesFaixaSexo();
            p.setUnidade(this.rs.getString("unidade"));
            if (pacientesFaixaSexoFilter.getAgrUsr().booleanValue()) {
                p.setIneEquipe(this.rs.getString("ineEquipe"));
                p.setNomeEquipe(this.rs.getString("nomeEquipe"));
                p.setProfissional(this.rs.getString("profissional"));
            }
            p.setFaixa(this.rs.getString("faixa"));
            p.setCidadao(this.rs.getString("cidadao"));
            p.setDtNascimento(this.rs.getDate("dataNascimento"));
            p.setIdade(this.rs.getInt("idade"));
            p.setCartaosus(this.rs.getString("cartaoSus"));
            pac.add(p);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(pacientesFaixaSexoFilter.getTpRel().name()).toLowerCase();
        String titulo = "Relat\u00f3rio Pacientes por Faixa Et\u00e1ria e Sexo";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, pac, pacientesFaixaSexoFilter.getTpRel());
        this.creator.setFiltro("");
        this.creator.addParameter("AGR_USR", pacientesFaixaSexoFilter.getAgrUsr());
        this.creator.gerarPdf();
    }

    @Override
    public void movimentoSaida(MovimentoSaidaFilter filter) throws Exception {
        if (filter.getSetor() != null) {
            this.params.put("setor", filter.getSetor());
        }
        if (filter.getProduto() != null) {
            this.params.put("produto", filter.getProduto());
        }
        if (StringUtils.isNotBlank(filter.getTpSaida())) {
            this.params.put("tpSaida", filter.getTpSaida());
        }
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        this.rs = Util.resolveResultSet(MateriaisScript.getSqlMovimentoSaida(filter), this.params);
        ArrayList<MovimentoSaida> movimentos = new ArrayList<MovimentoSaida>();
        while (this.rs.next()) {
            MovimentoSaida ms = new MovimentoSaida();
            ms.setSetor(this.rs.getString("setor"));
            ms.setTipoSaida(this.rs.getString("tipo_saida"));
            ms.setProduto(this.rs.getString("produto"));
            ms.setDtMovimento(this.rs.getDate("data_movimento"));
            ms.setQuantidade(this.rs.getInt("quantidade"));
            movimentos.add(ms);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.toLowerCase();
        String titulo = "Relat\u00f3rio Movimenta\u00e7\u00e3o de Sa\u00edda";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, movimentos, null);
        this.creator.setFiltro(FormatFilters.filterMovimentoSaida(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void visitaDomiciliar(VisitaDomiciliarFilter filter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        this.params.put("unidade", filter.getUnidade());
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getDesfecho() != null) {
            this.params.put("desfecho", filter.getDesfecho());
        }
        if (filter.getPaciente() != null) {
            this.params.put("paciente", filter.getPaciente());
        }
        this.rs = Util.resolveResultSet(VisitaDomiciliarScript.getSqlVisitasDomiciliares(filter), this.params);
        ArrayList<VisitaDomiciliar> visitas = new ArrayList<VisitaDomiciliar>();
        while (this.rs.next()) {
            VisitaDomiciliar vis = new VisitaDomiciliar();
            vis.setUnidade(this.rs.getString("unidade"));
            vis.setProfissional(this.rs.getString("profissional"));
            vis.setDesfecho(this.rs.getString("desfecho"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                vis.setQuantidade(this.rs.getInt("qtde"));
            } else {
                vis.setCodigo(this.rs.getInt("codigo"));
                vis.setData(this.rs.getDate("data"));
                vis.setHora(this.rs.getString("hora"));
                vis.setObservacao(Util.removeHtmlFrom(this.rs.getString("observacao")));
                vis.setPaciente(this.rs.getString("paciente"));
                vis.setTipoLogradouro(this.rs.getString("tipoLogradouro"));
                vis.setRua(this.rs.getString("rua"));
                vis.setNumero(this.rs.getInt("numero"));
                vis.setBairro(this.rs.getString("bairro"));
                vis.setCidade(this.rs.getString("cidade"));
                vis.setSigla(this.rs.getString("sigla"));
                HashMap<String, Object> subParams = new HashMap<String, Object>();
                subParams.put("codigo", vis.getCodigo());
                ResultSet subRs = Util.subResultSet(VisitaDomiciliarScript.getSqlVisitasMotivos(), subParams, this.conn);
                ArrayList<Motivos> motivos = new ArrayList<Motivos>();
                while (subRs.next()) {
                    Motivos mot = new Motivos();
                    mot.setMotivo(subRs.getString("motivo"));
                    motivos.add(mot);
                }
                vis.setMotivos(motivos);
            }
            visitas.add(vis);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Relat\u00f3rio de Visitas Domiciliares - ".concat(filter.getTpRel().name());
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, visitas, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterVisitaDomiciliar(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void buscaAtiva(BuscaAtivaFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getEquipe() != null) {
            this.params.put("equipe", filter.getEquipe());
        }
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        this.rs = Util.resolveResultSet(BuscaAtivaScript.getSqlBuscaAtiva(filter), this.params);
        ArrayList<BuscaAtiva> buscas = new ArrayList<BuscaAtiva>();
        while (this.rs.next()) {
            BuscaAtiva bus = new BuscaAtiva();
            bus.setUnidade(this.rs.getString("unidade"));
            bus.setProfissional(this.rs.getString("profissional"));
            bus.setBusca(this.rs.getString("motivo"));
            bus.setDesfecho(this.rs.getString("desfecho"));
            bus.setEquipe(this.rs.getString("nomeEquipe"));
            bus.setIne(this.rs.getString("ineEquipe"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                bus.setQuantidade(this.rs.getInt("qtde"));
            } else {
                bus.setCodigo(this.rs.getInt("codigo"));
                bus.setData(this.rs.getDate("data"));
                bus.setHora(this.rs.getString("hora"));
                bus.setObservacao(this.rs.getString("observacao"));
                bus.setPaciente(this.rs.getString("paciente"));
                bus.setTipoLogradouro(this.rs.getString("tipoLogradouro"));
                bus.setRua(this.rs.getString("rua"));
                bus.setNumero(this.rs.getInt("numero"));
                bus.setBairro(this.rs.getString("bairro"));
                bus.setCidade(this.rs.getString("cidade"));
                bus.setSigla(this.rs.getString("sigla"));
            }
            buscas.add(bus);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Relat\u00f3rio de Buscas Ativas - ".concat(filter.getTpRel().name());
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, buscas, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterBuscaAtiva(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void bpaIdade(BpaIdadeFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("unidade", filter.getUnidade());
        if (filter.getIdade() != null) {
            this.params.put("idade", filter.getIdade());
        }
        if (filter.getProcedimento() != null) {
            this.params.put("procedimento", filter.getProcedimento());
        }
        this.rs = Util.resolveResultSet(BpaScript.getSqlBpaIdade(filter), this.params);
        ArrayList<BpaIdade> data = new ArrayList<BpaIdade>();
        while (this.rs.next()) {
            BpaIdade bpa = new BpaIdade();
            bpa.setUnidade(this.rs.getString("unidade"));
            bpa.setProcedimento(this.rs.getString("procedimento"));
            bpa.setIdade(this.rs.getInt("idade"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                bpa.setCidadao(this.rs.getString("cidadao"));
                bpa.setDtNascimento(this.rs.getDate("dtnascimento"));
                bpa.setCartaosus(this.rs.getString("cartaosus"));
                bpa.setDtAtendimento(this.rs.getTimestamp("dtatendimento"));
            } else {
                bpa.setTotal(this.rs.getInt("total"));
            }
            data.add(bpa);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "BPA por Idade";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterBpaIdade(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void agendamentoExternoMedico(AgendamentoExternoMedicoFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getEspecialidade() != null) {
            this.params.put("especialidade", filter.getEspecialidade());
        }
        if (filter.getMedicoDestino() != null) {
            this.params.put("medicoDestino", filter.getMedicoDestino());
        }
        if (filter.getMedicoSolicitante() != null) {
            this.params.put("medicoSolicitante", filter.getMedicoSolicitante());
        }
        if (filter.getSituacao() != null) {
            this.params.put("situacao", filter.getSituacao());
        }
        if (filter.getGrauRisco() != null) {
            this.params.put("grauRisco", filter.getGrauRisco());
        }
        this.rs = Util.resolveResultSet(AgendamentoScript.getSqlAgendamentoExternoMedico(filter), this.params);
        ArrayList<AgendamentoExternoMedico> agendamentos = new ArrayList<AgendamentoExternoMedico>();
        while (this.rs.next()) {
            AgendamentoExternoMedico age = new AgendamentoExternoMedico();
            age.setUnidade(this.rs.getString("unidade"));
            age.setEspecialidade(this.rs.getString("especialidade"));
            age.setMedicoDestino(this.rs.getString("medico_destino"));
            age.setMedicoSolicitante(this.rs.getString("medico_solicitante"));
            age.setPrioridade(this.rs.getString("prioridade"));
            age.setSituacao(this.rs.getString("situacao"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
                age.setTotal(this.rs.getInt("total"));
            } else {
                age.setData(this.rs.getDate("data"));
                age.setPaciente(this.rs.getString("paciente"));
                age.setTelefone(this.rs.getString("telefone"));
                age.setCelular(this.rs.getString("celular"));
            }
            agendamentos.add(age);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Agendamento Externo por M\u00e9dico e Especialidade - ".concat(filter.getTpRel().name());
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, agendamentos, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAgendamentoExternoMedico(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void agendamentoExternoUnidade(AgendamentoExternoUnidadeFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getEspecialidade() != null) {
            this.params.put("especialidade", filter.getEspecialidade());
        }
        if (filter.getProcedimento() != null) {
            this.params.put("procedimento", filter.getProcedimento());
        }
        if (filter.getSituacao() != null) {
            this.params.put("situacao", filter.getSituacao());
        }
        if (filter.getGrauRisco() != null) {
            this.params.put("grauRisco", filter.getGrauRisco());
        }
        this.rs = Util.resolveResultSet(AgendamentoScript.getSqlAgendamentoExternoUnidade(filter), this.params);
        ArrayList<AgendamentoExternoUnidade> agendamentos = new ArrayList<AgendamentoExternoUnidade>();
        while (this.rs.next()) {
            AgendamentoExternoUnidade age = new AgendamentoExternoUnidade();
            age.setUnidade(this.rs.getString("unidade"));
            age.setEspecialidade(this.rs.getString("especialidade"));
            age.setMedicoDestino(this.rs.getString("medico_destino"));
            age.setProcedimento(this.rs.getString("procedimento"));
            age.setPrioridade(this.rs.getString("prioridade"));
            age.setSituacao(this.rs.getString("situacao"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                age.setData(this.rs.getDate("data"));
                age.setPaciente(this.rs.getString("paciente"));
                age.setTelefone(this.rs.getString("telefone"));
                age.setCelular(this.rs.getString("celular"));
                age.setCns(this.rs.getString("cns"));
                age.setTipoLogradouro(this.rs.getString("tipoLogradouro"));
                age.setRua(this.rs.getString("rua"));
                age.setNumero(this.rs.getInt("numero"));
                age.setBairro(this.rs.getString("bairro"));
                age.setCidade(this.rs.getString("cidade"));
                age.setSigla(this.rs.getString("sigla"));
            } else {
                age.setTotal(this.rs.getInt("total"));
            }
            agendamentos.add(age);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        filename = filename.concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Agendamento Externo por Unidade e Especialidade - ".concat(filter.getTpRel().name());
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, agendamentos, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAgendamentoExternoUnidade(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void laudoApac(LaudoApacFilter laudoApacFilter) throws Exception {
        this.params.put("codigoAtendimento", laudoApacFilter.getCodigoAtendimento());
        this.rs = Util.resolveResultSet(LaudoApacScript.getSql(), this.params);
        ArrayList<LaudoApac> data = new ArrayList<LaudoApac>();
        if (this.rs.next()) {
            LaudoApac lau = new LaudoApac();
            lau.setUniDesc(this.rs.getString("uniDesc"));
            lau.setUniCnes(this.rs.getString("uniCnes"));
            lau.setUsuNome(this.rs.getString("usuNome"));
            lau.setUsuProntuario(this.rs.getString("usuProntuario"));
            lau.setUsuCns(this.rs.getString("usuCns"));
            lau.setUsuDatanasc(this.rs.getDate("usuDatanasc"));
            lau.setUsuSexo(this.rs.getString("usuSexo"));
            lau.setUsuRacacor(this.rs.getString("usuRacacor"));
            lau.setUsuMae(this.rs.getString("usuMae"));
            lau.setUsuResponsavel(this.rs.getString("usuResponsavel"));
            lau.setUsuCelular(this.rs.getString("usuCelular"));
            lau.setUsuFone(this.rs.getString("usuFone"));
            lau.setCidadeNome(this.rs.getString("cidadeNome"));
            lau.setCidadeUf(this.rs.getString("cidadeUf"));
            lau.setCidadeIbge(this.rs.getString("cidadeIbge"));
            lau.setUsuCep(this.rs.getString("usuCep"));
            lau.setUsuEndereco(this.rs.getString("usuEndereco"));
            data.add(lau);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Laudo para Solicita\u00e7\u00e3o/Autoriza\u00e7\u00e3o de Procedimento Ambulatorial";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.gerarPdf();
    }

    @Override
    public void inventario(InventarioFilter inventarioFilter) throws Exception {
        this.params.put("codigo", inventarioFilter.getCodigo());
        this.rs = Util.resolveResultSet(InventarioScript.getSqlInventario(inventarioFilter), this.params);
        this.conn = ConnectionUtil.getConnection();
        ArrayList<Inventario> data = new ArrayList<Inventario>();
        while (this.rs.next()) {
            Inventario inv = new Inventario();
            inv.setUnidade(this.rs.getString("unidade"));
            inv.setCodigo(this.rs.getInt("codigo"));
            inv.setGrupo(this.rs.getString("grupo"));
            inv.setSetor(this.rs.getString("setor"));
            inv.setProduto(this.rs.getString("produto"));
            inv.setValidade(this.rs.getDate("validade"));
            inv.setLote(this.rs.getString("lote"));
            inv.setSaldoInicial(this.rs.getInt("saldoInicial"));
            inv.setSaldoFinal(this.rs.getInt("saldoFinal"));
            inv.setFracao(this.rs.getInt("fracao"));
            data.add(inv);
            HashMap<String, Object> params2 = new HashMap<String, Object>();
            params2.put("invp_codigo", this.rs.getInt("inv_pro"));
            ResultSet rs2 = Util.subResultSet(InventarioScript.getSqlProdutos(), params2, this.conn);
            while (rs2.next()) {
                Inventario inv2 = new Inventario();
                inv2.setUnidade(this.rs.getString("unidade"));
                inv2.setCodigo(this.rs.getInt("codigo"));
                inv2.setGrupo(this.rs.getString("grupo"));
                inv2.setSetor(this.rs.getString("setor"));
                inv2.setProduto(rs2.getString("produto"));
                inv2.setValidade(rs2.getDate("validade"));
                inv2.setLote(rs2.getString("lote"));
                inv2.setSaldoInicial(rs2.getInt("saldoInicial"));
                inv2.setSaldoFinal(rs2.getInt("saldoFinal"));
                inv2.setFracao(rs2.getInt("fracao"));
                data.add(inv2);
            }
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Produtos Inventariados";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.gerarPdf();
    }

    @Override
    public void dispensacaoTipoReceita(DispensacaoTipoReceitaFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        this.params.put("unidade", filter.getUnidade());
        if (filter.getTpRec() != null) {
            this.params.put("tpRec", filter.getTpRec());
        }
        this.rs = Util.resolveResultSet(DispensacaoTipoReceitaScript.getSql(filter), this.params);
        ArrayList<DispensacaoTipoReceita> data = new ArrayList<DispensacaoTipoReceita>();
        while (this.rs.next()) {
            DispensacaoTipoReceita dis = new DispensacaoTipoReceita();
            dis.setUnidade(this.rs.getString("unidade"));
            dis.setTipoReceita(this.rs.getString("tipo_receita"));
            dis.setData(this.rs.getDate("data"));
            dis.setPaciente(this.rs.getString("paciente"));
            dis.setProfissional(this.rs.getString("profissional"));
            dis.setMovimento(this.rs.getInt("movimento"));
            data.add(dis);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Dispensa\u00e7\u00e3o por Tipo de Receita";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterDispensacaoTipoReceita(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void listaViagem(ViagemFilter viagemFilter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        this.params.put("via_codigo", viagemFilter.getViaCodigo());
        this.rs = Util.resolveResultSet(ListaViagemScript.getSql(), this.params);
        ArrayList<ListaViagem> data = new ArrayList<ListaViagem>();
        while (this.rs.next()) {
            ListaViagem list = new ListaViagem();
            list.setViaCodigo(this.rs.getInt("codigo"));
            list.setData(this.rs.getDate("data"));
            list.setMotorista(this.rs.getString("motorista"));
            list.setVeiculo(this.rs.getString("veiculo"));
            list.setOrigem(this.rs.getString("origem"));
            list.setDestino(this.rs.getString("destino"));
            list.setPaciente(this.rs.getString("paciente"));
            list.setCns(this.rs.getString("cns"));
            list.setTelefone(this.rs.getString("telefone"));
            list.setCelular(this.rs.getString("celular"));
            list.setLocalEmbarque(this.rs.getString("local_emb"));
            list.setHoraEmbarque(this.rs.getString("hora_emb"));
            list.setLocalDesembarque(this.rs.getString("local_desemb"));
            list.setHoraDesembarque(this.rs.getString("hora_desemb"));
            list.setLocalAtendimento(this.rs.getString("local_atend"));
            list.setHoraAtendimento(this.rs.getString("hora_atend"));
            String obs = this.rs.getString("obs");
            if (obs != null && !obs.isEmpty()) {
                list.setObservacao(Util.removeHtmlFrom(obs));
            }
            HashMap<String, Object> paramAcomp = new HashMap<String, Object>();
            paramAcomp.put("codigo", this.rs.getInt("viausu_codigo"));
            ResultSet rsAcomp = Util.subResultSet(ListaViagemScript.getSqlAcomp(), paramAcomp, this.conn);
            ArrayList<Acompanhante> acomps = new ArrayList<Acompanhante>();
            while (rsAcomp.next()) {
                Acompanhante acomp = new Acompanhante();
                acomp.setNome(rsAcomp.getString("nome"));
                acomp.setCelular(rsAcomp.getString("celular"));
                acomp.setTelefone(rsAcomp.getString("telefone"));
                acomps.add(acomp);
            }
            list.setAcompanhantes(acomps);
            data.add(list);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Lista de Viagem";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro("");
        this.creator.gerarPdf();
    }

    @Override
    public void examesPorPrestador(ExamesPorPrestadorFilter examesPorPrestadorFilter) throws Exception {
        ExamesPorPrestador exa;
        this.params.put("dataInicial", Util.dateToTimeStamp(examesPorPrestadorFilter.getDataInicial()));
        this.params.put("dataFinal", Util.dateToTimeStamp(examesPorPrestadorFilter.getDataFinal()));
        if (examesPorPrestadorFilter.getUsuCodigo() != null) {
            this.params.put("paciente", examesPorPrestadorFilter.getUsuCodigo());
        }
        if (examesPorPrestadorFilter.getAgeiStatus() != null) {
            this.params.put("status", examesPorPrestadorFilter.getAgeiStatus());
        }
        if (examesPorPrestadorFilter.getUsrCodigo() != null) {
            this.params.put("solicitante", examesPorPrestadorFilter.getUsrCodigo());
        }
        if (examesPorPrestadorFilter.getMedCodigo() != null) {
            this.params.put("prestador", examesPorPrestadorFilter.getMedCodigo());
        }
        String sql = examesPorPrestadorFilter.getTpRel().equals((Object)TipoRelEnum.SINTETICO) ? ExamesPorPrestadorScript.getSqlSintetico(examesPorPrestadorFilter) : ExamesPorPrestadorScript.getSqlAnalitico(examesPorPrestadorFilter);
        this.rs = Util.resolveResultSet(sql, this.params);
        ArrayList<ExamesPorPrestador> data = new ArrayList<ExamesPorPrestador>();
        if (examesPorPrestadorFilter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
            while (this.rs.next()) {
                exa = new ExamesPorPrestador();
                exa.setPrestador(this.rs.getString("prestador"));
                if (examesPorPrestadorFilter.getAgrSolicitante().booleanValue()) {
                    exa.setSolicitante(this.rs.getString("solicitante"));
                }
                exa.setProcedimento(this.rs.getString("procedimento"));
                exa.setApelido(this.rs.getString("apelido"));
                exa.setCodigoSus(this.rs.getString("codigoSus"));
                exa.setSituacao(this.rs.getString("situacao"));
                exa.setTotal(this.rs.getInt("total"));
                exa.setValorUnitario(this.rs.getDouble("valorUnitario"));
                exa.setValorTotal(this.rs.getDouble("valorTotal"));
                data.add(exa);
            }
        } else {
            while (this.rs.next()) {
                exa = new ExamesPorPrestador();
                exa.setPrestador(this.rs.getString("prestador"));
                exa.setData(this.rs.getDate("data"));
                if (examesPorPrestadorFilter.getAgrSolicitante().booleanValue() || examesPorPrestadorFilter.getAgrPaciente().booleanValue()) {
                    exa.setSolicitante(this.rs.getString("solicitante"));
                    exa.setProntuario(this.rs.getString("prontuario"));
                }
                exa.setProcedimento(this.rs.getString("procedimento"));
                exa.setApelido(this.rs.getString("apelido"));
                exa.setCodigoSus(this.rs.getString("codigoSus"));
                exa.setSituacao(this.rs.getString("situacao"));
                exa.setValorUnitario(this.rs.getDouble("valorUnitario"));
                exa.setPaciente(this.rs.getString("paciente"));
                exa.setCns(this.rs.getString("cns"));
                exa.setDataNascimento(this.rs.getDate("dataNascimento"));
                exa.setData(this.rs.getDate("data"));
                exa.setIdade(this.rs.getInt("idade"));
                data.add(exa);
            }
        }
        String filename = "";
        filename = examesPorPrestadorFilter.getAgrSolicitante() != false && examesPorPrestadorFilter.getAgrPaciente() != false ? "examesporprestadoragrupadoporpacienteesolicitante" : (examesPorPrestadorFilter.getAgrPaciente() != false ? "examesporprestadoragrupadoporpaciente" : (examesPorPrestadorFilter.getAgrSolicitante() != false ? "examesporprestadoragrupadoporsolicitante" : "examesporprestador"));
        String titulo = "Relat\u00f3rio de Exames por Prestador";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, examesPorPrestadorFilter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterExamesPorPrestador(examesPorPrestadorFilter));
        this.creator.addParameter("AGR_SOLICITANTE", examesPorPrestadorFilter.getAgrSolicitante());
        this.creator.gerarPdf();
    }

    @Override
    public void domicilioVinculado(DomicilioVinculadoFilter filter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        if (filter.getDtInicial() != null) {
            this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        }
        if (filter.getUnidade() != null) {
            this.params.put("unidade", filter.getUnidade());
        }
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
            if (filter.getPaciente() != null) {
                this.params.put("paciente", filter.getPaciente());
            }
            this.rs = Util.resolveResultSet(DomicilioVinculadoScript.getSqlAnalitico(filter), this.params);
        } else {
            this.rs = Util.resolveResultSet(DomicilioVinculadoScript.getSqlSintetico(filter), this.params);
        }
        ArrayList<DomicilioVinculado> data = new ArrayList<DomicilioVinculado>();
        while (this.rs.next()) {
            DomicilioVinculado dom = new DomicilioVinculado();
            dom.setUnidade(this.rs.getString("unidade"));
            dom.setEquipe(this.rs.getString("equipe"));
            dom.setIne(this.rs.getString("ine"));
            dom.setProfissional(this.rs.getString("profissional"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                dom.setCodigo(this.rs.getInt("codigo"));
                dom.setNumero(this.rs.getInt("numero"));
                dom.setComplemento(this.rs.getString("complemento"));
                dom.setResponsavel(this.rs.getString("responsavel"));
                dom.setRua(this.rs.getString("rua"));
                dom.setTipoLogradouro(this.rs.getString("tipoLogradouro"));
                dom.setBairro(this.rs.getString("bairro"));
                ArrayList<Participantes> participantes = new ArrayList<Participantes>();
                if (filter.getIntegrantes().contains("S")) {
                    HashMap<String, Object> subParams = new HashMap<String, Object>();
                    subParams.put("codigo", dom.getCodigo());
                    ResultSet rs2 = Util.subResultSet(DomicilioVinculadoScript.getSqlParticipantes(), subParams, this.conn);
                    while (rs2.next()) {
                        Participantes part = new Participantes();
                        part.setPaciente(rs2.getString("paciente"));
                        part.setProntuario(rs2.getString("prontuario"));
                        part.setCns(rs2.getString("cns"));
                        part.setDataNascimento(rs2.getDate("dataNascimento"));
                        part.setTelefone(rs2.getString("telefone"));
                        part.setCelular(rs2.getString("celular"));
                        participantes.add(part);
                    }
                }
                dom.setParticipantes(participantes);
            } else {
                dom.setQtde(this.rs.getInt("qtde"));
            }
            data.add(dom);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName().concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Domic\u00edlios com Usu\u00e1rios Vinculados";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterDomicilioVinculado(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void viagens(ViagensFilter filter) throws Exception {
        Viagens via;
        this.conn = ConnectionUtil.getConnection();
        this.params.put("dtInicial", Util.dateToSqlDate(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToSqlDate(filter.getDtFinal()));
        if (filter.getVeiculo() != null) {
            this.params.put("veiculo", filter.getVeiculo());
        }
        if (filter.getPaciente() != null) {
            this.params.put("paciente", filter.getPaciente());
        }
        if (filter.getMunicipio() != null) {
            this.params.put("municipio", filter.getMunicipio());
        }
        ArrayList<Viagens> data = new ArrayList<Viagens>();
        if (filter.getTpRel().equals((Object)TipoRelEnum.SINTETICO)) {
            this.rs = Util.resolveResultSet(ViagensScript.getSqlSintetico(filter), this.params);
            while (this.rs.next()) {
                via = new Viagens();
                via.setViaCodigo(this.rs.getInt("codigo"));
                via.setData(this.rs.getDate("data"));
                via.setMotorista(this.rs.getString("motorista"));
                via.setVeiculo(this.rs.getString("veiculo"));
                Integer qtde = this.rs.getInt("qtdeAcompanhantes") + this.rs.getInt("qtdePacientes");
                via.setQuantidade(qtde);
                via.setOrigem(this.rs.getString("origem"));
                via.setDestino(this.rs.getString("destino"));
                via.setAgrupamento(filter.getAgrupamento());
                data.add(via);
            }
        } else {
            this.rs = Util.resolveResultSet(ViagensScript.getSqlAnalitico(filter), this.params);
            while (this.rs.next()) {
                via = new Viagens();
                via.setViaCodigo(this.rs.getInt("codigo"));
                via.setData(this.rs.getDate("data"));
                via.setMotorista(this.rs.getString("motorista"));
                via.setVeiculo(this.rs.getString("veiculo"));
                via.setDestino(this.rs.getString("destino"));
                via.setOrigem(this.rs.getString("origem"));
                via.setCns(this.rs.getString("cns"));
                via.setPaciente(this.rs.getString("paciente"));
                via.setCelular(this.rs.getString("celular"));
                via.setTelefone(this.rs.getString("telefone"));
                via.setHoraEmbarque(this.rs.getString("hora_emb"));
                via.setLocalEmbarque(this.rs.getString("local_emb"));
                via.setHoraDesembarque(this.rs.getString("hora_desemb"));
                via.setLocalDesembarque(this.rs.getString("local_desemb"));
                via.setHoraAtendimento(this.rs.getString("hora_atend"));
                via.setLocalAtendimento(this.rs.getString("local_atend"));
                String obs = this.rs.getString("obs");
                if (obs != null && !obs.isEmpty()) {
                    via.setObservacao(Util.removeHtmlFrom(obs));
                }
                HashMap<String, Object> paramAcomp = new HashMap<String, Object>();
                paramAcomp.put("codigo", this.rs.getInt("viausu_codigo"));
                ResultSet rsAcomp = Util.subResultSet(ListaViagemScript.getSqlAcomp(), paramAcomp, this.conn);
                ArrayList<Acompanhante> acomps = new ArrayList<Acompanhante>();
                while (rsAcomp.next()) {
                    Acompanhante acomp = new Acompanhante();
                    acomp.setNome(rsAcomp.getString("nome"));
                    acomp.setCelular(rsAcomp.getString("celular"));
                    acomp.setTelefone(rsAcomp.getString("telefone"));
                    acomps.add(acomp);
                }
                via.setAcompanhantes(acomps);
                via.setAgrupamento(filter.getAgrupamento());
                data.add(via);
            }
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName().concat(filter.getTpRel().name()).toLowerCase();
        String titulo = "Relat\u00f3rio de Viagens";
        this.creator = new JasperCreator(SistemaEnum.SAUDE, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterViagens(filter));
        this.creator.gerarPdf();
    }
}

