/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.filters;

import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.model.Unidade;
import br.com.elotech.saude.model.filters.EstatisticasAreaMicroAreaFilter;
import br.com.elotech.saude.model.filters.FilaDeEsperaFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoExternoMedicoFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoExternoUnidadeFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoPorProfissionalFilter;
import br.com.elotech.saude.model.filters.agendamento.AgendamentoPorUnidadeFilter;
import br.com.elotech.saude.model.filters.agendamento.ConsultasAgendadasFilter;
import br.com.elotech.saude.model.filters.bpa.BpaIdadeFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosGeraisFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosUnidadeFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoCriancaFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoFilter;
import br.com.elotech.saude.model.filters.estratificacao.EstratificacaoHdiFilter;
import br.com.elotech.saude.model.filters.farmacia.DispensacaoTipoReceitaFilter;
import br.com.elotech.saude.model.filters.laboratorio.ExamesPorPrestadorFilter;
import br.com.elotech.saude.model.filters.materiais.MovimentoSaidaFilter;
import br.com.elotech.saude.model.filters.materiais.SaidaTransferenciaMateriaisFilter;
import br.com.elotech.saude.model.filters.psf.BuscaAtivaFilter;
import br.com.elotech.saude.model.filters.psf.DomicilioVinculadoFilter;
import br.com.elotech.saude.model.filters.psf.VisitaDomiciliarFilter;
import br.com.elotech.saude.model.filters.transporte.ViagensFilter;
import br.com.elotech.saude.model.filters.vacinas.ControleVacinadosPorVacinaFilter;
import br.com.elotech.util.Util;
import br.com.elotech.util.UtilFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class FormatFilters {
    private static StringBuilder builder;

    public static String filterAgendamentoPorUnidade(AgendamentoPorUnidadeFilter filter) {
        builder = new StringBuilder();
        String dti = Util.formatDateBR(filter.getDtInicial());
        String dtf = Util.formatDateBR(filter.getDtFinal());
        builder.append(dti).append(" \u00e0 ").append(dtf);
        builder.append(" | Tipo: ").append(filter.getTpRel().name());
        return builder.toString();
    }

    public static String filterFilaDeEspera(FilaDeEsperaFilter filter) throws SQLException {
        Object rs;
        builder = new StringBuilder("Tipo:");
        if (filter.getTpRel().equals((Object)TipoRelEnum.NOME_CNS)) {
            builder.append(" Apenas CNS");
        } else {
            builder.append(" Nome/CNS");
        }
        if (filter.getDataEntrada() != null) {
            builder.append(" Dt Entrada: ".concat(Util.formatDateBR(filter.getDataEntrada())));
        }
        if (filter.getFilaCodigo() != null && (rs = Util.resolveResultSet("SELECT fila_nome from filas where fila_codigo = ".concat(filter.getFilaCodigo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Fila: ".concat(rs.getString("fila_nome")));
        }
        if (filter.getUsuCodigo() != null && (rs = Util.resolveResultSet("SELECT usu_nome from usuario where usu_codigo = ".concat(filter.getUsuCodigo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Usu\u00e1rio: ".concat(rs.getString("usu_nome")));
        }
        if (filter.getStatus() != null) {
            switch (filter.getStatus()) {
                case "AR": {
                    builder.append(" Status: Aguardando Regulador");
                    break;
                }
                case "ES": {
                    builder.append(" Status: Em espera");
                    break;
                }
                case "SA": {
                    builder.append(" Status: Solicita\u00e7\u00e3o agendada");
                    break;
                }
                case "CA": {
                    builder.append(" Status: Cancelada");
                }
            }
        }
        if (filter.getUniCodigo() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUniCodigo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Unidade Solicitante: ".concat(rs.getString("uni_desc")));
        }
        if (filter.getUsrCodigo() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getUsrCodigo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Profissional Solicitante: ".concat(rs.getString("usr_nome")));
        }
        if (filter.getProcCodigo() != null && (rs = Util.resolveResultSet("SELECT proc_nome from procedimento where proc_codigo = ".concat(filter.getProcCodigo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Procedimento: ".concat(rs.getString("proc_nome")));
        }
        return builder.toString();
    }

    public static String filterEstratificacaoHdi(EstratificacaoHdiFilter filter) throws SQLException {
        ResultSet rs;
        builder = new StringBuilder();
        if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Unidade: ".concat(rs.getString("uni_desc")));
        }
        if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" Profissional respons\u00e1vel: ".concat(rs.getString("usr_nome")));
        }
        if (filter.getEquipe() != null) {
            builder.append(" Equipe: ").append(filter.getEquipe());
        }
        if (filter.getRisco() != null) {
            builder.append(" Risco:");
            switch (filter.getRisco()) {
                case "A": {
                    builder.append(" Alto");
                    break;
                }
                case "M": {
                    builder.append(" M\u00e9dio");
                    break;
                }
                case "B": {
                    builder.append(" Baixo");
                }
            }
        }
        return builder.toString();
    }

    public static String filterEstratificacao(EstratificacaoFilter filter) {
        builder = new StringBuilder();
        if (filter.getUnidade() != null) {
            try {
                ResultSet rs;
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUnidade());
                builder.append("Unidade: ".concat(unidade.getUniDescricao()));
                if (StringUtils.isNotBlank(filter.getRisco())) {
                    builder.append(" | Risco: ");
                    switch (filter.getRisco()) {
                        case "A": {
                            builder.append("Alto");
                            break;
                        }
                        case "M": {
                            builder.append("M\u00e9dio");
                            break;
                        }
                        case "B": {
                            builder.append("Baixo");
                            break;
                        }
                        case "N": {
                            builder.append("N\u00e3o Estrat.");
                        }
                    }
                } else {
                    builder.append(" | Risco: Todos ");
                }
                if (StringUtils.isNotBlank(filter.getEquipe())) {
                    String equipe = UtilFilter.getEquipePorNuIne(filter.getEquipe());
                    builder.append(" | Equipe: ".concat(equipe));
                }
                if (filter.getProfissional() != null && (rs = UtilFilter.getUsuarios(filter.getProfissional())) != null) {
                    builder.append(" | Resp. M.A.: ".concat(rs.getString("usr_nome")));
                }
                builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static String filterEstatistica(EstatisticasAreaMicroAreaFilter filter) {
        builder = new StringBuilder();
        if (filter.getUnidade() != null) {
            try {
                String equipe;
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUnidade());
                builder.append("Unidade: ".concat(unidade.getUniDescricao()));
                if (StringUtils.isNotBlank(filter.getEquipe())) {
                    equipe = UtilFilter.getEquipePorNuIne(filter.getEquipe());
                    builder.append(" | Equipe: ".concat(equipe));
                }
                if (filter.getMicroarea() != null) {
                    equipe = UtilFilter.getMicroArea(filter.getMicroarea());
                    builder.append(" | Microarea: ".concat(equipe));
                }
                builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static String filterAgendamentoPorMedico(AgendamentoPorProfissionalFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
            if (filter.getSituacao() != null) {
                switch (filter.getSituacao()) {
                    case ATENDIDOS: {
                        builder.append(" | Situa\u00e7\u00e3o: Atendidos");
                        break;
                    }
                    case FALTOSOS: {
                        builder.append(" | Situa\u00e7\u00e3o: Faltosos");
                        break;
                    }
                    case FALTA_MEDICA: {
                        builder.append(" | Situa\u00e7\u00e3o: Falta M\u00e9dica");
                    }
                }
            }
            builder.append(" | Tipo: ").append(filter.getTpRel().name());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterEstratificacaoCrianca(EstratificacaoCriancaFilter filter) {
        builder = new StringBuilder();
        if (filter.getUnidade() != null) {
            try {
                ResultSet rs;
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUnidade());
                builder.append("Unidade: ".concat(unidade.getUniDescricao()));
                if (StringUtils.isNotBlank(filter.getRisco())) {
                    builder.append(" | Risco: ");
                    switch (filter.getRisco()) {
                        case "A": {
                            builder.append("Alto");
                            break;
                        }
                        case "M": {
                            builder.append("M\u00e9dio");
                            break;
                        }
                        case "B": {
                            builder.append("Baixo");
                            break;
                        }
                        case "N": {
                            builder.append("N\u00e3o Estrat.");
                        }
                    }
                } else {
                    builder.append(" | Risco: Todos ");
                }
                if (StringUtils.isNotBlank(filter.getEquipe())) {
                    String equipe = UtilFilter.getEquipePorNuIne(filter.getEquipe());
                    builder.append(" | Equipe: ".concat(equipe));
                }
                if (filter.getProfissional() != null && (rs = UtilFilter.getUsuarios(filter.getProfissional())) != null) {
                    builder.append(" | Resp. M.A.: ".concat(rs.getString("usr_nome")));
                }
                builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        builder.append(" Faixa(s) Et\u00e1ria(s): ");
        if (filter.getFaixaEtaria() == null) {
            builder.append(" TODAS |");
        } else {
            String[] array = StringUtils.split(filter.getFaixaEtaria(), "|");
            Object object = array;
            int n = ((String[])object).length;
            block42: for (int i = 0; i < n; ++i) {
                String s;
                switch (s = object[i]) {
                    case "1": {
                        builder.append(" 0 \u00e0 1 ");
                        continue block42;
                    }
                    case "2": {
                        builder.append(" 1 \u00e0 2 ");
                        continue block42;
                    }
                    case "3": {
                        builder.append(" 2 \u00e0 3 ");
                        continue block42;
                    }
                    case "4": {
                        builder.append(" 3 \u00e0 4");
                        continue block42;
                    }
                    case "5": {
                        builder.append(" 4 \u00e0 5");
                        continue block42;
                    }
                    case "6": {
                        builder.append(" 5 \u00e0 6");
                        continue block42;
                    }
                    case "7": {
                        builder.append(" 6 \u00e0 7");
                        continue block42;
                    }
                    case "8": {
                        builder.append(" 7 \u00e0 8");
                        continue block42;
                    }
                    case "9": {
                        builder.append(" 8 \u00e0 9");
                        continue block42;
                    }
                    case "10": {
                        builder.append(" 9 \u00e0 10");
                        continue block42;
                    }
                    case "11": {
                        builder.append(" 10 \u00e0 11");
                        continue block42;
                    }
                    case "12": {
                        builder.append(" 11 \u00e0 12");
                    }
                }
            }
            builder.append(" |");
        }
        return builder.toString();
    }

    public static String filterSaidaTransferenciaMateriais(SaidaTransferenciaMateriaisFilter saidaFilter) {
        String dti;
        ResultSet rs;
        builder = new StringBuilder();
        if (saidaFilter.getSetorOrigem() != null) {
            try {
                rs = Util.resolveResultSet("SELECT set_nome from setor where set_codigo = ".concat(saidaFilter.getSetorOrigem().toString()), new HashMap<String, Object>());
                if (rs.next()) {
                    builder.append("Setor de Origem: " + rs.getString("set_nome"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (saidaFilter.getSetorDestino() != null) {
            try {
                rs = Util.resolveResultSet("SELECT set_nome from setor where set_codigo = ".concat(saidaFilter.getSetorDestino().toString()), new HashMap<String, Object>());
                if (rs.next()) {
                    builder.append(" | Setor de Destino: " + rs.getString("set_nome"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (saidaFilter.getDtInicial() != null && saidaFilter.getDtFinal() != null) {
            dti = Util.formatDateBR(saidaFilter.getDtInicial());
            String dtf = Util.formatDateBR(saidaFilter.getDtFinal());
            builder.append(" | Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        } else if (saidaFilter.getDtInicial() != null) {
            dti = Util.formatDateBR(saidaFilter.getDtInicial());
            builder.append(" | Data Inicial: ").append(dti);
        } else if (saidaFilter.getDtFinal() != null) {
            String dtf = Util.formatDateBR(saidaFilter.getDtFinal());
            builder.append(" | Data Final: ").append(dtf);
        }
        return builder.toString();
    }

    public static String filterControleDeVacinadosPorVacina(ControleVacinadosPorVacinaFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
            if (filter.getVacina() != null && (rs = Util.resolveResultSet("SELECT pro_nome from produto where pro_codigo = ".concat(filter.getVacina().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Vacina: " + rs.getString("pro_nome"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterConsultasAgendadas(ConsultasAgendadasFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterProcedimentosGerais(ProcedimentosGeraisFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
            if (filter.getProcedimento() != null && (rs = Util.resolveResultSet("SELECT proc_nome from procedimento where proc_codigo = ".concat(filter.getProcedimento().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Procedimento: " + rs.getString("proc_nome"));
            }
            builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterProcedimentosUnidade(ProcedimentosUnidadeFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
            if (filter.getProcedimento() != null && (rs = Util.resolveResultSet("SELECT proc_nome from procedimento where proc_codigo = ".concat(filter.getProcedimento().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Procedimento: " + rs.getString("proc_nome"));
            }
            builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterMovimentoSaida(MovimentoSaidaFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getSetor() != null && (rs = Util.resolveResultSet("SELECT set_nome from setor where set_codigo = ".concat(filter.getSetor().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Setor: " + rs.getString("set_nome"));
            }
            if (filter.getProduto() != null && (rs = Util.resolveResultSet("SELECT pro_nome from produto where pro_codigo = ".concat(filter.getProduto().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Produto: " + rs.getString("pro_nome"));
            }
            if (StringUtils.isNotBlank(filter.getTpSaida())) {
                String tipo = "";
                switch (filter.getTpSaida()) {
                    case "S": {
                        tipo = "Sa\u00edda p/ consumo";
                        break;
                    }
                    case "D": {
                        tipo = "Dispensa\u00e7\u00e3o p/ paciente";
                        break;
                    }
                    case "M": {
                        tipo = "Sa\u00edda p/  emprestimo";
                        break;
                    }
                    case "P": {
                        tipo = "Sa\u00edda p/ permuta";
                        break;
                    }
                    case "I": {
                        tipo = "Sa\u00edda p/ invent\u00e1rio";
                        break;
                    }
                    case "A": {
                        tipo = "Sa\u00edda p/ ajuste";
                        break;
                    }
                    case "R": {
                        tipo = "Sa\u00edda p/ perdas";
                        break;
                    }
                    case "O": {
                        tipo = "Outras sa\u00eddas";
                        break;
                    }
                    case "T": {
                        tipo = "Transfer\u00eancia";
                        break;
                    }
                    case "S-AE": {
                        tipo = "Ajuste estoque";
                        break;
                    }
                    case "S-AEA": {
                        tipo = "Amostra exposi\u00e7\u00e3o an\u00e1lise";
                        break;
                    }
                    case "S-TR": {
                        tipo = "Transfer\u00eancia remanejamento";
                        break;
                    }
                    case "S-PE": {
                        tipo = "Perda";
                        break;
                    }
                    case "S-D": {
                        tipo = "Doa\u00e7\u00e3o";
                        break;
                    }
                    case "S-VV": {
                        tipo = "Val. Vencida";
                        break;
                    }
                    case "S-DD": {
                        tipo = "Distribui\u00e7\u00e3o";
                        break;
                    }
                    case "S-DEP": {
                        tipo = "Devolu\u00e7\u00e3o entrada";
                        break;
                    }
                    case "S-EE": {
                        tipo = "Devolu\u00e7\u00e3o empr\u00e9stimo";
                        break;
                    }
                    case "S-E": {
                        tipo = "Empr\u00e9stimo";
                        break;
                    }
                    case "S-AS": {
                        tipo = "Apreens\u00e3o_sanit\u00e1ria";
                        break;
                    }
                    case "S-PA": {
                        tipo = "Usu\u00e1rio sus sem cns";
                    }
                }
                builder.append(" | Tipo: ".concat(tipo));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterVisitaDomiciliar(VisitaDomiciliarFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
            if (filter.getDesfecho() != null && (rs = Util.resolveResultSet("SELECT no_cds_visita_dom_desfecho from tb_cds_visita_dom_desfecho where co_cds_visita_dom_desfecho = ".concat(filter.getDesfecho().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Desfecho: " + rs.getString("no_cds_visita_dom_desfecho"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterAgendamentoExternoMedico(AgendamentoExternoMedicoFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getEspecialidade() != null && (rs = Util.resolveResultSet("SELECT esp_nome from especialidade where esp_codigo = ".concat(filter.getEspecialidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Especialidade: " + rs.getString("esp_nome"));
            }
            if (filter.getMedicoDestino() != null && (rs = Util.resolveResultSet("SELECT med_nome from medico where med_codigo = ".concat(filter.getMedicoDestino().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | M\u00e9dico Destino: " + rs.getString("med_nome"));
            }
            if (filter.getMedicoSolicitante() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getMedicoSolicitante().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | M\u00e9dico Solicitante: " + rs.getString("usr_nome"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterBuscaAtiva(BuscaAtivaFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProfissional() != null && (rs = Util.resolveResultSet("SELECT usr_nome from usuarios where usr_codigo = ".concat(filter.getProfissional().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Profissional: " + rs.getString("usr_nome"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterAgendamentoExternoUnidade(AgendamentoExternoUnidadeFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getEspecialidade() != null && (rs = Util.resolveResultSet("SELECT esp_nome from especialidade where esp_codigo = ".concat(filter.getEspecialidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Especialidade: " + rs.getString("esp_nome"));
            }
            if (filter.getProcedimento() != null && (rs = Util.resolveResultSet("SELECT proc_nome from procedimento where proc_codigo = ".concat(filter.getProcedimento().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Procedimento: " + rs.getString("usr_nome"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterBpaIdade(BpaIdadeFilter filter) {
        builder = new StringBuilder();
        try {
            ResultSet rs;
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getProcedimento() != null && (rs = Util.resolveResultSet("SELECT proc_nome from procedimento where proc_codigo = ".concat(filter.getProcedimento().toString()), new HashMap<String, Object>())).next()) {
                builder.append(" | Procedimento: " + rs.getString("proc_nome"));
            }
            builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterDispensacaoTipoReceita(DispensacaoTipoReceitaFilter filter) {
        builder = new StringBuilder();
        try {
            String dti = Util.formatDateBR(filter.getDtInicial());
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
            ResultSet rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>());
            if (rs.next()) {
                builder.append(" | Unidade: " + rs.getString("uni_desc"));
            }
            if (filter.getTpRec() != null) {
                ResultSet rs2 = Util.resolveResultSet("SELECT tr_desc from tipo_receita where tr_codigo = ".concat(filter.getTpRec().toString()), new HashMap<String, Object>());
                if (rs.next()) {
                    builder.append(" | Tipo de Receita: ".concat(rs.getString("tr_desc")));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterExamesPorPrestador(ExamesPorPrestadorFilter filter) {
        builder = new StringBuilder();
        String dti = Util.formatDateBR(filter.getDataInicial());
        String dtf = Util.formatDateBR(filter.getDataFinal());
        builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        if (filter.getUsuCodigo() != null) {
            try {
                ResultSet rs = Util.resolveResultSet("SELECT usu_nome from usuario where usu_codigo = ".concat(filter.getUsuCodigo().toString()), new HashMap<String, Object>());
                if (rs.next()) {
                    builder.append("| Paciente: ".concat(rs.getString("usu_nome")));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (filter.getAgeiStatus() != null) {
            builder.append(" | Situa\u00e7\u00e3o: ");
            switch (filter.getAgeiStatus()) {
                case "A": {
                    builder.append("AGENDADO");
                    break;
                }
                case "C": {
                    builder.append("CANCELADO");
                    break;
                }
                case "F": {
                    builder.append("FALTA");
                    break;
                }
                case "R": {
                    builder.append("REALIZADO");
                    break;
                }
                case "T": {
                    builder.append("TRANSFER\u00caNCIA");
                }
            }
        } else {
            builder.append(" | Situa\u00e7\u00e3o: TODOS");
        }
        return builder.toString();
    }

    public static String filterDomicilioVinculado(DomicilioVinculadoFilter filter) throws SQLException {
        ResultSet rs;
        builder = new StringBuilder();
        String dtf = Util.formatDateBR(filter.getDtFinal());
        if (filter.getDtInicial() != null) {
            String dti = Util.formatDateBR(filter.getDtInicial());
            builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        } else {
            builder.append("Per\u00edodo: in\u00edcio \u00e0 ").append(dtf);
        }
        if (filter.getUnidade() != null && (rs = Util.resolveResultSet("SELECT uni_desc from unidade where uni_codigo = ".concat(filter.getUnidade().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" | Unidade: " + rs.getString("uni_desc"));
        }
        builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
        return builder.toString();
    }

    public static String filterViagens(ViagensFilter filter) throws SQLException {
        ResultSet rs;
        builder = new StringBuilder();
        String dti = Util.formatDateBR(filter.getDtInicial());
        String dtf = Util.formatDateBR(filter.getDtFinal());
        builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        if (filter.getVeiculo() != null && (rs = Util.resolveResultSet("SELECT vei_descricao from veiculo where vei_codigo = ".concat(filter.getVeiculo().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" | Ve\u00edculo: " + rs.getString("vei_descricao"));
        }
        if (filter.getPaciente() != null && (rs = Util.resolveResultSet("SELECT usu_nome from usuario where usu_codigo = ".concat(filter.getPaciente().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" | Paciente: " + rs.getString("usu_nome"));
        }
        if (filter.getMunicipio() != null && (rs = Util.resolveResultSet("SELECT cid_nome from cidade where cid_codigo = ".concat(filter.getMunicipio().toString()), new HashMap<String, Object>())).next()) {
            builder.append(" | Cidade de Destino: " + rs.getString("cid_nome"));
        }
        builder.append(" | Tipo: ".concat(filter.getTpRel().name()));
        return builder.toString();
    }
}

