/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.Main;
import br.com.elotech.saude.model.filters.bpa.BpaIdadeFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosGeraisFilter;
import br.com.elotech.saude.model.filters.bpa.ProcedimentosUnidadeFilter;
import br.com.elotech.util.Util;

public abstract class BpaScript {
    private static StringBuilder builder;

    public static String getSqlProcedimentosGerais(ProcedimentosGeraisFilter filter) {
        builder = new StringBuilder();
        StringBuilder sbFaixa = new StringBuilder();
        StringBuilder sbCaseFaixa = new StringBuilder();
        boolean caseFaixa = false;
        if (filter.getFaixaEtaria() != null && filter.getFaixaEtaria().size() > 0) {
            sbCaseFaixa.append("CASE ");
            for (int i = 0; i < filter.getFaixaEtaria().size(); ++i) {
                String f = filter.getFaixaEtaria().get(i);
                if (i == 0) {
                    sbFaixa.append(" AND (EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f));
                } else {
                    sbFaixa.append(" OR EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f));
                }
                sbCaseFaixa.append(" WHEN EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f).concat(" THEN '").concat(Util.getLabelCase(f)));
            }
            sbFaixa.append(")");
            sbCaseFaixa.append(" ELSE 'Todas idades' END AS faixa,");
            caseFaixa = true;
        }
        switch (filter.getTpRel()) {
            case SINTETICO: {
                builder.append(" SELECT").append("    unidade,").append("    coalesce(profissional, 'N\u00e3o informado') as profissional,").append(caseFaixa ? "faixa, " : "").append("    procedimento,").append(" sum(total) AS total").append(" FROM (").append("         ( SELECT DISTINCT").append("         uni.uni_desc as unidade,").append("         usr.usr_nome as profissional,").append("         trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("         count(proca.pat_codigo) AS total").append("         FROM atendimento AS ate").append("         INNER JOIN procedimento_atendimento AS proca ON ate.ate_codigo = proca.ate_codigo").append("         INNER JOIN procedimento AS proc ON proca.proc_codigo = proc.proc_codigo").append("         INNER JOIN usuarios AS usr ON ate.med_codigo = usr.usr_codigo").append("         INNER JOIN usuario AS usu ON ate.usu_codigo = usu.usu_codigo").append("         INNER JOIN unidade AS uni ON ate.uni_codigo = uni.uni_codigo").append("         WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(" , proc.proc_codigo").append(" UNION ALL").append("         SELECT DISTINCT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(proca.pat_codigo) AS total").append("                 FROM pre_consulta AS pc").append("                 INNER JOIN procedimento_atendimento AS proca ON pc.pc_codigo = proca.pc_codigo").append("                 INNER JOIN procedimento AS proc ON proca.proc_codigo = proc.proc_codigo").append("                 INNER JOIN usuarios AS usr ON pc.usr_codigo = usr.usr_codigo").append("                 INNER JOIN agendamento AS age ON pc.age_codigo = age.age_codigo").append("                 INNER JOIN usuario AS usu ON age.usu_codigo = usu.usu_codigo").append("                 INNER JOIN unidade AS uni ON uni.uni_codigo = age.uni_codigo").append("                 WHERE pc.pc_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                   GROUP BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo").append(" UNION ALL").append("          SELECT DISTINCT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(*) AS total").append("                 FROM atendimento AS ate").append("                 INNER JOIN odonto_procedimentos_controle AS opc ON opc.ate_codigo = ate.ate_codigo").append("                 INNER JOIN odonto_procedimentos_realizados AS opr ON opc.odo_pcon_codigo = opr.odo_pcon_codigo").append("                 INNER JOIN procedimento AS proc ON opr.proc_codigo = proc.proc_codigo").append("                 INNER JOIN usuarios AS usr ON ate.med_codigo = usr.usr_codigo").append("                 INNER JOIN usuario AS usu ON ate.usu_codigo = usu.usu_codigo").append("                 INNER JOIN unidade AS uni ON ate.uni_codigo = uni.uni_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                 GROUP BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo ").append(" UNION ALL").append("          SELECT DISTINCT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(proca.pat_codigo) AS total").append("                 FROM posto_enfermagem AS pe").append("                 INNER JOIN procedimento_atendimento AS proca ON pe.pe_codigo = proca.pe_codigo").append("                 INNER JOIN atendimento AS ate ON ate.ate_codigo = pe.ate_codigo").append("                 INNER JOIN procedimento AS proc ON proca.proc_codigo = proc.proc_codigo").append("                 INNER JOIN usuarios AS usr ON pe.usr_codigo = usr.usr_codigo").append("                 INNER JOIN usuario AS usu ON ate.usu_codigo = usu.usu_codigo").append("                 INNER JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                 GROUP BY uni.uni_desc, usr.usr_nome, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(")) AS procedimentos GROUP BY procedimentos.unidade, procedimentos.profissional").append(caseFaixa ? ",procedimentos.faixa" : "").append(", procedimentos.procedimento ORDER BY procedimentos.unidade, procedimentos.profissional").append(caseFaixa ? ",procedimentos.faixa" : "").append(", procedimentos.procedimento");
                break;
            }
            case ANALITICO: {
                builder.append(" SELECT").append("     unidade,").append("     coalesce(profissional, 'N\u00e3o informado') as profissional,").append(caseFaixa ? "faixa, " : "").append("     procedimento,").append("     cidadao,").append("     dtnascimento,").append("     idade,").append("     cartaosus,").append("     dtatendimento").append(" FROM (").append("         ( SELECT").append("         uni.uni_desc                             AS unidade,").append("         usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("         trim(proc.proc_nome)                     AS procedimento,").append("         usu.usu_nome                             AS cidadao,").append("         usu.usu_datanasc                         AS dtnascimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("         usu.usu_cartao_sus                       AS cartaosus,").append("         cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("         FROM agendamento AS age").append("         LEFT JOIN pre_consulta AS pc ON pc.age_codigo=age.age_codigo").append("         LEFT JOIN atendimento AS ate ON ate.age_codigo=age.age_codigo").append("         LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("         LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo=ate.ate_codigo").append("         JOIN procedimento_atendimento AS pat ON (pat.pc_codigo=pc.pc_codigo)").append("         JOIN procedimento AS proc ON proc.proc_codigo=pat.proc_codigo").append("         JOIN unidade AS uni ON uni.uni_codigo=ate.uni_codigo").append("         LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("         LEFT JOIN usuario AS usu ON usu.usu_codigo=ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, usr.usr_nome ").append(caseFaixa ? ",faixa" : "").append(",proc.proc_codigo, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo, usu.usu_nome, dtatendimento)").append(" UNION").append("         ( SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo=age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo=age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo=ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.ate_codigo=ate.ate_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo=pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo=ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo=ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, usr.usr_nome ").append(caseFaixa ? ",faixa" : "").append(",proc.proc_codigo, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo, usu.usu_nome, dtatendimento)").append(" UNION").append("         ( SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo=age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo=age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo=ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.pe_codigo=pe.pe_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo=pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo=ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo=ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, usr.usr_nome ").append(caseFaixa ? ",faixa" : "").append(",proc.proc_codigo, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo, usu.usu_nome, dtatendimento)").append(" UNION").append("         ( SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM odonto_procedimentos_realizados preal").append("                 LEFT JOIN odonto_procedimentos_controle pcon ON pcon.odo_pcon_codigo = preal.odo_pcon_codigo").append("                 LEFT JOIN atendimento ate ON pcon.ate_codigo = ate.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo=ate.ate_codigo").append("                 left JOIN procedimento_atendimento AS pat ON (pat.pe_codigo=pe.pe_codigo)").append("                 JOIN procedimento proc ON preal.proc_codigo = proc.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo=ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo=ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                   AND CASE ").append("                            WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, usr.usr_nome ").append(caseFaixa ? ",faixa" : "").append(",proc.proc_codigo, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, usr.usr_nome").append(caseFaixa ? ",faixa" : "").append(", proc.proc_codigo, usu.usu_nome, dtatendimento)) AS procedimentos").append(" GROUP BY procedimentos.unidade, procedimentos.profissional").append(caseFaixa ? ",procedimentos.faixa" : "").append("     ,procedimentos.procedimento, procedimentos.cidadao,").append("     procedimentos.dtnascimento, procedimentos.idade, ").append("     procedimentos.cartaosus, procedimentos.dtatendimento").append(" ORDER BY procedimentos.unidade, procedimentos.profissional").append(caseFaixa ? ",procedimentos.faixa" : "").append("     ,procedimentos.procedimento, procedimentos.cidadao, procedimentos.dtatendimento");
            }
        }
        return builder.toString();
    }

    public static String getSqlProcedimentosUnidade(ProcedimentosUnidadeFilter filter) {
        builder = new StringBuilder();
        StringBuilder sbFaixa = new StringBuilder();
        StringBuilder sbCaseFaixa = new StringBuilder();
        boolean caseFaixa = false;
        if (filter.getFaixaEtaria() != null && filter.getFaixaEtaria().size() > 0) {
            sbCaseFaixa.append("CASE ");
            for (int i = 0; i < filter.getFaixaEtaria().size(); ++i) {
                String f = filter.getFaixaEtaria().get(i);
                if (i == 0) {
                    sbFaixa.append(" AND (EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f));
                } else {
                    sbFaixa.append(" OR EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f));
                }
                sbCaseFaixa.append(" WHEN EXTRACT(YEAR FROM age(usu.usu_datanasc)) ".concat(f).concat(" THEN '").concat(Util.getLabelCase(f)));
            }
            sbFaixa.append(")");
            sbCaseFaixa.append(" ELSE 'Todas idades' END AS faixa,");
            caseFaixa = true;
        }
        switch (filter.getTpRel()) {
            case SINTETICO: {
                builder.append(" SELECT").append("    unidade,").append("    coalesce(profissional, 'N\u00e3o informado') as profissional,").append(caseFaixa ? "faixa, " : "").append("    procedimento,").append(" sum(total) AS total").append(" FROM (").append("         (SELECT").append("         uni.uni_desc as unidade,").append("         usr.usr_nome as profissional,").append("         trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("         count(pat.pat_codigo) AS total").append("         FROM agendamento AS age").append("         LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("         LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("         JOIN procedimento_atendimento AS pat ON (pat.pc_codigo = pc.pc_codigo)").append("         JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("         JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("         LEFT JOIN usuarios AS usr ON usr.usr_codigo = pat.usr_codigo").append("         LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("         WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(" , usr.usr_nome ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(pat.pat_codigo) AS total").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.ate_codigo = ate.ate_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo = pat.usr_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                   GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(pat.pat_codigo) AS total").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo = pat.usr_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                 GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 usr.usr_nome as profissional,").append("                 trim(proc.proc_nome) as procedimento,").append((CharSequence)sbCaseFaixa).append("                 count(odo_preal_codigo) AS total").append("                 FROM odonto_procedimentos_realizados preal").append("                 LEFT JOIN odonto_procedimentos_controle pcon ON pcon.odo_pcon_codigo = preal.odo_pcon_codigo").append("                 LEFT JOIN atendimento ate ON pcon.ate_codigo = ate.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 left JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento proc ON preal.proc_codigo = proc.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("                 GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome)) AS procedimentos GROUP BY procedimentos.unidade, procedimentos.procedimento").append(caseFaixa ? ",procedimentos.faixa" : "").append(", procedimentos.profissional ORDER BY procedimentos.unidade, procedimentos.procedimento").append(caseFaixa ? ",procedimentos.faixa" : "").append(", procedimentos.profissional");
                break;
            }
            case ANALITICO: {
                builder.append(" SELECT").append("     unidade,").append("     coalesce(profissional, 'N\u00e3o informado') as profissional,").append(caseFaixa ? "faixa, " : "").append("     procedimento,").append("     cidadao,").append("     dtnascimento,").append("     idade,").append("     cartaosus,").append("     dtatendimento").append(" FROM (").append("         (SELECT").append("         uni.uni_desc                             AS unidade,").append("         usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("         trim(proc.proc_nome)                     AS procedimento,").append("         usu.usu_nome                             AS cidadao,").append("         usu.usu_datanasc                         AS dtnascimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("         usu.usu_cartao_sus                       AS cartaosus,").append("         cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("         FROM agendamento AS age").append("         LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("         LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("         JOIN procedimento_atendimento AS pat ON (pat.pc_codigo = pc.pc_codigo)").append("         JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("         JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("         LEFT JOIN usuarios AS usr ON usr.usr_codigo = pat.usr_codigo").append("         LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome, usu.usu_nome, dtatendimento)").append(" UNION").append("         (SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.ate_codigo=ate.ate_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo = pat.usr_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                  AND CASE ").append("                 WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                 ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(",usr.usr_nome, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome, usu.usu_nome, dtatendimento)").append(" UNION").append("         (SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("           AND CASE ").append("                    WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                    ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(",usr.usr_nome, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome, usu.usu_nome, dtatendimento)").append(" UNION").append("         (SELECT").append("                 uni.uni_desc                             AS unidade,").append("                 usr.usr_nome                             AS profissional,").append((CharSequence)sbCaseFaixa).append("                 trim(proc.proc_nome)                     AS procedimento,").append("                 usu.usu_nome                             AS cidadao,").append("                 usu.usu_datanasc                         AS dtnascimento,").append("                 EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 usu.usu_cartao_sus                       AS cartaosus,").append("                 cast(concat(ate.ate_data, ' ', ate.ate_hora) as timestamp) AS dtatendimento").append("                 FROM odonto_procedimentos_realizados preal").append("                 LEFT JOIN odonto_procedimentos_controle pcon ON pcon.odo_pcon_codigo = preal.odo_pcon_codigo").append("                 LEFT JOIN atendimento ate ON pcon.ate_codigo = ate.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 left JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento proc ON preal.proc_codigo = proc.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuarios AS usr ON usr.usr_codigo=pat.usr_codigo OR usr.usr_codigo = ate.med_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                  AND CASE ").append("                           WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                           ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
                if (filter.getUnidade() != null) {
                    builder.append(" AND uni.uni_codigo = :unidade");
                }
                if (filter.getProfissional() != null) {
                    builder.append(" AND usr.usr_codigo = :profissional");
                }
                if (filter.getProcedimento() != null) {
                    builder.append(" AND proc.proc_codigo = :procedimento");
                }
                builder.append((CharSequence)sbFaixa);
                builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(",usr.usr_nome, usu.usu_nome, usu.usu_datanasc, idade, usu.usu_cartao_sus, dtatendimento").append("         ORDER BY uni.uni_desc, proc.proc_codigo").append(caseFaixa ? ",faixa" : "").append(", usr.usr_nome, usu.usu_nome, dtatendimento)) AS procedimentos").append(" GROUP BY procedimentos.unidade, procedimentos.procedimento").append(caseFaixa ? ",procedimentos.faixa" : "").append("     ,procedimentos.profissional, procedimentos.cidadao,").append("     procedimentos.dtnascimento, procedimentos.idade, ").append("     procedimentos.cartaosus, procedimentos.dtatendimento").append(" ORDER BY procedimentos.unidade, procedimentos.procedimento").append(caseFaixa ? ",procedimentos.faixa" : "").append("     ,procedimentos.profissional, procedimentos.cidadao, procedimentos.dtatendimento");
            }
        }
        return builder.toString();
    }

    public static String getSqlBpaIdade(BpaIdadeFilter filter) {
        builder = new StringBuilder();
        builder.append(" SELECT").append("    unidade,").append("    procedimento,").append("    idade,").append(" sum(total) AS total").append(" FROM (").append("         (SELECT").append("         uni.uni_desc as unidade,").append("         trim(proc.proc_nome) as procedimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("         count(pat.pat_codigo) AS total").append("         FROM agendamento AS age").append("         LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("         LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("         LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("         JOIN procedimento_atendimento AS pat ON (pat.pc_codigo = pc.pc_codigo)").append("         JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("         JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("         LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("         WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("          AND CASE ").append("                   WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                   ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
        if (filter.getUnidade() != null) {
            builder.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProcedimento() != null) {
            builder.append(" AND proc.proc_codigo = :procedimento");
        }
        if (filter.getIdade() != null) {
            builder.append(" AND EXTRACT(YEAR FROM age(usu.usu_datanasc)) = :idade");
        }
        builder.append("         GROUP BY uni.uni_desc, proc.proc_codigo").append(" , idade ORDER BY uni.uni_desc, proc.proc_codigo").append(", idade) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 trim(proc.proc_nome) as procedimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 count(pat.pat_codigo) AS total").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.ate_codigo = ate.ate_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                  AND CASE ").append("                           WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                           ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
        if (filter.getUnidade() != null) {
            builder.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProcedimento() != null) {
            builder.append(" AND proc.proc_codigo = :procedimento");
        }
        if (filter.getIdade() != null) {
            builder.append(" AND EXTRACT(YEAR FROM age(usu.usu_datanasc)) = :idade");
        }
        builder.append("                   GROUP BY uni.uni_desc, proc.proc_codigo").append(", idade ORDER BY uni.uni_desc, proc.proc_codigo").append(", idade) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 trim(proc.proc_nome) as procedimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 count(pat.pat_codigo) AS total").append("                 FROM agendamento AS age").append("                 LEFT JOIN pre_consulta AS pc ON pc.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento AS ate ON ate.age_codigo = age.age_codigo").append("                 LEFT JOIN atendimento_internacao AS atin ON ate.ate_codigo = atin.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento AS proc ON proc.proc_codigo = pat.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                  AND CASE ").append("                           WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                           ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
        if (filter.getUnidade() != null) {
            builder.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProcedimento() != null) {
            builder.append(" AND proc.proc_codigo = :procedimento");
        }
        if (filter.getIdade() != null) {
            builder.append(" AND EXTRACT(YEAR FROM age(usu.usu_datanasc)) = :idade");
        }
        builder.append("                 GROUP BY uni.uni_desc, proc.proc_codigo").append(", idade ORDER BY uni.uni_desc, proc.proc_codigo").append(", idade) UNION").append("         (SELECT").append("                 uni.uni_desc as unidade,").append("                 trim(proc.proc_nome) as procedimento,").append("         EXTRACT(YEAR FROM age(usu.usu_datanasc)) AS idade,").append("                 count(odo_preal_codigo) AS total").append("                 FROM odonto_procedimentos_realizados preal").append("                 LEFT JOIN odonto_procedimentos_controle pcon ON pcon.odo_pcon_codigo = preal.odo_pcon_codigo").append("                 LEFT JOIN atendimento ate ON pcon.ate_codigo = ate.ate_codigo").append("                 LEFT JOIN posto_enfermagem AS pe ON pe.ate_codigo = ate.ate_codigo").append("                 left JOIN procedimento_atendimento AS pat ON (pat.pe_codigo = pe.pe_codigo)").append("                 JOIN procedimento proc ON preal.proc_codigo = proc.proc_codigo").append("                 JOIN unidade AS uni ON uni.uni_codigo = ate.uni_codigo").append("                 LEFT JOIN usuario AS usu ON usu.usu_codigo = ate.usu_codigo").append("                 WHERE ate.ate_data BETWEEN :dt_inicial AND :dt_final ").append("                  AND CASE ").append("                           WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = " + Main.usrLogado + ") THEN 1 = 1").append("                           ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = " + Main.usrLogado + ") END");
        if (filter.getUnidade() != null) {
            builder.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProcedimento() != null) {
            builder.append(" AND proc.proc_codigo = :procedimento");
        }
        if (filter.getIdade() != null) {
            builder.append(" AND EXTRACT(YEAR FROM age(usu.usu_datanasc)) = :idade");
        }
        builder.append("                 GROUP BY uni.uni_desc, proc.proc_codigo").append(", idade ORDER BY uni.uni_desc, proc.proc_codigo").append(", idade)) AS procedimentos GROUP BY procedimentos.unidade, procedimentos.procedimento").append(", idade ORDER BY procedimentos.unidade, procedimentos.procedimento").append(", idade");
        return builder.toString();
    }
}

