/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.vacinas.ControleVacinadosPorVacinaFilter;

public abstract class ControleVacinadosPorVacinaScript {
    private static StringBuilder sb;

    public static String getSql(ControleVacinadosPorVacinaFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ").append("  vac.vac_data                              AS data_aplicacao, ").append("  est.est_descricao                         AS estrategia, ").append("  COALESCE(fab.fab_descricao, 'N\u00c3O INFORMADO')  AS laboratorio, ").append("  COALESCE(ite_lote, 'N\u00c3O INFORMADO')       AS lote, ").append("  usu.usu_nome                              AS paciente, ").append("  usu.usu_datanasc                          AS data_nascimento, ").append("  extract(YEAR from age(usu.usu_datanasc))  AS idade, ").append("  CASE usu.usu_esta_gestante ").append("     WHEN 't' THEN 'SIM' ").append("     ELSE 'N\u00c3O' ").append("  END                                       AS gestante, ").append("  CASE ").append("     WHEN ultimo_atendimento.tipo_consulta = 2 ").append("     THEN 'SIM' ELSE 'N\u00c3O' ").append("  END AS puerpera, ").append("  CASE uis.uis_hanseniase ").append("     WHEN 't' THEN 'SIM' ").append("     ELSE 'N\u00c3O' ").append("  END                                       AS hanseniase, ").append("  vac.vac_dose                              AS dose, ").append("  pro2.pro_nome                             AS vacina, ").append("  uni.uni_desc                              AS unidade, ").append("  usr.usr_nome                              AS profissional ").append("  FROM vacina_usuario AS vac ").append("  JOIN controlefracionado AS cont ON cont.cont_codigo = vac.cont_codigo ").append("  JOIN itens_movimento AS ite ON ite.ite_codigo = cont.ite_codigo ").append("  JOIN movimento AS mov ON ite.mov_codigo = mov.mov_codigo ").append("  JOIN produto AS pro2 ON pro2.pro_codigo = vac.pro_codigo ").append("  JOIN unidade AS uni ON uni.uni_codigo = to_number(vac.vac_unidade,'999999999')").append("  JOIN usuarios AS usr ON usr.usr_codigo = vac.usr_codigo ").append("  LEFT JOIN fabricante AS fab ON ite.fab_codigo = fab.fab_codigo ").append("  JOIN usuario AS usu ON vac.usu_codigo = usu.usu_codigo ").append("  LEFT JOIN usuario_info_sociodemo uis on usu.usu_codigo = uis.usu_codigo ").append("  LEFT JOIN tb_vacina_estrategia AS est ON vac.est_codigo = est.tve_codigo ").append("  LEFT JOIN (SELECT max(ate.ate_codigo) AS ate_codigo,usu_codigo,atp2.tipo_consulta AS tipo_consulta ").append("  FROM atendimento ate ").append("  INNER JOIN atendimento_prenatal atp2 ON atp2.ate_codigo = ate.ate_codigo ").append("  GROUP BY ate.usu_codigo, atp2.tipo_consulta ").append("  )     AS ultimo_atendimento ON usu.usu_codigo = ultimo_atendimento.usu_codigo ").append("  WHERE 1=1 ").append(" AND uni.uni_codigo = :unidade").append(" AND vac.vac_data >=:dt_inicial").append(" AND vac.vac_data <=:dt_final");
        if (filter.getProfissional() != null) {
            sb.append(" AND usr.usr_codigo = :profissional");
        }
        if (filter.getVacina() != null) {
            sb.append(" AND vac.pro_codigo = :vacina");
        }
        sb.append("  ORDER BY pro2.pro_nome,uni.uni_codigo,usr.usr_codigo,vac.vac_data ASC ");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControleVacinadosPorVacinaScript)) {
            return false;
        }
        ControleVacinadosPorVacinaScript other = (ControleVacinadosPorVacinaScript)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ControleVacinadosPorVacinaScript;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "ControleVacinadosPorVacinaScript()";
    }
}

