/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.psf.DomicilioVinculadoFilter;

public abstract class DomicilioVinculadoScript {
    private static StringBuilder sb;

    public static String getSqlSintetico(DomicilioVinculadoFilter filter) {
        sb = new StringBuilder();
        sb.append("  SELECT").append("   count(dom.dom_codigo)    AS qtde,").append("   uni.uni_desc             AS unidade,").append("   usr.usr_nome             AS profissional,").append("   esp.esp_nome             AS especialidade,").append("   te.no_equipe             AS equipe,").append("   te.nu_ine                AS ine").append("  FROM domicilio AS dom").append("   INNER JOIN usuario AS resp ON resp.usu_codigo = dom.usu_codigo_responsavel").append("   INNER JOIN unidade AS uni ON uni.uni_codigo = dom.uni_codigo").append("   INNER JOIN usuarios AS usr ON usr.usr_codigo = dom.usr_codigo").append("   INNER JOIN medico_especialidade AS mep ON mep.med_codigo = usr.usr_codigo and mes_ativo = 'A'").append("   INNER JOIN especialidade AS esp ON esp.esp_codigo = mep.esp_codigo").append("   INNER JOIN tb_equipe AS te ON te.co_seq_equipe = dom.cod_equipe and st_ativo = 'A'").append(" WHERE 1 = 1");
        if (filter.getDtInicial() != null) {
            sb.append(" AND dom.dom_data_cadastro >= :dtInicial");
        }
        if (filter.getDtFinal() != null) {
            sb.append(" AND dom.dom_data_cadastro <= :dtFinal");
        }
        if (filter.getUnidade() != null) {
            sb.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProfissional() != null) {
            sb.append(" AND dom.usr_codigo = :profissional");
        }
        sb.append("  GROUP BY uni.uni_desc, te.no_equipe, te.nu_ine, usr.usr_nome, esp.esp_nome").append("  ORDER BY uni.uni_desc ASC, te.no_equipe ASC, usr.usr_nome ASC");
        return sb.toString();
    }

    public static String getSqlAnalitico(DomicilioVinculadoFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT").append("   dom.dom_codigo           AS codigo,").append("   dom.dom_numero           AS numero,").append("   dom.dom_complemento      AS complemento,").append("   aur.rua_nome             AS rua,").append("   mtl.ds_tipo_logradouro   AS tipoLogradouro,").append("   bai.bai_nome             AS bairro,").append("   resp.usu_nome            AS responsavel,").append("   uni.uni_desc             AS unidade,").append("   usr.usr_nome             AS profissional,").append("   esp.esp_nome             AS especialidade,").append("   te.no_equipe             AS equipe,").append("   te.nu_ine                AS ine").append(" FROM domicilio AS dom").append("   LEFT JOIN rua AS aur ON aur.rua_codigo = dom.rua_codigo").append("   LEFT JOIN tb_ms_tipo_logradouro AS mtl ON mtl.co_tipo_logradouro = aur.co_tipo_logradouro").append("   LEFT JOIN bairro AS bai ON bai.bai_codigo = aur.bai_codigo").append("   LEFT JOIN distrito AS dis ON dis.dis_codigo = bai.dis_codigo").append("   INNER JOIN usuario AS resp ON resp.usu_codigo = dom.usu_codigo_responsavel").append("   INNER JOIN unidade AS uni ON uni.uni_codigo = dom.uni_codigo").append("   INNER JOIN usuarios AS usr ON usr.usr_codigo = dom.usr_codigo").append("   INNER JOIN medico_especialidade AS mep ON mep.med_codigo = usr.usr_codigo and mes_ativo = 'A'").append("   INNER JOIN especialidade AS esp ON esp.esp_codigo = mep.esp_codigo").append("   INNER JOIN tb_equipe AS te ON te.co_seq_equipe = dom.cod_equipe and st_ativo = 'A'").append(" WHERE 1 = 1");
        if (filter.getDtInicial() != null) {
            sb.append(" AND dom.dom_data_cadastro >= :dtInicial");
        }
        if (filter.getDtFinal() != null) {
            sb.append(" AND dom.dom_data_cadastro <= :dtFinal");
        }
        if (filter.getUnidade() != null) {
            sb.append(" AND uni.uni_codigo = :unidade");
        }
        if (filter.getProfissional() != null) {
            sb.append(" AND dom.usr_codigo = :profissional");
        }
        if (filter.getPaciente() != null) {
            sb.append(" AND resp.usu_codigo = :paciente");
        }
        sb.append(" ORDER BY uni.uni_desc ASC,te.no_equipe ASC,usr.usr_nome ASC,dom.dom_codigo ASC, resp.usu_nome ASC");
        return sb.toString();
    }

    public static String getSqlParticipantes() {
        sb = new StringBuilder();
        sb.append(" SELECT").append("   usu.usu_nome             AS paciente,").append("   usu.usu_datanasc         AS dataNascimento,").append("   usu.usu_fone             AS telefone,").append("   usu.usu_celular          AS celular,").append("   usu.usu_cartao_sus       AS cns,").append("   usu.usu_prontuario       AS prontuario").append(" FROM domicilio AS dom").append("   JOIN usuario AS usu ON usu.dom_codigo = dom.dom_codigo").append(" WHERE dom.dom_codigo = :codigo").append(" ORDER BY usu.usu_nome ASC");
        return sb.toString();
    }
}

