/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.EstatisticasAreaMicroAreaFilter;
import org.apache.commons.lang3.StringUtils;

public abstract class EstatisticasAreaMicroAreaScript {
    private static StringBuilder sb;

    public static String getSqlSintetico(EstatisticasAreaMicroAreaFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT").append("       eq.no_equipe      AS equipe,").append("       mic.mic_descricao AS microarea,").append("       usr.usr_nome      AS responsavel,").append("       COALESCE(COUNT(CASE WHEN uis.uis_hanseniase = 't'     THEN 1 END), 0) AS hanseniase_sim,").append("       COALESCE(COUNT(CASE WHEN uis.uis_hanseniase = 'f'     THEN 1 END), 0) AS hanseniase_nao,").append("       COALESCE(COUNT(CASE WHEN uis.uis_hanseniase is null   THEN 1 END), 0) AS hanseniase_ninformado,").append("       COALESCE(COUNT(CASE WHEN uis.uis_fumante = 't'        THEN 1 END), 0) AS tabagistas_sim,").append("       COALESCE(COUNT(CASE WHEN uis.uis_fumante = 'f'        THEN 1 END), 0) AS tabagistas_nao,").append("       COALESCE(COUNT(CASE WHEN uis.uis_fumante is null      THEN 1 END), 0) AS tabagistas_ninformado,").append("       COALESCE(COUNT(CASE WHEN uis.uis_tuberculose = 't'    THEN 1 END), 0) AS tuberculose_sim,").append("       COALESCE(COUNT(CASE WHEN uis.uis_tuberculose = 'f'    THEN 1 END), 0) AS tuberculose_nao,").append("       COALESCE(COUNT(CASE WHEN uis.uis_tuberculose is null  THEN 1 END), 0) AS tuberculose_ninformado").append("    FROM usuario usu").append("    JOIN usuario_info_sociodemo uis ON usu.usu_codigo = uis.usu_codigo").append("    JOIN unidade u                  ON u.uni_codigo = usu.uni_codigo").append("    LEFT JOIN microarea mic         ON mic.mic_codigo = usu.usu_microarea").append("    LEFT JOIN usuarios usr          ON usr.usr_codigo = mic.mic_responsavel").append("    LEFT JOIN tb_equipe eq          ON mic.co_seq_equipe = eq.co_seq_equipe").append("   WHERE u.uni_codigo = :uni_codigo AND mic.ativo is true AND usu.usu_mudanca_territorio = 'f'");
        if (StringUtils.isNotBlank(filter.getEquipe())) {
            sb.append(" AND eq.nu_ine = :nu_equipe");
        }
        if (filter.getMicroarea() != null) {
            sb.append(" AND mic.mic_codigo = :mic_codigo");
        }
        sb.append("   GROUP BY eq.no_equipe, mic.mic_descricao, usr.usr_nome");
        return sb.toString();
    }

    public static String getSqlAnalitico(EstatisticasAreaMicroAreaFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT").append("     eq.no_equipe as equipe,").append("     mic.mic_descricao as microarea,").append("     usr.usr_nome as responsavel,").append("     usu.usu_nome as cidadao,").append("     usu.usu_datanasc as dt_nascimento,").append("     extract(YEAR from age(usu.usu_datanasc)) as idade,").append("     usu.usu_cartao_sus AS cns,").append("     CASE uis.uis_hanseniase").append("         WHEN 't' THEN 'SIM'").append("         WHEN 'f' THEN 'N\u00c3O'").append("         ELSE 'N\u00c3O INFORMADA'").append("     END AS hanseniase,").append("     CASE uis.uis_fumante").append("         WHEN 't' THEN 'SIM'").append("         WHEN 'f' THEN 'N\u00c3O'").append("         ELSE 'N\u00c3O INFORMADA'").append("     END AS tabagista,").append("     CASE uis.uis_tuberculose").append("         WHEN 't' THEN 'SIM'").append("         WHEN 'f' THEN 'N\u00c3O'").append("         ELSE 'N\u00c3O INFORMADA'").append("     END AS tuberculose").append("   FROM usuario usu").append("   JOIN usuario_info_sociodemo uis on usu.usu_codigo = uis.usu_codigo").append("   JOIN unidade u on u.uni_codigo = usu.uni_codigo").append("   JOIN microarea mic on mic.mic_codigo = usu.usu_microarea").append("   JOIN usuarios usr on usr.usr_codigo = mic.mic_responsavel").append("   JOIN tb_equipe as eq on mic.co_seq_equipe = eq.co_seq_equipe").append("  WHERE u.uni_codigo = :uni_codigo AND mic.ativo is true AND usu.usu_mudanca_territorio = 'f'");
        if (StringUtils.isNotBlank(filter.getEquipe())) {
            sb.append(" AND eq.nu_ine = :nu_equipe");
        }
        if (filter.getMicroarea() != null) {
            sb.append(" AND mic.mic_codigo = :mic_codigo");
        }
        sb.append("  ORDER by eq.no_equipe, mic.mic_descricao, usu.usu_nome,").append("        CASE uis.uis_tuberculose").append("           WHEN 't' THEN 1").append("           WHEN 'f' THEN 2").append("           ELSE 3").append("        END,").append("        CASE uis.uis_hanseniase").append("           WHEN 't' THEN 1").append("           WHEN 'f' THEN 2").append("           ELSE 3").append("           END,").append("        CASE uis.uis_fumante").append("           WHEN 't' THEN 1").append("           WHEN 'f' THEN 2").append("           ELSE 3").append("        END;");
        return sb.toString();
    }
}

