/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.laboratorio.ExamesPorPrestadorFilter;

public class ExamesPorPrestadorScript {
    private static StringBuilder sb;

    public static String getSqlSintetico(ExamesPorPrestadorFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT DISTINCT").append("   prestador.med_nome      AS prestador,");
        if (filter.getAgrSolicitante().booleanValue()) {
            sb.append("   COALESCE(usr.usr_nome,med.med_nome,'N\u00c3O INFORMADO') AS solicitante,");
        }
        sb.append("   proc.proc_nome          AS procedimento,").append("   proc.proc_apelido       AS apelido,").append("   proc.proc_codigo_sus    AS codigoSus,").append("   CASE agei.agei_status").append("     WHEN 'A' THEN 'AGENDADO'").append("     WHEN 'C' THEN 'CANCELADO'").append("     WHEN 'F' THEN 'FALTA'").append("     WHEN 'R' THEN 'REALIZADO'").append("     WHEN 'T' THEN 'TRANSFER\u00caNCIA'").append("   END                     AS situacao,");
        if (filter.getAgrSolicitante().booleanValue()) {
            sb.append("   count(agei.agei_codigo) AS total,");
        } else {
            sb.append("count(agei.agei_codigo) as total,");
        }
        sb.append("   coni.coni_valor         AS valorUnitario,").append("   sum(coni.coni_valor)    AS valorTotal").append(" FROM agenda AS age").append("   INNER JOIN agenda_itens AS agei ON age.age_codigo = agei.age_codigo").append("   INNER JOIN convenio_itens AS coni ON coni.coni_codigo = agei.coni_codigo").append("   INNER JOIN convenio AS conv ON coni.conv_codigo = conv.conv_codigo").append("   INNER JOIN medico AS prestador ON conv.med_codigo = prestador.med_codigo").append("   INNER JOIN procedimento AS proc ON proc.proc_codigo = coni.proc_codigo").append("   LEFT JOIN coleta AS col ON col.agei_codigo = agei.agei_codigo");
        if (filter.getAgrSolicitante().booleanValue()) {
            sb.append("   LEFT JOIN usuarios AS usr ON usr.usr_codigo = age.usr_codigo_medico").append("   LEFT JOIN medico AS med ON med.med_codigo = age.med_codigo");
        }
        sb.append(" WHERE agei_data BETWEEN :dataInicial AND :dataFinal");
        if (filter.getAgeiStatus() != null) {
            sb.append("   AND agei.agei_status =:status");
        }
        if (filter.getMedCodigo() != null) {
            sb.append("   AND prestador.med_codigo = :prestador");
        }
        if (filter.getUsrCodigo() != null) {
            sb.append("   AND (usr.usr_codigo = :solicitante OR med.med_codigo = :solicitante)");
        }
        if (filter.getUsuCodigo() != null) {
            sb.append("   AND age.usu_codigo = :paciente");
        }
        sb.append(" GROUP BY").append("   prestador.med_codigo,").append("   prestador.med_nome,");
        if (filter.getAgrSolicitante().booleanValue()) {
            sb.append("   usr.usr_nome,med.med_nome,");
        }
        sb.append("   proc.proc_nome,").append("   proc.proc_codigo_sus,").append("   proc.proc_apelido,").append("   coni.coni_valor,").append("   agei.agei_status,").append("   proc.proc_codigo");
        if (filter.getAgrSolicitante().booleanValue()) {
            sb.append(" ORDER BY prestador, solicitante, proc.proc_nome, proc.proc_apelido,situacao ASC");
        } else {
            sb.append(" ORDER BY prestador, proc.proc_nome, proc.proc_apelido,situacao ASC");
        }
        return sb.toString();
    }

    public static String getSqlAnalitico(ExamesPorPrestadorFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ").append("   prestador.med_nome      AS prestador,").append("   agei.agei_data          AS data,");
        if (filter.getAgrSolicitante().booleanValue() || filter.getAgrPaciente().booleanValue()) {
            sb.append("   COALESCE(usr.usr_nome,med.med_nome,'N\u00c3O INFORMADO') AS solicitante,");
        }
        sb.append("   proc.proc_nome          AS procedimento,").append("   proc.proc_apelido       AS apelido,").append("   proc.proc_codigo_sus    AS codigoSus,").append("   CASE agei.agei_status").append("     WHEN 'A' THEN 'AGENDADO'").append("     WHEN 'C' THEN 'CANCELADO'").append("     WHEN 'F' THEN 'FALTA'").append("     WHEN 'R' THEN 'REALIZADO'").append("     WHEN 'T' THEN 'TRANSFER\u00caNCIA'").append("   END                     AS situacao,").append("   coni.coni_valor         AS valorUnitario,").append("   usu.usu_nome            AS paciente,").append("   usu.usu_prontuario      AS prontuario,").append("   usu.usu_cartao_sus      AS cns,").append("   usu.usu_datanasc        AS dataNascimento,").append("   extract(YEAR from age(usu.usu_datanasc))  AS idade").append("    FROM agenda AS age").append("   INNER JOIN agenda_itens AS agei ON age.age_codigo = agei.age_codigo").append("   INNER JOIN convenio_itens AS coni ON coni.coni_codigo = agei.coni_codigo").append("   INNER JOIN convenio AS conv ON coni.conv_codigo = conv.conv_codigo").append("   INNER JOIN medico AS prestador ON conv.med_codigo = prestador.med_codigo").append("   INNER JOIN procedimento AS proc ON proc.proc_codigo = coni.proc_codigo").append("   INNER JOIN usuario AS usu ON age.usu_codigo = usu.usu_codigo").append("   LEFT JOIN coleta AS col ON col.agei_codigo = agei.agei_codigo").append("   LEFT JOIN usuarios AS usr ON usr.usr_codigo = age.usr_codigo_medico").append("   LEFT JOIN medico AS med ON med.med_codigo = age.med_codigo").append(" WHERE agei_data BETWEEN :dataInicial AND :dataFinal");
        if (filter.getAgeiStatus() != null) {
            sb.append("   AND agei.agei_status =:status");
        }
        if (filter.getMedCodigo() != null) {
            sb.append("   AND prestador.med_codigo = :prestador");
        }
        if (filter.getUsrCodigo() != null) {
            sb.append("   AND usr.usr_codigo = :solicitante OR med.med_codigo = :solicitante");
        }
        if (filter.getUsuCodigo() != null) {
            sb.append("   AND age.usu_codigo = :paciente");
        }
        if (filter.getAgrPaciente().booleanValue() && filter.getAgrSolicitante().booleanValue()) {
            sb.append(" ORDER BY prestador, solicitante, usu.usu_nome ASC, proc.proc_nome, data, proc.proc_apelido,situacao, usu.usu_nome ASC");
        } else if (filter.getAgrPaciente().booleanValue()) {
            sb.append(" ORDER BY prestador, usu.usu_nome ASC, proc.proc_nome, data, proc.proc_apelido,situacao, usu.usu_nome ASC");
        } else if (filter.getAgrSolicitante().booleanValue()) {
            sb.append(" ORDER BY prestador, data,solicitante,proc.proc_nome, proc.proc_apelido,situacao, usu.usu_nome ASC");
        } else {
            sb.append(" ORDER BY prestador, proc.proc_nome, data, proc.proc_apelido,situacao, usu.usu_nome ASC");
        }
        return sb.toString();
    }
}

