/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.FilaDeEsperaFilter;

public abstract class FilaDeEsperaScript {
    private static StringBuilder sb;

    public static String getSql(FilaDeEsperaFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ").append("     fiusu_ordem, ").append("     fiusu_data_entrada, ").append("     fiusu.fiusu_codigo, ").append("     CASE ").append("       WHEN fiusu_status = 'AR' THEN 'Aguardando Regula\u00e7\u00e3o'").append("       WHEN fiusu_status = 'ES' THEN 'Em Espera'").append("       WHEN fiusu_status = 'SA' THEN 'Solicita\u00e7\u00e3o Agendada'").append("       WHEN fiusu_status = 'CA' THEN 'Cancelado'").append("      END AS fiusu_status,").append("     usu_nome,").append("     usu_cartao_sus,").append("     usu_fone,").append("     usu_celular,").append("     COALESCE (usr.usr_nome,med.med_nome) AS medico_solicitante,").append("     fipr_nome,").append("     fiti_nome,").append("     fila_nome,").append("     fila_tipo,").append("     proc.proc_nome,").append("     esp.esp_nome      AS especialidade").append(" FROM filas_usuario fiusu").append(" JOIN usuario AS usu ON fiusu.usu_codigo = usu.usu_codigo ").append(" LEFT JOIN usuarios AS usr ON fiusu.usr_codigo = usr.usr_codigo ").append(" LEFT JOIN medico AS med ON fiusu.med_codigo = med.med_codigo ").append(" JOIN filas_prioridades AS fipr ON fiusu.fipr_codigo = fipr.fipr_codigo ").append(" JOIN filas_tipoatendimentos AS fiti ON fiusu.fiti_codigo = fiti.fiti_codigo ").append(" JOIN filas AS fila ON  fiusu.fila_codigo = fila.fila_codigo ").append(" JOIN filas_usuario_procedimento AS fiproc ON fiusu.fiusu_codigo = fiproc.fiusu_codigo").append(" JOIN especialidade AS esp ON fiusu.esp_codigo = esp.esp_codigo").append(" LEFT JOIN procedimento  AS proc ON fiproc.proc_codigo = proc.proc_codigo").append(" WHERE 1=1");
        if (filter.getFilaCodigo() != null) {
            sb.append(" AND fiusu.fila_codigo = :fila_codigo");
        }
        if (filter.getUsuCodigo() != null) {
            sb.append(" AND fiusu.usu_codigo = :usu_codigo");
        }
        if (filter.getEspCodigo() != null) {
            sb.append(" AND fiusu.esp_codigo = :esp_codigo");
        }
        if (filter.getFitiCodigo() != null) {
            sb.append(" AND fiusu.fiti_codigo = :fiti_codigo");
        }
        if (filter.getFiprCodigo() != null) {
            sb.append(" AND fiusu.fipr_codigo = :fipr_codigo");
        }
        if (filter.getStatus() != null) {
            sb.append(" AND fiusu.fiusu_status = :fiusu_status");
        }
        if (filter.getUniCodigo() != null) {
            sb.append(" AND fiusu.uni_codigo = :uni_codigo");
        }
        if (filter.getProcCodigo() != null) {
            sb.append(" AND fiproc.proc_codigo = :proc_codigo");
        }
        if (filter.getUsrCodigo() != null) {
            sb.append(" AND fiusu.usr_codigo = :usr_codigo");
        }
        if (filter.getDataEntrada() != null) {
            sb.append(" AND date(fiusu.fiusu_data_entrada) = :fiusu_data_entrada");
        }
        sb.append(" ORDER BY fila_nome, ");
        switch (filter.getAgrupamento()) {
            case "E": {
                sb.append("esp.esp_nome,").append(" CASE ").append("    WHEN fiusu_status = 'ES' THEN 1 ").append("    WHEN fiusu_status = 'AR' THEN 2 ").append("    WHEN fiusu_status = 'SA' THEN 3 ").append(" END, fiusu_ordem,").append(" proc.proc_nome, fiusu.fiti_codigo");
                break;
            }
            case "P": {
                sb.append("proc.proc_nome,").append(" CASE ").append("    WHEN fiusu_status = 'ES' THEN 1 ").append("    WHEN fiusu_status = 'AR' THEN 2 ").append("    WHEN fiusu_status = 'SA' THEN 3 ").append(" END, fiusu_ordem, fiusu.fiti_codigo");
                break;
            }
            case "N": {
                sb.append(" CASE ").append("    WHEN fiusu_status = 'ES' THEN 1 ").append("    WHEN fiusu_status = 'AR' THEN 2 ").append("    WHEN fiusu_status = 'SA' THEN 3 ").append(" END, fiusu_ordem,").append("fiusu.fiti_codigo");
            }
        }
        return sb.toString();
    }
}

