/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.materiais.MovimentoSaidaFilter;
import org.apache.commons.lang3.StringUtils;

public abstract class MateriaisScript {
    private static StringBuilder builder;

    public static String getSqlMovimentoSaida(MovimentoSaidaFilter filter) {
        builder = new StringBuilder();
        builder.append(" SELECT").append("     s2.set_nome             AS setor,").append("     CASE mov.mov_saida").append("      WHEN 'S'     THEN 'SA\u00cdDA POR CONSUMO'").append("      WHEN 'D'     THEN 'DISPENSA\u00c7\u00c3O PARA PACIENTE'").append("      WHEN 'M'     THEN 'SA\u00cdDA POR EMPRESTIMO'").append("      WHEN 'P'     THEN 'SA\u00cdDA POR PERMUTA'").append("      WHEN 'I'     THEN 'SA\u00cdDA POR INVENTARIO'").append("      WHEN 'A'     THEN 'SA\u00cdDA POR AJUSTE'").append("      WHEN 'R'     THEN 'SA\u00cdDA POR PERDAS'").append("      WHEN 'O'     THEN 'OUTRAS SA\u00cdDAS'").append("      WHEN 'T'     THEN 'TRANSFER\u00caNCIA'").append("      WHEN 'S-AE'  THEN 'AJUSTE ESTOQUE'").append("      WHEN 'S-AEA' THEN 'AMOSTRA EXPOSI\u00c7\u00c3O_AN\u00c1LISE'").append("      WHEN 'S-TR'  THEN 'TRANSF\u00caRENCIA REMANEJAMENTO'").append("      WHEN 'S-PE'  THEN 'PERDA'").append("      WHEN 'S-D'   THEN 'DOA\u00c7\u00c3O'").append("      WHEN 'S-VV'  THEN 'VALIDADE VENCIDA'").append("      WHEN 'S-DD'  THEN 'DISTRIBUI\u00c7\u00c3O'").append("      WHEN 'S-DEP' THEN 'DEVOLU\u00c7\u00c3O ENTRADA PRODUTO'").append("      WHEN 'S-EE'  THEN 'DEVOLU\u00c7\u00c3O EMPR\u00c9STIMO'").append("      WHEN 'S-E'   THEN 'EMPRESTIMO'").append("      WHEN 'S-AS'  THEN 'APREENS\u00c3O SANIT\u00c1RIA'").append("      WHEN 'S-PA'  THEN 'USU\u00c1RIO SUS S/ CNS'").append("     END                     AS tipo_saida,").append("     pro.pro_nome            AS produto,").append("     mov.mov_data            AS data_movimento,").append("     SUM(ite.ite_quantidade) AS quantidade").append("  FROM itens_movimento ite").append("  JOIN movimento mov ON ite.mov_codigo = mov.mov_codigo").append("  JOIN setor s2      ON mov.set_saida = s2.set_codigo").append("  JOIN produto pro   ON ite.pro_codigo = pro.pro_codigo").append(" WHERE mov.mov_tipo IN ('S', 'T')").append("   AND mov.mov_data BETWEEN :dtInicial AND :dtFinal");
        if (filter.getSetor() != null) {
            builder.append(" AND s2.set_codigo = :setor");
        }
        if (filter.getProduto() != null) {
            builder.append(" AND pro.pro_codigo = :produto");
        }
        if (StringUtils.isNotBlank(filter.getTpSaida())) {
            builder.append(" AND mov.mov_saida = :tpSaida");
        }
        builder.append(" GROUP BY s2.set_nome , mov.mov_saida, pro.pro_nome, mov.mov_data").append(" ORDER BY s2.set_nome , mov.mov_saida, pro.pro_nome, mov.mov_data");
        return builder.toString();
    }
}

