/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.saude.scripts;

import br.com.elotech.saude.model.filters.materiais.SaidaTransferenciaMateriaisFilter;

public abstract class SaidaTransferenciaMateriaisScript {
    private static StringBuilder sb;

    public static String getSqlSaidaTransferenciaMateriais(SaidaTransferenciaMateriaisFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT DISTINCT").append(" pro.pro_codigo   AS codigo,").append(" pro.pro_nome     AS nome,").append(" (SELECT ROUND(AVG(ite2.ite_vlrunit), 4)").append(" FROM itens_movimento ite2 INNER JOIN movimento mov2 ON mov2.mov_codigo = ite2.mov_codigo").append(" WHERE ite2.pro_codigo = ite.pro_codigo ").append("  AND ite2.ite_lote = ite.ite_lote").append("  AND mov2.mov_tipo = 'E') AS custo_unitario,");
        if (filter.getSaida() != null) {
            sb.append(" (SELECT SUM(ite_quantidade)").append("   FROM produto p2").append("   JOIN itens_movimento i2 ON i2.pro_codigo = p2.pro_codigo").append("   JOIN movimento m2 ON i2.mov_codigo = m2.mov_codigo").append("   WHERE 1 = 1");
            if (filter.getDtInicial() != null) {
                sb.append(" AND m2.mov_data >= :dtInicial");
            }
            if (filter.getDtFinal() != null) {
                sb.append(" AND m2.mov_data <= :dtFinal");
            }
            sb.append(" AND (mov_tipo = 'S')").append(" AND set_saida = :setorOrigem").append(" AND ite.ite_lote = i2.ite_lote").append(" AND pro.pro_codigo = p2.pro_codigo").append(" AND (mov_saida <> 'R' AND mov_saida <> 'S-PE' AND mov_saida <> 'S-TR')) AS saida,");
        }
        if (filter.getPerda() != null) {
            sb.append(" (SELECT SUM(ite_quantidade) ").append("  FROM produto p2 ").append("  JOIN itens_movimento i2 ON i2.pro_codigo = p2.pro_codigo ").append("  JOIN movimento m2 ON i2.mov_codigo = m2.mov_codigo ").append("  WHERE 1 = 1 ");
            if (filter.getDtInicial() != null) {
                sb.append("    AND m2.mov_data >= :dtInicial");
            }
            if (filter.getDtFinal() != null) {
                sb.append(" AND m2.mov_data <= :dtFinal");
            }
            sb.append("    AND (mov_tipo = 'S') ").append("    AND ite.ite_lote = i2.ite_lote ").append("    AND (mov_saida = 'R' OR mov_saida = 'S-PE') ").append("    AND (mov_saida <> 'S-TR') ").append("    AND set_saida = :setorOrigem").append("    AND pro.pro_codigo = p2.pro_codigo)  AS perda,");
        }
        if (filter.getTransferencia() != null) {
            sb.append("  (SELECT SUM(ite_quantidade)  ").append("  FROM produto p2 ").append("  JOIN itens_movimento i2 ON i2.pro_codigo = p2.pro_codigo ").append("  JOIN movimento m2 ON i2.mov_codigo = m2.mov_codigo ").append("  LEFT JOIN requisicao_materiais req ON m2.req_codigo = req.rem_codigo ").append("  WHERE 1 = 1 ");
            if (filter.getDtInicial() != null) {
                sb.append("  AND m2.mov_data >= :dtInicial");
            }
            if (filter.getDtFinal() != null) {
                sb.append("  AND m2.mov_data <= :dtFinal");
            }
            sb.append(" AND ((m2.mov_tipo = 'T'");
            if (filter.getSetorDestino() != null) {
                sb.append(" AND m2.set_entrada = :setorDestino)");
            } else {
                sb.append(" )");
            }
            sb.append(" OR (m2.mov_tipo = 'S' AND m2.mov_saida = 'S-TR'");
            if (filter.getSetorDestino() != null) {
                sb.append(" AND req.set_codigo_req = :setorDestino))");
            } else {
                sb.append("))");
            }
            sb.append("      AND ite.ite_lote = i2.ite_lote ");
            if (filter.getSetorOrigem() != null) {
                sb.append("      AND m2.set_saida = :setorOrigem");
            }
            sb.append("      AND pro.pro_codigo = p2.pro_codigo ").append("      AND (m2.mov_saida <> 'R' AND m2.mov_saida <> 'S-PE'))  AS transferencia, ");
        }
        sb.append(" ite.ite_lote    AS lote,").append(" gru.gru_nome    AS grupo").append(" FROM produto AS pro").append(" LEFT JOIN itens_movimento AS ite ON ite.pro_codigo = pro.pro_codigo").append(" LEFT JOIN movimento AS mov ON mov.mov_codigo = ite.mov_codigo").append(" LEFT JOIN setor AS set ON SET.set_codigo = mov.set_saida").append(" LEFT JOIN grupo AS gru ON pro.gru_codigo = gru.gru_codigo").append(" WHERE 1=1");
        if (filter.getDtInicial() != null) {
            sb.append(" AND mov.mov_data >= :dtInicial");
        }
        if (filter.getDtFinal() != null) {
            sb.append(" AND mov.mov_data <= :dtFinal");
        }
        if (filter.getGrupo() != null) {
            sb.append(" AND gru.gru_codigo =:grupo");
        }
        if (filter.getSetorOrigem() != null) {
            sb.append(" AND mov.set_saida = :setorOrigem");
        }
        if (filter.getSaida() != null) {
            // empty if block
        }
        if (filter.getPerda() != null) {
            // empty if block
        }
        if (filter.getTransferencia() != null) {
            // empty if block
        }
        sb.append(" GROUP BY gru.gru_codigo, pro.pro_nome, set.set_codigo, pro.pro_codigo, mov.mov_data, ite.pro_codigo, ite.ite_lote").append(" ORDER BY gru.gru_nome, pro.pro_nome ASC");
        return sb.toString();
    }
}

