/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.social;

import br.com.elotech.social.Social;
import br.com.elotech.social.model.filters.AtaReuniaoFilter;
import br.com.elotech.social.model.filters.AtendimentoBasicoFilter;
import br.com.elotech.social.model.filters.AtendimentoRealizadoAosMunicipesFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaInscricaoAbertaFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaProfissionalFilter;
import br.com.elotech.social.model.filters.BeneficiosPorAtendenteFilter;
import br.com.elotech.social.model.filters.CertidaoLiberatoriaFilter;
import br.com.elotech.social.model.filters.CidadaosCadastradosFilter;
import br.com.elotech.social.model.filters.ProntuarioSuasFilter;
import br.com.elotech.social.model.filters.ResumoGeralFilter;
import br.com.elotech.social.service.Impl.SocialServiceImpl;
import br.com.elotech.social.service.SocialService;
import br.com.elotech.util.Util;

public class SocialController
implements Social {
    private SocialService service = new SocialServiceImpl();

    public void gerarRelatorio(String relatorio, Object filter) throws Exception {
        switch (relatorio.toLowerCase()) {
            case "resumogeral": {
                this.resumoGeral(filter);
                break;
            }
            case "certidaoliberatoria": {
                this.certidaoLiberatoria(filter);
                break;
            }
            case "atareuniao": {
                this.ataReuniao(filter);
                break;
            }
            case "atividadecoletivainscricaoaberta": {
                this.atividadeColetivaInscricaoAberta(filter);
                break;
            }
            case "atendimentorealizadoaosmunicipes": {
                this.atendimentoRealizadoAosMunicipes(filter);
                break;
            }
            case "prontuariosuas": {
                this.prontuarioSuas(filter);
                break;
            }
            case "beneficiosporatendente": {
                this.beneficiosPorAtendente(filter);
                break;
            }
            case "cidadaoscadastrados": {
                this.cidadaosCadastrados(filter);
                break;
            }
            case "atividadecoletivaprofissional": {
                this.atividadeColetivaProfissional(filter);
                break;
            }
            case "atendimentobasico": {
                this.atendimentoBasico(filter);
            }
        }
    }

    @Override
    public void resumoGeral(Object filter) throws Exception {
        ResumoGeralFilter resumoGeralFilter = (ResumoGeralFilter)Util.fromJsom(filter.toString(), ResumoGeralFilter.class);
        this.service.resumoGeral(resumoGeralFilter);
    }

    @Override
    public void certidaoLiberatoria(Object filter) throws Exception {
        CertidaoLiberatoriaFilter certidaoLiberatoriaFilter = (CertidaoLiberatoriaFilter)Util.fromJsom(filter.toString(), CertidaoLiberatoriaFilter.class);
        this.service.certidaoLiberatoria(certidaoLiberatoriaFilter);
    }

    @Override
    public void atividadeColetivaInscricaoAberta(Object filter) throws Exception {
        AtividadeColetivaInscricaoAbertaFilter atividadeColetivaInscricaoAbertaFilter = (AtividadeColetivaInscricaoAbertaFilter)Util.fromJsom(filter.toString(), AtividadeColetivaInscricaoAbertaFilter.class);
        this.service.atividadeColetivaInscricaoAberta(atividadeColetivaInscricaoAbertaFilter);
    }

    @Override
    public void ataReuniao(Object filter) throws Exception {
        AtaReuniaoFilter ataReuniaoFilter = (AtaReuniaoFilter)Util.fromJsom(filter.toString(), AtaReuniaoFilter.class);
        this.service.ataReuniao(ataReuniaoFilter);
    }

    @Override
    public void atendimentoRealizadoAosMunicipes(Object filter) throws Exception {
        AtendimentoRealizadoAosMunicipesFilter atendimentoRealizadoAosMunicipesFilter = (AtendimentoRealizadoAosMunicipesFilter)Util.fromJsom(filter.toString(), AtendimentoRealizadoAosMunicipesFilter.class);
        this.service.atendimentoRealizadoAosMunicipes(atendimentoRealizadoAosMunicipesFilter);
    }

    @Override
    public void prontuarioSuas(Object filter) throws Exception {
        ProntuarioSuasFilter prontuarioSuasFilter = (ProntuarioSuasFilter)Util.fromJsom(filter.toString(), ProntuarioSuasFilter.class);
        this.service.prontuarioSuas(prontuarioSuasFilter);
    }

    @Override
    public void beneficiosPorAtendente(Object filter) throws Exception {
        BeneficiosPorAtendenteFilter beneficiosPorAtendenteFilter = (BeneficiosPorAtendenteFilter)Util.fromJsom(filter.toString(), BeneficiosPorAtendenteFilter.class);
        this.service.beneficiosPorAtendente(beneficiosPorAtendenteFilter);
    }

    @Override
    public void cidadaosCadastrados(Object filter) throws Exception {
        CidadaosCadastradosFilter cidadaosCadastradosFilter = (CidadaosCadastradosFilter)Util.fromJsom(filter.toString(), CidadaosCadastradosFilter.class);
        this.service.cidadaosCadastrados(cidadaosCadastradosFilter);
    }

    @Override
    public void atividadeColetivaProfissional(Object filter) throws Exception {
        AtividadeColetivaProfissionalFilter coletivaProfissionalFilter = (AtividadeColetivaProfissionalFilter)Util.fromJsom(filter.toString(), AtividadeColetivaProfissionalFilter.class);
        this.service.atividadeColetivaProfissional(coletivaProfissionalFilter);
    }

    @Override
    public void atendimentoBasico(Object filter) throws Exception {
        AtendimentoBasicoFilter atendimentoBasicoFilter = (AtendimentoBasicoFilter)Util.fromJsom(filter.toString(), AtendimentoBasicoFilter.class);
        this.service.atendimentoBasico(atendimentoBasicoFilter);
    }
}

