/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.social.dao.Impl;

import br.com.elotech.config.ConnectionUtil;
import br.com.elotech.enuns.SistemaEnum;
import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.social.filters.FormatFilters;
import br.com.elotech.social.model.filters.ResumoGeralFilter;
import br.com.elotech.social.model.resumoGeral.AtendimentoBasico;
import br.com.elotech.social.model.resumoGeral.AtividadeColetiva;
import br.com.elotech.social.model.resumoGeral.AtividadeColetivaParticipantes;
import br.com.elotech.social.model.resumoGeral.BeneficioBeneficiario;
import br.com.elotech.social.model.resumoGeral.BeneficiosOfertados;
import br.com.elotech.social.model.resumoGeral.RelatorioGeral;
import br.com.elotech.social.model.resumoGeral.RelatorioGeralAtendimento;
import br.com.elotech.social.model.resumoGeral.RelatorioGeralAtividade;
import br.com.elotech.social.model.resumoGeral.RelatorioGeralAtividadeEncontro;
import br.com.elotech.social.model.resumoGeral.RelatorioGeralBeneficio;
import br.com.elotech.social.model.resumoGeral.RelatorioGeralEncaminhamento;
import br.com.elotech.social.scripts.ResumoGeralScript;
import br.com.elotech.util.JasperCreator;
import br.com.elotech.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ResumoGeral {
    private Connection conn;
    private PreparedStatement pstm;
    private ResultSet rs;
    private JasperCreator creator;
    private Map<String, Object> params = new HashMap<String, Object>();

    public void imprimeAtividadeColetiva(ResumoGeralFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("usr_codigo", filter.getUsuarioLogado());
        if (filter.getUniCodigo() != null) {
            this.params.put("uni_codigo", filter.getUniCodigo());
        }
        this.rs = Util.resolveResultSet(ResumoGeralScript.getSqlAtividadeColetiva(filter), this.params);
        ArrayList<AtividadeColetiva> data = new ArrayList<AtividadeColetiva>();
        while (this.rs.next()) {
            AtividadeColetiva ac = new AtividadeColetiva();
            ac.setGruDescricao(this.rs.getString("gru_descricao"));
            ac.setGruQtdePermitida(this.rs.getInt("gru_qtde_permitida"));
            ac.setEncTitulo(this.rs.getString("enc_titulo"));
            ac.setEncDescricao(this.rs.getString("enc_descricao"));
            ac.setEncEstabelecimento(this.rs.getString("enc_estabelecimento"));
            ac.setEncData(this.rs.getDate("enc_data"));
            ac.setEncQtdeParticipante(this.rs.getInt("qtde_participantes"));
            ac.setEncQtdePresente(this.rs.getInt("qtde_presente"));
            ac.setEncQtdeFalta(this.rs.getInt("qtde_falta"));
            if (filter.getTp_rel().equals((Object)TipoRelEnum.ANALITICO)) {
                HashMap<String, Object> p2 = new HashMap<String, Object>();
                p2.put("enc_codigo", this.rs.getInt("enc_codigo"));
                ResultSet rsp = Util.resolveResultSet(ResumoGeralScript.getSqlAtividadeColetivaParticipantes(), p2);
                while (rsp.next()) {
                    AtividadeColetivaParticipantes acp = new AtividadeColetivaParticipantes();
                    acp.setCidadao(rsp.getString("cidadao"));
                    acp.setDtNascimento(rsp.getDate("dt_nascimento"));
                    acp.setIdade(rsp.getInt("idade"));
                    acp.setTelefone(rsp.getString("telefone"));
                    acp.setCelular(rsp.getString("celular"));
                    acp.setStatus(rsp.getString("status"));
                    ac.getParticipantes().add(acp);
                }
            }
            data.add(ac);
        }
        String titulo = "Relat\u00f3rio Atividade Coletiva";
        String filename = filter.getTipo().toLowerCase();
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterResumoGeral(filter));
        this.creator.gerarPdf();
    }

    public void imprimeBeneficiosOfertados(ResumoGeralFilter filter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("usr_codigo", filter.getUsuarioLogado());
        if (filter.getUniCodigo() != null) {
            this.params.put("uni_codigo", filter.getUniCodigo());
        }
        this.rs = Util.subResultSet(ResumoGeralScript.getSqlBeneficiosOfertados(filter), this.params, this.conn);
        ArrayList<BeneficiosOfertados> data = new ArrayList<BeneficiosOfertados>();
        while (this.rs.next()) {
            BeneficiosOfertados bo = new BeneficiosOfertados();
            bo.setUnidade(this.rs.getString("unidade"));
            bo.setBeneficio(this.rs.getString("beneficio"));
            bo.setQtdeBeneficio(this.rs.getInt("quantidade"));
            if (filter.getTp_rel().equals((Object)TipoRelEnum.ANALITICO)) {
                HashMap<String, Object> pBen = new HashMap<String, Object>();
                pBen.put("ben_codigo", this.rs.getInt("ben_codigo"));
                pBen.put("uni_codigo", this.rs.getInt("uni_codigo"));
                pBen.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
                pBen.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
                ResultSet rsBen = Util.subResultSet(ResumoGeralScript.getSqlBeneficiosPorBeneficiario(), pBen, this.conn);
                while (rsBen.next()) {
                    BeneficioBeneficiario bb = new BeneficioBeneficiario();
                    bb.setBeneficiario(rsBen.getString("beneficiario"));
                    bb.setDtCadastro(rsBen.getDate("dt_cadastro"));
                    bb.setDtEntrega(rsBen.getDate("dt_entrega"));
                    bb.setConcedido(rsBen.getString("concedido"));
                    bb.setSituacao(rsBen.getString("situacao"));
                    bb.setQtdeBeneficiario(rsBen.getInt("quantidade"));
                    bo.getBeneficiarios().add(bb);
                }
            }
            data.add(bo);
        }
        String filename = filter.getTipo().toLowerCase();
        String titulo = "Relat\u00f3rio de Benef\u00edcios";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterResumoGeral(filter));
        this.creator.gerarPdf();
    }

    public void imprimeAtendimentoBasico(ResumoGeralFilter filter) throws Exception {
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("usr_codigo", filter.getUsuarioLogado());
        if (filter.getUniCodigo() != null) {
            this.params.put("uni_codigo", filter.getUniCodigo());
        }
        this.rs = Util.resolveResultSet(ResumoGeralScript.getSqlAtendimentoBasico(filter), this.params);
        ArrayList<AtendimentoBasico> data = new ArrayList<AtendimentoBasico>();
        while (this.rs.next()) {
            AtendimentoBasico ab = new AtendimentoBasico();
            ab.setUnidade(this.rs.getString("unidade"));
            ab.setTipoAtendimento(this.rs.getString("tipo_atendimento"));
            ab.setProfissional(this.rs.getString("profissional"));
            ab.setMotivo(this.rs.getString("motivo"));
            ab.setData(this.rs.getDate("data"));
            ab.setQuantidade(this.rs.getInt("quantidade"));
            data.add(ab);
        }
        String filename = filter.getTipo().toLowerCase();
        String titulo = "Relat\u00f3rio de Atendimento B\u00e1sico";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterResumoGeral(filter));
        this.creator.gerarPdf();
    }

    public void imprimeRelatorioGeral(ResumoGeralFilter filter) throws Exception {
        this.conn = ConnectionUtil.getConnection();
        Timestamp dtInicial = Util.dateToTimeStamp(filter.getDtInicial());
        Timestamp dtFinal = Util.dateToTimeStamp(filter.getDtFinal());
        this.params.put("dt_inicial", dtInicial);
        this.params.put("dt_final", dtFinal);
        this.params.put("usr_codigo", filter.getUsuarioLogado());
        if (filter.getUniCodigo() != null) {
            this.params.put("uni_codigo", filter.getUniCodigo());
        }
        this.rs = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral(filter), this.params, this.conn);
        ArrayList<RelatorioGeral> data = new ArrayList<RelatorioGeral>();
        while (this.rs.next()) {
            RelatorioGeral relatorioGeral = new RelatorioGeral();
            relatorioGeral.setUsuCodigo(this.rs.getLong("usu_codigo"));
            relatorioGeral.setUsuNome(this.rs.getString("usu_nome"));
            relatorioGeral.setTipo(filter.getTp_rel().name());
            HashMap<String, Object> pAte = new HashMap<String, Object>();
            pAte.put("dt_inicial", dtInicial);
            pAte.put("dt_final", dtFinal);
            pAte.put("usu_codigo", relatorioGeral.getUsuCodigo());
            pAte.put("uni_codigo", this.rs.getInt("uni_codigo"));
            ResultSet rsAte = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral_atendimento(filter), pAte, this.conn);
            while (rsAte.next()) {
                RelatorioGeralAtendimento rga = new RelatorioGeralAtendimento();
                rga.setUnidade(rsAte.getString("unidade"));
                rga.setTipoAtendimento(rsAte.getString("tipo_atendimento"));
                rga.setProfissional(rsAte.getString("profissional"));
                rga.setMotivos(rsAte.getString("motivos"));
                rga.setDataAtendimento(rsAte.getDate("data_atendimento"));
                relatorioGeral.getAtendimentos().add(rga);
            }
            HashMap<String, Object> pBen = new HashMap<String, Object>();
            pBen.put("dt_inicial", dtInicial);
            pBen.put("dt_final", dtFinal);
            pBen.put("usu_codigo", relatorioGeral.getUsuCodigo());
            pBen.put("uni_codigo", this.rs.getInt("uni_codigo"));
            ResultSet rsBen = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral_beneficios(filter), pBen, this.conn);
            while (rsBen.next()) {
                RelatorioGeralBeneficio rgb = new RelatorioGeralBeneficio();
                rgb.setBeneficio(rsBen.getString("beneficio"));
                rgb.setAtendente(rsBen.getString("atendente"));
                rgb.setDataCadastro(rsBen.getDate("data_cadastro"));
                rgb.setDataEntrega(rsBen.getDate("data_entrega"));
                rgb.setQuantidade(rsBen.getInt("quantidade"));
                relatorioGeral.getBeneficios().add(rgb);
            }
            HashMap<String, Object> pEnc = new HashMap<String, Object>();
            pEnc.put("dt_inicial", dtInicial);
            pEnc.put("dt_final", dtFinal);
            pEnc.put("usu_codigo", relatorioGeral.getUsuCodigo());
            pEnc.put("uni_codigo", this.rs.getInt("uni_codigo"));
            ResultSet rsEnc = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral_encaminhamento(filter), pEnc, this.conn);
            while (rsEnc.next()) {
                RelatorioGeralEncaminhamento rge = new RelatorioGeralEncaminhamento();
                rge.setOrigem(rsEnc.getString("origem"));
                rge.setDestino(rsEnc.getString("destino"));
                rge.setTitulo(rsEnc.getString("titulo"));
                rge.setDataEncaminhamento(rsEnc.getDate("data_encaminhamento"));
                rge.setProfissional(rsEnc.getString("profissional"));
                relatorioGeral.getEncaminhamentos().add(rge);
            }
            HashMap<String, Object> pAti = new HashMap<String, Object>();
            pAti.put("usu_codigo", relatorioGeral.getUsuCodigo());
            pAti.put("uni_codigo", this.rs.getInt("uni_codigo"));
            ResultSet rsAti = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral_atividade(filter), pAti, this.conn);
            ArrayList atividades = new ArrayList();
            while (rsAti.next()) {
                RelatorioGeralAtividade rgat = new RelatorioGeralAtividade();
                rgat.setCodigoGrupo(rsAti.getLong("codigo"));
                rgat.setGrupo(rsAti.getString("grupo"));
                rgat.setUnidade(rsAti.getString("unidade"));
                HashMap<String, Object> pAtiEnc = new HashMap<String, Object>();
                pAtiEnc.put("gru_codigo", rgat.getCodigoGrupo());
                pAtiEnc.put("usu_codigo", relatorioGeral.getUsuCodigo());
                ResultSet rsAtiEnc = Util.subResultSet(ResumoGeralScript.getSqlRelatorioGeral_atividade_encontro(), pAtiEnc, this.conn);
                while (rsAtiEnc.next()) {
                    RelatorioGeralAtividadeEncontro rgae = new RelatorioGeralAtividadeEncontro();
                    rgae.setTitulo(rsAtiEnc.getString("titulo"));
                    rgae.setDescricao(rsAtiEnc.getString("descricao"));
                    rgae.setDataInicio(rsAtiEnc.getTimestamp("dt_inicio"));
                    rgae.setDataFinal(rsAtiEnc.getTimestamp("dt_final"));
                    rgae.setPresenca(rsAtiEnc.getString("asaeh_presenca"));
                    rgat.getEncontros().add(rgae);
                }
                relatorioGeral.getAtividades().add(rgat);
            }
            data.add(relatorioGeral);
        }
        this.conn.close();
        String titulo = "Relat\u00f3rio Geral";
        String filename = filter.getTipo().toLowerCase();
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterResumoGeral(filter));
        this.creator.gerarPdf();
    }
}

