/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.social.dao.Impl;

import br.com.elotech.config.ConnectionUtil;
import br.com.elotech.enuns.SistemaEnum;
import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.social.dao.Impl.ResumoGeral;
import br.com.elotech.social.dao.SocialDao;
import br.com.elotech.social.filters.FormatFilters;
import br.com.elotech.social.model.atendimento.CertidaoLiberatoria;
import br.com.elotech.social.model.cadastros.AtaReuniao;
import br.com.elotech.social.model.cadastros.ReuniaoParticipantes;
import br.com.elotech.social.model.filters.AtaReuniaoFilter;
import br.com.elotech.social.model.filters.AtendimentoBasicoFilter;
import br.com.elotech.social.model.filters.AtendimentoRealizadoAosMunicipesFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaInscricaoAbertaFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaProfissionalFilter;
import br.com.elotech.social.model.filters.BeneficiosPorAtendenteFilter;
import br.com.elotech.social.model.filters.CertidaoLiberatoriaFilter;
import br.com.elotech.social.model.filters.CidadaosCadastradosFilter;
import br.com.elotech.social.model.filters.ProntuarioSuasFilter;
import br.com.elotech.social.model.filters.ResumoGeralFilter;
import br.com.elotech.social.model.prontuarioSuas.Analfabeto;
import br.com.elotech.social.model.prontuarioSuas.AnotacoesProgramasCidadao;
import br.com.elotech.social.model.prontuarioSuas.AnotacoesProgramasFamilia;
import br.com.elotech.social.model.prontuarioSuas.AnotacoesSaude;
import br.com.elotech.social.model.prontuarioSuas.AtendimentoBasico;
import br.com.elotech.social.model.prontuarioSuas.AtendimentoColetivo;
import br.com.elotech.social.model.prontuarioSuas.BeneficioEventual;
import br.com.elotech.social.model.prontuarioSuas.BeneficioItem;
import br.com.elotech.social.model.prontuarioSuas.CondicoesEducacionais;
import br.com.elotech.social.model.prontuarioSuas.CondicoesHabitacionais;
import br.com.elotech.social.model.prontuarioSuas.ConvivenciaFamiliar;
import br.com.elotech.social.model.prontuarioSuas.Encaminhamento;
import br.com.elotech.social.model.prontuarioSuas.FaixaEtaria;
import br.com.elotech.social.model.prontuarioSuas.HistoricoAcolhimento;
import br.com.elotech.social.model.prontuarioSuas.MedidaSocioEducativa;
import br.com.elotech.social.model.prontuarioSuas.NaoFrequentaEscola;
import br.com.elotech.social.model.prontuarioSuas.Observacao;
import br.com.elotech.social.model.prontuarioSuas.PessoaFamilia;
import br.com.elotech.social.model.prontuarioSuas.PessoaReferencia;
import br.com.elotech.social.model.prontuarioSuas.ProntuarioSuas;
import br.com.elotech.social.model.prontuarioSuas.RegistroViolacao;
import br.com.elotech.social.model.relatorio.AtendimentoRealizadoAosMunicipes;
import br.com.elotech.social.model.relatorio.AtividadeColetivaInscricaoAberta;
import br.com.elotech.social.model.relatorio.AtividadeColetivaProfissional;
import br.com.elotech.social.model.relatorio.BeneficiosPorAtendente;
import br.com.elotech.social.model.relatorio.CidadaosCadastrados;
import br.com.elotech.social.scripts.AtaReuniaoScript;
import br.com.elotech.social.scripts.AtendimentoBasicoScript;
import br.com.elotech.social.scripts.AtendimentoRealizadoAosMunicipesScript;
import br.com.elotech.social.scripts.AtividadeColetivaInscricaoAbertaScript;
import br.com.elotech.social.scripts.AtividadeColetivaProfissionalScript;
import br.com.elotech.social.scripts.BeneficiosPorAtendenteScript;
import br.com.elotech.social.scripts.CertidaoLiberatoriaScript;
import br.com.elotech.social.scripts.CidadaosCadastradosScript;
import br.com.elotech.social.scripts.ProntuarioSuasScript;
import br.com.elotech.util.JasperCreator;
import br.com.elotech.util.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SocialDaoImpl
implements SocialDao {
    private Connection conn;
    private ResultSet rs;
    private JasperCreator creator;
    private Map<String, Object> params = new HashMap<String, Object>();
    private final String ATENDIMENTO_BASICO = "atendimento_basico";
    private final String BENEFICIOS_OFERTADOS = "beneficios_ofertados";
    private final String ATIVIDADE_COLETIVA = "atividade_coletiva";
    private final String RELATORIO_GERAL = "relatorio_geral";

    @Override
    public void resumoGeral(ResumoGeralFilter filter) throws Exception {
        ResumoGeral resumoGeral = new ResumoGeral();
        switch (filter.getTipo()) {
            case "atendimento_basico": {
                resumoGeral.imprimeAtendimentoBasico(filter);
                break;
            }
            case "beneficios_ofertados": {
                resumoGeral.imprimeBeneficiosOfertados(filter);
                break;
            }
            case "atividade_coletiva": {
                resumoGeral.imprimeAtividadeColetiva(filter);
                break;
            }
            case "relatorio_geral": {
                resumoGeral.imprimeRelatorioGeral(filter);
            }
        }
    }

    @Override
    public void certidaoLiberatoria(CertidaoLiberatoriaFilter filter) throws Exception {
        this.params.put("asclCodigo", filter.getAsclCodigo());
        this.rs = Util.resolveResultSet(CertidaoLiberatoriaScript.getSqlCertidaoLiberatoria(filter), this.params);
        ArrayList<CertidaoLiberatoria> data = new ArrayList<CertidaoLiberatoria>();
        while (this.rs.next()) {
            CertidaoLiberatoria certidao = new CertidaoLiberatoria();
            certidao.setUnidade(this.rs.getString("uni_desc"));
            certidao.setCnpjUnidade(this.rs.getString("uni_cnpj"));
            certidao.setLei(this.rs.getString("ascl_lei"));
            certidao.setDecreto(this.rs.getString("ascl_decreto"));
            certidao.setDataValidade(this.rs.getDate("ascl_data_validade"));
            certidao.setDataConcessao(this.rs.getDate("ascl_data_concessao"));
            certidao.setNumero(this.rs.getInt("ascl_numero"));
            certidao.setExercicio(this.rs.getInt("ascl_exercicio"));
            certidao.setProfissional(this.rs.getString("usr_nome"));
            certidao.setCargo(this.rs.getString("crg_nome"));
            data.add(certidao);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Certid\u00e3o Liberat\u00f3ria";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterCertidaoLiberatoria(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void atividadeColetivaInscricaoAberta(AtividadeColetivaInscricaoAbertaFilter filter) throws Exception {
        if (filter.getUniCodigo() != null) {
            this.params.put("unidade", filter.getUniCodigo());
        }
        this.params.put("usr_codigo", filter.getUsr_logado());
        this.rs = Util.resolveResultSet(AtividadeColetivaInscricaoAbertaScript.getSqlAtividadeColetivaInscricaoAberta(filter), this.params);
        ArrayList<AtividadeColetivaInscricaoAberta> data = new ArrayList<AtividadeColetivaInscricaoAberta>();
        while (this.rs.next()) {
            AtividadeColetivaInscricaoAberta atividade = new AtividadeColetivaInscricaoAberta();
            atividade.setUnidade(this.rs.getString("uni_desc"));
            atividade.setGruDescricao(this.rs.getString("asag_titulo"));
            atividade.setGruQtdePermitida(this.rs.getInt("asag_quantidade_grupo"));
            if (this.rs.getInt("asag_quantidade_grupo") - this.rs.getInt("gruQtdeVagasOcupadas") >= 0) {
                atividade.setGruQtdeVagasAbertas(this.rs.getInt("asag_quantidade_grupo") - this.rs.getInt("gruQtdeVagasOcupadas"));
            } else {
                atividade.setGruQtdeVagasAbertas(0);
            }
            atividade.setPrograma(this.rs.getString("programa"));
            data.add(atividade);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Atividade Coletiva com Inscri\u00e7\u00e3o Aberta";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterAtividadeColetivaInscricaoAberta(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void ataReuniao(AtaReuniaoFilter filter) throws Exception {
        this.params.put("asreuCodigo", filter.getAsreu_codigo());
        this.rs = Util.resolveResultSet(AtaReuniaoScript.getSqlAtaReuniao(), this.params);
        ArrayList<AtaReuniao> data = new ArrayList<AtaReuniao>();
        int aux = 0;
        String titulo = "Ata de Reuni\u00e3o";
        if (this.rs.next()) {
            AtaReuniao ataReuniao = new AtaReuniao();
            ataReuniao.setUnidade(this.rs.getString("uni_desc"));
            ataReuniao.setTitulo(this.rs.getString("asreu_titulo"));
            ataReuniao.setNumero(this.rs.getString("asreu_numero"));
            if (ataReuniao.getNumero() != null && !ataReuniao.getNumero().isEmpty()) {
                titulo = titulo.concat(" N\u00ba ").concat(ataReuniao.getNumero());
            }
            ataReuniao.setDescricao(this.rs.getString("asreu_desc"));
            ataReuniao.setData(this.rs.getDate("asreu_data"));
            ataReuniao.setHoraInicio(this.rs.getTime("asreu_hora_inicio"));
            ataReuniao.setHoraTermino(this.rs.getTime("asreu_hora_fim"));
            HashMap<String, Object> p2 = new HashMap<String, Object>();
            p2.put("asreuCodigo", filter.getAsreu_codigo());
            ResultSet rsp = Util.resolveResultSet(AtaReuniaoScript.getSqlReuniaoParticipantes(), p2);
            while (rsp.next()) {
                ReuniaoParticipantes rpc = new ReuniaoParticipantes();
                rpc.setParticipante(rsp.getString("usr_nome"));
                rpc.setCargo(rsp.getString("crg_nome"));
                if (aux % 2 == 0) {
                    ataReuniao.getParticipantespar().add(rpc);
                } else {
                    ataReuniao.getParticipantesimpar().add(rpc);
                }
                ++aux;
            }
            data.add(ataReuniao);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterAtaReuniao(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void atendimentoRealizadoAosMunicipes(AtendimentoRealizadoAosMunicipesFilter filter) throws Exception {
        if (filter.getUniCodigo() != null) {
            this.params.put("unidade", filter.getUniCodigo());
        }
        this.params.put("dt_inicial", Util.dateToTimeStamp(filter.getDt_inicial()));
        this.params.put("dt_final", Util.dateToTimeStamp(filter.getDt_final()));
        this.rs = Util.resolveResultSet(AtendimentoRealizadoAosMunicipesScript.getSqlAtendimentoRealizadoAosMunicipes(filter), this.params);
        ArrayList<AtendimentoRealizadoAosMunicipes> data = new ArrayList<AtendimentoRealizadoAosMunicipes>();
        while (this.rs.next()) {
            AtendimentoRealizadoAosMunicipes att = new AtendimentoRealizadoAosMunicipes();
            att.setUnidade(this.rs.getString("uni_desc"));
            att.setFaixaEtaria(this.rs.getString("faixa_etaria"));
            att.setQtdeAtendimento(this.rs.getInt("qtdeAtendimento"));
            switch (att.getFaixaEtaria()) {
                case "00 e 05 ANOS": {
                    att.setQtde_0_5(att.getQtdeAtendimento());
                    break;
                }
                case "06 e 14 ANOS": {
                    att.setQtde_6_14(att.getQtdeAtendimento());
                    break;
                }
                case "15 e 17 ANOS": {
                    att.setQtde_15_17(att.getQtdeAtendimento());
                    break;
                }
                case "18 e 59 ANOS": {
                    att.setQtde_18_59(att.getQtdeAtendimento());
                    break;
                }
                case "60 ANOS OU MAIS": {
                    att.setQtde_60(att.getQtdeAtendimento());
                }
            }
            data.add(att);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Atendimentos Realizados aos Mun\u00edcipes por Faixa Et\u00e1ria";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTp_rel());
        this.creator.setFiltro(FormatFilters.filterAtendimentoRealizadoAosMunicipes(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void prontuarioSuas(ProntuarioSuasFilter filter) throws Exception {
        this.params.put("aspsCodigo", filter.getAspsCodigo());
        this.conn = ConnectionUtil.getConnection();
        ArrayList<ProntuarioSuas> data = new ArrayList<ProntuarioSuas>();
        ProntuarioSuas pront = new ProntuarioSuas();
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlPessoaReferencia(), this.params, this.conn);
        if (this.rs.next()) {
            PessoaReferencia pes = new PessoaReferencia();
            pes.setUsuCodigo(this.rs.getInt("codigo"));
            pes.setNome(this.rs.getString("nome"));
            pes.setSexo(this.rs.getString("sexo"));
            pes.setDataNascimento(this.rs.getDate("data_nascimento"));
            pes.setIdade(this.rs.getInt("idade"));
            pes.setNis(this.rs.getString("nis"));
            String end = this.rs.getString("tipoLog").concat(" ").concat(this.rs.getString("rua_nome")).concat(" ").concat(this.rs.getString("domicilio_numero") != null ? this.rs.getString("domicilio_numero") : "").concat(" ").concat(this.rs.getString("domicilio_complemento") != null ? this.rs.getString("domicilio_complemento") : "").concat(", ").concat(this.rs.getString("bairro_nome") != null ? this.rs.getString("bairro_nome") : "").concat(" ").concat(this.rs.getString("cidade_nome") != null ? this.rs.getString("cidade_nome") : "").concat(this.rs.getString("cidade_nome") != null ? "/" : "").concat(this.rs.getString("estado_sigla") != null ? this.rs.getString("estado_sigla") : "");
            pes.setEndereco(end);
            pront.setPessoaReferencia(pes);
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlFormaIngresso(), this.params, this.conn);
        if (this.rs.next()) {
            pront.setFormaAcesso(this.rs.getString("formaAcesso"));
            pront.setRazoesNecessidades(this.rs.getString("razoesNecessidades"));
            pront.setFamiliaBolsa(this.rs.getBoolean("bolsaFamilia"));
            pront.setFamiliaBpc(this.rs.getBoolean("bpc"));
            pront.setFamiliaPeti(this.rs.getBoolean("peti"));
            pront.setFamiliaPaefi(this.rs.getBoolean("paefi"));
            pront.setFamiliaOutras(this.rs.getBoolean("prog_outros"));
            pront.setFamiliaPaif(this.rs.getBoolean("paif"));
            pront.setFamiliaScfv(this.rs.getBoolean("scfv"));
            pront.setFamiliaProgPrioritario(this.rs.getString("prog_prioritario"));
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlAtendimentoBasico(), this.params, this.conn);
        ArrayList<AtendimentoBasico> listAtend = new ArrayList<AtendimentoBasico>();
        while (this.rs.next()) {
            AtendimentoBasico atend = new AtendimentoBasico();
            atend.setData(this.rs.getDate("data"));
            atend.setDescricao(this.rs.getString("descricao"));
            atend.setParecer(this.rs.getString("parecer"));
            atend.setParecerSocial(this.rs.getString("parecer_social"));
            atend.setUnidade(this.rs.getString("unidade"));
            atend.setProfissional(this.rs.getString("profissional"));
            atend.setCidadao(this.rs.getString("cidadao"));
            atend.setTipoAtendimento(this.rs.getString("tipo"));
            listAtend.add(atend);
        }
        pront.setAtendimentosBasicos(listAtend);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlBeneficio(), this.params, this.conn);
        ArrayList<BeneficioEventual> listBen = new ArrayList<BeneficioEventual>();
        while (this.rs.next()) {
            BeneficioEventual ben = new BeneficioEventual();
            ben.setUnidade(this.rs.getString("unidade"));
            ben.setCidadao(this.rs.getString("cidadao"));
            ben.setEstabelecimento(this.rs.getString("estabelecimento"));
            ben.setObservacao(this.rs.getString("observacao"));
            ben.setDataEntrega(this.rs.getDate("dataEntrega"));
            ben.setDataConcessao(this.rs.getDate("dataConcessao"));
            HashMap<String, Object> params2 = new HashMap<String, Object>();
            params2.put("asbdCodigo", this.rs.getInt("codigo"));
            ResultSet rs2 = Util.subResultSet(ProntuarioSuasScript.getSqlBeneficioItem(), params2, this.conn);
            ArrayList<BeneficioItem> listItem = new ArrayList<BeneficioItem>();
            while (rs2.next()) {
                BeneficioItem item = new BeneficioItem();
                item.setBeneficio(rs2.getString("beneficio"));
                item.setTipo(rs2.getString("tipo"));
                item.setQuantidade(rs2.getInt("quantidade"));
                item.setValor(rs2.getDouble("valor"));
                item.setConcedido(rs2.getBoolean("concedido"));
                listItem.add(item);
            }
            ben.setItens(listItem);
            listBen.add(ben);
        }
        pront.setBeneficios(listBen);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlEncaminhamento(), this.params, this.conn);
        ArrayList<Encaminhamento> listEnc = new ArrayList<Encaminhamento>();
        while (this.rs.next()) {
            Encaminhamento enc = new Encaminhamento();
            enc.setUnidade(this.rs.getString("unidade"));
            enc.setProfissional(this.rs.getString("profissional"));
            enc.setLocal(this.rs.getString("local"));
            enc.setCidadao(this.rs.getString("cidadao"));
            enc.setData(this.rs.getDate("data"));
            listEnc.add(enc);
        }
        pront.setEncaminhamentos(listEnc);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlGrupos(), this.params, this.conn);
        ArrayList<AtendimentoColetivo> listGrupo = new ArrayList<AtendimentoColetivo>();
        while (this.rs.next()) {
            AtendimentoColetivo atend = new AtendimentoColetivo();
            atend.setUnidade(this.rs.getString("unidade"));
            atend.setGrupo(this.rs.getString("grupo"));
            atend.setAtivo(this.rs.getBoolean("ativo"));
            atend.setDataInsercao(this.rs.getDate("data"));
            atend.setCidadao(this.rs.getString("cidadao"));
            listGrupo.add(atend);
        }
        pront.setGrupos(listGrupo);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlComposicaoFamiliar(), this.params, this.conn);
        ArrayList<PessoaFamilia> listPesf = new ArrayList<PessoaFamilia>();
        while (this.rs.next()) {
            PessoaFamilia pesf = new PessoaFamilia();
            pesf.setOrdem(this.rs.getInt("ordem"));
            pesf.setParentesco(this.rs.getString("parentesco"));
            pesf.setNome(this.rs.getString("nome"));
            pesf.setSexo(this.rs.getString("sexo"));
            pesf.setDataNascimento(this.rs.getDate("data_nascimento"));
            pesf.setDeficiencia(this.rs.getBoolean("deficiencia"));
            pesf.setIdade(this.rs.getInt("idade"));
            pesf.setAlfabetizado(this.rs.getBoolean("alfabetizado"));
            pesf.setEstudante(this.rs.getBoolean("estuda"));
            pesf.setEscolaridade(this.rs.getString("escolaridade"));
            pesf.setCtps(this.rs.getBoolean("possui_ctps"));
            pesf.setCondicaoOcupacao(this.rs.getString("condicao_ocupacao"));
            pesf.setPossuiQualificacao(this.rs.getBoolean("possui_qualificacao"));
            pesf.setQualificacao(this.rs.getString("qualificacao"));
            pesf.setRendaMensal(this.rs.getDouble("renda_mensal"));
            pesf.setTipoDeficiencia(this.rs.getString("tipo_deficiencia"));
            pesf.setCuidadoConstante(this.rs.getBoolean("cuidado_constante"));
            pesf.setResponsavelCuidado(this.rs.getString("resp_cuidado"));
            listPesf.add(pesf);
        }
        pront.setComposicaoFamiliar(listPesf);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlPerfilEtario(), this.params, this.conn);
        ArrayList<FaixaEtaria> listFaxEt = new ArrayList<FaixaEtaria>();
        while (this.rs.next()) {
            FaixaEtaria faxEt = new FaixaEtaria();
            faxEt.setFaixaEtaria(this.rs.getString("faixa_etaria"));
            faxEt.setQtdeFamiliares(this.rs.getInt("qtdeFamiliares"));
            listFaxEt.add(faxEt);
        }
        pront.setFaixaEtaria(listFaxEt);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlEspecificidadesFamilia(), this.params, this.conn);
        while (this.rs.next()) {
            pront.setSituacaoRua(this.rs.getBoolean("aspses_fam_situacao_rua"));
            pront.setFamiliaQuilombola(this.rs.getBoolean("aspses_fam_quilombada"));
            pront.setFamiliaRibeirinha(this.rs.getBoolean("aspses_fam_ribeirinha"));
            pront.setFamiliaCigana(this.rs.getBoolean("aspses_fam_cigana"));
            pront.setFamiliaIndigenaResidente(this.rs.getBoolean("aspses_fam_indigena_residente"));
            pront.setFamiliaIndigenaResidenteEtnia(this.rs.getString("aspses_fam_indigena_retnia"));
            pront.setFamiliaIndigenaNaoResidente(this.rs.getBoolean("aspses_fam_indigena_nretnia"));
            pront.setFamiliaIndigenaNaoResidenteEtnia(this.rs.getString("aspses_fam_indigena_nretnia"));
            pront.setFamiliaOutras(this.rs.getBoolean("aspses_outros"));
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlComposicaoFamiliarObservacao(), this.params, this.conn);
        ArrayList<Observacao> obs = new ArrayList<Observacao>();
        while (this.rs.next()) {
            Observacao obsFam = new Observacao();
            obsFam.setData(this.rs.getDate("data"));
            obsFam.setObservacao(this.rs.getString("observacao"));
            obsFam.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsFam);
        }
        pront.setObsCompFamiliar(obs);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlCondicoesHabitacionais(), this.params, this.conn);
        CondicoesHabitacionais condHab = new CondicoesHabitacionais();
        if (this.rs.next()) {
            condHab.setTipoResidencia(this.rs.getString("aspsch_tipo_residencia"));
            condHab.setMaterialResidencia(this.rs.getString("aspsch_material"));
            condHab.setAcessoEnergia(this.rs.getString("aspsch_acesso_energia"));
            condHab.setPossuiAgua(this.rs.getBoolean("aspsch_possui_agua"));
            condHab.setFormaAbastecimento(this.rs.getString("aspsch_forma_abastecimento"));
            condHab.setEscoamentoSanitario(this.rs.getString("aspsch_escoamento_sanit"));
            condHab.setColetaLixo(this.rs.getString("aspsch_coleta_lixo"));
            condHab.setNumeroComodos(this.rs.getInt("aspsch_num_comodos"));
            condHab.setNumeroComodosUtilizados(this.rs.getInt("aspsch_num_comodos_utilizado"));
            condHab.setNumeroPessoasComodo(this.rs.getInt("aspsch_num_pessoas_comodos"));
            condHab.setAcessibilidade(this.rs.getString("aspsch_acessibilidade"));
            condHab.setDomAreaRisco(this.rs.getBoolean("aspsch_domicilio_area_risco"));
            condHab.setDomAreaGeografica(this.rs.getBoolean("aspsch_domicilio_area_geografica"));
            condHab.setDomAreaConflito(this.rs.getBoolean("aspsch_domicilio_area_conflito"));
        }
        pront.setCondicoesHabitacionais(condHab);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlCondicoesHabitacionaisObservacao(), this.params, this.conn);
        obs = new ArrayList();
        while (this.rs.next()) {
            Observacao obsHab = new Observacao();
            obsHab.setData(this.rs.getDate("data"));
            obsHab.setObservacao(this.rs.getString("observacao"));
            obsHab.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsHab);
        }
        pront.setObsHabitacionais(obs);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlVulnerabilidadeEducacionalNaoFreqEsc(), this.params, this.conn);
        ArrayList<NaoFrequentaEscola> naoFrequentaEscola = new ArrayList<NaoFrequentaEscola>();
        while (this.rs.next()) {
            NaoFrequentaEscola nFreqEsc = new NaoFrequentaEscola();
            nFreqEsc.setFaixaEtaria(this.rs.getString("faixa_etaria"));
            nFreqEsc.setQtdeNFreqEscola(this.rs.getInt("qtdeNFreqEsc"));
            naoFrequentaEscola.add(nFreqEsc);
        }
        pront.setNaoFrequentaEscola(naoFrequentaEscola);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlVulnerabilidadeEducacionalAnalfabeto(), this.params, this.conn);
        ArrayList<Analfabeto> analfabetos = new ArrayList<Analfabeto>();
        while (this.rs.next()) {
            Analfabeto analf = new Analfabeto();
            analf.setFaixaEtaria(this.rs.getString("faixa_etaria"));
            analf.setQtdeAnalfabeto(this.rs.getInt("qtdeAnalfabeto"));
            analfabetos.add(analf);
        }
        pront.setAnalfabeto(analfabetos);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlCondicoesEducacionaisDescPrograma(), this.params, this.conn);
        ArrayList<CondicoesEducacionais> listCondEduc = new ArrayList<CondicoesEducacionais>();
        while (this.rs.next()) {
            CondicoesEducacionais condEduc = new CondicoesEducacionais();
            condEduc.setDataOcorrencia(this.rs.getDate("data_ocorrencia"));
            condEduc.setEfeito(this.rs.getString("efeito"));
            condEduc.setSuspenso(this.rs.getBoolean("suspenso"));
            condEduc.setDataCadastro(this.rs.getDate("data_cadastro"));
            condEduc.setNome(this.rs.getString("nome"));
            listCondEduc.add(condEduc);
        }
        pront.setCondicoesEducacionais(listCondEduc);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlObsCondicoesEducacionais(), this.params, this.conn);
        obs = new ArrayList();
        while (this.rs.next()) {
            Observacao obsEdu = new Observacao();
            obsEdu.setData(this.rs.getDate("data"));
            obsEdu.setObservacao(this.rs.getString("observacao"));
            obsEdu.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsEdu);
        }
        pront.setObsEducacionais(obs);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlAnotProgramasFamilia(), this.params, this.conn);
        ArrayList<AnotacoesProgramasFamilia> listAnotFam = new ArrayList<AnotacoesProgramasFamilia>();
        while (this.rs.next()) {
            AnotacoesProgramasFamilia anotProgFam = new AnotacoesProgramasFamilia();
            anotProgFam.setProgramaNome(this.rs.getString("programa_nome"));
            anotProgFam.setValorRecebido(this.rs.getDouble("valor_recebido"));
            anotProgFam.setDataInicio(this.rs.getDate("data_inicio"));
            anotProgFam.setDataFinal(this.rs.getDate("data_final"));
            listAnotFam.add(anotProgFam);
        }
        pront.setAnotacoesProgramasFamilia(listAnotFam);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlAnotProgramasCidadao(), this.params, this.conn);
        ArrayList<AnotacoesProgramasCidadao> listAnotCid = new ArrayList<AnotacoesProgramasCidadao>();
        while (this.rs.next()) {
            AnotacoesProgramasCidadao anotProgCid = new AnotacoesProgramasCidadao();
            anotProgCid.setProgramaNome(this.rs.getString("programa_nome"));
            anotProgCid.setValorRecebido(this.rs.getDouble("valor_recebido"));
            anotProgCid.setDataInicio(this.rs.getDate("data_inicio"));
            anotProgCid.setDataFinal(this.rs.getDate("data_final"));
            anotProgCid.setNome(this.rs.getString("nome"));
            listAnotCid.add(anotProgCid);
        }
        pront.setAnotacoesProgramasCidadao(listAnotCid);
        Double rendaFamiliarProgramas = 0.0;
        Double rendaPerCapitaProgramas = 0.0;
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlInfRendaFamiliar(), this.params, this.conn);
        if (this.rs.next()) {
            rendaFamiliarProgramas = this.rs.getDouble("renda_progs");
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getsqlRendaFamiliar(), this.params, this.conn);
        if (this.rs.next()) {
            pront.setQtdMembros(this.rs.getInt("qtd_membros"));
            pront.setRendaFamiliar(this.rs.getDouble("renda_familia"));
            pront.setRendaPerCapita(this.rs.getDouble("renda_percapita"));
        }
        rendaFamiliarProgramas = rendaFamiliarProgramas + pront.getRendaFamiliar();
        rendaPerCapitaProgramas = rendaFamiliarProgramas / (double)pront.getQtdMembros().intValue();
        pront.setRendaFamiliarProgramas(rendaFamiliarProgramas);
        pront.setRendaPerCapitaProgramas(rendaPerCapitaProgramas);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlObsCondTrabalho(), this.params, this.conn);
        obs = new ArrayList();
        while (this.rs.next()) {
            Observacao obsConT = new Observacao();
            obsConT.setData(this.rs.getDate("data"));
            obsConT.setObservacao(this.rs.getString("observacao"));
            obsConT.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsConT);
        }
        pront.setObsTrabalho(obs);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlAnotSaudeFamilia(), this.params, this.conn);
        if (this.rs.next()) {
            AnotacoesSaude ant = new AnotacoesSaude();
            ant.setCuidadoConstante(this.rs.getBoolean("cuidado_constante"));
            ant.setResponsavelCuidado(this.rs.getString("responsavel_cuidado"));
            ant.setInsegurancaAlimentar(this.rs.getBoolean("inseguranca_alimentar"));
            ant.setInsegurancaAlimentarData(this.rs.getDate("inseguranca_alimentar_data"));
            ant.setDoencaGrave(this.rs.getBoolean("doenca_grave"));
            ant.setTipoDoencaGrave(this.rs.getString("tipo_doenca_grave"));
            ant.setRemedioControlado(this.rs.getBoolean("remedio_controlado"));
            ant.setAlcoolatra(this.rs.getBoolean("alcoolatra"));
            ant.setAlcoolatraData(this.rs.getDate("alcoolatra_data"));
            ant.setDrogado(this.rs.getBoolean("drogado"));
            ant.setTipoDroga(this.rs.getString("tipo_droga"));
            ant.setDrogadoData(this.rs.getDate("drogado_data"));
            pront.setAnotacoesSaude(ant);
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlObsSaudeFam(), this.params, this.conn);
        obs = new ArrayList();
        while (this.rs.next()) {
            Observacao obsSau = new Observacao();
            obsSau.setData(this.rs.getDate("data"));
            obsSau.setObservacao(this.rs.getString("observacao"));
            obsSau.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsSau);
        }
        pront.setObsSaudeFamilia(obs);
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlConvivencia(), this.params, this.conn);
        while (this.rs.next()) {
            ConvivenciaFamiliar conv = new ConvivenciaFamiliar();
            conv.setAnosEstado(this.rs.getInt("aspscf_anos_estado"));
            conv.setSempreResEstado(this.rs.getBoolean("aspscf_res_estado"));
            conv.setAnosMunicipio(this.rs.getInt("aspscf_anos_municipio"));
            conv.setSempreResMunicipio(this.rs.getBoolean("aspscf_res_municipio"));
            conv.setAnosBairro(this.rs.getInt("aspscf_anos_bairro"));
            conv.setSempreResBairro(this.rs.getBoolean("aspscf_res_bairro"));
            conv.setAmeacadaComunidade(this.rs.getBoolean("aspscf_ameacada"));
            conv.setParentesRede(this.rs.getBoolean("aspscf_parente_rede"));
            conv.setVizinhosRede(this.rs.getBoolean("aspscf_vizinho_rede"));
            conv.setGrupoRede(this.rs.getBoolean("aspscf_grupo_rede"));
            conv.setParticipaMovimento(this.rs.getBoolean("aspscf_movimento"));
            conv.setCriancaLazer(this.rs.getBoolean("aspscf_crianca_lazer"));
            conv.setIdosoLazer(this.rs.getBoolean("aspscf_idoso_lazer"));
            conv.setCompanhia(this.rs.getBoolean("aspscf_companhia"));
            conv.setConflito(this.rs.getString("aspscf_conflito"));
            conv.setRelConjugal(this.rs.getString("aspscf_rel_conjugal"));
            conv.setRelFamiliar(this.rs.getString("aspscf_rel_familiar"));
            conv.setRelIrmaos(this.rs.getString("aspscf_rel_irmaos"));
            pront.setConvivenciaFamiliar(conv);
        }
        this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlConvivenciaObs(), this.params, this.conn);
        obs = new ArrayList();
        while (this.rs.next()) {
            Observacao obsConv = new Observacao();
            obsConv.setData(this.rs.getDate("data"));
            obsConv.setObservacao(this.rs.getString("observacao"));
            obsConv.setResponsavel(this.rs.getString("responsavel"));
            obs.add(obsConv);
        }
        pront.setObsConvivencia(obs);
        if (filter.getTipoUnidade() != null) {
            pront.setTipoUnidade(filter.getTipoUnidade());
            if (filter.getTipoUnidade().contains("CREAS")) {
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlRegistrosViolacao(), this.params, this.conn);
                ArrayList<RegistroViolacao> listRegVio = new ArrayList<RegistroViolacao>();
                while (this.rs.next()) {
                    RegistroViolacao reg = new RegistroViolacao();
                    reg.setPersiste(this.rs.getBoolean("persiste"));
                    reg.setDataInicio(this.rs.getDate("data_inicio"));
                    reg.setDataFinal(this.rs.getDate("data_final"));
                    reg.setNome(this.rs.getString("nome"));
                    reg.setSituacao(this.rs.getString("situacao"));
                    listRegVio.add(reg);
                }
                pront.setRegistroViolacao(listRegVio);
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlHistAcolhimento(), this.params, this.conn);
                ArrayList<HistoricoAcolhimento> listHist = new ArrayList<HistoricoAcolhimento>();
                while (this.rs.next()) {
                    HistoricoAcolhimento hist = new HistoricoAcolhimento();
                    hist.setOrdem(this.rs.getInt("ordem"));
                    hist.setNome(this.rs.getString("nome"));
                    hist.setMotivo(this.rs.getString("motivo"));
                    hist.setDataInicio(this.rs.getDate("data_inicio"));
                    hist.setDataFinal(this.rs.getDate("data_final"));
                    listHist.add(hist);
                }
                pront.setHistoricoAcolhimento(listHist);
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlMedSocEduc(), this.params, this.conn);
                ArrayList<MedidaSocioEducativa> listMed = new ArrayList<MedidaSocioEducativa>();
                while (this.rs.next()) {
                    MedidaSocioEducativa med = new MedidaSocioEducativa();
                    med.setOrdem(this.rs.getInt("ordem"));
                    med.setNome(this.rs.getString("nome"));
                    med.setMedidaSocioeducativa(this.rs.getString("medida_socioeducativa"));
                    med.setProcesso(this.rs.getString("processo"));
                    med.setDataInicio(this.rs.getDate("data_inicio"));
                    med.setDataFinal(this.rs.getDate("data_final"));
                    med.setAtendidoCreas(this.rs.getBoolean("atendido_creas"));
                    listMed.add(med);
                }
                pront.setMedidaSocioEducativa(listMed);
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlMedSocEducObs(), this.params, this.conn);
                obs = new ArrayList();
                while (this.rs.next()) {
                    Observacao obsMed = new Observacao();
                    obsMed.setData(this.rs.getDate("data"));
                    obsMed.setObservacao(this.rs.getString("observacao"));
                    obsMed.setResponsavel(this.rs.getString("responsavel"));
                    obs.add(obsMed);
                }
                pront.setObsMedSocEduc(obs);
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlHistAcolObs(), this.params, this.conn);
                obs = new ArrayList();
                while (this.rs.next()) {
                    Observacao obsHist = new Observacao();
                    obsHist.setData(this.rs.getDate("data"));
                    obsHist.setObservacao(this.rs.getString("observacao"));
                    obsHist.setResponsavel(this.rs.getString("responsavel"));
                    obs.add(obsHist);
                }
                pront.setObsHistAlcoolismo(obs);
                this.rs = Util.subResultSet(ProntuarioSuasScript.getSqlViolacaoObs(), this.params, this.conn);
                obs = new ArrayList();
                while (this.rs.next()) {
                    Observacao obsViol = new Observacao();
                    obsViol.setData(this.rs.getDate("data"));
                    obsViol.setObservacao(this.rs.getString("observacao"));
                    obsViol.setResponsavel(this.rs.getString("responsavel"));
                    obs.add(obsViol);
                }
                pront.setObsViolacao(obs);
            }
        }
        data.add(pront);
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio Prontu\u00e1rio SUAS";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterProntuarioSuas(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void beneficiosPorAtendente(BeneficiosPorAtendenteFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("usrLogado", filter.getUsrLogado());
        if (filter.getUniCodigo() != null) {
            this.params.put("unidade", filter.getUniCodigo());
        }
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getBeneficio() != null) {
            this.params.put("beneficio", filter.getBeneficio());
        }
        this.rs = Util.resolveResultSet(BeneficiosPorAtendenteScript.getSql(filter), this.params);
        ArrayList<BeneficiosPorAtendente> data = new ArrayList<BeneficiosPorAtendente>();
        while (this.rs.next()) {
            BeneficiosPorAtendente ben = new BeneficiosPorAtendente();
            ben.setDataCadastro(this.rs.getDate("data_cadastro"));
            ben.setDataEntrega(this.rs.getDate("data_entrega"));
            ben.setUnidade(this.rs.getString("unidade"));
            ben.setProfissional(this.rs.getString("atendente"));
            ben.setCidadao(this.rs.getString("beneficiario"));
            ben.setBeneficio(this.rs.getString("beneficio"));
            ben.setConcedido(this.rs.getString("concedido"));
            ben.setQuantidade(this.rs.getInt("quantidade"));
            ben.setEstabelecimento(this.rs.getString("estabelecimento"));
            data.add(ben);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Benef\u00edcios por Atendente";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterBeneficiosPorAtendente(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void cidadaosCadastrados(CidadaosCadastradosFilter filter) throws Exception {
        this.params.put("uniCodigo", filter.getUniCodigo());
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getDtInicial() != null) {
            this.params.put("dtInicial", filter.getDtInicial());
        }
        if (filter.getDtFinal() != null) {
            this.params.put("dtFinal", filter.getDtFinal());
        }
        if (filter.getCidadao() != null) {
            this.params.put("cidadao", filter.getCidadao());
        }
        this.rs = Util.resolveResultSet(CidadaosCadastradosScript.getSqlCidadaosCadastrados(filter), this.params);
        ArrayList<CidadaosCadastrados> data = new ArrayList<CidadaosCadastrados>();
        while (this.rs.next()) {
            CidadaosCadastrados cidadaos = new CidadaosCadastrados();
            cidadaos.setCidadao(this.rs.getString("usuNome"));
            cidadaos.setDataCadastro(this.rs.getDate("dataCadastro"));
            cidadaos.setUnidade(this.rs.getString("nomeUnidade"));
            cidadaos.setProfissional(this.rs.getString("nomeProfissional"));
            data.add(cidadaos);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Cidad\u00e3os Cadastrados";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, TipoRelEnum.SINTETICO);
        this.creator.setFiltro(FormatFilters.filterCidadaosCadastrados(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void atividadeColetivaProfissional(AtividadeColetivaProfissionalFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("unidade", filter.getUniCodigo());
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getAtivo() != null) {
            this.params.put("ativo", filter.getAtivo());
        }
        this.rs = Util.resolveResultSet(AtividadeColetivaProfissionalScript.getSql(filter), this.params);
        ArrayList<AtividadeColetivaProfissional> data = new ArrayList<AtividadeColetivaProfissional>();
        while (this.rs.next()) {
            AtividadeColetivaProfissional atv = new AtividadeColetivaProfissional();
            atv.setUnidade(this.rs.getString("unidade"));
            atv.setGrupo(this.rs.getString("grupo"));
            atv.setProfissional(this.rs.getString("profissional"));
            atv.setEncontro(this.rs.getString("encontro"));
            atv.setDataEncontro(this.rs.getDate("dt_encontro"));
            atv.setHoraInicio(this.rs.getTimestamp("hr_inicial"));
            atv.setHoraFinal(this.rs.getTimestamp("hr_final"));
            atv.setQtdeParticipantes(this.rs.getInt("qtd_participantes"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                atv.setCidadao(this.rs.getString("cidadao"));
                atv.setDtNascimento(this.rs.getDate("dt_nasc"));
                atv.setNis(this.rs.getString("nis"));
            }
            data.add(atv);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio Atividade Coletiva por Profissional";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAtividadeColetivaProfissional(filter));
        this.creator.gerarPdf();
    }

    @Override
    public void atendimentoBasico(AtendimentoBasicoFilter filter) throws Exception {
        this.params.put("dtInicial", Util.dateToTimeStamp(filter.getDtInicial()));
        this.params.put("dtFinal", Util.dateToTimeStamp(filter.getDtFinal()));
        this.params.put("unidade", filter.getUniCodigo());
        if (filter.getProfissional() != null) {
            this.params.put("profissional", filter.getProfissional());
        }
        if (filter.getMotivo() != null) {
            this.params.put("motivo", filter.getMotivo());
        }
        this.rs = Util.resolveResultSet(AtendimentoBasicoScript.getSql(filter), this.params);
        ArrayList<AtendimentoBasico> data = new ArrayList<AtendimentoBasico>();
        while (this.rs.next()) {
            AtendimentoBasico atb = new AtendimentoBasico();
            atb.setUnidade(this.rs.getString("unidade"));
            atb.setMotivo(this.rs.getString("motivo"));
            atb.setTipoAtendimento(this.rs.getString("tipo_atendimento"));
            if (filter.getTpRel().equals((Object)TipoRelEnum.ANALITICO)) {
                atb.setProfissional(this.rs.getString("profissional"));
                atb.setData(this.rs.getDate("data"));
                atb.setCidadao(this.rs.getString("cidadao"));
            } else {
                atb.setQtdAtendimentos(this.rs.getInt("qtd_atendimentos"));
            }
            data.add(atb);
        }
        String filename = Thread.currentThread().getStackTrace()[2].getMethodName();
        String titulo = "Relat\u00f3rio de Atendimentos B\u00e1sicos";
        this.creator = new JasperCreator(SistemaEnum.SOCIAL, filename, titulo, data, filter.getTpRel());
        this.creator.setFiltro(FormatFilters.filterAtendimentoBasico(filter));
        this.creator.gerarPdf();
    }
}

