/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.social.filters;

import br.com.elotech.model.Unidade;
import br.com.elotech.social.model.filters.AtaReuniaoFilter;
import br.com.elotech.social.model.filters.AtendimentoBasicoFilter;
import br.com.elotech.social.model.filters.AtendimentoRealizadoAosMunicipesFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaInscricaoAbertaFilter;
import br.com.elotech.social.model.filters.AtividadeColetivaProfissionalFilter;
import br.com.elotech.social.model.filters.BeneficiosPorAtendenteFilter;
import br.com.elotech.social.model.filters.CertidaoLiberatoriaFilter;
import br.com.elotech.social.model.filters.CidadaosCadastradosFilter;
import br.com.elotech.social.model.filters.ProntuarioSuasFilter;
import br.com.elotech.social.model.filters.ResumoGeralFilter;
import br.com.elotech.util.Util;
import br.com.elotech.util.UtilFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public abstract class FormatFilters {
    public static String filterResumoGeral(ResumoGeralFilter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        if (filter.getUniCodigo() != null) {
            try {
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
                builder.append(unidade.getUniDescricao().concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            builder.append("Todas | ");
        }
        String dti = Util.formatDateBR(filter.getDtInicial());
        String dtf = Util.formatDateBR(filter.getDtFinal());
        builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        builder.append(" | Tipo: ").append(filter.getTp_rel().name());
        return builder.toString();
    }

    public static String filterCertidaoLiberatoria(CertidaoLiberatoriaFilter filter) {
        return "";
    }

    public static String filterAtaReuniao(AtaReuniaoFilter filter) {
        return "";
    }

    public static String filterAtividadeColetivaInscricaoAberta(AtividadeColetivaInscricaoAbertaFilter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        if (filter.getUniCodigo() != null) {
            try {
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
                builder.append(unidade.getUniDescricao().concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            builder.append("Todas | ");
        }
        builder.append(" Status:");
        if (filter.getAsag_status().contains("t")) {
            builder.append("Ativo");
        } else {
            builder.append("Inativo");
        }
        return builder.toString();
    }

    public static String filterAtendimentoRealizadoAosMunicipes(AtendimentoRealizadoAosMunicipesFilter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        if (filter.getUniCodigo() != null) {
            try {
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
                builder.append(unidade.getUniDescricao().concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            builder.append("TODAS | ");
        }
        builder.append(" Faixa(s) Et\u00e1ria(s): ");
        if (filter.getFaixa_etaria() == null) {
            builder.append(" TODAS |");
        } else {
            String[] array;
            String[] stringArray = array = StringUtils.split(filter.getFaixa_etaria(), "|");
            int n = stringArray.length;
            block16: for (int i = 0; i < n; ++i) {
                String s;
                switch (s = stringArray[i]) {
                    case "1": {
                        builder.append(" Entre 0 e 5");
                        continue block16;
                    }
                    case "6": {
                        builder.append(" Entre 6 e 14");
                        continue block16;
                    }
                    case "15": {
                        builder.append(" Entre 15 e 17");
                        continue block16;
                    }
                    case "18": {
                        builder.append(" Entre 18 e 59");
                        continue block16;
                    }
                    case "60": {
                        builder.append(" 60 ou mais");
                    }
                }
            }
            builder.append(" |");
        }
        String dti = Util.formatDateBR(filter.getDt_inicial());
        String dtf = Util.formatDateBR(filter.getDt_final());
        builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf);
        return builder.toString();
    }

    public static String filterProntuarioSuas(ProntuarioSuasFilter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append("Prontu\u00e1rio SUAS N\u00ba ").append(filter.getAspsCodigo()).append(" | ");
        try {
            String responsavel = UtilFilter.getResponsavelProntuarioSuas(filter.getAspsCodigo());
            builder.append("Respons\u00e1vel: ").append(responsavel);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String filterBeneficiosPorAtendente(BeneficiosPorAtendenteFilter filter) {
        StringBuilder builder = new StringBuilder();
        String dti = Util.formatDateBR(filter.getDtInicial());
        String dtf = Util.formatDateBR(filter.getDtFinal());
        builder.append("Per\u00edodo: ").append(dti).append(" \u00e0 ").append(dtf).append(" | ");
        builder.append(" | Unidade Atendimento: ");
        if (filter.getUniCodigo() != null) {
            try {
                Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
                builder.append(unidade.getUniDescricao().concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            builder.append(" TODAS |");
        }
        if (filter.getProfissional() != null) {
            try {
                ResultSet responsavel = UtilFilter.getUsuarios(filter.getProfissional());
                builder.append("Atendente: ").append(responsavel.getString("usr_nome")).append(" | ");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (filter.getBeneficio() != null) {
            try {
                String beneficio = UtilFilter.getBeneficio(filter.getBeneficio());
                builder.append(" Benef\u00edcio: ").append(beneficio).append(" | ");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static String filterCidadaosCadastrados(CidadaosCadastradosFilter filter) {
        ResultSet rs;
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        try {
            Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
            builder.append(unidade.getUniDescricao().concat(" | "));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (filter.getProfissional() != null) {
            builder.append("Profissional: ");
            try {
                rs = UtilFilter.getUsuarios(filter.getProfissional());
                builder.append(rs.getString("usr_nome").concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (filter.getDtInicial() != null) {
            String dti = Util.formatDateBR(filter.getDtInicial());
            builder.append("Data Inicial: ").append(dti.concat(" | "));
        }
        if (filter.getDtFinal() != null) {
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append("Data Final: ").append(dtf.concat(" | "));
        }
        if (filter.getCidadao() != null) {
            builder.append("Cidad\u00e3o: ");
            try {
                rs = UtilFilter.getUsuarios(filter.getCidadao());
                builder.append(rs.getString("usu_nome").concat(" | "));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return builder.toString();
    }

    public static String filterAtividadeColetivaProfissional(AtividadeColetivaProfissionalFilter filter) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        try {
            Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
            builder.append(unidade.getUniDescricao());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (filter.getProfissional() != null) {
            builder.append(" | Profissional: ");
            try {
                ResultSet rs = UtilFilter.getUsuarios(filter.getProfissional());
                builder.append(rs.getString("usr_nome"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (filter.getDtInicial() != null) {
            String dti = Util.formatDateBR(filter.getDtInicial());
            builder.append(" | Data Inicial: ").append(dti);
        }
        if (filter.getDtFinal() != null) {
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append(" | Data Final: ").append(dtf);
        }
        if (filter.getAtivo() != null) {
            builder.append(" | Status: ".concat(filter.getAtivo() != false ? "Ativo" : "Inativo"));
        }
        builder.append(" | Tipo: ").append(filter.getTpRel().name());
        return builder.toString();
    }

    public static String filterAtendimentoBasico(AtendimentoBasicoFilter filter) {
        ResultSet rs;
        StringBuilder builder = new StringBuilder();
        builder.append("Unidade: ");
        try {
            Unidade unidade = UtilFilter.getUnidadePorCodigo(filter.getUniCodigo());
            builder.append(unidade.getUniDescricao());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (filter.getProfissional() != null) {
            builder.append(" | Profissional: ");
            try {
                rs = UtilFilter.getUsuarios(filter.getProfissional());
                builder.append(rs.getString("usr_nome"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (filter.getDtInicial() != null) {
            String dti = Util.formatDateBR(filter.getDtInicial());
            builder.append(" | Data Inicial: ").append(dti);
        }
        if (filter.getDtFinal() != null) {
            String dtf = Util.formatDateBR(filter.getDtFinal());
            builder.append(" | Data Final: ").append(dtf);
        }
        if (filter.getMotivo() != null) {
            builder.append(" | Motivo: ");
            try {
                rs = UtilFilter.getMotivos(filter.getMotivo());
                builder.append(rs.getString("asam_nome"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        builder.append(" | Tipo: ").append(filter.getTpRel().name());
        return builder.toString();
    }
}

