/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.social.scripts;

import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.social.model.filters.ResumoGeralFilter;

public abstract class ResumoGeralScript {
    private static StringBuilder sb;
    private static String subUnidades;

    public static String getSqlAtendimentoBasico(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append("    u.uni_desc    AS unidade,");
        sb.append("    aat.asat_nome AS tipo_atendimento,");
        sb.append("    us.usr_nome   AS profissional,");
        sb.append("    ab.asab_data  AS data,");
        sb.append("  (SELECT array_to_string(array_agg(DISTINCT aam.asam_nome),', ') ");
        sb.append("     FROM as_atendimento_basicocras_motivo aabm ");
        sb.append("     JOIN as_atendimento_motivo aam ON aabm.asam_codigo = aam.asam_codigo ");
        sb.append("     WHERE aabm.asab_codigo = ab.asab_codigo) AS motivo, ");
        sb.append("    COUNT(u.uni_desc) AS quantidade");
        sb.append("  FROM as_atendimento_basicocras ab");
        sb.append("  JOIN unidade               u ON u.uni_codigo = ab.uni_codigo");
        sb.append("  JOIN usuarios             us ON us.usr_codigo = ab.usr_codigo");
        sb.append("  JOIN as_atendimento_tipo aat ON aat.asat_codigo = ab.asat_codigo");
        sb.append(" WHERE ab.asab_data BETWEEN :dt_inicial AND :dt_final ");
        sb.append("   AND u.uni_codigo IN ".concat(subUnidades));
        if (filter.getUniCodigo() != null) {
            sb.append(" AND u.uni_codigo = :uni_codigo");
        }
        sb.append(" GROUP BY 1,2,3,4,5");
        sb.append(" ORDER BY uni_desc, profissional, data");
        return sb.toString();
    }

    public static String getSqlBeneficiosOfertados(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT");
        sb.append("     uni.uni_codigo as uni_codigo");
        sb.append("     ,lower(uni.uni_desc) as unidade");
        sb.append("     ,ben.cod_ben AS ben_codigo");
        sb.append("     ,lower(ben.beneficio) AS beneficio");
        sb.append("     ,SUM(abdi.asbdi_qtd) AS quantidade");
        sb.append("   FROM as_beneficios_dados asbd");
        sb.append("   JOIN unidade uni  \t\t\t\t  ON asbd.uni_codigo = uni.uni_codigo");
        sb.append("   JOIN as_beneficios_dados_itens abdi ON asbd.asbd_codigo = abdi.asbd_codigo");
        sb.append("   JOIN beneficios ben \t\t\t\t  ON abdi.cod_ben=ben.cod_ben");
        sb.append("  WHERE asbd.asbd_dtcadastro BETWEEN :dt_inicial and :dt_final");
        sb.append("   AND uni.uni_codigo IN ".concat(subUnidades));
        if (filter.getUniCodigo() != null) {
            sb.append(" AND uni.uni_codigo = :uni_codigo");
        }
        sb.append("  GROUP BY uni.uni_codigo, uni.uni_desc, ben.cod_ben, ben.beneficio");
        sb.append("  ORDER BY uni.uni_desc, ben.beneficio");
        return sb.toString();
    }

    public static String getSqlBeneficiosPorBeneficiario() {
        sb = new StringBuilder();
        sb.append(" SELECT");
        sb.append("     usu.usu_nome         AS beneficiario,");
        sb.append("     asbd.asbd_dtcadastro AS dt_cadastro,");
        sb.append("     asbd.asbd_dtentrega  AS dt_entrega,");
        sb.append("     CASE WHEN abdi.asbdi_concedido is true THEN 'Concedido' ELSE 'N\u00e3o Concedido' END as concedido,");
        sb.append("     CASE WHEN (abdi.asbdi_concedido is true AND asbd_dtentrega is null) THEN '\u00c0 retirar'");
        sb.append("          WHEN (abdi.asbdi_concedido is true AND asbd_dtentrega is not null) THEN 'Entregue'");
        sb.append("     ELSE 'N\u00e3o Entregue' END  AS situacao,");
        sb.append("     SUM(abdi.asbdi_qtd)      AS quantidade");
        sb.append("   FROM as_beneficios_dados asbd");
        sb.append("   JOIN unidade uni ON asbd.uni_codigo = uni.uni_codigo");
        sb.append("   JOIN usuario usu ON asbd.usu_codigo = usu.usu_codigo");
        sb.append("   JOIN as_beneficios_dados_itens abdi ON asbd.asbd_codigo = abdi.asbd_codigo");
        sb.append("   JOIN beneficios ben ON abdi.cod_ben = ben.cod_ben");
        sb.append("  WHERE asbd.asbd_dtcadastro BETWEEN :dt_inicial and :dt_final");
        sb.append("    AND ben.cod_ben = :ben_codigo AND uni.uni_codigo = :uni_codigo");
        sb.append("  GROUP BY usu.usu_nome, asbd.asbd_dtcadastro, asbd.asbd_dtentrega, abdi.asbdi_concedido");
        sb.append("  ORDER BY usu.usu_nome");
        return sb.toString();
    }

    public static String getSqlAtividadeColetiva(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT");
        sb.append("    asag.asag_codigo as gru_codigo");
        sb.append("   ,lower(asag.asag_titulo) as gru_descricao");
        sb.append("   ,asag.asag_quantidade_grupo as gru_qtde_permitida");
        sb.append("   ,asae.asae_codigo as enc_codigo");
        sb.append("   ,lower(asae.asae_titulo) as enc_titulo");
        sb.append("   ,ase.ase_nome as enc_estabelecimento");
        sb.append("   ,lower(asae.asae_descricao) as enc_descricao");
        sb.append("   ,CAST(asae.asae_dtinicio as DATE) as enc_data");
        sb.append("   ,(SELECT count(asap.asapar_codigo)");
        sb.append("       FROM as_atendimentocol_grupo asagp");
        sb.append("       JOIN as_atendimentocol_participantes asap ON asagp.asag_codigo = asap.asag_codigo");
        sb.append("      WHERE asagp.asag_codigo = asag.asag_codigo) as qtde_participantes");
        sb.append("   ,(SELECT count(*) from as_atendimentocol_encontroshist asaeh where asaeh.asae_codigo = asae.asae_codigo and asaeh_presenca is true) as qtde_presente");
        sb.append("   ,(SELECT count(*) from as_atendimentocol_encontroshist asaeh where asaeh.asae_codigo = asae.asae_codigo and asaeh_presenca is false) as qtde_falta");
        sb.append("  FROM as_atendimentocol_grupo asag");
        sb.append("  JOIN as_atendimentocol_encontros asae on asag.asag_codigo = asae.asag_codigo");
        sb.append("  JOIN as_estabelecimentos ase on asae.ase_codigo = ase.ase_codigo");
        sb.append(" WHERE asag.asag_data BETWEEN :dt_inicial AND :dt_final");
        sb.append("   AND asag.asag_status IS TRUE");
        sb.append("   AND asag.uni_codigo IN ".concat(subUnidades));
        if (filter.getUniCodigo() != null) {
            sb.append(" AND asag.uni_codigo = :uni_codigo");
        }
        sb.append(" GROUP BY asag.asag_codigo, ase.ase_nome, asae.asae_codigo");
        sb.append(" ORDER BY  asag.asag_titulo, ase.ase_nome, asae.asae_titulo, asae.asae_dtinicio");
        return sb.toString();
    }

    public static String getSqlAtividadeColetivaParticipantes() {
        sb = new StringBuilder();
        sb.append("SELECT");
        sb.append("    usu.usu_nome as cidadao");
        sb.append("   ,usu.usu_datanasc  as dt_nascimento");
        sb.append("   ,extract(year from age(usu.usu_datanasc)) as idade");
        sb.append("   ,usu.usu_fone as telefone");
        sb.append("   ,usu.usu_celular as celular");
        sb.append("   ,CASE WHEN asaeh.asaeh_presenca IS TRUE THEN 'Presente' ELSE 'Faltou' END as status");
        sb.append("  FROM as_atendimentocol_encontroshist asaeh");
        sb.append("  JOIN as_atendimentocol_encontros asae ON asaeh.asae_codigo = asae.asae_codigo");
        sb.append("  JOIN usuario usu ON usu.usu_codigo = asaeh.usu_codigo");
        sb.append(" WHERE asae.asae_codigo = :enc_codigo");
        sb.append(" ORDER BY asaeh.asaeh_presenca desc, usu.usu_nome asc");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT DISTINCT usu.usu_codigo, usu.usu_nome, uni.uni_codigo");
        sb.append("   FROM usuario usu");
        sb.append("   LEFT JOIN as_atendimento_basicocras ab ON ab.usu_codigo = usu.usu_codigo");
        sb.append("   LEFT JOIN as_beneficios_dados asbd ON asbd.usu_codigo = usu.usu_codigo");
        sb.append("   LEFT JOIN as_encaminhamento asenc ON asenc.usu_codigo = usu.usu_codigo");
        sb.append("   JOIN unidade uni ON ab.uni_codigo = uni.uni_codigo OR asbd.uni_codigo = uni.uni_codigo OR asenc.uni_codigo = uni.uni_codigo");
        sb.append("   JOIN unidade_usuarios uu ON uni.uni_codigo = uu.uni_codigo and uu.usr_codigo = 1");
        sb.append("  WHERE (ab.usu_codigo IS NOT NULL");
        sb.append("         OR asbd.usu_codigo IS NOT NULL");
        sb.append("         OR asenc.usu_codigo IS NOT NULL)");
        sb.append("    AND (ab.asab_data BETWEEN :dt_inicial AND :dt_final");
        sb.append("         OR asbd.asbd_dtcadastro BETWEEN :dt_inicial AND :dt_final");
        sb.append("         OR asenc.asenc_data BETWEEN :dt_inicial AND :dt_final)");
        if (filter.getUniCodigo() != null) {
            sb.append(" AND uni.uni_codigo = :uni_codigo");
        }
        if (!filter.getTp_rel().equals((Object)TipoRelEnum.RESPONSAVEL)) {
            sb.append(" AND (usu_asps_ref = 't')");
        }
        sb.append(" ORDER BY usu_nome;");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral_atendimento(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(" u.uni_desc AS unidade, ");
        sb.append(" aat.asat_nome AS tipo_atendimento, ");
        sb.append(" us.usr_nome AS profissional, ");
        sb.append(" (SELECT array_to_string(array_agg(DISTINCT aam.asam_nome),', ') ");
        sb.append("    FROM as_atendimento_basicocras_motivo aabm ");
        sb.append("    JOIN as_atendimento_motivo aam ON aabm.asam_codigo = aam.asam_codigo ");
        sb.append("    WHERE aabm.asab_codigo = ab.asab_codigo) AS motivos, ");
        sb.append("  ab.asab_data AS data_atendimento ");
        sb.append("  FROM as_atendimento_basicocras ab ");
        sb.append("  JOIN unidade u ON u.uni_codigo = ab.uni_codigo AND u.uni_codigo = :uni_codigo");
        sb.append("  JOIN usuarios us ON us.usr_codigo = ab.usr_codigo ");
        sb.append("  JOIN as_atendimento_tipo aat ON aat.asat_codigo = ab.asat_codigo");
        sb.append("  WHERE ab.usu_codigo = :usu_codigo");
        sb.append("  AND ab.asab_data BETWEEN :dt_inicial AND :dt_final");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral_beneficios(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append("    ben.beneficio AS beneficio, ");
        sb.append("    usr.usr_nome AS atendente, ");
        sb.append("    asbd.asbd_dtcadastro AS data_cadastro, ");
        sb.append("    asbd.asbd_dtentrega AS data_entrega, ");
        sb.append("    sum(abdi.asbdi_qtd) AS quantidade ");
        sb.append(" FROM as_beneficios_dados asbd ");
        sb.append(" JOIN unidade uni ON asbd.uni_codigo = uni.uni_codigo AND uni.uni_codigo = :uni_codigo");
        sb.append(" JOIN usuarios usr ON asbd.usr_codigo = usr.usr_codigo");
        sb.append(" JOIN as_beneficios_dados_itens abdi ON asbd.asbd_codigo = abdi.asbd_codigo ");
        sb.append(" JOIN beneficios ben ON abdi.cod_ben=ben.cod_ben ");
        sb.append(" WHERE asbd.usu_codigo = :usu_codigo ");
        sb.append("   AND asbd.asbd_dtcadastro BETWEEN :dt_inicial AND :dt_final ");
        sb.append(" GROUP BY 1,2,3,4 ");
        sb.append(" ORDER BY 1,2,3,4");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral_encaminhamento(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT ");
        sb.append("    lower(uni.uni_desc) AS origem, ");
        sb.append("    lower(ase.ase_nome) AS destino, ");
        sb.append("    asec.asec_titulo AS titulo, ");
        sb.append("    asenc.asenc_motivo AS motivo, ");
        sb.append("    cast(asenc.asenc_data as DATE ) AS data_encaminhamento, ");
        sb.append("    usr.usr_nome AS profissional ");
        sb.append("  FROM as_encaminhamento asenc ");
        sb.append(" INNER JOIN as_encaminhamento_codigos asec ON asenc.asec_codigo = asec.asec_codigo ");
        sb.append(" INNER JOIN unidade uni ON asenc.uni_codigo  = uni.uni_codigo ");
        sb.append(" INNER JOIN as_estabelecimentos ase ON asenc.ase_codigo  = ase.ase_codigo ");
        sb.append(" INNER JOIN usuarios usr ON asenc.usr_codigo  = usr.usr_codigo ");
        sb.append(" WHERE asenc.usu_codigo = :usu_codigo ");
        sb.append("   AND asenc.asenc_data BETWEEN :dt_inicial AND :dt_final ");
        sb.append("   AND asenc.uni_codigo = :uni_codigo ");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral_atividade(ResumoGeralFilter filter) {
        sb = new StringBuilder();
        sb.append(" SELECT DISTINCT ");
        sb.append("   atg.asag_codigo as codigo, ");
        sb.append("   atg.asag_titulo as grupo, ");
        sb.append("   uni.uni_desc as unidade ");
        sb.append("  FROM as_atendimentocol_participantes atp ");
        sb.append("  JOIN as_atendimentocol_grupo atg ON atp.asag_codigo = atg.asag_codigo ");
        sb.append("  JOIN unidade uni ON atg.uni_codigo = uni.uni_codigo AND uni.uni_codigo = :uni_codigo");
        sb.append("  WHERE usu_codigo = :usu_codigo ");
        return sb.toString();
    }

    public static String getSqlRelatorioGeral_atividade_encontro() {
        sb = new StringBuilder();
        sb.append(" SELECT ");
        sb.append("    ate.asae_titulo as titulo, ");
        sb.append("    ate.asae_descricao as descricao, ");
        sb.append("    ate.asae_dtinicio as dt_inicio, ");
        sb.append("    ate.asae_dtfinal as dt_final, ");
        sb.append("   CASE ateh.asaeh_presenca ");
        sb.append("   WHEN true ");
        sb.append("     THEN 'Presente' ");
        sb.append("   ELSE 'Falta' ");
        sb.append("   END AS asaeh_presenca ");
        sb.append("  FROM as_atendimentocol_encontros ate ");
        sb.append("  JOIN as_atendimentocol_encontroshist ateh on ate.asae_codigo = ateh.asae_codigo ");
        sb.append(" WHERE ate.asag_codigo = :gru_codigo ");
        sb.append("   AND ateh.usu_codigo = :usu_codigo ");
        return sb.toString();
    }

    static {
        subUnidades = "(SELECT unidade.uni_codigo FROM unidade   JOIN unidade_usuarios ON unidade.uni_codigo = unidade_usuarios.uni_codigo   WHERE unidade_usuarios.usr_codigo = :usr_codigo    AND unidade.uni_as is not null) ";
    }
}

