/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.util;

import br.com.elotech.Main;
import br.com.elotech.config.DadosBasicos;
import br.com.elotech.enuns.SistemaEnum;
import br.com.elotech.enuns.TipoRelEnum;
import br.com.elotech.util.Path;
import br.com.elotech.util.Util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;

public class JasperCreator {
    private String filename;
    private String title;
    private String repo_jasper;
    private String export_path;
    private TipoRelEnum tipoRelEnum;
    private String temp = Util.getJarPath().concat("/report/");
    private JRDataSource dataSource;
    private Map<String, Object> params;

    public JasperCreator(SistemaEnum sistema, String filename, String title, List<?> dataSource, TipoRelEnum tipoRelEnum) throws Exception {
        if (dataSource.isEmpty()) {
            filename = "empty".concat(sistema.name().toLowerCase());
        }
        this.filename = filename.toLowerCase();
        this.title = title;
        this.repo_jasper = "jasper/".concat(sistema.toString().toLowerCase()).concat("/");
        this.tipoRelEnum = tipoRelEnum;
        this.dataSource = dataSource.isEmpty() ? new JREmptyDataSource() : new JRBeanCollectionDataSource(dataSource);
        this.carregaDadosBasicos(sistema);
    }

    public void gerarPdf() throws Exception {
        this.export_path = this.temp + this.filename.concat("-").concat(new Date().getTime() + ".pdf");
        try {
            URL url = this.getClass().getClassLoader().getResource(this.repo_jasper.concat(this.filename).concat(".jrxml"));
            if (url == null) {
                throw new Exception("Arquivo de relat\u00f3rio n\u00e3o encontrado. (" + this.filename + ".jrxml)");
            }
            JasperReport report = JasperCompileManager.compileReport(url.openStream());
            JasperPrint print = JasperFillManager.fillReport(report, this.params, this.dataSource);
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, new File(this.export_path));
            exporter.setParameter(JRPdfExporterParameter.METADATA_TITLE, this.title);
            exporter.exportReport();
            Path.print(this.export_path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Erro ao gerar arquivo pdf: " + e.getMessage());
        }
    }

    public void setFiltro(String filtro) {
        this.params.put("FILTRO", filtro);
    }

    public void addParameter(String key, Object value) {
        this.params.put(key, value);
    }

    private void carregaDadosBasicos(SistemaEnum sistema) throws IOException, URISyntaxException, SQLException {
        this.params = new HashMap<String, Object>();
        DadosBasicos db = new DadosBasicos();
        this.params.put("DADOS_BASICOS", db);
        File logo = Util.getLogo(sistema);
        FileInputStream is = logo.exists() ? new FileInputStream(logo) : this.getClass().getClassLoader().getResource("img/logo_" + sistema.name().toLowerCase() + ".jpg").openStream();
        BufferedImage isLogo = ImageIO.read(is);
        this.params.put("LOGO", isLogo);
        this.params.put("TITULO", this.title.toUpperCase());
        Properties prop = this.readConfigProperties();
        this.params.put("VERSION", prop.getProperty("version"));
        if (this.tipoRelEnum != null) {
            this.params.put("TP_REL", this.tipoRelEnum.name());
        }
    }

    public Properties readConfigProperties() throws IOException {
        Properties prop = new Properties();
        prop.load(Main.class.getClassLoader().getResourceAsStream("config.properties"));
        return prop;
    }
}

