/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.util;

import br.com.elotech.Main;
import br.com.elotech.config.ConnectionUtil;
import br.com.elotech.enuns.SistemaEnum;
import com.google.gson.Gson;
import java.io.File;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.htmlcleaner.HtmlCleaner;
import org.httprpc.sql.Parameters;

public abstract class Util {
    private static final Gson gson = new Gson();
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final DateFormat df_BR = new SimpleDateFormat("dd/MM/yyyy");
    private static final DateFormat dtf_BR = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private static final String EXTENSION = ".png";

    public static Object decodeArgsToJson(String arg, Class classe) {
        byte[] decoded = Base64.getMimeDecoder().decode(arg);
        return Util.fromJsom(new String(decoded), classe);
    }

    public static Object fromJsom(String obj, Class classe) {
        return gson.fromJson(obj, classe);
    }

    public static String formatDateBD(java.util.Date dt) {
        return df.format(dt);
    }

    public static String formatDateTimeBD(java.util.Date dt) {
        return dtf.format(dt);
    }

    public static String formatDateBR(java.util.Date dt) {
        return df_BR.format(dt);
    }

    public static String formatDateTimeBR(java.util.Date dt) {
        return dtf_BR.format(dt);
    }

    public static Timestamp dateToTimeStamp(java.util.Date dt) {
        return new Timestamp(dt.getTime());
    }

    public static Date dateToSqlDate(java.util.Date dt) {
        return new Date(dt.getTime());
    }

    public static java.util.Date startDataInicial(java.util.Date dt) {
        Calendar c = Calendar.getInstance();
        c.set(1, 1950);
        c.set(2, 0);
        c.set(5, 1);
        return dt == null ? c.getTime() : dt;
    }

    public static String getJarPath() throws URISyntaxException {
        return new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
    }

    public static File getLogo(SistemaEnum sistema) throws URISyntaxException {
        return new File(new File(Util.getJarPath()).getPath().concat("/logos/".concat(sistema.name().toLowerCase()).concat(EXTENSION)));
    }

    public static String toCamelCase(String phrase) {
        while (phrase.contains("_")) {
            phrase = phrase.replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(phrase.charAt(phrase.indexOf("_") + 1))));
        }
        return phrase;
    }

    public static ResultSet resolveResultSet(String sql, Map<String, Object> params) throws SQLException {
        Parameters p = Parameters.parse(sql);
        if (!params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                p.put(entry.getKey(), entry.getValue());
            }
        }
        Connection conn = ConnectionUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement(p.getSQL());
        p.apply(ps);
        ResultSet rs = ps.executeQuery();
        conn.commit();
        conn.close();
        return rs;
    }

    public static ResultSet subResultSet(String sql, Map<String, Object> params, Connection conn) throws SQLException {
        Parameters p = Parameters.parse(sql);
        if (!params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                p.put(entry.getKey(), entry.getValue());
            }
        }
        PreparedStatement ps = conn.prepareStatement(p.getSQL());
        p.apply(ps);
        return ps.executeQuery();
    }

    public static boolean existColumn(ResultSet resultSet, String columnName) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int coulmnCount = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= coulmnCount; ++i) {
            if (!columnName.equals(resultSetMetaData.getColumnName(i))) continue;
            return true;
        }
        return false;
    }

    public static String removeHtmlFrom(String html) {
        return new HtmlCleaner().clean(StringEscapeUtils.unescapeHtml4(html)).getText().toString();
    }

    public static String getLabelCase(String filter) {
        StringBuilder sb = new StringBuilder();
        if (filter.contains("<")) {
            sb.append(filter.replace("<", "Menores que"));
        }
        if (filter.contains("BETWEEN")) {
            sb.append(filter.replace("BETWEEN", "Entre").replace("AND", "e"));
        }
        if (filter.contains("=")) {
            sb.append(filter.replace("=", ""));
        }
        if (filter.contains(">")) {
            sb.append(filter.replace(">", "Maiores que "));
        }
        return sb.append(" anos'").toString();
    }

    public static String getSexo(String filter) {
        switch (filter) {
            case "F": {
                filter = "FEMININO";
                break;
            }
            case "M": {
                filter = "MASCULINO";
            }
        }
        return filter;
    }
}

