/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.util;

import br.com.elotech.model.Unidade;
import br.com.elotech.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class UtilFilter {
    public static Unidade getUnidadePorCodigo(Integer uni_codigo) throws SQLException {
        String sql = "SELECT uni_codigo, uni_desc FROM unidade where uni_codigo = :uni_codigo";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("uni_codigo", uni_codigo);
        ResultSet rs = Util.resolveResultSet(sql, params);
        Unidade unidade = null;
        if (rs.next()) {
            unidade = new Unidade(rs.getInt("uni_codigo"), rs.getString("uni_desc"));
        }
        return unidade;
    }

    public static String getEquipePorNuIne(String nu_ine) throws SQLException {
        String sql = "SELECT nu_ine as nu_ine, no_equipe as nome_equipe from tb_equipe where nu_ine = :nu_ine AND st_ativo = 'A'";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nu_ine", nu_ine);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs.getString("nome_equipe");
        }
        return "";
    }

    public static String getMicroArea(Integer micCodigo) throws SQLException {
        String sql = "SELECT mic_descricao from microarea where mic_codigo = :mic_codigo AND ativo is true";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("mic_codigo", micCodigo);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs.getString("mic_descricao");
        }
        return "";
    }

    public static ResultSet getUsuarios(Integer usr_codigo) throws SQLException {
        String sql = "SELECT * FROM usuarios WHERE usr_codigo = :usr_codigo";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("usr_codigo", usr_codigo);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs;
        }
        return null;
    }

    public static ResultSet getUsuario(Integer usu_codigo) throws SQLException {
        String sql = "SELECT * FROM usuario WHERE usu_codigo = :usu_codigo";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("usu_codigo", usu_codigo);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs;
        }
        return null;
    }

    public static String getResponsavelProntuarioSuas(Integer asps) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT usu.usu_nome FROM usuario usu").append(" INNER JOIN as_prontuario_suas_usuario aspsu ON usu.usu_codigo = aspsu.usu_codigo").append(" WHERE aspsu.asps_codigo = :aspsCodigo").append(" AND usu.usu_asps_ativo ='t'").append(" AND usu.usu_asps_ref ='t'");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("aspsCodigo", asps);
        ResultSet rs = Util.resolveResultSet(sql.toString(), params);
        if (rs.next()) {
            return rs.getString("usu_nome");
        }
        return "";
    }

    public static String getBeneficio(Integer cod_ben) throws SQLException {
        String sql = "SELECT beneficio FROM beneficios WHERE cod_ben = :cod_ben";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cod_ben", cod_ben);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs.getString("beneficio");
        }
        return null;
    }

    public static ResultSet getMotivos(Integer asam_codigo) throws SQLException {
        String sql = "SELECT asam_nome FROM as_atendimento_motivo WHERE asam_codigo = :asam_codigo";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("asam_codigo", asam_codigo);
        ResultSet rs = Util.resolveResultSet(sql, params);
        if (rs.next()) {
            return rs;
        }
        return null;
    }
}

