/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseThermometerPlot
extends JRBaseChartPlot
implements JRThermometerPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange;
    protected JRValueDisplay valueDisplay;
    protected boolean showValueLines;
    protected ValueLocationEnum valueLocationObject;
    protected Color mercuryColor;
    protected JRDataRange lowRange;
    protected JRDataRange mediumRange;
    protected JRDataRange highRange;
    private int PSEUDO_SERIAL_VERSION_UID = 40600;
    private byte valueLocation = ValueLocationEnum.BULB.getValue();
    private Byte valueLocationByte;

    public JRBaseThermometerPlot(JRChartPlot plot, JRChart chart) {
        super(plot, chart);
        JRThermometerPlot thermoPlot = plot instanceof JRThermometerPlot ? (JRThermometerPlot)plot : null;
        this.valueDisplay = thermoPlot == null ? new JRBaseValueDisplay(null, chart) : new JRBaseValueDisplay(thermoPlot.getValueDisplay(), chart);
    }

    public JRBaseThermometerPlot(JRThermometerPlot thermoPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)thermoPlot, factory);
        this.dataRange = new JRBaseDataRange(thermoPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(thermoPlot.getValueDisplay(), factory);
        this.valueLocationObject = thermoPlot.getValueLocationValue();
        this.mercuryColor = thermoPlot.getMercuryColor();
        if (thermoPlot.getLowRange() != null) {
            this.lowRange = new JRBaseDataRange(thermoPlot.getLowRange(), factory);
        }
        if (thermoPlot.getMediumRange() != null) {
            this.mediumRange = new JRBaseDataRange(thermoPlot.getMediumRange(), factory);
        }
        if (thermoPlot.getHighRange() != null) {
            this.highRange = new JRBaseDataRange(thermoPlot.getHighRange(), factory);
        }
    }

    @Override
    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    @Override
    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    @Override
    public boolean isShowValueLines() {
        return this.showValueLines;
    }

    @Override
    public ValueLocationEnum getValueLocationValue() {
        return this.valueLocationObject;
    }

    @Override
    public Color getMercuryColor() {
        return this.mercuryColor;
    }

    @Override
    public JRDataRange getLowRange() {
        return this.lowRange;
    }

    @Override
    public JRDataRange getMediumRange() {
        return this.mediumRange;
    }

    @Override
    public JRDataRange getHighRange() {
        return this.highRange;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public Object clone(JRChart parentChart) {
        JRBaseThermometerPlot clone = (JRBaseThermometerPlot)super.clone(parentChart);
        clone.dataRange = JRCloneUtils.nullSafeClone(this.dataRange);
        clone.valueDisplay = this.valueDisplay == null ? null : this.valueDisplay.clone(parentChart);
        clone.lowRange = JRCloneUtils.nullSafeClone(this.lowRange);
        clone.mediumRange = JRCloneUtils.nullSafeClone(this.mediumRange);
        clone.highRange = JRCloneUtils.nullSafeClone(this.highRange);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30103) {
            this.valueLocationObject = ValueLocationEnum.getByValue(this.valueLocation);
        } else if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.valueLocationObject = ValueLocationEnum.getByValue(this.valueLocationByte);
            this.valueLocationByte = null;
        }
    }
}

