/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.optimizer.Codegen;

public class JavaScriptClassLoader
extends DefiningClassLoader {
    private static final Log log = LogFactory.getLog(JavaScriptClassLoader.class);

    public JavaScriptClassLoader() {
        super(Codegen.class.getClassLoader());
    }

    public Script createScript(int classIndex, JavaScriptCompiledData compiledData) {
        JavaScriptCompiledData.CompiledClass compiledClass = compiledData.getCompiledClass(classIndex);
        Class<? extends Script> scriptClass = this.loadExpressionClass(compiledClass);
        try {
            Script script = scriptClass.newInstance();
            return script;
        }
        catch (InstantiationException e) {
            throw new JRRuntimeException("Failed to instantiate script class " + compiledClass.getClassName(), e);
        }
        catch (IllegalAccessException e) {
            throw new JRRuntimeException("Failed to instantiate script class " + compiledClass.getClassName(), e);
        }
    }

    protected synchronized Class<? extends Script> loadExpressionClass(JavaScriptCompiledData.CompiledClass compiledClass) {
        String className = compiledClass.getClassName();
        Class scriptClass = this.findLoadedClass(className);
        if (scriptClass == null) {
            if (log.isDebugEnabled()) {
                log.debug("loading script class " + className);
            }
            try {
                scriptClass = this.defineClass(className, compiledClass.getClassBytes());
                this.linkClass(scriptClass);
            }
            catch (SecurityException e) {
                throw new JRRuntimeException("Failed to load script class " + className, e);
            }
            catch (IllegalArgumentException e) {
                throw new JRRuntimeException("Failed to load script class " + className, e);
            }
        }
        return scriptClass;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + ((Object)((Object)this)).hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (log.isDebugEnabled()) {
            log.debug("finalized " + (Object)((Object)this));
        }
    }
}

