/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptEvaluatorScope;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;

public class JavaScriptEvaluator
extends JREvaluator {
    public static final String PROPERTY_OPTIMIZATION_LEVEL = "net.sf.jasperreports.javascript.evaluator.optimization.level";
    private static final Log log = LogFactory.getLog(JavaScriptEvaluator.class);
    private final JasperReportsContext jrContext;
    private final JavaScriptCompileData compileData;
    private Context context;
    private JavaScriptEvaluatorScope evaluatorScope;
    private Map<String, Class<?>> loadedTypes = new HashMap();
    private Map<String, Script> compiledExpressions = new HashMap<String, Script>();

    public JavaScriptEvaluator(JasperReportsContext jrContext, JavaScriptCompileData compileData) {
        this.jrContext = jrContext;
        this.compileData = compileData;
    }

    @Override
    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        this.context = ContextFactory.getGlobal().enterContext();
        int optimizationLevel = JRPropertiesUtil.getInstance(this.jrContext).getIntegerProperty(PROPERTY_OPTIMIZATION_LEVEL);
        if (log.isDebugEnabled()) {
            log.debug("optimization level " + optimizationLevel);
        }
        this.context.setOptimizationLevel(optimizationLevel);
        this.context.getWrapFactory().setJavaPrimitiveWrap(false);
        this.evaluatorScope = new JavaScriptEvaluatorScope(this.context, this);
        this.evaluatorScope.init(parametersMap, fieldsMap, variablesMap);
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpression());
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpression());
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpression());
    }

    protected JavaScriptCompileData.Expression getExpression(int id) {
        return this.compileData.getExpression(id);
    }

    protected Object evaluateExpression(String type, String expression) {
        return this.evaluateExpression(expression);
    }

    protected Object evaluateExpression(String expression) {
        Script compiledExpression = this.getCompiledExpression(expression);
        return this.evaluatorScope.evaluateExpression(compiledExpression);
    }

    protected Script getCompiledExpression(String expression) {
        Script compiledExpression = this.compiledExpressions.get(expression);
        if (compiledExpression == null) {
            if (log.isTraceEnabled()) {
                log.trace("compiling expression " + expression);
            }
            compiledExpression = this.context.compileString(expression, "expression", 0, null);
            this.compiledExpressions.put(expression, compiledExpression);
        }
        return compiledExpression;
    }

    protected Class<?> getTypeClass(String type) {
        Class<?> typeClass = this.loadedTypes.get(type);
        if (typeClass == null) {
            try {
                typeClass = JRClassLoader.loadClassForName(type);
            }
            catch (ClassNotFoundException e) {
                throw new JRRuntimeException("Unable to load class " + type, e);
            }
            this.loadedTypes.put(type, typeClass);
        }
        return typeClass;
    }
}

