/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.util.List;
import net.sf.jasperreports.components.headertoolbar.actions.ConditionalFormattingData;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.web.commands.Command;
import net.sf.jasperreports.web.util.JacksonUtil;

public class ConditionalFormattingCommand
implements Command {
    public static final String COLUMN_CONDITIONAL_FORMATTING_PROPERTY = "net.sf.jasperreports.components.headertoolbar.conditional.formatting";
    private JasperReportsContext jasperReportsContext;
    protected StandardTable table;
    protected ConditionalFormattingData conditionalFormattingData;
    private String oldSerializedConditionsData;
    private String newSerializedConditionsData;
    private JRDesignTextField textElement;

    public ConditionalFormattingCommand(JasperReportsContext jasperReportsContext, StandardTable table, ConditionalFormattingData conditionalFormattingData) {
        this.jasperReportsContext = jasperReportsContext;
        this.table = table;
        this.conditionalFormattingData = conditionalFormattingData;
    }

    @Override
    public void execute() {
        List<BaseColumn> tableColumns = TableUtil.getAllColumns(this.table);
        StandardColumn column = (StandardColumn)tableColumns.get(this.conditionalFormattingData.getColumnIndex());
        this.textElement = (JRDesignTextField)TableUtil.getColumnDetailTextElement(column);
        if (this.textElement != null) {
            String serializedConditionData = null;
            JRPropertiesMap propertiesMap = this.textElement.getPropertiesMap();
            if (propertiesMap.containsProperty(COLUMN_CONDITIONAL_FORMATTING_PROPERTY)) {
                serializedConditionData = propertiesMap.getProperty(COLUMN_CONDITIONAL_FORMATTING_PROPERTY);
            }
            this.oldSerializedConditionsData = serializedConditionData;
            JacksonUtil jacksonUtil = JacksonUtil.getInstance(this.jasperReportsContext);
            ConditionalFormattingData existingConditionData = jacksonUtil.loadObject(serializedConditionData, ConditionalFormattingData.class);
            if (existingConditionData != null) {
                existingConditionData.setConditions(this.conditionalFormattingData.getConditions());
            } else {
                existingConditionData = this.conditionalFormattingData;
            }
            this.newSerializedConditionsData = jacksonUtil.getJsonString(existingConditionData);
            propertiesMap.setProperty(COLUMN_CONDITIONAL_FORMATTING_PROPERTY, this.newSerializedConditionsData);
        }
    }

    @Override
    public void undo() {
        if (this.textElement != null) {
            this.textElement.getPropertiesMap().setProperty(COLUMN_CONDITIONAL_FORMATTING_PROPERTY, this.oldSerializedConditionsData);
        }
    }

    @Override
    public void redo() {
        if (this.textElement != null) {
            this.textElement.getPropertiesMap().setProperty(COLUMN_CONDITIONAL_FORMATTING_PROPERTY, this.newSerializedConditionsData);
        }
    }
}

