/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.analytics.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingService;
import net.sf.jasperreports.crosstabs.fill.calculation.BucketingServiceContext;
import net.sf.jasperreports.crosstabs.fill.calculation.MeasureDefinition;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.analytics.data.Axis;
import net.sf.jasperreports.engine.analytics.data.AxisLevel;
import net.sf.jasperreports.engine.analytics.data.AxisLevelNode;
import net.sf.jasperreports.engine.analytics.data.MappedPropertyValues;
import net.sf.jasperreports.engine.analytics.data.Measure;
import net.sf.jasperreports.engine.analytics.data.MeasureValue;
import net.sf.jasperreports.engine.analytics.data.MultiAxisDataSource;
import net.sf.jasperreports.engine.analytics.data.PropertyValues;
import net.sf.jasperreports.engine.analytics.data.StandardAxisLevel;
import net.sf.jasperreports.engine.analytics.data.StandardMeasure;
import net.sf.jasperreports.engine.analytics.data.StandardMeasureValue;
import net.sf.jasperreports.engine.analytics.dataset.DataAxis;
import net.sf.jasperreports.engine.analytics.dataset.DataAxisLevel;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucket;
import net.sf.jasperreports.engine.analytics.dataset.DataLevelBucketProperty;
import net.sf.jasperreports.engine.analytics.dataset.DataMeasure;
import net.sf.jasperreports.engine.analytics.dataset.MultiAxisData;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRIncrementerFactoryCache;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.util.SingleValue;
import net.sf.jasperreports.engine.util.ValuePropertiesWrapper;
import net.sf.jasperreports.engine.util.ValuePropertiesWrapperComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiAxisDataService {
    protected static final Log log = LogFactory.getLog(MultiAxisDataService.class);
    private final BucketingServiceContext serviceContext;
    private final MultiAxisData data;
    private final MultiAxisBucketingService bucketingService;
    private final Map<DataAxisLevel, Map<String, Integer>> axisLevelBucketPropertyIndexes = new HashMap<DataAxisLevel, Map<String, Integer>>();
    private final List<List<AxisLevel>> axisLevels;
    private final BucketDefinition.Bucket[] axisRoots;
    private final List<Measure> measures;
    private final Object[] bucketValues;
    private final Object[] measureValues;

    public MultiAxisDataService(JasperReportsContext jasperReportsContext, JRFillExpressionEvaluator expressionEvaluator, MultiAxisData data, byte evaluation) throws JRException {
        this.serviceContext = new ServiceContext(jasperReportsContext, expressionEvaluator);
        this.data = data;
        if (log.isDebugEnabled()) {
            log.debug("creating multi axis data service for " + data);
        }
        this.axisLevels = new ArrayList<List<AxisLevel>>(Axis.axisCount());
        this.axisLevels.addAll(Collections.nCopies(Axis.axisCount(), null));
        ArrayList axisBuckets = new ArrayList(Axis.axisCount());
        axisBuckets.addAll(Collections.nCopies(Axis.axisCount(), null));
        this.axisRoots = new BucketDefinition.Bucket[Axis.axisCount()];
        for (Axis axis : Axis.values()) {
            DataAxis dataAxis = data.getDataAxis(axis);
            List<Object> dataLevels = dataAxis == null ? Collections.emptyList() : dataAxis.getLevels();
            int levelCount = this.axisLevels.size();
            ArrayList<AxisLevel> levels = new ArrayList<AxisLevel>(levelCount + 1);
            levels.add(this.createRootLevel(axis));
            ArrayList<BucketDefinition> buckets = new ArrayList<BucketDefinition>(levelCount + 1);
            BucketDefinition rowRootBucket = this.createRootBucket();
            buckets.add(rowRootBucket);
            this.axisRoots[axis.ordinal()] = rowRootBucket.create(SingleValue.VALUE);
            for (DataAxisLevel dataAxisLevel : dataLevels) {
                AxisLevel level = this.createLevel(axis, dataAxisLevel, evaluation, levels.size());
                levels.add(level);
                buckets.add(this.createServiceBucket(dataAxisLevel, evaluation));
                if (!log.isDebugEnabled()) continue;
                log.debug("created level " + level);
            }
            this.axisLevels.set(axis.ordinal(), levels);
            axisBuckets.set(axis.ordinal(), buckets);
        }
        List<DataMeasure> dataMeasures = data.getMeasures();
        this.measures = new ArrayList<Measure>(dataMeasures.size());
        ArrayList<MeasureDefinition> measureList = new ArrayList<MeasureDefinition>(dataMeasures.size());
        for (DataMeasure dataMeasure : dataMeasures) {
            Measure measure = this.createMeasure(dataMeasure, evaluation);
            this.measures.add(measure);
            measureList.add(this.createServiceMeasure(dataMeasure));
            if (!log.isDebugEnabled()) continue;
            log.debug("created measure " + measure);
        }
        List rowBuckets = (List)axisBuckets.get(Axis.ROWS.ordinal());
        if (rowBuckets.size() > 1) {
            ((BucketDefinition)rowBuckets.get(1)).setComputeTotal();
        }
        List colBuckets = (List)axisBuckets.get(Axis.COLUMNS.ordinal());
        ((BucketDefinition)colBuckets.get(0)).setComputeTotal();
        this.bucketValues = new Object[rowBuckets.size() + colBuckets.size()];
        this.measureValues = new Object[dataMeasures.size()];
        boolean[][] retrieveTotal = new boolean[rowBuckets.size() + 1][colBuckets.size() + 2];
        this.bucketingService = new MultiAxisBucketingService(rowBuckets, colBuckets, measureList, retrieveTotal);
    }

    protected AxisLevel createRootLevel(Axis axis) throws JRException {
        StandardAxisLevel level = new StandardAxisLevel();
        level.setAxis(axis);
        level.setType(AxisLevel.Type.ROOT);
        level.setName("$ROOT");
        level.setLabel("$ROOT");
        level.setValueType(SingleValue.class);
        level.setDepth(0);
        return level;
    }

    protected BucketDefinition createRootBucket() throws JRException {
        return new BucketDefinition(SingleValue.class, null, null, SortOrderEnum.ASCENDING, CrosstabTotalPositionEnum.START);
    }

    protected AxisLevel createLevel(Axis axis, DataAxisLevel dataLevel, byte evaluation, int depth) throws JRException {
        StandardAxisLevel level = new StandardAxisLevel();
        level.setAxis(axis);
        level.setName(dataLevel.getName());
        String label = (String)this.serviceContext.getExpressionEvaluator().evaluate(dataLevel.getLabelExpression(), evaluation);
        level.setLabel(label);
        level.setValueType(dataLevel.getBucket().getValueClass());
        level.setDepth(depth);
        return level;
    }

    protected BucketDefinition createServiceBucket(DataAxisLevel level, byte evaluation) throws JRException {
        BucketDefinition bucketDefinition;
        List<DataLevelBucketProperty> bucketProperties;
        DataLevelBucket bucket = level.getBucket();
        Class<?> valueClass = bucket.getValueClass();
        Comparator comparator = null;
        JRExpression comparatorExpression = bucket.getComparatorExpression();
        if (comparatorExpression != null) {
            comparator = (Comparator)this.serviceContext.getExpressionEvaluator().evaluate(comparatorExpression, evaluation);
        }
        if ((bucketProperties = bucket.getBucketProperties()) != null && !bucketProperties.isEmpty()) {
            LinkedHashMap<String, Integer> propertyIndexes = new LinkedHashMap<String, Integer>();
            ListIterator<DataLevelBucketProperty> it = bucketProperties.listIterator();
            while (it.hasNext()) {
                DataLevelBucketProperty bucketProperty = it.next();
                propertyIndexes.put(bucketProperty.getName(), it.previousIndex());
            }
            this.axisLevelBucketPropertyIndexes.put(level, propertyIndexes);
            bucketDefinition = new PropertiesWrapperBucketDefintion(comparator, bucket.getOrderValue(), CrosstabTotalPositionEnum.START);
        } else {
            bucketDefinition = new BucketDefinition(valueClass, null, comparator, bucket.getOrderValue(), CrosstabTotalPositionEnum.START);
        }
        return bucketDefinition;
    }

    protected Measure createMeasure(DataMeasure dataMeasure, byte evaluation) throws JRException {
        StandardMeasure measure = new StandardMeasure();
        measure.setName(dataMeasure.getName());
        String label = (String)this.serviceContext.getExpressionEvaluator().evaluate(dataMeasure.getLabelExpression(), evaluation);
        measure.setLabel(label);
        measure.setValueType(dataMeasure.getValueClass());
        return measure;
    }

    protected MeasureDefinition createServiceMeasure(DataMeasure measure) {
        String incrementerFactoryClassName = measure.getIncrementerFactoryClassName();
        JRExtendedIncrementerFactory incrFactory = incrementerFactoryClassName == null ? JRDefaultIncrementerFactory.getFactory(measure.getValueClass()) : (JRExtendedIncrementerFactory)JRIncrementerFactoryCache.getInstance(measure.getIncrementerFactoryClass());
        return new MeasureDefinition(measure.getValueClass(), measure.getCalculation(), incrFactory);
    }

    public void evaluateRecord(JRCalculator calculator) throws JRExpressionEvalException {
        int bucketIdx = 0;
        this.bucketValues[bucketIdx++] = SingleValue.VALUE;
        DataAxis rowAxis = this.data.getDataAxis(Axis.ROWS);
        if (rowAxis != null) {
            for (DataAxisLevel level : rowAxis.getLevels()) {
                this.bucketValues[bucketIdx++] = this.evaluateBucketValue(calculator, level);
            }
        }
        this.bucketValues[bucketIdx++] = SingleValue.VALUE;
        DataAxis colAxis = this.data.getDataAxis(Axis.COLUMNS);
        if (colAxis != null) {
            for (DataAxisLevel level : colAxis.getLevels()) {
                this.bucketValues[bucketIdx++] = this.evaluateBucketValue(calculator, level);
            }
        }
        int measureIdx = 0;
        for (DataMeasure measure : this.data.getMeasures()) {
            this.measureValues[measureIdx++] = calculator.evaluate(measure.getValueExpression());
        }
    }

    protected Object evaluateBucketValue(JRCalculator calculator, DataAxisLevel level) throws JRExpressionEvalException {
        Object bucketValue;
        DataLevelBucket bucket = level.getBucket();
        Object mainValue = calculator.evaluate(bucket.getExpression());
        List<DataLevelBucketProperty> bucketProperties = bucket.getBucketProperties();
        if (bucketProperties == null || bucketProperties.isEmpty()) {
            bucketValue = mainValue;
        } else {
            Object[] propertyValues = new Object[bucketProperties.size()];
            ListIterator<DataLevelBucketProperty> it = bucketProperties.listIterator();
            while (it.hasNext()) {
                DataLevelBucketProperty bucketProperty = it.next();
                propertyValues[it.previousIndex()] = calculator.evaluate(bucketProperty.getExpression());
            }
            bucketValue = new ValuePropertiesWrapper(mainValue, propertyValues);
        }
        return bucketValue;
    }

    public void addRecord() {
        try {
            this.bucketingService.addData(this.bucketValues, this.measureValues);
        }
        catch (JRException e) {
            throw new JRRuntimeException("Error incrementing bidimensional dataset", e);
        }
    }

    public void clearData() {
        if (log.isDebugEnabled()) {
            log.debug("clearing data");
        }
        this.bucketingService.clear();
    }

    public MultiAxisDataSource createDataSource() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("creating multi axis data source");
        }
        this.bucketingService.processData();
        return new DataSource();
    }

    protected static class PropertiesWrapperBucketDefintion
    extends BucketDefinition {
        public PropertiesWrapperBucketDefintion(Comparator<Object> comparator, SortOrderEnum order, CrosstabTotalPositionEnum totalPosition) throws JRException {
            super(ValuePropertiesWrapper.class, null, comparator == null ? null : new ValuePropertiesWrapperComparator(comparator), order, totalPosition);
        }

        @Override
        public BucketDefinition.Bucket create(Object value) {
            if (value instanceof ValuePropertiesWrapper && ((ValuePropertiesWrapper)value).getValue() == null) {
                return new BucketDefinition.Bucket(this, value, 1);
            }
            return super.create(value);
        }
    }

    protected static class ServiceContext
    implements BucketingServiceContext {
        private final JasperReportsContext jasperReportsContext;
        private final JRFillExpressionEvaluator expressionEvaluator;

        public ServiceContext(JasperReportsContext jasperReportsContext, JRFillExpressionEvaluator expressionEvaluator) {
            this.jasperReportsContext = jasperReportsContext;
            this.expressionEvaluator = expressionEvaluator;
        }

        @Override
        public JasperReportsContext getJasperReportsContext() {
            return this.jasperReportsContext;
        }

        @Override
        public JRFillExpressionEvaluator getExpressionEvaluator() {
            return this.expressionEvaluator;
        }

        @Override
        public Object evaluateMeasuresExpression(JRExpression expression, MeasureDefinition.MeasureValue[] measureValues) throws JRException {
            throw new UnsupportedOperationException();
        }
    }

    protected class LevelNode
    implements AxisLevelNode {
        protected final Axis axis;
        protected final int axisDepth;
        protected final LevelNode parent;
        protected final BucketDefinition.Bucket bucket;
        protected final BucketingService.BucketMap childrenMap;
        protected Object value;
        protected PropertyValues propertyValues;

        public LevelNode(Axis axis, int axisDepth, LevelNode parent, BucketDefinition.Bucket bucket, BucketingService.BucketMap childrenMap) {
            this.axis = axis;
            this.axisDepth = axisDepth;
            this.parent = parent;
            this.bucket = bucket;
            this.childrenMap = childrenMap;
            this.initValues();
        }

        private void initValues() {
            DataAxisLevel dataLevel;
            List<DataLevelBucketProperty> bucketProperties;
            Object bucketValue;
            Object nodeValue = bucketValue = this.bucket.getValue();
            MappedPropertyValues propertyValues = null;
            if (this.axisDepth > 0 && bucketValue != null && (bucketProperties = (dataLevel = MultiAxisDataService.this.data.getDataAxis(this.axis).getLevels().get(this.axisDepth - 1)).getBucket().getBucketProperties()) != null && !bucketProperties.isEmpty()) {
                ValuePropertiesWrapper valueWrapper = (ValuePropertiesWrapper)bucketValue;
                nodeValue = valueWrapper.getValue();
                Map propertyIndexes = (Map)MultiAxisDataService.this.axisLevelBucketPropertyIndexes.get(dataLevel);
                Object[] propertyValuesArray = valueWrapper.getPropertyValues();
                propertyValues = new MappedPropertyValues(propertyIndexes, propertyValuesArray);
            }
            this.value = nodeValue;
            this.propertyValues = propertyValues;
        }

        @Override
        public AxisLevel getLevel() {
            return (AxisLevel)((List)MultiAxisDataService.this.axisLevels.get(this.axis.ordinal())).get(this.axisDepth);
        }

        @Override
        public boolean isTotal() {
            return this.axisDepth == 0 || this.bucket.isTotal();
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public PropertyValues getNodePropertyValues() {
            return this.propertyValues;
        }

        @Override
        public AxisLevelNode getParent() {
            return this.parent;
        }

        @Override
        public List<? extends AxisLevelNode> getChildren() {
            if (this.axisDepth + 1 >= ((List)MultiAxisDataService.this.axisLevels.get(this.axis.ordinal())).size()) {
                return Collections.emptyList();
            }
            if (this.childrenMap == null) {
                return Collections.emptyList();
            }
            ArrayList<LevelNode> children = new ArrayList<LevelNode>(this.childrenMap.size());
            Iterator<Map.Entry<BucketDefinition.Bucket, Object>> entryIterator = this.childrenMap.entryIterator();
            while (entryIterator.hasNext()) {
                Map.Entry<BucketDefinition.Bucket, Object> entry = entryIterator.next();
                BucketDefinition.Bucket childBucket = entry.getKey();
                Object entryValue = entry.getValue();
                BucketingService.BucketMap nextChildMap = entryValue instanceof BucketingService.BucketMap ? (BucketingService.BucketMap)entryValue : null;
                LevelNode childNode = new LevelNode(this.axis, this.axisDepth + 1, this, childBucket, nextChildMap);
                children.add(childNode);
            }
            if (log.isTraceEnabled()) {
                log.trace("children of " + this + ": " + children);
            }
            return children;
        }

        public String toString() {
            return this.bucket + " on " + this.axis + " level " + this.axisDepth;
        }
    }

    protected class DataSource
    implements MultiAxisDataSource {
        private final List<List<AxisLevel>> axisDataLevels;

        public DataSource() {
            this.axisDataLevels = new ArrayList<List<AxisLevel>>(MultiAxisDataService.this.axisLevels.size());
            for (List levels : MultiAxisDataService.this.axisLevels) {
                List dataLevels = Collections.unmodifiableList(levels.subList(1, levels.size()));
                this.axisDataLevels.add(dataLevels);
            }
        }

        @Override
        public List<? extends AxisLevel> getAxisLevels(Axis axis) {
            return this.axisDataLevels.get(axis.ordinal());
        }

        @Override
        public List<? extends Measure> getMeasures() {
            return MultiAxisDataService.this.measures;
        }

        @Override
        public AxisLevelNode getAxisRootNode(Axis axis) {
            BucketingService.BucketMap rootChildren;
            switch (axis) {
                case ROWS: {
                    rootChildren = MultiAxisDataService.this.bucketingService.getRowRootChildren();
                    break;
                }
                case COLUMNS: {
                    rootChildren = MultiAxisDataService.this.bucketingService.getColumnRootChildren();
                    break;
                }
                default: {
                    throw new JRRuntimeException("Unknown axis " + axis);
                }
            }
            BucketDefinition.Bucket rootBucket = MultiAxisDataService.this.axisRoots[axis.ordinal()];
            return new LevelNode(axis, 0, null, rootBucket, rootChildren);
        }

        @Override
        public List<? extends MeasureValue> getMeasureValues(AxisLevelNode ... nodes) {
            MeasureDefinition.MeasureValue[] values;
            Object bucketValue;
            if (nodes.length == 0) {
                throw new IllegalArgumentException("At least one node needs to be passed");
            }
            LevelNode rowNode = this.axisLevelNodeArgument(Axis.ROWS, nodes);
            LevelNode columnNode = this.axisLevelNodeArgument(Axis.COLUMNS, nodes);
            BucketingService.BucketMap bucketMap = rowNode == null ? MultiAxisDataService.this.bucketingService.getRowRootChildren() : rowNode.childrenMap;
            for (int idx = rowNode.axisDepth + 1; bucketMap != null && idx < ((List)MultiAxisDataService.this.axisLevels.get(Axis.ROWS.ordinal())).size(); bucketMap = (BucketingService.BucketMap)bucketMap.getTotal(), ++idx) {
            }
            if (bucketMap != null) {
                LinkedList<BucketDefinition.Bucket> columnBuckets = new LinkedList<BucketDefinition.Bucket>();
                if (columnNode != null) {
                    LevelNode node = columnNode;
                    while (node.axisDepth > 0) {
                        columnBuckets.addFirst(node.bucket);
                        node = node.parent;
                    }
                }
                bucketValue = bucketMap.get(MultiAxisDataService.this.axisRoots[Axis.COLUMNS.ordinal()]);
                Iterator columnBucketIterator = columnBuckets.iterator();
                for (int idx = 1; idx < ((List)MultiAxisDataService.this.axisLevels.get(Axis.COLUMNS.ordinal())).size() && bucketValue != null; ++idx) {
                    bucketMap = (BucketingService.BucketMap)bucketValue;
                    if (columnBucketIterator.hasNext()) {
                        BucketDefinition.Bucket bucket = (BucketDefinition.Bucket)columnBucketIterator.next();
                        bucketValue = bucketMap.get(bucket);
                        continue;
                    }
                    bucketValue = bucketMap.getTotal();
                }
            } else {
                bucketValue = null;
            }
            if (bucketValue == null) {
                values = MultiAxisDataService.this.bucketingService.getZeroUserMeasureValues();
            } else {
                MeasureDefinition.MeasureValue[] rawValues = (MeasureDefinition.MeasureValue[])bucketValue;
                values = MultiAxisDataService.this.bucketingService.getUserMeasureValues(rawValues);
            }
            ArrayList<StandardMeasureValue> measureValues = new ArrayList<StandardMeasureValue>(values.length);
            for (int i = 0; i < values.length; ++i) {
                Measure measure = (Measure)MultiAxisDataService.this.measures.get(i);
                Object value = values[i].getValue();
                StandardMeasureValue measureValue = new StandardMeasureValue(measure, value);
                measureValues.add(measureValue);
            }
            if (log.isTraceEnabled()) {
                log.trace("values for (" + rowNode + ", " + columnNode + "): " + measureValues);
            }
            return measureValues;
        }

        protected LevelNode axisLevelNodeArgument(Axis axis, AxisLevelNode ... nodes) {
            LevelNode axisNode = null;
            for (AxisLevelNode node : nodes) {
                if (node.getLevel().getAxis() != axis) continue;
                if (axisNode != null) {
                    throw new IllegalArgumentException("More than one node on axis " + axis);
                }
                if (!(node instanceof LevelNode)) {
                    throw new IllegalArgumentException("The method should be called with nodes created by this data source");
                }
                axisNode = (LevelNode)node;
            }
            return axisNode;
        }
    }

    protected class MultiAxisBucketingService
    extends BucketingService {
        public MultiAxisBucketingService(List<BucketDefinition> rowBuckets, List<BucketDefinition> columnBuckets, List<MeasureDefinition> measures, boolean[][] retrieveTotal) {
            super(MultiAxisDataService.this.serviceContext, rowBuckets, columnBuckets, measures, false, retrieveTotal);
        }

        protected BucketingService.BucketMap getRowRootChildren() {
            if (((List)MultiAxisDataService.this.axisLevels.get(Axis.ROWS.ordinal())).size() == 1) {
                return null;
            }
            return (BucketingService.BucketMap)this.bucketValueMap.get(MultiAxisDataService.this.axisRoots[Axis.ROWS.ordinal()]);
        }

        protected BucketingService.BucketMap getColumnRootChildren() {
            if (((List)MultiAxisDataService.this.axisLevels.get(Axis.COLUMNS.ordinal())).size() == 1) {
                return null;
            }
            BucketingService.BucketMap bucketMap = (BucketingService.BucketMap)this.bucketValueMap.get(MultiAxisDataService.this.axisRoots[Axis.ROWS.ordinal()]);
            int rowLevelsCount = ((List)MultiAxisDataService.this.axisLevels.get(Axis.ROWS.ordinal())).size();
            for (int idx = 1; bucketMap != null && idx < rowLevelsCount; ++idx) {
                bucketMap = (BucketingService.BucketMap)bucketMap.getTotalEntry().getValue();
            }
            if (bucketMap == null) {
                return null;
            }
            return (BucketingService.BucketMap)bucketMap.get(MultiAxisDataService.this.axisRoots[Axis.COLUMNS.ordinal()]);
        }
    }
}

