/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.UUID;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseDatasetParameter;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseDatasetRun
implements JRDatasetRun,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected UUID uuid;
    protected String datasetName;
    protected JRExpression parametersMapExpression;
    protected JRDatasetParameter[] parameters;
    protected JRExpression connectionExpression;
    protected JRExpression dataSourceExpression;
    protected JRPropertiesMap propertiesMap;

    protected JRBaseDatasetRun() {
    }

    protected JRBaseDatasetRun(JRDatasetRun datasetRun, JRBaseObjectFactory factory) {
        factory.put(datasetRun, this);
        this.uuid = datasetRun.getUUID();
        this.datasetName = datasetRun.getDatasetName();
        this.parametersMapExpression = factory.getExpression(datasetRun.getParametersMapExpression());
        this.connectionExpression = factory.getExpression(datasetRun.getConnectionExpression());
        this.dataSourceExpression = factory.getExpression(datasetRun.getDataSourceExpression());
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(datasetRun);
        JRDatasetParameter[] datasetParams = datasetRun.getParameters();
        if (datasetParams != null && datasetParams.length > 0) {
            this.parameters = new JRBaseDatasetParameter[datasetParams.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = factory.getDatasetParameter(datasetParams[i]);
            }
        }
    }

    @Override
    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    @Override
    public JRDatasetParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return this.connectionExpression;
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return this.dataSourceExpression;
    }

    @Override
    public Object clone() {
        JRBaseDatasetRun clone = null;
        try {
            clone = (JRBaseDatasetRun)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.parametersMapExpression = JRCloneUtils.nullSafeClone(this.parametersMapExpression);
        clone.connectionExpression = JRCloneUtils.nullSafeClone(this.connectionExpression);
        clone.dataSourceExpression = JRCloneUtils.nullSafeClone(this.dataSourceExpression);
        clone.parameters = (JRDatasetParameter[])JRCloneUtils.cloneArray((JRCloneable[])this.parameters);
        clone.propertiesMap = JRPropertiesMap.getPropertiesClone(this);
        clone.uuid = null;
        return clone;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }
}

