/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRCsvDataSource
extends JRAbstractTextDataSource {
    protected static final Log log = LogFactory.getLog(JRCsvDataSource.class);
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private char fieldDelimiter = (char)44;
    private String recordDelimiter = "\n";
    private Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    private boolean useFirstRowAsHeader;
    private List<String> fields;
    private Reader reader;
    private char[] buffer = new char[1024];
    private int position;
    private int bufSize;
    private boolean processingStarted;
    private boolean toClose;
    private boolean isStrictCsv = true;

    public JRCsvDataSource(InputStream stream) {
        this(new BufferedReader(new InputStreamReader(stream)));
    }

    public JRCsvDataSource(InputStream stream, String charsetName) throws UnsupportedEncodingException {
        this(new BufferedReader(new InputStreamReader(stream, charsetName)));
    }

    public JRCsvDataSource(URL url) throws IOException {
        this(url.openStream());
        this.toClose = true;
    }

    public JRCsvDataSource(URL url, String charsetName) throws IOException {
        this(url.openStream(), charsetName);
        this.toClose = true;
    }

    public JRCsvDataSource(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
        this.toClose = true;
    }

    public JRCsvDataSource(File file, String charsetName) throws FileNotFoundException, UnsupportedEncodingException {
        this(new FileInputStream(file), charsetName);
        this.toClose = true;
    }

    public JRCsvDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location));
        this.toClose = true;
    }

    public JRCsvDataSource(JasperReportsContext jasperReportsContext, String location, String charsetName) throws JRException, UnsupportedEncodingException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location), charsetName);
        this.toClose = true;
    }

    public JRCsvDataSource(String location) throws JRException {
        this(DefaultJasperReportsContext.getInstance(), location);
    }

    public JRCsvDataSource(String location, String charsetName) throws JRException, UnsupportedEncodingException {
        this(DefaultJasperReportsContext.getInstance(), location, charsetName);
    }

    public JRCsvDataSource(Reader reader) {
        this.reader = reader;
    }

    @Override
    public boolean next() throws JRException {
        try {
            if (!this.processingStarted) {
                if (this.useFirstRowAsHeader) {
                    this.parseRow();
                    this.columnNames = new LinkedHashMap<String, Integer>();
                    for (int i = 0; i < this.fields.size(); ++i) {
                        String name = this.fields.get(i);
                        this.columnNames.put(name, i);
                    }
                }
                this.processingStarted = true;
            }
            return this.parseRow();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Integer columnIndex = this.columnNames.get(fieldName);
        if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
            columnIndex = Integer.valueOf(fieldName.substring(7));
        }
        if (columnIndex == null) {
            throw new JRException("Unknown column name : " + fieldName);
        }
        if (this.fields.size() > columnIndex) {
            String fieldValue = this.fields.get(columnIndex);
            Class<?> valueClass = jrField.getValueClass();
            if (valueClass.equals(String.class)) {
                return fieldValue;
            }
            if ((fieldValue = fieldValue.trim()).length() == 0) {
                return null;
            }
            try {
                if (valueClass.equals(Boolean.class)) {
                    return fieldValue.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Number.class.isAssignableFrom(valueClass)) {
                    if (this.numberFormat != null) {
                        return FormatUtils.getFormattedNumber(this.numberFormat, fieldValue, valueClass);
                    }
                    return this.convertStringValue(fieldValue, valueClass);
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    if (this.dateFormat != null) {
                        return FormatUtils.getFormattedDate(this.dateFormat, fieldValue, valueClass);
                    }
                    return this.convertStringValue(fieldValue, valueClass);
                }
                throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and can not be converted");
            }
            catch (Exception e) {
                throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
            }
        }
        return null;
    }

    private boolean parseRow() throws IOException, JRException {
        int pos = 0;
        int startFieldPos = 0;
        int addedFields = 0;
        boolean insideQuotes = false;
        boolean isQuoted = false;
        boolean misplacedQuote = false;
        boolean startPosition = false;
        int leadingSpaces = 0;
        this.fields = new ArrayList<String>();
        String row = this.getRow();
        if (row == null) {
            return false;
        }
        if (row.length() > 0 && row.charAt(0) == '\ufeff') {
            row = row.substring(1);
        }
        while (pos < row.length()) {
            String newRow;
            char c = row.charAt(pos);
            if (pos == startFieldPos) {
                while (pos + leadingSpaces < row.length() && row.charAt(pos + leadingSpaces) <= ' ' && row.charAt(pos + leadingSpaces) != this.fieldDelimiter) {
                    ++leadingSpaces;
                }
            }
            if (c == '\"') {
                boolean bl = startPosition = pos == startFieldPos + leadingSpaces || !insideQuotes && row.charAt(pos - 1) == this.fieldDelimiter;
                if (startPosition) {
                    insideQuotes = true;
                    isQuoted = true;
                } else if (insideQuotes) {
                    if (pos + 1 < row.length()) {
                        if (row.charAt(pos + 1) == '\"') {
                            ++pos;
                        } else {
                            int trailingSpaces = 1;
                            while (pos + trailingSpaces < row.length() && row.charAt(pos + trailingSpaces) <= ' ') {
                                ++trailingSpaces;
                            }
                            if (pos + trailingSpaces < row.length() && row.charAt(pos + trailingSpaces) != this.fieldDelimiter) {
                                misplacedQuote = true;
                                if (this.isStrictCsv) {
                                    throw new JRException("Misplaced quote found at position " + pos + " in row: " + row);
                                }
                            }
                            insideQuotes = false;
                        }
                    } else {
                        insideQuotes = false;
                    }
                } else if (this.isStrictCsv) {
                    throw new JRException("Misplaced quote found at position " + pos + " in row: " + row);
                }
            }
            if (c == this.fieldDelimiter && !insideQuotes) {
                String field = row.substring(startFieldPos, pos);
                field = field.trim();
                if (isQuoted) {
                    if (field.endsWith("\"")) {
                        field = field.substring(0, field.length() - 1);
                    } else if (this.isStrictCsv) {
                        throw new JRException("Malformed quoted field: " + field);
                    }
                    field = field.substring(1);
                    field = this.replaceAll(field, "\"\"", "\"");
                }
                if (misplacedQuote) {
                    misplacedQuote = false;
                    if (log.isDebugEnabled()) {
                        log.debug("Undoubled quote found in quoted field: " + field);
                    }
                }
                isQuoted = false;
                insideQuotes = false;
                this.fields.add(field);
                if (++addedFields == this.columnNames.size()) {
                    addedFields = 0;
                }
                startFieldPos = pos + 1;
                leadingSpaces = 0;
            }
            if (++pos != row.length() || !insideQuotes || (newRow = this.getRow()) == null) continue;
            row = row + this.recordDelimiter + newRow;
        }
        String field = row.substring(startFieldPos, pos);
        if (field == null) {
            return true;
        }
        if (misplacedQuote) {
            if (this.isStrictCsv) {
                throw new JRException("Misplaced quote found in field: " + field);
            }
            if (log.isDebugEnabled()) {
                log.debug("Undoubled quote found in field: " + field);
            }
        }
        field = field.trim();
        if (isQuoted) {
            if (field.endsWith("\"")) {
                field = field.substring(0, field.length() - 1);
            } else if (this.isStrictCsv) {
                throw new JRException("Malformed quoted field: " + field);
            }
            field = field.substring(1);
            field = this.replaceAll(field, "\"\"", "\"");
        }
        this.fields.add(field);
        ++addedFields;
        while (addedFields < this.columnNames.size()) {
            this.fields.add("");
            ++addedFields;
        }
        return true;
    }

    private String getRow() throws IOException {
        StringBuffer row = new StringBuffer();
        try {
            while (true) {
                char c;
                if ((c = this.getChar()) == this.recordDelimiter.charAt(0) || c == '\u0000') {
                    int i;
                    char[] temp = new char[this.recordDelimiter.length()];
                    temp[0] = c;
                    boolean isDelimiter = true;
                    for (i = 1; i < this.recordDelimiter.length() && isDelimiter; ++i) {
                        temp[i] = this.getChar();
                        if (temp[i] == this.recordDelimiter.charAt(i)) continue;
                        isDelimiter = false;
                    }
                    if (isDelimiter) {
                        return row.toString();
                    }
                    row.append(temp, 0, i);
                }
                row.append(c);
            }
        }
        catch (JRException e) {
            if (row.length() == 0) {
                return null;
            }
            return row.toString();
        }
    }

    private char getChar() throws IOException, JRException {
        if (this.position + 1 > this.bufSize) {
            this.bufSize = this.reader.read(this.buffer);
            this.position = 0;
            if (this.bufSize == -1) {
                throw new JRException("No more chars");
            }
        }
        return this.buffer[this.position++];
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.dateFormat = dateFormat;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setRecordDelimiter(String recordDelimiter) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.recordDelimiter = recordDelimiter;
    }

    public void setColumnNames(String[] columnNames) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.columnNames = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < columnNames.length; ++i) {
            this.columnNames.put(columnNames[i], i);
        }
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public void close() {
        if (this.toClose) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String replaceAll(String string, String substring, String replacement) {
        StringBuffer result = new StringBuffer();
        int index = string.indexOf(substring);
        int oldIndex = 0;
        while (index >= 0) {
            result.append(string.substring(oldIndex, index));
            result.append(replacement);
            oldIndex = index += substring.length();
            index = string.indexOf(substring, index);
        }
        if (oldIndex < string.length()) {
            result.append(string.substring(oldIndex, string.length()));
        }
        return result.toString();
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        if (this.processingStarted) {
            throw new JRRuntimeException("Cannot modify data source properties after data reading has started");
        }
        this.numberFormat = numberFormat;
    }

    public Map<String, Integer> getColumnNames() {
        return this.columnNames;
    }
}

