/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.GenericElementOdtHandler;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterContext;
import net.sf.jasperreports.engine.export.oasis.JROdtExporterNature;
import net.sf.jasperreports.engine.export.oasis.JROpenDocumentExporter;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JROdtExporter
extends JROpenDocumentExporter {
    private static final Log log = LogFactory.getLog(JROdtExporter.class);
    public static final String ODT_EXPORTER_KEY = "net.sf.jasperreports.odt";
    protected static final String ODT_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.odt.";

    public JROdtExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JROdtExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected ExporterNature getExporterNature(ExporterFilter filter) {
        return new JROdtExporterNature(filter);
    }

    @Override
    protected String getExporterPropertiesPrefix() {
        return ODT_EXPORTER_PROPERTIES_PREFIX;
    }

    @Override
    protected void exportLine(TableBuilder tableBuilder, JRPrintLine line, JRExporterGridCell gridCell) throws IOException {
        double y2;
        double x2;
        double y1;
        double x1;
        tableBuilder.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
            x1 = LengthUtil.inch(0.0);
            y1 = LengthUtil.inch(0.0);
            x2 = LengthUtil.inch(line.getWidth() - 1);
            y2 = LengthUtil.inch(line.getHeight() - 1);
        } else {
            x1 = LengthUtil.inch(0.0);
            y1 = LengthUtil.inch(line.getHeight() - 1);
            x2 = LengthUtil.inch(line.getWidth() - 1);
            y2 = LengthUtil.inch(0.0);
        }
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("<draw:line text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(line) + "\" " + "svg:x1=\"" + x1 + "in\" " + "svg:y1=\"" + y1 + "in\" " + "svg:x2=\"" + x2 + "in\" " + "svg:y2=\"" + y2 + "in\">" + "<text:p/></draw:line>" + "</text:p>");
        tableBuilder.buildCellFooter();
    }

    @Override
    protected void exportEllipse(TableBuilder tableBuilder, JRPrintEllipse ellipse, JRExporterGridCell gridCell) throws IOException {
        tableBuilder.buildCellHeader(null, gridCell.getColSpan(), gridCell.getRowSpan());
        this.tempBodyWriter.write("<text:p>");
        this.insertPageAnchor();
        this.tempBodyWriter.write("<draw:ellipse text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(ellipse) + "\" " + "svg:width=\"" + LengthUtil.inch(ellipse.getWidth()) + "in\" " + "svg:height=\"" + LengthUtil.inch(ellipse.getHeight()) + "in\" " + "svg:x=\"0in\" " + "svg:y=\"0in\">" + "<text:p/></draw:ellipse></text:p>");
        tableBuilder.buildCellFooter();
    }

    @Override
    public void exportImage(TableBuilder tableBuilder, JRPrintImage image, JRExporterGridCell gridCell) throws JRException, IOException {
        int topPadding = Math.max(image.getLineBox().getTopPadding(), Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue()));
        int leftPadding = Math.max(image.getLineBox().getLeftPadding(), Math.round(image.getLineBox().getLeftPen().getLineWidth().floatValue()));
        int bottomPadding = Math.max(image.getLineBox().getBottomPadding(), Math.round(image.getLineBox().getBottomPen().getLineWidth().floatValue()));
        int rightPadding = Math.max(image.getLineBox().getRightPadding(), Math.round(image.getLineBox().getRightPen().getLineWidth().floatValue()));
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int width = availableImageWidth;
        int height = availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        Renderable renderer = image.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && !image.isLazy()) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, image.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            float xalignFactor = this.getXAlignFactor(image);
            float yalignFactor = this.getYAlignFactor(image);
            switch (image.getScaleImageValue()) {
                case FILL_FRAME: {
                    width = availableImageWidth;
                    height = availableImageHeight;
                    xoffset = 0;
                    yoffset = 0;
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    if (availableImageHeight > 0) {
                        double ratio = normalWidth / normalHeight;
                        if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                            width = availableImageWidth;
                            height = (int)((double)width / ratio);
                        } else {
                            height = availableImageHeight;
                            width = (int)(ratio * (double)height);
                        }
                    }
                    xoffset = (int)(xalignFactor * (float)(availableImageWidth - width));
                    yoffset = (int)(yalignFactor * (float)(availableImageHeight - height));
                }
            }
            this.tempBodyWriter.write("<text:p>");
            this.insertPageAnchor();
            if (image.getAnchorName() != null) {
                this.exportAnchor(JRStringUtil.xmlEncode(image.getAnchorName()));
            }
            boolean startedHyperlink = this.startHyperlink(image, false);
            this.tempBodyWriter.write("<draw:frame text:anchor-type=\"paragraph\" draw:style-name=\"" + this.styleCache.getGraphicStyle(image) + "\" " + "svg:x=\"" + LengthUtil.inch(leftPadding + xoffset) + "in\" " + "svg:y=\"" + LengthUtil.inch(topPadding + yoffset) + "in\" " + "svg:width=\"" + LengthUtil.inch(width) + "in\" " + "svg:height=\"" + LengthUtil.inch(height) + "in\">");
            this.tempBodyWriter.write("<draw:image ");
            String imagePath = this.getImagePath(renderer, image.isLazy(), gridCell);
            this.tempBodyWriter.write(" xlink:href=\"" + JRStringUtil.xmlEncode(imagePath) + "\"");
            this.tempBodyWriter.write(" xlink:type=\"simple\"");
            this.tempBodyWriter.write(" xlink:show=\"embed\"");
            this.tempBodyWriter.write(" xlink:actuate=\"onLoad\"");
            this.tempBodyWriter.write("/>\n");
            this.tempBodyWriter.write("</draw:frame>");
            if (startedHyperlink) {
                this.endHyperlink(false);
            }
            this.tempBodyWriter.write("</text:p>");
        }
        tableBuilder.buildCellFooter();
    }

    @Override
    protected void exportAnchor(String anchorName) throws IOException {
        this.tempBodyWriter.write("<text:bookmark text:name=\"");
        this.tempBodyWriter.write(anchorName);
        this.tempBodyWriter.write("\"/>\n");
    }

    @Override
    protected void exportGenericElement(TableBuilder tableBuilder, JRGenericPrintElement element, JRExporterGridCell gridCell) throws IOException, JRException {
        GenericElementOdtHandler handler = (GenericElementOdtHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), this.getExporterKey());
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(tableBuilder);
            handler.exportElement(exporterContext, element, gridCell);
        } else if (log.isDebugEnabled()) {
            log.debug("No ODT generic element handler for " + element.getGenericType());
        }
    }

    @Override
    protected String getExporterKey() {
        return ODT_EXPORTER_KEY;
    }

    @Override
    protected JRPrintImage getPrintImageForGenericElement(JRGenericPrintElement genericPrintElement) throws JRException {
        return ((GenericElementOdtHandler)GenericElementHandlerEnviroment.getInstance(this.jasperReportsContext).getElementHandler(genericPrintElement.getGenericType(), ODT_EXPORTER_KEY)).getImage(new ExporterContext(null), genericPrintElement);
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JROdtExporterContext {
        TableBuilder tableBuilder;

        public ExporterContext(TableBuilder tableBuidler) {
            super(JROdtExporter.this);
            this.tableBuilder = null;
            this.tableBuilder = tableBuidler;
        }

        @Override
        public TableBuilder getTableBuilder() {
            return this.tableBuilder;
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JROdtExporter.ODT_EXPORTER_PROPERTIES_PREFIX;
        }
    }
}

