/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class JRXPathQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXPathQueryExecuter.class);
    protected static final String CANONICAL_LANGUAGE = "XPath";
    private JRXmlDataSource datasource;

    public JRXPathQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    public JRXPathQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRXmlDataSource datasource = null;
        String xPath = this.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug("XPath query: " + xPath);
        }
        if (xPath != null) {
            Document document = (Document)this.getParameterValue("XML_DATA_DOCUMENT");
            if (document != null) {
                datasource = new JRXmlDataSource(this.getJasperReportsContext(), document, xPath);
            } else {
                InputStream xmlInputStream = (InputStream)this.getParameterValue("XML_INPUT_STREAM");
                if (xmlInputStream != null) {
                    datasource = new JRXmlDataSource(this.getJasperReportsContext(), xmlInputStream, xPath);
                } else {
                    File xmlFile = (File)this.getParameterValue("XML_FILE");
                    if (xmlFile != null) {
                        datasource = new JRXmlDataSource(this.getJasperReportsContext(), xmlFile, xPath);
                    } else {
                        String xmlSource = this.getStringParameterOrProperty("net.sf.jasperreports.xml.source");
                        if (xmlSource != null) {
                            datasource = new JRXmlDataSource(this.getJasperReportsContext(), xmlSource, xPath);
                        } else if (log.isWarnEnabled()) {
                            log.warn("No XML source was provided.");
                        }
                    }
                }
            }
            if (datasource != null) {
                datasource.setLocale((Locale)this.getParameterValue("XML_LOCALE", true));
                datasource.setDatePattern(this.getStringParameter("XML_DATE_PATTERN", "net.sf.jasperreports.xml.date.pattern"));
                datasource.setNumberPattern(this.getStringParameter("XML_NUMBER_PATTERN", "net.sf.jasperreports.xml.number.pattern"));
                datasource.setTimeZone((TimeZone)this.getParameterValue("XML_TIME_ZONE", true));
            }
        }
        return datasource;
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }
}

