/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import jxl.Workbook;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXlsQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXlsQueryExecuter.class);
    private JRXlsDataSource datasource;

    protected JRXlsQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
    }

    protected JRXlsQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        try {
            Workbook workbook = (Workbook)this.getParameterValue("XLS_WORKBOOK");
            if (workbook != null) {
                this.datasource = new JRXlsDataSource(workbook);
            } else {
                InputStream xlsInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM");
                if (xlsInputStream != null) {
                    this.datasource = new JRXlsDataSource(xlsInputStream);
                } else {
                    File xlsFile = (File)this.getParameterValue("XLS_FILE");
                    if (xlsFile != null) {
                        this.datasource = new JRXlsDataSource(xlsFile);
                    } else {
                        String xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                        if (xlsSource != null) {
                            this.datasource = new JRXlsDataSource(this.getJasperReportsContext(), xlsSource);
                        } else if (log.isWarnEnabled()) {
                            log.warn("No XLS source was provided.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.datasource != null) {
            List<Object> columnNamesList = null;
            String columnNames = this.getStringParameterOrProperty("net.sf.jasperreports.xls.column.names");
            if (columnNames != null) {
                columnNamesList = new ArrayList<String>();
                columnNamesList.add(columnNames);
            } else {
                String[] columnNamesArray = (String[])this.getParameterValue("XLS_COLUMN_NAMES_ARRAY", true);
                if (columnNamesArray != null) {
                    columnNamesList = Arrays.asList(columnNamesArray);
                } else {
                    String propertiesPrefix = "net.sf.jasperreports.xls.column.names";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnNamesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            JRPropertiesUtil.PropertySuffix property = properties.get(i);
                            columnNamesList.add(property.getValue());
                        }
                    } else {
                        JRField[] fields = this.dataset.getFields();
                        if (fields != null && fields.length > 0) {
                            columnNamesList = new ArrayList();
                            for (int i = 0; i < fields.length; ++i) {
                                columnNamesList.add(fields[i].getName());
                            }
                        }
                    }
                }
            }
            ArrayList<String> splitColumnNamesList = null;
            if (columnNamesList != null && columnNamesList.size() > 0) {
                splitColumnNamesList = new ArrayList<String>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    String names = (String)columnNamesList.get(i);
                    String[] arr$ = names.split(",");
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String token = arr$[i$];
                        splitColumnNamesList.add(token.trim());
                    }
                }
            }
            List<Object> columnIndexesList = null;
            String columnIndexes = this.getStringParameterOrProperty("net.sf.jasperreports.xls.column.indexes");
            if (columnIndexes != null) {
                columnIndexesList = new ArrayList();
                for (String colIndex : columnIndexes.split(",")) {
                    columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                }
            } else {
                Integer[] columnIndexesArray = (Integer[])this.getParameterValue("XLS_COLUMN_INDEXES_ARRAY", true);
                if (columnIndexesArray != null) {
                    columnIndexesList = Arrays.asList(columnIndexesArray);
                } else {
                    String propertiesPrefix = "net.sf.jasperreports.xls.column.indexes";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnIndexesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            String propertyValue = properties.get(i).getValue();
                            for (String colIndex : propertyValue.split(",")) {
                                columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                            }
                        }
                    }
                }
            }
            if (splitColumnNamesList != null) {
                if (columnIndexesList != null) {
                    int[] indexesArray = new int[columnIndexesList.size()];
                    for (int i = 0; i < columnIndexesList.size(); ++i) {
                        indexesArray[i] = (Integer)columnIndexesList.get(i);
                    }
                    this.datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]), indexesArray);
                } else {
                    this.datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]));
                }
            } else if (columnIndexesList != null) {
                this.datasource.setColumnIndexes(columnIndexesList.toArray(new Integer[columnIndexesList.size()]));
            } else if (log.isWarnEnabled()) {
                log.warn("No column names or column indexes were specified.");
            }
            DateFormat dateFormat = (DateFormat)this.getParameterValue("XLS_DATE_FORMAT", true);
            if (dateFormat != null) {
                this.datasource.setDateFormat(dateFormat);
            } else {
                String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xls.date.pattern");
                if (dateFormatPattern != null) {
                    this.datasource.setDatePattern(dateFormatPattern);
                }
            }
            NumberFormat numberFormat = (NumberFormat)this.getParameterValue("XLS_NUMBER_FORMAT", true);
            if (numberFormat != null) {
                this.datasource.setNumberFormat(numberFormat);
            } else {
                String numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xls.number.pattern");
                if (numberFormatPattern != null) {
                    this.datasource.setNumberPattern(numberFormatPattern);
                }
            }
            this.datasource.setUseFirstRowAsHeader(this.getBooleanParameterOrProperty("XLS_USE_FIRST_ROW_AS_HEADER", false));
            Locale csvLocale = (Locale)this.getParameterValue("REPORT_LOCALE", true);
            if (csvLocale != null) {
                this.datasource.setLocale(csvLocale);
            } else {
                String csvLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.xls.locale.code");
                if (csvLocaleCode != null) {
                    this.datasource.setLocale(csvLocaleCode);
                }
            }
            TimeZone csvTimezone = (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true);
            if (csvTimezone != null) {
                this.datasource.setTimeZone(csvTimezone);
            } else {
                String csvTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.xls.timezone.id");
                if (csvTimezoneId != null) {
                    this.datasource.setTimeZone(csvTimezoneId);
                }
            }
        }
        return this.datasource;
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }
}

