/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.charts.type.PlotOrientationEnum;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.xml.sax.Attributes;

public class JRChartPlotFactory
extends JRBaseFactory {
    @Override
    public Object createObject(Attributes atts) {
        String labelRotation;
        String backgroundAlpha;
        String foregroundAlpha;
        PlotOrientationEnum orientation;
        JRChartPlot plot = (JRChartPlot)this.digester.peek();
        Color color = JRColorUtil.getColor(atts.getValue("backcolor"), Color.black);
        if (color != null) {
            plot.setBackcolor(color);
        }
        if ((orientation = PlotOrientationEnum.getByName(atts.getValue("orientation"))) != null) {
            plot.setOrientation(orientation);
        }
        if ((foregroundAlpha = atts.getValue("foregroundAlpha")) != null && foregroundAlpha.length() > 0) {
            plot.setForegroundAlpha(Float.valueOf(foregroundAlpha));
        }
        if ((backgroundAlpha = atts.getValue("backgroundAlpha")) != null && backgroundAlpha.length() > 0) {
            plot.setBackgroundAlpha(Float.valueOf(backgroundAlpha));
        }
        if ((labelRotation = atts.getValue("labelRotation")) != null && labelRotation.length() > 0) {
            plot.setLabelRotation(Double.valueOf(labelRotation));
        }
        return plot;
    }

    public static class JRSeriesColorFactory
    extends JRBaseFactory {
        @Override
        public Object createObject(Attributes atts) {
            String colorName;
            int seriesIndex = -1;
            Color color = null;
            String seriesNumber = atts.getValue("seriesOrder");
            if (seriesNumber != null && seriesNumber.length() > 0) {
                seriesIndex = Integer.valueOf(seriesNumber);
            }
            if ((colorName = atts.getValue("color")) != null && colorName.length() > 0) {
                color = JRColorUtil.getColor(colorName, null);
            }
            return new JRBaseChartPlot.JRBaseSeriesColor(seriesIndex, color);
        }
    }
}

