/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JRXmlDigester
extends Digester {
    private Map<String, String> internalEntityResources;
    private String lastNamespacePrefix;
    private Object lastPopped;

    public JRXmlDigester() {
        this.initInternalResources();
    }

    public JRXmlDigester(XMLReader xmlReader) {
        super(xmlReader);
        this.initInternalResources();
    }

    public JRXmlDigester(SAXParser parser) {
        super(parser);
        this.initInternalResources();
    }

    private void initInternalResources() {
        this.internalEntityResources = new HashMap<String, String>();
        this.internalEntityResources.put("http://jasperreports.sourceforge.net/dtds/jasperreport.dtd", "net/sf/jasperreports/engine/dtds/jasperreport.dtd");
        this.internalEntityResources.put("http://jasperreports.sourceforge.net/dtds/jasperprint.dtd", "net/sf/jasperreports/engine/dtds/jasperprint.dtd");
        this.internalEntityResources.put("http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd", "net/sf/jasperreports/engine/dtds/jaspertemplate.dtd");
        this.internalEntityResources.put("http://jasperreports.sourceforge.net/xsd/jasperreport.xsd", "net/sf/jasperreports/engine/dtds/jasperreport.xsd");
        this.internalEntityResources.put("http://jasperreports.sourceforge.net/xsd/jasperprint.xsd", "net/sf/jasperreports/engine/dtds/jasperprint.xsd");
    }

    public void addInternalEntityResource(String systemId, String resource) {
        this.internalEntityResources.put(systemId, resource);
    }

    @Override
    public InputSource resolveEntity(String pubId, String systemId) {
        InputSource inputSource = null;
        if (systemId != null) {
            InputStream is;
            String resource = this.internalEntityResources.get(systemId);
            if (resource == null) {
                return new InputSource(systemId);
            }
            ClassLoader clsLoader = Thread.currentThread().getContextClassLoader();
            URL url = null;
            if (clsLoader != null) {
                url = clsLoader.getResource(resource);
            }
            if (url == null) {
                clsLoader = JRXmlDigester.class.getClassLoader();
            }
            if ((is = clsLoader == null ? JRXmlDigester.class.getResourceAsStream("/" + resource) : clsLoader.getResourceAsStream(resource)) != null) {
                inputSource = new InputSource(is);
            }
        }
        return inputSource;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.lastNamespacePrefix = this.getNamespacePrefix(qName);
        super.endElement(namespaceURI, localName, qName);
    }

    protected String getNamespacePrefix(String qName) {
        int sepIdx;
        String prefix = qName == null ? null : ((sepIdx = qName.indexOf(58)) > 0 ? qName.substring(0, sepIdx) : null);
        return prefix;
    }

    public String getLastNamespacePrefix() {
        return this.lastNamespacePrefix;
    }

    @Override
    public Object pop() {
        this.lastPopped = super.pop();
        return this.lastPopped;
    }

    public void clearLastPopped() {
        this.lastPopped = null;
    }

    public Object lastPopped() {
        return this.lastPopped;
    }
}

