/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public class ImageServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;
    public static final String IMAGE_NAME_REQUEST_PARAMETER = "image";

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] imageData = null;
        String imageMimeType = null;
        String imageName = request.getParameter(IMAGE_NAME_REQUEST_PARAMETER);
        if ("px".equals(imageName)) {
            try {
                Renderable pxRenderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
                imageData = pxRenderer.getImageData(this.getJasperReportsContext());
                imageMimeType = ImageTypeEnum.GIF.getMimeType();
            }
            catch (JRException e) {
                throw new ServletException(e);
            }
        }
        List<JasperPrint> jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, imageName);
        Renderable renderer = image.getRenderable();
        if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
            renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
        }
        imageMimeType = renderer.getImageTypeValue().getMimeType();
        try {
            imageData = renderer.getImageData(this.getJasperReportsContext());
        }
        catch (JRException e) {
            throw new ServletException(e);
        }
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(imageData, 0, imageData.length);
            ouputStream.flush();
            ouputStream.close();
        }
    }
}

