/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperViewer
extends JFrame {
    private static final Log log = LogFactory.getLog(JasperViewer.class);
    private static final long serialVersionUID = 10200L;
    protected JRViewer viewer;
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewer(String sourceFile, boolean isXMLFile) throws JRException {
        this(sourceFile, isXMLFile, true);
    }

    public JasperViewer(InputStream is, boolean isXMLFile) throws JRException {
        this(is, isXMLFile, true);
    }

    public JasperViewer(JasperPrint jasperPrint) {
        this(jasperPrint, true);
    }

    public JasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public JasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(is, isXMLFile, isExitOnClose, null);
    }

    public JasperViewer(JasperPrint jasperPrint, boolean isExitOnClose) {
        this(jasperPrint, isExitOnClose, null);
    }

    public JasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), sourceFile, isXMLFile, isExitOnClose, locale, null);
    }

    public JasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), is, isXMLFile, isExitOnClose, locale, null);
    }

    public JasperViewer(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        this(DefaultJasperReportsContext.getInstance(), jasperPrint, isExitOnClose, locale, null);
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(jasperReportsContext, sourceFile, isXMLFile, locale, resBundle);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(jasperReportsContext, is, isXMLFile, locale, resBundle);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(jasperReportsContext, jasperPrint, locale, resBundle);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(jasperReportsContext, sourceFile, isXMLFile, isExitOnClose, null, null);
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(jasperReportsContext, is, isXMLFile, isExitOnClose, null, null);
    }

    public JasperViewer(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, boolean isExitOnClose) {
        this(jasperReportsContext, jasperPrint, isExitOnClose, null, null);
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                JasperViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float zoomRatio) {
        this.viewer.setZoomRatio(zoomRatio);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-XML")) {
                isXMLFile = true;
                continue;
            }
            fileName = args[i].startsWith("-F") ? args[i].substring(2) : args[i];
        }
        if (fileName == null) {
            JasperViewer.usage();
            return;
        }
        if (!isXMLFile && fileName.endsWith(".jrpxml")) {
            isXMLFile = true;
        }
        try {
            JasperViewer.viewReport(fileName, isXMLFile);
        }
        catch (JRException e) {
            if (log.isErrorEnabled()) {
                log.error("Error viewing report.", e);
            }
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer [-XML] file");
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        JasperViewer.viewReport(sourceFile, isXMLFile, true, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        JasperViewer.viewReport(is, isXMLFile, true, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperViewer.viewReport(jasperPrint, true, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer.viewReport(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer.viewReport(is, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) {
        JasperViewer.viewReport(jasperPrint, isExitOnClose, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperViewer.viewReport((JasperReportsContext)DefaultJasperReportsContext.getInstance(), sourceFile, isXMLFile, isExitOnClose, locale, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperViewer.viewReport((JasperReportsContext)DefaultJasperReportsContext.getInstance(), is, isXMLFile, isExitOnClose, locale, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        JasperViewer.viewReport(DefaultJasperReportsContext.getInstance(), jasperPrint, isExitOnClose, locale, null);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperReportsContext, sourceFile, isXMLFile, isExitOnClose, locale, resBundle);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperReportsContext, is, isXMLFile, isExitOnClose, locale, resBundle);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, boolean isExitOnClose, Locale locale, ResourceBundle resBundle) {
        JasperViewer jasperViewer = new JasperViewer(jasperReportsContext, jasperPrint, isExitOnClose, locale, resBundle);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer.viewReport(jasperReportsContext, sourceFile, isXMLFile, isExitOnClose, null, null);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer.viewReport(jasperReportsContext, is, isXMLFile, isExitOnClose, null, null);
    }

    public static void viewReport(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, boolean isExitOnClose) {
        JasperViewer.viewReport(jasperReportsContext, jasperPrint, isExitOnClose, null, null);
    }
}

