/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;

public class ImageServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    public static final String REQUEST_PARAMETER_IMAGE_NAME = "image";

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] imageData = null;
        String imageMimeType = null;
        String imageName = request.getParameter(REQUEST_PARAMETER_IMAGE_NAME);
        if ("px".equals(imageName)) {
            try {
                Renderable pxRenderer = RenderableUtil.getInstance(this.getJasperReportsContext()).getRenderable("net/sf/jasperreports/engine/images/pixel.GIF");
                imageData = pxRenderer.getImageData(this.getJasperReportsContext());
                imageMimeType = ImageTypeEnum.GIF.getMimeType();
            }
            catch (JRException e) {
                throw new ServletException(e);
            }
        }
        WebReportContext webReportContext = WebReportContext.getInstance(request, false);
        if (webReportContext == null) {
            throw new ServletException("No web report context found.");
        }
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        if (jasperPrintAccessor == null) {
            throw new ServletException("No JasperPrint found in report context.");
        }
        List<JasperPrint> jasperPrintList = Collections.singletonList(jasperPrintAccessor.getJasperPrint());
        JRPrintImage image = JRHtmlExporter.getImage(jasperPrintList, imageName);
        Renderable renderer = image.getRenderable();
        if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
            renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
        }
        imageMimeType = renderer.getImageTypeValue().getMimeType();
        try {
            imageData = renderer.getImageData(this.getJasperReportsContext());
        }
        catch (JRException e) {
            throw new ServletException(e);
        }
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream ouputStream = response.getOutputStream();
            ouputStream.write(imageData, 0, imageData.length);
            ouputStream.flush();
            ouputStream.close();
        }
    }
}

