/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        Object object;
        AlgorithmIdentifier algorithmIdentifier;
        Object object2;
        SecretKey secretKey;
        Object object3;
        String string3 = keyGenerator.getProvider().getName();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            object3 = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string, string3);
            secretKey = keyGenerator.generateKey();
            object2 = this.generateParameters(string, secretKey, string3);
            ((Cipher)object3).init(1, (Key)secretKey, (AlgorithmParameters)object2);
            if (object2 == null) {
                object2 = ((Cipher)object3).getParameters();
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameters)object2);
            object = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)object, (Cipher)object3);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        object3 = this.recipientInfs.iterator();
        while (object3.hasNext()) {
            object2 = (CMSEnvelopedGenerator.RecipientInf)object3.next();
            try {
                aSN1EncodableVector.add(((CMSEnvelopedGenerator.RecipientInf)object2).toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object2 = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, bERConstructedOctetString);
        object = new ContentInfo(PKCSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), (EncryptedContentInfo)object2, null));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, string2);
        keyGenerator.init(n);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }
}

