/*
 * Decompiled with CFR 0.152.
 */
package org.castor.xml;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.xml.JavaNaming;

public class JavaNamingImpl
implements JavaNaming {
    private static final Log LOG = LogFactory.getLog(class$org$castor$xml$JavaNamingImpl == null ? (class$org$castor$xml$JavaNamingImpl = JavaNamingImpl.class$("org.castor.xml.JavaNamingImpl")) : class$org$castor$xml$JavaNamingImpl);
    public static final String UPPER_CASE_AFTER_UNDERSCORE_PROPERTY = "org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore";
    public static boolean _upperCaseAfterUnderscore = false;
    private static final Hashtable SUBST = JavaNamingImpl.keywordMap();
    private static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    static /* synthetic */ Class class$org$castor$xml$JavaNamingImpl;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;

    public final boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < KEYWORDS.length; ++i) {
            if (!KEYWORDS[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public final boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '_' || ch == '$' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            if (ch >= '0' && ch <= '9') {
                if (i != 0) continue;
                return false;
            }
            return false;
        }
        return !this.isKeyword(string);
    }

    public final String toJavaClassName(String name) {
        if (name == null || name.length() <= 0) {
            return name;
        }
        int colon = name.indexOf(58);
        if (colon != -1) {
            return this.toJavaName(name.substring(colon + 1), true);
        }
        return this.toJavaName(name, true);
    }

    public final String toJavaMemberName(String name) {
        return this.toJavaMemberName(name, true);
    }

    public final String toJavaMemberName(String name, boolean useKeywordSubstitutions) {
        if (name == null) {
            return null;
        }
        String memberName = this.toJavaName(name, false);
        if (this.isKeyword(memberName) && useKeywordSubstitutions) {
            String mappedName = (String)SUBST.get(memberName);
            memberName = mappedName != null ? mappedName : '_' + memberName;
        }
        return memberName;
    }

    public final boolean isValidPackageName(String packageName) {
        if (packageName == null || packageName.length() < 1) {
            return true;
        }
        if (".".equals(packageName)) {
            return false;
        }
        if (packageName.startsWith(".") || packageName.endsWith(".")) {
            return false;
        }
        boolean valid = true;
        String[] packageNameParts = packageName.split("\\.");
        for (int i = 0; i < packageNameParts.length; ++i) {
            String packageNamePart = packageNameParts[i];
            valid &= this.isValidJavaIdentifier(packageNamePart);
        }
        return valid;
    }

    public final String packageToPath(String packageName) {
        if (packageName == null) {
            return packageName;
        }
        if (!this.isValidPackageName(packageName)) {
            String message = "Package name: " + packageName + " is not valid";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        return packageName.replace('.', File.separatorChar);
    }

    private static Hashtable keywordMap() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("class", "clazz");
        return ht;
    }

    private String toJavaName(String name, boolean upperFirst) {
        boolean lowercase;
        int size = name.length();
        char[] ncChars = name.toCharArray();
        int next = 0;
        boolean uppercase = upperFirst;
        boolean bl = lowercase = !uppercase;
        if (size > 1 && lowercase && Character.isUpperCase(ncChars[0]) && Character.isUpperCase(ncChars[1])) {
            lowercase = false;
        }
        block5: for (int i = 0; i < size; ++i) {
            char ch = ncChars[i];
            switch (ch) {
                case ' ': 
                case '.': {
                    ncChars[next++] = 95;
                    continue block5;
                }
                case '-': 
                case ':': {
                    uppercase = true;
                    continue block5;
                }
                case '_': {
                    if (_upperCaseAfterUnderscore) {
                        uppercase = true;
                        ncChars[next] = ch;
                        ++next;
                        continue block5;
                    }
                }
                default: {
                    if (uppercase) {
                        ncChars[next] = Character.toUpperCase(ch);
                        uppercase = false;
                    } else if (lowercase) {
                        ncChars[next] = Character.toLowerCase(ch);
                        lowercase = false;
                    } else {
                        ncChars[next] = ch;
                    }
                    ++next;
                }
            }
        }
        return new String(ncChars, 0, next);
    }

    public final String getQualifiedFileName(String fileName, String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return fileName;
        }
        StringBuffer result = new StringBuffer();
        result.append(this.packageToPath(packageName));
        result.append('/');
        result.append(fileName);
        return result.toString();
    }

    public final String getPackageName(String className) {
        if (className == null || className.length() < 1) {
            return className;
        }
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            return className.substring(0, idx);
        }
        return "";
    }

    public final String extractFieldNameFromMethod(Method method) {
        if (method == null) {
            return null;
        }
        String fieldName = null;
        if (this.isSetMethod(method)) {
            fieldName = method.getName().substring("set".length());
        } else if (this.isCreateMethod(method)) {
            fieldName = method.getName().substring("create".length());
        } else if (this.isGetMethod(method)) {
            fieldName = method.getName().substring("get".length());
        } else if (this.isIsMethod(method)) {
            fieldName = method.getName().substring("is".length());
        } else if (this.isAddMethod(method)) {
            fieldName = method.getName().substring("add".length());
        }
        return this.toJavaMemberName(fieldName);
    }

    public final String extractFieldNameFromField(Field field) {
        String fieldName = field.getName();
        if (fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        return fieldName;
    }

    public final boolean isSetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == (class$java$lang$Void == null ? (class$java$lang$Void = JavaNamingImpl.class$("java.lang.Void")) : class$java$lang$Void);
    }

    public final boolean isCreateMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("create")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    public final boolean isGetMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("get")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return method.getReturnType() != null;
    }

    public final boolean isIsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("is")) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getReturnType().isPrimitive() && method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        return method.getReturnType().isPrimitive() || method.getReturnType() == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = JavaNamingImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public final boolean isAddMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (!method.getName().startsWith("add")) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getReturnType() == Void.TYPE || method.getReturnType() == (class$java$lang$Void == null ? (class$java$lang$Void = JavaNamingImpl.class$("java.lang.Void")) : class$java$lang$Void);
    }

    public final String getAddMethodNameForField(String fieldName) {
        return "add" + this.toJavaClassName(fieldName);
    }

    public final String getCreateMethodNameForField(String fieldName) {
        return "create" + this.toJavaClassName(fieldName);
    }

    public final String getGetMethodNameForField(String fieldName) {
        return "get" + this.toJavaClassName(fieldName);
    }

    public final String getIsMethodNameForField(String fieldName) {
        return "is" + this.toJavaClassName(fieldName);
    }

    public final String getSetMethodNameForField(String fieldName) {
        return "set" + this.toJavaClassName(fieldName);
    }

    public String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

