/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.util.ResolverStrategy;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class XMLClassDescriptorResolverImpl
implements XMLClassDescriptorResolver {
    private static final Log LOG = LogFactory.getLog(class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl == null ? (class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl = XMLClassDescriptorResolverImpl.class$("org.exolab.castor.xml.util.XMLClassDescriptorResolverImpl")) : class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl);
    private InternalContext _internalContext;
    private DescriptorCacheImpl _descriptorCache = new DescriptorCacheImpl();
    static /* synthetic */ Class class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl;
    static /* synthetic */ Class class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl$DescriptorCacheImpl;

    public void setInternalContext(InternalContext internalContext) {
        this._internalContext = internalContext;
    }

    public MappingLoader getMappingLoader() {
        return this._internalContext.getMappingLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this._internalContext.setClassLoader(loader);
    }

    public void setUseIntrospection(boolean enable) {
        this._internalContext.setUseIntrospector(enable);
    }

    public void setLoadPackageMappings(boolean loadPackageMappings) {
        this._internalContext.setLoadPackageMapping(loadPackageMappings);
    }

    public void setMappingLoader(MappingLoader mappingLoader) {
        this._internalContext.setMappingLoader(mappingLoader);
        if (mappingLoader != null) {
            Iterator descriptors = mappingLoader.descriptorIterator();
            while (descriptors.hasNext()) {
                XMLClassDescriptor descriptor = (XMLClassDescriptor)descriptors.next();
                this._descriptorCache.addDescriptor(descriptor.getJavaClass().getName(), descriptor);
            }
        }
    }

    public void setIntrospector(Introspector introspector) {
        this._internalContext.setIntrospector(introspector);
    }

    public void setResolverStrategy(ResolverStrategy resolverStrategy) {
        this._internalContext.setResolverStrategy(resolverStrategy);
    }

    private ResolverStrategy getResolverStrategy() {
        this.setAttributesIntoStrategy();
        return this._internalContext.getResolverStrategy();
    }

    public ClassDescriptor resolve(Class type) throws ResolverException {
        if (type == null) {
            String message = "Type argument must not be null for resolve";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.getDescriptor(type.getName()) != null) {
            return this._descriptorCache.getDescriptor(type.getName());
        }
        ClassLoader l = this._internalContext.getClassLoader();
        if (l == null) {
            l = type.getClassLoader();
        }
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        return this.resolve(type.getName(), l);
    }

    public XMLClassDescriptor resolve(String className) throws ResolverException {
        if (className == null || className.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.getDescriptor(className) != null) {
            return this._descriptorCache.getDescriptor(className);
        }
        ClassLoader l = this._internalContext.getClassLoader();
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        return this.resolve(className, l);
    }

    public XMLClassDescriptor resolve(String className, ClassLoader loader) throws ResolverException {
        if (className == null || className.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (this._descriptorCache.getDescriptor(className) != null) {
            return this._descriptorCache.getDescriptor(className);
        }
        ClassLoader l = loader;
        if (l == null) {
            l = this._internalContext.getClassLoader();
        }
        if (l == null) {
            l = Thread.currentThread().getContextClassLoader();
        }
        this.getResolverStrategy().setProperty("org.exolab.castor.xml.util.ResolverStrategy.ClassLoader", l);
        return (XMLClassDescriptor)this.getResolverStrategy().resolveClass(this._descriptorCache, className);
    }

    public XMLClassDescriptor resolveByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String message = "Cannot resolve a null or zero-length class name.";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        List possibleMatches = this._descriptorCache.getDescriptorList(xmlName);
        if (possibleMatches.size() == 0) {
            return null;
        }
        if (possibleMatches.size() == 1) {
            return (XMLClassDescriptor)possibleMatches.get(0);
        }
        Iterator i = possibleMatches.iterator();
        while (i.hasNext()) {
            XMLClassDescriptor descriptor = (XMLClassDescriptor)i.next();
            if (!ResolveHelpers.namespaceEquals(namespaceURI, descriptor.getNameSpaceURI())) continue;
            return descriptor;
        }
        return null;
    }

    public Iterator resolveAllByXMLName(String xmlName, String namespaceURI, ClassLoader loader) {
        if (xmlName == null || xmlName.length() == 0) {
            String message = "Cannot resolve a null or zero-length xml name.";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        return this._descriptorCache.getDescriptors(xmlName);
    }

    public void addClass(String className) throws ResolverException {
        this.resolve(className);
    }

    public void addClasses(String[] classNames) throws ResolverException {
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            this.addClass(className);
        }
    }

    public void addClass(Class clazz) throws ResolverException {
        this.resolve(clazz);
    }

    public void addClasses(Class[] clazzes) throws ResolverException {
        for (int i = 0; i < clazzes.length; ++i) {
            Class clazz = clazzes[i];
            this.addClass(clazz);
        }
    }

    public void addPackage(String packageName) throws ResolverException {
        if (packageName == null || packageName.length() == 0) {
            String message = "Cannot resolve a null or zero-length package name.";
            LOG.warn(message);
            throw new IllegalArgumentException(message);
        }
        this.getResolverStrategy().resolvePackage(this._descriptorCache, packageName);
    }

    public void addPackages(String[] packageNames) throws ResolverException {
        for (int i = 0; i < packageNames.length; ++i) {
            String packageName = packageNames[i];
            this.addPackage(packageName);
        }
    }

    public void loadClassDescriptors(String packageName) throws ResolverException {
        String message = "Already deprecated in the interface!";
        LOG.warn(message);
        throw new UnsupportedOperationException();
    }

    private void setAttributesIntoStrategy() {
        ResolverStrategy strategy = this._internalContext.getResolverStrategy();
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.LoadPackageMappings", this._internalContext.getLoadPackageMapping());
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.useIntrospection", this._internalContext.getUseIntrospector());
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.MappingLoader", this._internalContext.getMappingLoader());
        strategy.setProperty("org.exolab.castor.xml.util.ResolverStrategy.Introspector", this._internalContext.getIntrospector());
    }

    public void cleanDescriptorCache() {
        this._descriptorCache = new DescriptorCacheImpl();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DescriptorCacheImpl
    implements ResolverStrategy.ResolverResults {
        private static final Log LOG2 = LogFactory.getLog(class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl$DescriptorCacheImpl == null ? (class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl$DescriptorCacheImpl = XMLClassDescriptorResolverImpl.class$("org.exolab.castor.xml.util.XMLClassDescriptorResolverImpl$DescriptorCacheImpl")) : class$org$exolab$castor$xml$util$XMLClassDescriptorResolverImpl$DescriptorCacheImpl);
        private static final String INTERNAL_CONTAINER_NAME = "-error-if-this-is-used-";
        private List _missingTypes;
        private Map _typeMap;
        private Map _xmlNameMap;

        public DescriptorCacheImpl() {
            LOG2.debug("New instance!");
            this._typeMap = new HashMap();
            this._xmlNameMap = new HashMap();
            this._missingTypes = new ArrayList();
        }

        public void addDescriptor(String className, XMLClassDescriptor descriptor) {
            if (className == null || className.length() == 0) {
                String message = "Class name to insert ClassDescriptor must not be null";
                LOG2.warn(message);
                throw new IllegalArgumentException(message);
            }
            if (descriptor == null) {
                if (LOG2.isDebugEnabled()) {
                    LOG2.debug("Adding class name to missing classes: " + className);
                }
                this._missingTypes.add(className);
                return;
            }
            if (LOG2.isDebugEnabled()) {
                LOG2.debug("Adding descriptor class for: " + className + " descriptor: " + descriptor);
            }
            this._typeMap.put(className, descriptor);
            String xmlName = descriptor.getXMLName();
            if (xmlName == null || xmlName.length() == 0) {
                return;
            }
            if (INTERNAL_CONTAINER_NAME.equals(xmlName)) {
                return;
            }
            List descriptorList = this.getDescriptorList(descriptor.getXMLName());
            if (!descriptorList.contains(descriptor)) {
                descriptorList.add(descriptor);
            }
            this._missingTypes.remove(className);
        }

        public XMLClassDescriptor getDescriptor(String className) {
            if (className == null || "".equals(className) || this._missingTypes.contains(className)) {
                return null;
            }
            XMLClassDescriptor ret = (XMLClassDescriptor)this._typeMap.get(className);
            if (LOG2.isDebugEnabled()) {
                LOG2.debug("Get descriptor for: " + className + " found: " + ret);
            }
            return ret;
        }

        public List getDescriptorList(String xmlName) {
            ArrayList list = (ArrayList)this._xmlNameMap.get(xmlName);
            if (list == null) {
                list = new ArrayList();
                this._xmlNameMap.put(xmlName, list);
            }
            return list;
        }

        public Iterator getDescriptors(String xmlName) {
            return this.getDescriptorList(xmlName).iterator();
        }

        public boolean isMissingDescriptor(String className) {
            return this._missingTypes.contains(className);
        }

        public void addAllDescriptors(Map descriptors) {
            if (descriptors == null || descriptors.isEmpty()) {
                LOG2.debug("Called addAllDescriptors with null or empty descriptor map");
                return;
            }
            Iterator iter = descriptors.keySet().iterator();
            while (iter.hasNext()) {
                String clsName = (String)iter.next();
                this.addDescriptor(clsName, (XMLClassDescriptor)descriptors.get(clsName));
            }
        }
    }
}

