/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.spi.QueryPlanCache;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.TransactionEnvironmentImpl;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.jndi.spi.JndiService;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.jboss.logging.Logger;

public final class SessionFactoryImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SessionFactoryImpl.class.getName());
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String name;
    private final String uuid;
    private final transient Map<String, EntityPersister> entityPersisters;
    private final transient Map<String, ClassMetadata> classMetadata;
    private final transient Map<String, CollectionPersister> collectionPersisters;
    private final transient Map<String, CollectionMetadata> collectionMetadata;
    private final transient Map<String, Set<String>> collectionRolesByEntityParticipant;
    private final transient Map<String, IdentifierGenerator> identifierGenerators;
    private final transient Map<String, NamedQueryDefinition> namedQueries;
    private final transient Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    private final transient Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient Map<String, String> imports;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient Dialect dialect;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient ConcurrentHashMap<EntityNameResolver, Object> entityNameResolvers = new ConcurrentHashMap();
    private final transient QueryPlanCache queryPlanCache;
    private final transient CacheImplementor cacheAccess;
    private transient boolean isClosed = false;
    private final transient TypeResolver typeResolver;
    private final transient TypeHelper typeHelper;
    private final transient TransactionEnvironment transactionEnvironment;
    private final transient SessionFactory.SessionFactoryOptions sessionFactoryOptions;
    private final transient CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
    private final transient CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private static final Object ENTITY_NAME_RESOLVER_MAP_VALUE = new Object();

    public SessionFactoryImpl(final Configuration cfg, Mapping mapping, ServiceRegistry serviceRegistry, Settings settings, SessionFactoryObserver observer) throws HibernateException {
        Map<String, HibernateException> map;
        String entityName;
        LOG.debug("Building session factory");
        this.sessionFactoryOptions = new SessionFactory.SessionFactoryOptions(){
            private EntityNotFoundDelegate entityNotFoundDelegate;

            @Override
            public Interceptor getInterceptor() {
                return cfg.getInterceptor();
            }

            @Override
            public EntityNotFoundDelegate getEntityNotFoundDelegate() {
                if (this.entityNotFoundDelegate == null) {
                    this.entityNotFoundDelegate = cfg.getEntityNotFoundDelegate() != null ? cfg.getEntityNotFoundDelegate() : new EntityNotFoundDelegate(){

                        @Override
                        public void handleEntityNotFound(String entityName, Serializable id) {
                            throw new ObjectNotFoundException(id, entityName);
                        }
                    };
                }
                return this.entityNotFoundDelegate;
            }
        };
        this.settings = settings;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)cfg.getProperties());
        this.serviceRegistry = serviceRegistry.getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, cfg);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        RegionFactory regionFactory = this.cacheAccess.getRegionFactory();
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.getDialect(), cfg.getSqlFunctions());
        if (observer != null) {
            this.observer.addObserver(observer);
        }
        this.typeResolver = cfg.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        this.filters.putAll(cfg.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", (Object)this.filters);
        LOG.debugf("Instantiating session factory with properties: %s", (Object)this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(cfg, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        Iterator<PersistentClass> classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = classes.next();
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(cfg.getIdentifierGeneratorFactory(), this.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        String cacheRegionPrefix = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        PersisterFactory persisterFactory = serviceRegistry.getService(PersisterFactory.class);
        this.entityPersisters = new HashMap<String, EntityPersister>();
        HashMap<String, RegionAccessStrategy> entityAccessStrategies = new HashMap<String, RegionAccessStrategy>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            String string;
            AccessType accessType;
            PersistentClass model = classes.next();
            model.prepareTemporaryTables(mapping, this.getDialect());
            String cacheRegionName = cacheRegionPrefix + model.getRootClass().getCacheRegionName();
            EntityRegionAccessStrategy accessStrategy = (EntityRegionAccessStrategy)entityAccessStrategies.get(cacheRegionName);
            if (accessStrategy == null && settings.isSecondLevelCacheEnabled() && (accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy())) != null) {
                LOG.tracef("Building shared cache region for entity data [%s]", (Object)model.getEntityName());
                EntityRegion entityRegion = regionFactory.buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.cacheAccess.addCacheRegion(cacheRegionName, entityRegion);
            }
            NaturalIdRegionAccessStrategy naturalIdAccessStrategy = null;
            if (model.hasNaturalId() && model.getNaturalIdCacheRegionName() != null && (naturalIdAccessStrategy = (NaturalIdRegionAccessStrategy)entityAccessStrategies.get(string = cacheRegionPrefix + model.getNaturalIdCacheRegionName())) == null && settings.isSecondLevelCacheEnabled()) {
                CacheDataDescriptionImpl cacheDataDescriptionImpl = CacheDataDescriptionImpl.decode(model);
                NaturalIdRegion naturalIdRegion = null;
                try {
                    naturalIdRegion = regionFactory.buildNaturalIdRegion(string, this.properties, cacheDataDescriptionImpl);
                }
                catch (UnsupportedOperationException e) {
                    LOG.warnf("Shared cache region factory [%s] does not support natural id caching; shared NaturalId caching will be disabled for not be enabled for %s", (Object)regionFactory.getClass().getName(), (Object)model.getEntityName());
                }
                if (naturalIdRegion != null) {
                    naturalIdAccessStrategy = naturalIdRegion.buildAccessStrategy(regionFactory.getDefaultAccessType());
                    entityAccessStrategies.put(string, naturalIdAccessStrategy);
                    this.cacheAccess.addCacheRegion(string, naturalIdRegion);
                }
            }
            EntityPersister entityPersister = persisterFactory.createEntityPersister(model, accessStrategy, naturalIdAccessStrategy, this, mapping);
            this.entityPersisters.put(model.getEntityName(), entityPersister);
            classMeta.put(model.getEntityName(), entityPersister.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap<String, CollectionPersister>();
        HashMap<String, CollectionMetadata> tmpCollectionMetadata = new HashMap<String, CollectionMetadata>();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            Type elementType;
            Collection model = (Collection)collections.next();
            String string = cacheRegionPrefix + model.getCacheRegionName();
            AccessType accessType = AccessType.fromExternalName(model.getCacheConcurrencyStrategy());
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && settings.isSecondLevelCacheEnabled()) {
                LOG.tracev("Building shared cache region for collection data [{0}]", (Object)model.getRole());
                CollectionRegion collectionRegion = regionFactory.buildCollectionRegion(string, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(string, accessStrategy);
                this.cacheAccess.addCacheRegion(string, collectionRegion);
            }
            CollectionPersister persister = persisterFactory.createCollectionPersister(cfg, model, accessStrategy, (SessionFactoryImplementor)this);
            this.collectionPersisters.put(model.getRole(), persister);
            tmpCollectionMetadata.put(model.getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName2 = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName2);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName2, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(tmpCollectionMetadata);
        for (Map.Entry entry : tmpEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>(cfg.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>(cfg.getSqlResultSetMappings());
        this.imports = new HashMap<String, String>(cfg.getImports());
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, settings.isSessionFactoryNameAlsoJndiName(), this, serviceRegistry.getService(JndiService.class));
        LOG.debug("Instantiated session factory");
        settings.getMultiTableBulkIdStrategy().prepare(this.jdbcServices, this.buildLocalConnectionAccess(), cfg.createMappings(), cfg.buildMapping(), this.properties);
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(serviceRegistry, cfg).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(serviceRegistry, cfg).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(serviceRegistry, cfg).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(serviceRegistry, cfg).setImportSqlCommandExtractor(serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isNamedQueryStartupCheckingEnabled() && !(map = this.checkNamedQueries()).isEmpty()) {
            StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
            String sep = "";
            for (Map.Entry<String, HibernateException> entry : map.entrySet()) {
                LOG.namedQueryError(entry.getKey(), entry.getValue());
                failingQueries.append(sep).append(entry.getKey());
                sep = ", ";
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        Iterator itr = cfg.iterateFetchProfiles();
        while (itr.hasNext()) {
            org.hibernate.mapping.FetchProfile fetchProfile = (org.hibernate.mapping.FetchProfile)itr.next();
            FetchProfile fetchProfile2 = new FetchProfile(fetchProfile.getName());
            for (FetchProfile.Fetch mappingFetch : fetchProfile.getFetches()) {
                EntityPersister owner;
                entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister entityPersister = owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile2.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile2.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile2.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile2.getName());
            }
            this.fetchProfiles.put(fetchProfile2.getName(), fetchProfile2);
        }
        this.customEntityDirtinessStrategy = this.determineCustomEntityDirtinessStrategy();
        this.currentTenantIdentifierResolver = this.determineCurrentTenantIdentifierResolver(cfg.getCurrentTenantIdentifierResolver());
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    private JdbcConnectionAccess buildLocalConnectionAccess() {
        return new JdbcConnectionAccess(){

            @Override
            public Connection obtainConnection() throws SQLException {
                return SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE ? SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).getConnection() : SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).getAnyConnection();
            }

            @Override
            public void releaseConnection(Connection connection) throws SQLException {
                if (SessionFactoryImpl.this.settings.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE) {
                    SessionFactoryImpl.this.serviceRegistry.getService(ConnectionProvider.class).closeConnection(connection);
                } else {
                    SessionFactoryImpl.this.serviceRegistry.getService(MultiTenantConnectionProvider.class).releaseAnyConnection(connection);
                }
            }

            @Override
            public boolean supportsAggressiveRelease() {
                return false;
            }
        };
    }

    private CustomEntityDirtinessStrategy determineCustomEntityDirtinessStrategy() {
        CustomEntityDirtinessStrategy defaultValue = new CustomEntityDirtinessStrategy(){

            @Override
            public boolean canDirtyCheck(Object entity, EntityPersister persister, Session session) {
                return false;
            }

            @Override
            public boolean isDirty(Object entity, EntityPersister persister, Session session) {
                return false;
            }

            @Override
            public void resetDirty(Object entity, EntityPersister persister, Session session) {
            }

            @Override
            public void findDirty(Object entity, EntityPersister persister, Session session, CustomEntityDirtinessStrategy.DirtyCheckContext dirtyCheckContext) {
            }
        };
        return this.serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.entity_dirtiness_strategy", CustomEntityDirtinessStrategy.class, defaultValue);
    }

    private CurrentTenantIdentifierResolver determineCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver explicitResolver) {
        if (explicitResolver != null) {
            return explicitResolver;
        }
        return this.serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.tenant_identifier_resolver", CurrentTenantIdentifierResolver.class, null);
    }

    /*
     * WARNING - void declaration
     */
    public SessionFactoryImpl(MetadataImplementor metadata, SessionFactory.SessionFactoryOptions sessionFactoryOptions, SessionFactoryObserver observer) throws HibernateException {
        Map<String, HibernateException> map;
        AccessType accessType;
        String cacheRegionName;
        boolean debugEnabled;
        boolean traceEnabled = LOG.isTraceEnabled();
        boolean bl = debugEnabled = traceEnabled || LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debug("Building session factory");
        }
        this.sessionFactoryOptions = sessionFactoryOptions;
        this.properties = SessionFactoryImpl.createPropertiesFromMap(metadata.getServiceRegistry().getService(ConfigurationService.class).getSettings());
        this.settings = new SettingsFactory().buildSettings(this.properties, metadata.getServiceRegistry());
        this.serviceRegistry = metadata.getServiceRegistry().getService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry((SessionFactoryImplementor)this, metadata);
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.dialect = this.jdbcServices.getDialect();
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        this.sqlFunctionRegistry = new SQLFunctionRegistry(this.dialect, new HashMap<String, SQLFunction>());
        if (observer != null) {
            this.observer.addObserver(observer);
        }
        this.typeResolver = metadata.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap<String, FilterDefinition>();
        for (FilterDefinition filterDefinition : metadata.getFilterDefinitions()) {
            this.filters.put(filterDefinition.getFilterName(), filterDefinition);
        }
        if (debugEnabled) {
            LOG.debugf("Session factory constructed with filter configurations : %s", (Object)this.filters);
            LOG.debugf("Instantiating session factory with properties: %s", (Object)this.properties);
        }
        this.queryPlanCache = new QueryPlanCache(this);
        class IntegratorObserver
        implements SessionFactoryObserver {
            private ArrayList<Integrator> integrators = new ArrayList();

            IntegratorObserver() {
            }

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                for (Integrator integrator : this.integrators) {
                    integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
                }
            }
        }
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        for (Integrator integrator : this.serviceRegistry.getService(IntegratorService.class).getIntegrators()) {
            integrator.integrate(metadata, (SessionFactoryImplementor)this, this.serviceRegistry);
            integratorObserver.integrators.add(integrator);
        }
        this.identifierGenerators = new HashMap<String, IdentifierGenerator>();
        for (EntityBinding entityBinding : metadata.getEntityBindings()) {
            if (!entityBinding.isRoot()) continue;
            this.identifierGenerators.put(entityBinding.getEntity().getName(), entityBinding.getHierarchyDetails().getEntityIdentifier().getIdentifierGenerator());
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.settings.getCacheRegionPrefix() != null) {
            stringBuilder.append(this.settings.getCacheRegionPrefix()).append('.');
        }
        String cacheRegionPrefix = stringBuilder.toString();
        this.entityPersisters = new HashMap<String, EntityPersister>();
        HashMap<String, RegionAccessStrategy> entityAccessStrategies = new HashMap<String, RegionAccessStrategy>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        for (EntityBinding model : metadata.getEntityBindings()) {
            void var14_14;
            EntityRegionAccessStrategy entityRegionAccessStrategy;
            EntityBinding rootEntityBinding = metadata.getRootEntityBinding(model.getEntity().getName());
            Object var14_15 = null;
            if (this.settings.isSecondLevelCacheEnabled() && rootEntityBinding.getHierarchyDetails().getCaching() != null && model.getHierarchyDetails().getCaching() != null && model.getHierarchyDetails().getCaching().getAccessType() != null && (entityRegionAccessStrategy = (EntityRegionAccessStrategy)EntityRegionAccessStrategy.class.cast(entityAccessStrategies.get(cacheRegionName = cacheRegionPrefix + rootEntityBinding.getHierarchyDetails().getCaching().getRegion()))) == null) {
                accessType = model.getHierarchyDetails().getCaching().getAccessType();
                if (traceEnabled) {
                    LOG.tracev("Building cache for entity data [{0}]", (Object)model.getEntity().getName());
                }
                EntityRegion entityRegion = this.settings.getRegionFactory().buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                EntityRegionAccessStrategy entityRegionAccessStrategy2 = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, entityRegionAccessStrategy2);
                this.cacheAccess.addCacheRegion(cacheRegionName, entityRegion);
            }
            EntityPersister cp = this.serviceRegistry.getService(PersisterFactory.class).createEntityPersister(model, (EntityRegionAccessStrategy)var14_14, this, metadata);
            this.entityPersisters.put(model.getEntity().getName(), cp);
            classMeta.put(model.getEntity().getName(), cp.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap<String, CollectionPersister>();
        HashMap<String, CollectionMetadata> tmpCollectionMetadata = new HashMap<String, CollectionMetadata>();
        for (PluralAttributeBinding pluralAttributeBinding : metadata.getCollectionBindings()) {
            Type elementType;
            if (pluralAttributeBinding.getAttribute() == null) {
                throw new IllegalStateException("No attribute defined for a AbstractPluralAttributeBinding: " + pluralAttributeBinding);
            }
            if (pluralAttributeBinding.getAttribute().isSingular()) {
                throw new IllegalStateException("AbstractPluralAttributeBinding has a Singular attribute defined: " + pluralAttributeBinding.getAttribute().getName());
            }
            cacheRegionName = cacheRegionPrefix + pluralAttributeBinding.getCaching().getRegion();
            accessType = pluralAttributeBinding.getCaching().getAccessType();
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && this.settings.isSecondLevelCacheEnabled()) {
                if (traceEnabled) {
                    LOG.tracev("Building cache for collection data [{0}]", (Object)pluralAttributeBinding.getAttribute().getRole());
                }
                CollectionRegion collectionRegion = this.settings.getRegionFactory().buildCollectionRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(pluralAttributeBinding));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.cacheAccess.addCacheRegion(cacheRegionName, collectionRegion);
            }
            CollectionPersister persister = this.serviceRegistry.getService(PersisterFactory.class).createCollectionPersister(metadata, pluralAttributeBinding, accessStrategy, (SessionFactoryImplementor)this);
            this.collectionPersisters.put(pluralAttributeBinding.getAttribute().getRole(), persister);
            tmpCollectionMetadata.put(pluralAttributeBinding.getAttribute().getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                String entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(tmpCollectionMetadata);
        for (Map.Entry entry : tmpEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        for (NamedQueryDefinition namedQueryDefinition : metadata.getNamedQueryDefinitions()) {
            this.namedQueries.put(namedQueryDefinition.getName(), namedQueryDefinition);
        }
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        for (NamedSQLQueryDefinition namedSQLQueryDefinition : metadata.getNamedNativeQueryDefinitions()) {
            this.namedSqlQueries.put(namedSQLQueryDefinition.getName(), namedSQLQueryDefinition);
        }
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        for (ResultSetMappingDefinition resultSetMappingDefinition : metadata.getResultSetMappingDefinitions()) {
            this.sqlResultSetMappings.put(resultSetMappingDefinition.getName(), resultSetMappingDefinition);
        }
        this.imports = new HashMap<String, String>();
        for (Map.Entry entry : metadata.getImports()) {
            this.imports.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            entityPersister.postInstantiate();
            this.registerEntityNameResolvers(entityPersister);
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            collectionPersister.postInstantiate();
        }
        this.name = this.settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryRegistry.INSTANCE.addSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this, this.serviceRegistry.getService(JndiService.class));
        if (debugEnabled) {
            LOG.debug("Instantiated session factory");
        }
        if (this.settings.isAutoCreateSchema()) {
            new SchemaExport(metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class)).create(false, true);
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(metadata).setImportSqlCommandExtractor(this.serviceRegistry.getService(ImportSqlCommandExtractor.class));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (this.settings.isNamedQueryStartupCheckingEnabled() && !(map = this.checkNamedQueries()).isEmpty()) {
            StringBuilder failingQueries = new StringBuilder("Errors in named queries: ");
            String sep = "";
            for (Map.Entry<String, HibernateException> entry : map.entrySet()) {
                LOG.namedQueryError(entry.getKey(), entry.getValue());
                failingQueries.append(entry.getKey()).append(sep);
                sep = ", ";
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        for (org.hibernate.metamodel.binding.FetchProfile mappingProfile : metadata.getFetchProfiles()) {
            FetchProfile fetchProfile = new FetchProfile(mappingProfile.getName());
            for (FetchProfile.Fetch mappingFetch : mappingProfile.getFetches()) {
                EntityPersister owner;
                String entityName = this.getImportedClassName(mappingFetch.getEntity());
                EntityPersister entityPersister = owner = entityName == null ? null : this.entityPersisters.get(entityName);
                if (owner == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + mappingFetch.getEntity() + "] in fetch profile [" + fetchProfile.getName() + "]");
                }
                Type associationType = owner.getPropertyType(mappingFetch.getAssociation());
                if (associationType == null || !associationType.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + fetchProfile.getName() + "] specified an invalid association");
                }
                Fetch.Style fetchStyle = Fetch.Style.parse(mappingFetch.getStyle());
                fetchProfile.addFetch(new Association(owner, mappingFetch.getAssociation()), fetchStyle);
                ((Loadable)owner).registerAffectingFetchProfile(fetchProfile.getName());
            }
            this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
        }
        this.customEntityDirtinessStrategy = this.determineCustomEntityDirtinessStrategy();
        this.currentTenantIdentifierResolver = this.determineCurrentTenantIdentifierResolver(null);
        this.transactionEnvironment = new TransactionEnvironmentImpl(this);
        this.observer.sessionFactoryCreated(this);
    }

    private static Properties createPropertiesFromMap(Map map) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)map);
        return properties;
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.withOptions().openSession();
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return this.withOptions().autoClose(false).flushBeforeCompletion(false).connectionReleaseMode(ConnectionReleaseMode.AFTER_STATEMENT).openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImplementor withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    public TransactionEnvironment getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    private void registerEntityNameResolvers(EntityPersister persister) {
        if (persister.getEntityMetamodel() == null || persister.getEntityMetamodel().getTuplizer() == null) {
            return;
        }
        this.registerEntityNameResolvers(persister.getEntityMetamodel().getTuplizer());
    }

    private void registerEntityNameResolvers(EntityTuplizer tuplizer) {
        EntityNameResolver[] resolvers = tuplizer.getEntityNameResolvers();
        if (resolvers == null) {
            return;
        }
        for (EntityNameResolver resolver : resolvers) {
            this.registerEntityNameResolver(resolver);
        }
    }

    public void registerEntityNameResolver(EntityNameResolver resolver) {
        this.entityNameResolvers.put(resolver, ENTITY_NAME_RESOLVER_MAP_VALUE);
    }

    public Iterable<EntityNameResolver> iterateEntityNameResolvers() {
        return this.entityNameResolvers.keySet();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map<String, HibernateException> checkNamedQueries() throws HibernateException {
        NamedQueryDefinition qd;
        String queryName;
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Checking %s named HQL queries", (Object)this.namedQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedQueries.entrySet()) {
            queryName = entry.getKey();
            qd = entry.getValue();
            try {
                if (debugEnabled) {
                    LOG.debugf("Checking named query: %s", (Object)queryName);
                }
                this.queryPlanCache.getHQLQueryPlan(qd.getQueryString(), false, Collections.EMPTY_MAP);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        if (debugEnabled) {
            LOG.debugf("Checking %s named SQL queries", (Object)this.namedSqlQueries.size());
        }
        for (Map.Entry<String, NamedQueryDefinition> entry : this.namedSqlQueries.entrySet()) {
            queryName = entry.getKey();
            qd = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification spec;
                if (debugEnabled) {
                    LOG.debugf("Checking named SQL query: %s", (Object)queryName);
                }
                if (((NamedSQLQueryDefinition)qd).getResultSetRef() != null) {
                    ResultSetMappingDefinition definition = this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)qd).getResultSetRef());
                    if (definition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)qd).getResultSetRef());
                    }
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), definition.getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                } else {
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), ((NamedSQLQueryDefinition)qd).getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(spec);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        return errors;
    }

    @Override
    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    @Override
    public Map<String, CollectionPersister> getCollectionPersisters() {
        return this.collectionPersisters;
    }

    @Override
    public Map<String, EntityPersister> getEntityPersisters() {
        return this.entityPersisters;
    }

    @Override
    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public SessionFactory.SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public Dialect getDialect() {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Cannot determine dialect because serviceRegistry is null.");
        }
        return this.dialect;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getSQLExceptionHelper().getSqlExceptionConverter();
    }

    @Override
    public SqlExceptionHelper getSQLExceptionHelper() {
        return this.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String entityName) {
        return this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String queryName) {
        return this.namedQueries.get(queryName);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return this.namedSqlQueries.get(queryName);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String resultSetName) {
        return this.sqlResultSetMappings.get(resultSetName);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    @Override
    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, Collections.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.collectionMetadata.get(roleName);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return this.classMetadata.get(entityName);
    }

    @Override
    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = this.serviceRegistry.getService(ClassLoaderService.class).classForName(className);
        }
        catch (ClassLoadingException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        for (EntityPersister checkPersister : this.entityPersisters.values()) {
            boolean assignableSuperclass;
            if (!Queryable.class.isInstance(checkPersister)) continue;
            Queryable checkQueryable = (Queryable)Queryable.class.cast(checkPersister);
            String checkQueryableEntityName = checkQueryable.getEntityName();
            boolean isMappedClass = className.equals(checkQueryableEntityName);
            if (checkQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(checkQueryableEntityName);
                continue;
            }
            Class mappedClass = checkQueryable.getMappedClass();
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (checkQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(checkQueryable.getMappedSuperclass()).getMappedClass();
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(checkQueryableEntityName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String getImportedClassName(String className) {
        String result = this.imports.get(className);
        if (result == null) {
            try {
                this.serviceRegistry.getService(ClassLoaderService.class).classForName(className);
                return className;
            }
            catch (ClassLoadingException cnfe) {
                return null;
            }
        }
        return result;
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.jdbcServices.getConnectionProvider();
    }

    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            LOG.trace("Already closed");
            return;
        }
        LOG.closing();
        this.isClosed = true;
        this.settings.getMultiTableBulkIdStrategy().release(this.jdbcServices, this.buildLocalConnectionAccess());
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            if (!entityPersister.hasCache()) continue;
            entityPersister.getCacheAccessStrategy().getRegion().destroy();
        }
        for (CollectionPersister collectionPersister : this.collectionPersisters.values()) {
            if (!collectionPersister.hasCache()) continue;
            collectionPersister.getCacheAccessStrategy().getRegion().destroy();
        }
        this.cacheAccess.close();
        this.queryPlanCache.cleanup();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        SessionFactoryRegistry.INSTANCE.removeSessionFactory(this.uuid, this.name, this.settings.isSessionFactoryNameAlsoJndiName(), this.serviceRegistry.getService(JndiService.class));
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public Cache getCache() {
        return this.cacheAccess;
    }

    @Override
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        this.getCache().evictEntity(entityName, id);
    }

    @Override
    public void evictEntity(String entityName) throws HibernateException {
        this.getCache().evictEntityRegion(entityName);
    }

    @Override
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getCache().evictEntity(persistentClass, id);
    }

    @Override
    public void evict(Class persistentClass) throws HibernateException {
        this.getCache().evictEntityRegion(persistentClass);
    }

    @Override
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getCache().evictCollection(roleName, id);
    }

    @Override
    public void evictCollection(String roleName) throws HibernateException {
        this.getCache().evictCollectionRegion(roleName);
    }

    @Override
    public void evictQueries() throws HibernateException {
        this.cacheAccess.evictQueries();
    }

    @Override
    public void evictQueries(String regionName) throws HibernateException {
        this.getCache().evictQueryRegion(regionName);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.cacheAccess.getUpdateTimestampsCache();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.cacheAccess.getQueryCache();
    }

    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        return this.cacheAccess.getQueryCache(regionName);
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        return this.cacheAccess.getSecondLevelCacheRegion(regionName);
    }

    @Override
    public Region getNaturalIdCacheRegion(String regionName) {
        return this.cacheAccess.getNaturalIdCacheRegion(regionName);
    }

    @Override
    public Map getAllSecondLevelCacheRegions() {
        return this.cacheAccess.getAllSecondLevelCacheRegions();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.getStatisticsImplementor();
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.serviceRegistry.getService(StatisticsImplementor.class);
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private TransactionFactory transactionFactory() {
        return this.serviceRegistry.getService(TransactionFactory.class);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.getService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null) {
            if (this.canAccessTransactionManager()) {
                impl = "jta";
            } else {
                return null;
            }
        }
        if ("jta".equals(impl)) {
            if (!this.transactionFactory().compatibleWithJtaSynchronization()) {
                LOG.autoFlushWillNotWork();
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = this.serviceRegistry.getService(ClassLoaderService.class).classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(impl, t);
            return null;
        }
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.customEntityDirtinessStrategy;
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LOG.debugf("Serializing: %s", (Object)this.uuid);
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        LOG.debugf("Deserialized: %s", (Object)this.uuid);
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.uuid, this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactory namedResult;
        SessionFactory uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", (Object)uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", (Object)name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.uuid);
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing SessionFactory from Session");
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(uuid, name);
    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder {
        private final SessionFactoryImpl sessionFactory;
        private Connection connection;
        private String tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.connection, this.tenantIdentifier, this.sessionFactory);
        }

        @Override
        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }
    }

    static class SessionBuilderImpl
    implements SessionBuilderImplementor {
        private final SessionFactoryImpl sessionFactory;
        private SessionOwner sessionOwner;
        private Interceptor interceptor;
        private Connection connection;
        private ConnectionReleaseMode connectionReleaseMode;
        private boolean autoClose;
        private boolean autoJoinTransactions = true;
        private boolean flushBeforeCompletion;
        private String tenantIdentifier;

        SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.sessionOwner = null;
            Settings settings = sessionFactory.settings;
            this.interceptor = sessionFactory.getInterceptor();
            this.connectionReleaseMode = settings.getConnectionReleaseMode();
            this.autoClose = settings.isAutoCloseSessionEnabled();
            this.flushBeforeCompletion = settings.isFlushBeforeCompletionEnabled();
            if (sessionFactory.getCurrentTenantIdentifierResolver() != null) {
                this.tenantIdentifier = sessionFactory.getCurrentTenantIdentifierResolver().resolveCurrentTenantIdentifier();
            }
        }

        protected TransactionCoordinatorImpl getTransactionCoordinator() {
            return null;
        }

        @Override
        public Session openSession() {
            return new SessionImpl(this.connection, this.sessionFactory, this.sessionOwner, this.getTransactionCoordinator(), this.autoJoinTransactions, this.sessionFactory.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.flushBeforeCompletion, this.autoClose, this.connectionReleaseMode, this.tenantIdentifier);
        }

        @Override
        public SessionBuilder owner(SessionOwner sessionOwner) {
            this.sessionOwner = sessionOwner;
            return this;
        }

        @Override
        public SessionBuilder interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        @Override
        public SessionBuilder noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            return this;
        }

        @Override
        public SessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public SessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
            this.connectionReleaseMode = connectionReleaseMode;
            return this;
        }

        @Override
        public SessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return this;
        }

        @Override
        public SessionBuilder autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return this;
        }

        @Override
        public SessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
            this.flushBeforeCompletion = flushBeforeCompletion;
            return this;
        }

        @Override
        public SessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }
    }
}

