/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.beans.BeanInfoHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.internal.DriverManagerConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.internal.UserSuppliedConnectionProviderImpl;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class ConnectionProviderInitiator
implements BasicServiceInitiator<ConnectionProvider> {
    public static final ConnectionProviderInitiator INSTANCE = new ConnectionProviderInitiator();
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ConnectionProviderInitiator.class.getName());
    public static final String C3P0_PROVIDER_CLASS_NAME = "org.hibernate.service.jdbc.connections.internal.C3P0ConnectionProvider";
    public static final String PROXOOL_PROVIDER_CLASS_NAME = "org.hibernate.service.jdbc.connections.internal.ProxoolConnectionProvider";
    public static final String INJECTION_DATA = "hibernate.connection_provider.injection_data";
    private static final Map<String, String> LEGACY_CONNECTION_PROVIDER_MAPPING = new HashMap<String, String>(5);
    private static final Set<String> SPECIAL_PROPERTIES;
    private static final Map<String, String> CONDITIONAL_PROPERTIES;

    @Override
    public Class<ConnectionProvider> getServiceInitiated() {
        return ConnectionProvider.class;
    }

    @Override
    public ConnectionProvider initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Map injectionData;
        MultiTenancyStrategy strategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configurationValues);
        if (strategy == MultiTenancyStrategy.DATABASE || strategy == MultiTenancyStrategy.SCHEMA) {
            return null;
        }
        ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
        ConnectionProvider connectionProvider = null;
        String providerClassName = this.getConfiguredConnectionProviderName(configurationValues);
        if (providerClassName != null) {
            connectionProvider = this.instantiateExplicitConnectionProvider(providerClassName, classLoaderService);
        } else if (configurationValues.get("hibernate.connection.datasource") != null) {
            connectionProvider = new DatasourceConnectionProviderImpl();
        }
        if (connectionProvider == null && ConnectionProviderInitiator.c3p0ConfigDefined(configurationValues) && this.c3p0ProviderPresent(classLoaderService)) {
            connectionProvider = this.instantiateExplicitConnectionProvider(C3P0_PROVIDER_CLASS_NAME, classLoaderService);
        }
        if (connectionProvider == null && ConnectionProviderInitiator.proxoolConfigDefined(configurationValues) && this.proxoolProviderPresent(classLoaderService)) {
            connectionProvider = this.instantiateExplicitConnectionProvider(PROXOOL_PROVIDER_CLASS_NAME, classLoaderService);
        }
        if (connectionProvider == null && configurationValues.get("hibernate.connection.url") != null) {
            connectionProvider = new DriverManagerConnectionProviderImpl();
        }
        if (connectionProvider == null) {
            LOG.noAppropriateConnectionProvider();
            connectionProvider = new UserSuppliedConnectionProviderImpl();
        }
        if ((injectionData = (Map)configurationValues.get(INJECTION_DATA)) != null && injectionData.size() > 0) {
            final ConnectionProvider theConnectionProvider = connectionProvider;
            new BeanInfoHelper(connectionProvider.getClass()).applyToBeanInfo(connectionProvider, new BeanInfoHelper.BeanInfoDelegate(){

                @Override
                public void processBeanInfo(BeanInfo beanInfo) throws Exception {
                    PropertyDescriptor[] descritors = beanInfo.getPropertyDescriptors();
                    int size = descritors.length;
                    for (int i = 0; i < size; ++i) {
                        String propertyName = descritors[i].getName();
                        if (!injectionData.containsKey(propertyName)) continue;
                        Method method = descritors[i].getWriteMethod();
                        method.invoke((Object)theConnectionProvider, injectionData.get(propertyName));
                    }
                }
            });
        }
        return connectionProvider;
    }

    private String getConfiguredConnectionProviderName(Map configurationValues) {
        String providerClassName = (String)configurationValues.get("hibernate.connection.provider_class");
        if (LEGACY_CONNECTION_PROVIDER_MAPPING.containsKey(providerClassName)) {
            String actualProviderClassName = LEGACY_CONNECTION_PROVIDER_MAPPING.get(providerClassName);
            LOG.providerClassDeprecated(providerClassName, actualProviderClassName);
            providerClassName = actualProviderClassName;
        }
        return providerClassName;
    }

    private ConnectionProvider instantiateExplicitConnectionProvider(String providerClassName, ClassLoaderService classLoaderService) {
        try {
            LOG.instantiatingExplicitConnectionProvider(providerClassName);
            return (ConnectionProvider)classLoaderService.classForName(providerClassName).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate connection provider [" + providerClassName + "]", e);
        }
    }

    private boolean c3p0ProviderPresent(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(C3P0_PROVIDER_CLASS_NAME);
        }
        catch (Exception e) {
            LOG.c3p0ProviderClassNotFound(C3P0_PROVIDER_CLASS_NAME);
            return false;
        }
        return true;
    }

    private static boolean c3p0ConfigDefined(Map configValues) {
        for (Object key : configValues.keySet()) {
            if (!String.class.isInstance(key) || !((String)key).startsWith("hibernate.c3p0")) continue;
            return true;
        }
        return false;
    }

    private boolean proxoolProviderPresent(ClassLoaderService classLoaderService) {
        try {
            classLoaderService.classForName(PROXOOL_PROVIDER_CLASS_NAME);
        }
        catch (Exception e) {
            LOG.proxoolProviderClassNotFound(PROXOOL_PROVIDER_CLASS_NAME);
            return false;
        }
        return true;
    }

    private static boolean proxoolConfigDefined(Map configValues) {
        for (Object key : configValues.keySet()) {
            if (!String.class.isInstance(key) || !((String)key).startsWith("hibernate.proxool")) continue;
            return true;
        }
        return false;
    }

    public static Properties getConnectionProperties(Map<?, ?> properties) {
        Properties result = new Properties();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            if (!String.class.isInstance(entry.getKey()) || !String.class.isInstance(entry.getValue())) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("hibernate.connection")) {
                if (SPECIAL_PROPERTIES.contains(key)) {
                    if (!"hibernate.connection.username".equals(key)) continue;
                    result.setProperty("user", value);
                    continue;
                }
                result.setProperty(key.substring("hibernate.connection".length() + 1), value);
                continue;
            }
            if (!CONDITIONAL_PROPERTIES.containsKey(key)) continue;
            result.setProperty(CONDITIONAL_PROPERTIES.get(key), value);
        }
        return result;
    }

    static {
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.DatasourceConnectionProvider", DatasourceConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.DriverManagerConnectionProvider", DriverManagerConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.UserSuppliedConnectionProvider", UserSuppliedConnectionProviderImpl.class.getName());
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.C3P0ConnectionProvider", C3P0_PROVIDER_CLASS_NAME);
        LEGACY_CONNECTION_PROVIDER_MAPPING.put("org.hibernate.connection.ProxoolConnectionProvider", PROXOOL_PROVIDER_CLASS_NAME);
        SPECIAL_PROPERTIES = new HashSet<String>();
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
        CONDITIONAL_PROPERTIES = new HashMap<String, String>();
        CONDITIONAL_PROPERTIES.put("hibernate.synonyms", "includeSynonyms");
    }
}

