/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.httprpc.JSONEncoder;
import org.httprpc.RequestMethod;
import org.httprpc.RequestParameter;
import org.httprpc.ResourcePath;

public abstract class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 0L;
    private Resource root = null;
    private ThreadLocal<HttpServletRequest> request = new ThreadLocal();
    private ThreadLocal<HttpServletResponse> response = new ThreadLocal();
    private ThreadLocal<List<String>> keys = new ThreadLocal();
    private static final String UTF_8 = "UTF-8";

    @Override
    public void init() throws ServletException {
        this.root = new Resource();
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String verb;
            List<Method> handlerList;
            Method method = methods[i];
            RequestMethod requestMethod = method.getAnnotation(RequestMethod.class);
            if (requestMethod == null) continue;
            Resource resource = this.root;
            ResourcePath resourcePath = method.getAnnotation(ResourcePath.class);
            if (resourcePath != null) {
                String[] components = resourcePath.value().split("/");
                for (int j = 0; j < components.length; ++j) {
                    String component = components[j];
                    if (component.length() == 0) continue;
                    Resource child = resource.resources.get(component);
                    if (child == null) {
                        child = new Resource();
                        resource.resources.put(component, child);
                    }
                    resource = child;
                }
            }
            if ((handlerList = resource.handlerMap.get(verb = requestMethod.value().toLowerCase())) == null) {
                handlerList = new LinkedList<Method>();
                resource.handlerMap.put(verb, handlerList);
            }
            handlerList.add(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List<Method> handlerList;
        Resource resource = this.root;
        LinkedList<String> keys = new LinkedList<String>();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            String[] components = pathInfo.split("/");
            for (int i = 0; i < components.length; ++i) {
                String component = components[i];
                if (component.length() == 0) continue;
                Resource child = resource.resources.get(component);
                if (child == null) {
                    child = resource.resources.get("?");
                    if (child == null) {
                        response.setStatus(404);
                        return;
                    }
                    keys.add(component);
                }
                resource = child;
            }
        }
        if ((handlerList = resource.handlerMap.get(request.getMethod().toLowerCase())) == null) {
            response.setStatus(405);
            return;
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(UTF_8);
        }
        this.request.set(request);
        this.response.set(response);
        this.keys.set(new ArrayList(keys));
        LinkedList<File> files = new LinkedList<File>();
        try {
            Object object;
            Method method;
            HashMap parameterMap = new HashMap();
            Enumeration<String> parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String name = parameterNames.nextElement();
                parameterMap.put(name, Arrays.asList(request.getParameterValues(name)));
            }
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                for (Part part : request.getParts()) {
                    String submittedFileName = part.getSubmittedFileName();
                    if (submittedFileName == null || submittedFileName.length() == 0) continue;
                    String name = part.getName();
                    ArrayList<File> values = (ArrayList<File>)parameterMap.get(name);
                    if (values == null) {
                        values = new ArrayList<File>();
                        parameterMap.put(name, values);
                    }
                    File file = File.createTempFile(part.getName(), "_" + submittedFileName);
                    files.add(file);
                    values.add(file);
                    part.write(file.getAbsolutePath());
                }
            }
            if ((method = DispatcherServlet.getMethod(handlerList, parameterMap)) == null) {
                response.setStatus(405);
                return;
            }
            try {
                object = method.invoke((Object)this, DispatcherServlet.getArguments(method, parameterMap));
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                if (response.isCommitted()) {
                    throw new ServletException(exception);
                }
                Throwable cause = exception.getCause();
                if (cause != null) {
                    response.setStatus(500);
                    response.setContentType(String.format("text/plain;charset=%s", UTF_8));
                    PrintWriter writer = response.getWriter();
                    writer.append(cause.getMessage());
                    writer.flush();
                    this.request.set(null);
                    this.response.set(null);
                    this.keys.set(null);
                    for (File file : files) {
                        file.delete();
                    }
                    return;
                }
                throw new ServletException(exception);
            }
            if (response.isCommitted()) {
                return;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE && returnType != Void.class) {
                response.setStatus(200);
                response.setContentType(String.format("application/json;charset=%s", UTF_8));
                JSONEncoder jsonEncoder = new JSONEncoder();
                jsonEncoder.writeValue(object, response.getOutputStream());
            } else {
                response.setStatus(204);
            }
        }
        finally {
            this.request.set(null);
            this.response.set(null);
            this.keys.set(null);
            for (File file : files) {
                file.delete();
            }
        }
    }

    private static Method getMethod(List<Method> handlerList, Map<String, List<?>> parameterMap) {
        Method method = null;
        int n = parameterMap.size();
        int i = Integer.MAX_VALUE;
        for (Method handler : handlerList) {
            Parameter[] parameters = handler.getParameters();
            if (parameters.length < n) continue;
            int j = 0;
            for (int k = 0; k < parameters.length; ++k) {
                String name = DispatcherServlet.getName(parameters[k]);
                if (parameterMap.containsKey(name)) continue;
                ++j;
            }
            if (parameters.length - j != n || j >= i) continue;
            method = handler;
            i = j;
        }
        return method;
    }

    private static Object[] getArguments(Method method, Map<String, List<?>> parameterMap) throws IOException {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            List argument;
            Parameter parameter = parameters[i];
            String name = DispatcherServlet.getName(parameter);
            Class<?> type = parameter.getType();
            List<?> values = parameterMap.get(name);
            if (type == List.class) {
                List list;
                Type elementType = ((ParameterizedType)parameter.getParameterizedType()).getActualTypeArguments()[0];
                if (!(elementType instanceof Class)) {
                    throw new UnsupportedOperationException("Unsupported argument type.");
                }
                if (values != null) {
                    list = new ArrayList(values.size());
                    for (Object value : values) {
                        list.add(DispatcherServlet.getArgument(value, (Class)elementType));
                    }
                } else {
                    list = Collections.emptyList();
                }
                argument = list;
            } else {
                Object value = values != null ? values.get(values.size() - 1) : null;
                argument = DispatcherServlet.getArgument(value, type);
            }
            arguments[i] = argument;
        }
        return arguments;
    }

    private static String getName(Parameter parameter) {
        RequestParameter requestParameter = parameter.getAnnotation(RequestParameter.class);
        return requestParameter == null ? parameter.getName() : requestParameter.value();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object getArgument(Object value, Class<?> type) {
        if (type == String.class) {
            if (value == null) {
                return null;
            }
            String string = value.toString();
            return string;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            if (value != null) return Byte.parseByte(value.toString());
            if (type != Byte.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Short.TYPE || type == Short.class) {
            if (value != null) return Short.parseShort(value.toString());
            if (type != Short.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            if (value != null) return Integer.parseInt(value.toString());
            if (type != Integer.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Long.TYPE || type == Long.class) {
            if (value != null) return Long.parseLong(value.toString());
            if (type != Long.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Float.TYPE || type == Float.class) {
            if (value != null) return Float.valueOf(Float.parseFloat(value.toString()));
            if (type != Float.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Double.TYPE || type == Double.class) {
            if (value != null) return Double.parseDouble(value.toString());
            if (type != Double.TYPE) return null;
            Integer n = 0;
            return n;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (value != null) return Boolean.parseBoolean(value.toString());
            if (type != Boolean.TYPE) return null;
            Boolean bl = false;
            return bl;
        }
        if (type == Date.class) {
            if (value == null) {
                return null;
            }
            Date date = new Date(Long.parseLong(value.toString()));
            return date;
        }
        if (type == LocalDate.class) {
            if (value == null) {
                return null;
            }
            LocalDate localDate = LocalDate.parse(value.toString());
            return localDate;
        }
        if (type == LocalTime.class) {
            if (value == null) {
                return null;
            }
            LocalTime localTime = LocalTime.parse(value.toString());
            return localTime;
        }
        if (type == LocalDateTime.class) {
            if (value == null) {
                return null;
            }
            LocalDateTime localDateTime = LocalDateTime.parse(value.toString());
            return localDateTime;
        }
        if (type != URL.class) throw new UnsupportedOperationException("Unsupported argument type.");
        if (value == null) {
            return null;
        }
        if (!(value instanceof File)) throw new IllegalArgumentException();
        try {
            return ((File)value).toURI().toURL();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected HttpServletRequest getRequest() {
        return this.request.get();
    }

    protected HttpServletResponse getResponse() {
        return this.response.get();
    }

    protected String getKey(int index) {
        return this.keys.get().get(index);
    }

    private static class Resource {
        public final HashMap<String, List<Method>> handlerMap = new HashMap();
        public final HashMap<String, Resource> resources = new HashMap();

        private Resource() {
        }

        public String toString() {
            return this.handlerMap.keySet().toString() + "; " + this.resources.toString();
        }
    }
}

