/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.httprpc.JSONDecoder;
import org.httprpc.RequestMethod;
import org.httprpc.RequestParameter;
import org.httprpc.ResourcePath;
import org.httprpc.WebServiceException;

public class WebServiceProxy {
    private String method;
    private URL url;
    private Encoding encoding = Encoding.APPLICATION_X_WWW_FORM_URLENCODED;
    private LinkedHashMap<String, Object> headers = new LinkedHashMap();
    private LinkedHashMap<String, Object> arguments = new LinkedHashMap();
    private RequestHandler requestHandler = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private String multipartBoundary = UUID.randomUUID().toString();
    private static final String UTF_8 = "UTF-8";
    private static final int EOF = -1;

    public WebServiceProxy(String method, URL url) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        if (url == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public LinkedHashMap<String, Object> getHeaders() {
        return this.headers;
    }

    public LinkedHashMap<String, Object> getArguments() {
        return this.arguments;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public <T> T invoke() throws IOException {
        return this.invoke(new ResponseHandler<T>(){

            @Override
            public T decodeResponse(InputStream inputStream, String contentType) throws IOException {
                Object result;
                if (contentType != null && contentType.startsWith("application/json")) {
                    JSONDecoder jsonDecoder = new JSONDecoder();
                    result = jsonDecoder.readValue(inputStream);
                } else {
                    result = null;
                }
                return result;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public <T> T invoke(ResponseHandler<T> responseHandler) throws IOException {
        void var7_14;
        int responseCode;
        Object value;
        RequestHandler requestHandler;
        URL url;
        if (responseHandler == null) {
            throw new IllegalArgumentException();
        }
        if (this.method.equalsIgnoreCase("POST") && this.requestHandler == null) {
            url = this.url;
            requestHandler = new RequestHandler(){

                @Override
                public String getContentType() {
                    String contentType;
                    switch (WebServiceProxy.this.encoding) {
                        case APPLICATION_X_WWW_FORM_URLENCODED: {
                            contentType = "application/x-www-form-urlencoded";
                            break;
                        }
                        case MULTIPART_FORM_DATA: {
                            contentType = String.format("multipart/form-data; boundary=%s", WebServiceProxy.this.multipartBoundary);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    return contentType;
                }

                @Override
                public void encodeRequest(OutputStream outputStream) throws IOException {
                    switch (WebServiceProxy.this.encoding) {
                        case APPLICATION_X_WWW_FORM_URLENCODED: {
                            WebServiceProxy.this.encodeApplicationXWWWFormURLEncodedRequest(outputStream);
                            break;
                        }
                        case MULTIPART_FORM_DATA: {
                            WebServiceProxy.this.encodeMultipartFormDataRequest(outputStream);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
            };
        } else {
            String query = this.encodeQuery();
            url = query.length() == 0 ? this.url : new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), this.url.getFile() + "?" + query);
            requestHandler = this.requestHandler;
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(this.method);
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestProperty("Accept", "*/*");
        Locale locale = Locale.getDefault();
        connection.setRequestProperty("Accept-Language", String.format("%s-%s", locale.getLanguage().toLowerCase(), locale.getCountry().toLowerCase()));
        for (Map.Entry<String, Object> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            value = entry.getValue();
            if (key == null || value == null) continue;
            connection.setRequestProperty(key, value.toString());
        }
        if (requestHandler != null) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", requestHandler.getContentType());
            Throwable throwable = null;
            try (OutputStream outputStream = connection.getOutputStream();){
                requestHandler.encodeRequest(outputStream);
            }
            catch (Throwable key) {
                Throwable throwable2 = key;
                throw key;
            }
        }
        if ((responseCode = connection.getResponseCode()) / 100 == 2) {
            if (responseCode % 100 < 4) {
                InputStream inputStream = connection.getInputStream();
                value = null;
                try {
                    T t = responseHandler.decodeResponse(inputStream, connection.getContentType());
                }
                catch (Throwable throwable) {
                    value = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        if (value != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)value).addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            } else {
                Object var7_13 = null;
            }
        } else {
            String message;
            String contentType = connection.getContentType();
            if (contentType != null && contentType.startsWith("text/plain")) {
                StringBuilder messageBuilder = new StringBuilder(1024);
                try (InputStream inputStream = connection.getErrorStream();
                     InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(UTF_8));){
                    int c;
                    while ((c = reader.read()) != -1) {
                        messageBuilder.append((char)c);
                    }
                }
                message = messageBuilder.toString();
            } else {
                message = connection.getResponseMessage();
            }
            throw new WebServiceException(message, responseCode);
        }
        return var7_14;
    }

    private String encodeQuery() throws UnsupportedEncodingException {
        StringBuilder queryBuilder = new StringBuilder(256);
        int i = 0;
        for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
            String key = entry.getKey();
            if (key == null) continue;
            for (Object value : WebServiceProxy.getParameterValues(entry.getValue())) {
                if (value == null) continue;
                if (i > 0) {
                    queryBuilder.append("&");
                }
                queryBuilder.append(URLEncoder.encode(key, UTF_8));
                queryBuilder.append("=");
                queryBuilder.append(URLEncoder.encode(value.toString(), UTF_8));
                ++i;
            }
        }
        return queryBuilder.toString();
    }

    private void encodeApplicationXWWWFormURLEncodedRequest(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName(UTF_8));
        writer.append(this.encodeQuery());
        writer.flush();
    }

    private void encodeMultipartFormDataRequest(OutputStream outputStream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, Charset.forName(UTF_8));
        for (Map.Entry<String, Object> entry : this.arguments.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            for (Object value : WebServiceProxy.getParameterValues(entry.getValue())) {
                if (value == null) continue;
                writer.append(String.format("--%s\r\n", this.multipartBoundary));
                writer.append(String.format("Content-Disposition: form-data; name=\"%s\"", name));
                if (value instanceof URL) {
                    String path = ((URL)value).getPath();
                    String filename = path.substring(path.lastIndexOf(47) + 1);
                    writer.append(String.format("; filename=\"%s\"\r\n", filename));
                    writer.append("Content-Type: application/octet-stream\r\n\r\n");
                    writer.flush();
                    try (InputStream inputStream = ((URL)value).openStream();){
                        int b;
                        while ((b = inputStream.read()) != -1) {
                            outputStream.write(b);
                        }
                    }
                } else {
                    writer.append("\r\n\r\n");
                    writer.append(value.toString());
                }
                writer.append("\r\n");
            }
        }
        writer.append(String.format("--%s--\r\n", this.multipartBoundary));
        writer.flush();
    }

    private static Iterable<?> getParameterValues(Object argument) throws UnsupportedEncodingException {
        List<Object> values = argument instanceof Iterable ? (List<Object>)WebServiceProxy.getParameterValue(argument) : Collections.singletonList(WebServiceProxy.getParameterValue(argument));
        return values;
    }

    private static Object getParameterValue(Object argument) {
        if (argument instanceof Date) {
            return ((Date)argument).getTime();
        }
        return argument;
    }

    public static <T> T adapt(URL baseURL, Class<T> type) {
        return WebServiceProxy.adapt(baseURL, type, Collections.emptyMap());
    }

    public static <T> T adapt(final URL baseURL, Class<T> type, final Map<String, ?> headers) {
        if (baseURL == null) {
            throw new IllegalArgumentException();
        }
        if (headers == null) {
            throw new IllegalArgumentException();
        }
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                RequestMethod requestMethod = method.getAnnotation(RequestMethod.class);
                if (requestMethod == null) {
                    throw new UnsupportedOperationException();
                }
                ResourcePath resourcePath = method.getAnnotation(ResourcePath.class);
                URL url = resourcePath != null ? new URL(baseURL, resourcePath.value()) : baseURL;
                WebServiceProxy webServiceProxy = new WebServiceProxy(requestMethod.value(), url);
                if (webServiceProxy.getMethod().equalsIgnoreCase("POST")) {
                    webServiceProxy.setEncoding(Encoding.MULTIPART_FORM_DATA);
                }
                webServiceProxy.getHeaders().putAll(headers);
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    RequestParameter requestParameter = parameter.getAnnotation(RequestParameter.class);
                    String name = requestParameter == null ? parameter.getName() : requestParameter.value();
                    webServiceProxy.getArguments().put(name, arguments[i]);
                }
                return webServiceProxy.invoke();
            }
        }));
    }

    public static interface ResponseHandler<T> {
        public T decodeResponse(InputStream var1, String var2) throws IOException;
    }

    public static interface RequestHandler {
        default public String getContentType() {
            return "application/octet-stream";
        }

        public void encodeRequest(OutputStream var1) throws IOException;
    }

    public static enum Encoding {
        APPLICATION_X_WWW_FORM_URLENCODED,
        MULTIPART_FORM_DATA;

    }
}

