/*
 * Decompiled with CFR 0.152.
 */
package org.httprpc.sql;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.httprpc.beans.BeanAdapter;

public class ResultSetAdapter
implements Iterable<Map<String, Object>> {
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;
    private LinkedHashMap<String, Object> row = new LinkedHashMap();

    public ResultSetAdapter(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException();
        }
        this.resultSet = resultSet;
        try {
            this.resultSetMetaData = resultSet.getMetaData();
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return new Iterator<Map<String, Object>>(){
            private Boolean hasNext = null;

            @Override
            public boolean hasNext() {
                if (this.hasNext == null) {
                    try {
                        this.hasNext = ResultSetAdapter.this.resultSet.next() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (SQLException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ResultSetAdapter.this.row.clear();
                try {
                    int n = ResultSetAdapter.this.resultSetMetaData.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        ResultSetAdapter.this.row.put(ResultSetAdapter.this.resultSetMetaData.getColumnLabel(i + 1), ResultSetAdapter.this.resultSet.getObject(i + 1));
                    }
                }
                catch (SQLException exception) {
                    throw new RuntimeException(exception);
                }
                this.hasNext = null;
                return ResultSetAdapter.this.row;
            }
        };
    }

    public static <T> Iterable<T> adapt(final ResultSet resultSet, final Class<T> rowType) {
        return new Iterable<T>(){
            private ResultSetAdapter resultSetAdapter;
            {
                this.resultSetAdapter = new ResultSetAdapter(resultSet);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private Iterator<Map<String, Object>> iterator;
                    private T proxy;
                    {
                        this.iterator = resultSetAdapter.iterator();
                        this.proxy = BeanAdapter.adapt((Object)resultSetAdapter.row, (Type)rowType);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        this.iterator.next();
                        return this.proxy;
                    }
                };
            }
        };
    }
}

