/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;

public final class ByteArrayBuilder {
    private ArrayList<byte[]> buffer;
    private int length = 0;
    private byte[] contents = null;

    public int getLength() {
        return this.length;
    }

    public ByteArrayBuilder() {
        this.buffer = new ArrayList(10);
    }

    public ByteArrayBuilder(int initialCapacity) {
        this.buffer = new ArrayList(initialCapacity);
    }

    public ByteArrayBuilder(byte[] initialContents) {
        this();
        this.append(initialContents);
    }

    public ByteArrayBuilder(byte[] initialContents, int initialCapacity) {
        this(initialCapacity);
        this.append(initialContents);
    }

    private void resetContents() {
        this.contents = null;
    }

    public void clear() {
        this.length = 0;
        this.resetContents();
        this.buffer.clear();
    }

    public final ByteArrayBuilder append(byte[] bs) {
        this.resetContents();
        this.length += bs.length;
        this.buffer.add(bs);
        return this;
    }

    public final ByteArrayBuilder append(String s, Charset c) throws UnsupportedEncodingException {
        return this.append(s.getBytes(c.name()));
    }

    public final ByteArrayBuilder append(StringBuilder s, Charset c) throws UnsupportedEncodingException {
        return this.append(s.toString(), c);
    }

    public byte[] getByteArray() {
        if (this.contents == null) {
            this.contents = new byte[this.getLength()];
            int pos = 0;
            for (byte[] bs : this.buffer) {
                System.arraycopy(bs, 0, this.contents, pos, bs.length);
                pos += bs.length;
            }
        }
        return this.contents;
    }
}

