/*
 * Decompiled with CFR 0.152.
 */
package jzebra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jzebra.ByteArrayBuilder;
import jzebra.ByteUtilities;
import jzebra.LanguageType;
import jzebra.LogIt;
import jzebra.exception.InvalidRawImageException;

public class ImageWrapperOld {
    public static byte[] getImage(ImageIcon i, LanguageType lang, Charset charset, int x, int y) throws InvalidRawImageException, IOException {
        ByteArrayBuilder b = new ByteArrayBuilder();
        int w = i.getIconWidth();
        int h = i.getIconHeight();
        if (w % 8 != 0) {
            int newW = w + 8 - w % 8;
            LogIt.log(Level.WARNING, "Image width of " + w + " is not divisible by 8.  " + "Will round-up to " + newW);
            w = newW;
        }
        LogIt.log("Image specified: " + i.getDescription());
        LogIt.log("Dimensions: " + w + "x" + h);
        BufferedImage buffer = new BufferedImage(w, h, 1);
        Graphics2D g = buffer.createGraphics();
        g.setBackground(Color.WHITE);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.drawImage(i.getImage(), 0, 0, w, h, 0, 0, w, h, Color.WHITE, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)buffer, "bmp", out);
        boolean[] black = ImageWrapperOld.getBlackPixels(out, w, h, lang != LanguageType.EPL);
        int[] hex = ByteUtilities.binaryArrayToIntArray(black);
        String data = ByteUtilities.getHexString(hex);
        int bytesLen = data.length() / 2;
        int perRow = bytesLen / h;
        int pixels = black.length;
        LogIt.log("Bytes: " + bytesLen + ", Pixels: " + pixels);
        LogIt.log("Pixels/Row: " + pixels / h);
        LogIt.log("Bytes/Row: " + perRow);
        LogIt.log("Binary Data: " + data);
        switch (lang) {
            case ESCP: 
            case ESCP2: {
                if (h > 510) {
                    throw new InvalidRawImageException("ESC/P images taller than 510 pixels are not supported using ESC V syntax.");
                }
                byte n1 = (byte)(h > 255 ? h - 255 : 0);
                byte n2 = (byte)(h <= 255 ? h : 255);
                b.append(new byte[]{27, 86, n1, n2});
                b.append(ByteUtilities.intArrayToByteArray(hex));
                break;
            }
            case ZPL: 
            case ZPLII: {
                b.append(("^GFA," + bytesLen + "," + bytesLen + "," + perRow + "," + data).getBytes(charset.name()));
                break;
            }
            case EPL: {
                b.append(("GW" + x + "," + y + "," + w / 8 + "," + h + ",").getBytes(charset.name()));
                b.append(ByteUtilities.intArrayToByteArray(hex));
                break;
            }
            case CPCL: {
                b.append(("EG " + w / 8 + " " + h + " " + x + " " + y + data).getBytes(charset.name()));
                break;
            }
            default: {
                throw new InvalidRawImageException(lang.name() + " image conversion is not yet supported.");
            }
        }
        return b.getByteArray();
    }

    public static byte[] getImage(byte[] imgData, LanguageType lang, Charset charset, int x, int y) throws InvalidRawImageException, IOException, MalformedURLException, IllegalArgumentException {
        return ImageWrapperOld.getImage(new ImageIcon(imgData, "Byte Array"), lang, charset, x, y);
    }

    public static byte[] getImage(String url, LanguageType lang, Charset charset, int x, int y) throws InvalidRawImageException, IOException, MalformedURLException, IllegalArgumentException {
        return ImageWrapperOld.getImage(new ImageIcon(new URL(url), url), lang, charset, x, y);
    }

    private static String flipRows(String hex, int height) {
        String flipped = "";
        int width = hex.length() / height;
        for (int i = 0; i < height; ++i) {
            flipped = flipped + new StringBuilder(hex.substring(i * width, (i + 1) * width)).reverse().toString();
        }
        return flipped;
    }

    private static boolean[] getBlackPixels(ByteArrayOutputStream o, int width, int height, boolean blackFilled) {
        int skip = 54;
        byte[] data = o.toByteArray();
        int length = data.length - skip;
        boolean[] pixels = new boolean[length / 3];
        int pos = 0;
        for (int y = height - 1; y >= 0; --y) {
            for (int x = 0; x < width; ++x) {
                int i = width * y + x;
                int r = Integer.parseInt(Byte.toString(data[3 * i + skip]));
                int g = Integer.parseInt(Byte.toString(data[3 * i + skip + 1]));
                int b = Integer.parseInt(Byte.toString(data[3 * i + skip + 2]));
                pixels[pos++] = r * g * b == -1 ? !blackFilled : blackFilled;
            }
        }
        return pixels;
    }
}

