/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus;

import br.com.elotech.websaude.integracao.esus.controller.DadosEsus;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.comparator.LastModifiedFileComparator;

public class Main {
    public static void main(String[] args) {
        if (args.length == 3 && Conexao.abrirConexao(args)) {
            try {
                Main.processar();
                Main.varreServidorArqs();
                Conexao.CONN.commit();
            }
            catch (IOException | SQLException | JAXBException ex) {
                try {
                    Conexao.CONN.rollback();
                }
                catch (SQLException ex1) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex1);
                }
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ParseException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            Conexao.fecharConexao();
        }
    }

    private static void processar() throws SQLException, IOException, JAXBException, ParseException {
        DadosEsus dadosEsus = new DadosEsus();
        dadosEsus.geraArquivo();
    }

    protected static void varreServidorArqs() {
        File directory = new File("arqs/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (!directory.canWrite()) {
            try {
                throw new Exception("N\u00e3o \u00e9 poss\u00edvel escrever.");
            }
            catch (Exception ex) {
                Logger.getLogger(DadosEsus.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        File[] arqs = directory.listFiles();
        Arrays.sort(arqs, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
        for (File file : arqs) {
            Date ultModificado = new Date(file.lastModified());
            if (ultModificado.before(new Date(ultModificado.getYear(), ultModificado.getMonth() - 4, ultModificado.getDay())) && file.canWrite()) {
                file.deleteOnExit();
            }
            if (!file.getName().contains("xml")) continue;
            file.deleteOnExit();
        }
    }
}

