/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.websaude.integracao.esus.controller;

import br.com.elotech.websaude.integracao.esus.model.BD;
import br.com.elotech.websaude.integracao.esus.model.BancoAtendimentoIndividual;
import br.com.elotech.websaude.integracao.esus.model.EsusHistoricoItens;
import br.com.elotech.websaude.integracao.esus.model.dao.Conexao;
import br.com.elotech.websaude.integracao.esus.util.Compactador;
import br.com.elotech.websaude.integracao.esus.util.DataConvert;
import br.ufsc.esus.dadoinstalacao.DadoInstalacaoTransport;
import br.ufsc.esus.dadotransporte.DadoTransporteTransportAteIndividualXml;
import br.ufsc.esus.dadotransporte.ObjectFactoryAteIndividual;
import br.ufsc.esus.fichaatendimentoindividualchild.FichaAtendimentoIndividualChildTransport;
import br.ufsc.esus.fichaatendimentoindividualmaster.FichaAtendimentoIndividualMasterTransport;
import br.ufsc.esus.lotacaoheader.LotacaoHeaderTransport;
import br.ufsc.esus.outrossia.OutrosSiaTransport;
import br.ufsc.esus.problemacondicaoavaliacaoai.ProblemaCondicaoAvaliacaoAITransport;
import br.ufsc.esus.variaslotacoesheader.VariasLotacoesHeaderTransport;
import br.ufsc.esus.versao.VersaoTransport;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class AteIndividual
extends BD {
    public void executeMain(int eehCodigo) throws SQLException, JAXBException, IOException {
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        EsusHistoricoItens bdEsusHistoricoItens = new EsusHistoricoItens();
        ResultSet dadosAteIndividual = bdAteIndividual.getDados();
        ResultSet numAtend = bdAteIndividual.getQtdRegistros();
        if (!numAtend.wasNull()) {
            while (dadosAteIndividual.next()) {
                AteIndividual dadosThrift = new AteIndividual();
                String uuid = this.getGUID();
                FichaAtendimentoIndividualMasterTransport ficha_master = this.fichaAtendimentoIndividualMasterThrift(uuid, dadosAteIndividual);
                DadoTransporteTransportAteIndividualXml array_envio = this.montaArrayEnvioDto(ficha_master, uuid, dadosAteIndividual, eehCodigo);
                this.zipWriter(array_envio, uuid, eehCodigo);
                bdEsusHistoricoItens.registratHistoricoItens(eehCodigo, uuid, 4);
                bdAteIndividual.atualizaStatus(uuid, dadosAteIndividual.getInt("ate_codigo"));
            }
        }
    }

    public void zipWriter(DadoTransporteTransportAteIndividualXml xmlText, String uuid, int eeh) throws JAXBException, IOException {
        String arquivo = uuid + ".esus.xml";
        ObjectFactoryAteIndividual factoryCadastroIndividual = new ObjectFactoryAteIndividual();
        JAXBContext context = JAXBContext.newInstance(ObjectFactoryAteIndividual.class);
        JAXBElement<DadoTransporteTransportAteIndividualXml> element = factoryCadastroIndividual.createDadoTransporteTransportAteIndividualXml(xmlText);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.marshal(element, new FileWriter("arqs/" + arquivo));
        Compactador.ARQUIVOS.add(arquivo);
    }

    public FichaAtendimentoIndividualMasterTransport fichaAtendimentoIndividualMasterThrift(String uuid, ResultSet row) throws SQLException {
        VariasLotacoesHeaderTransport variasLotacoes = this.variasLotacoes(row);
        FichaAtendimentoIndividualChildTransport atendimentosIndividuais = this.fichaAtendimentoIndividualChildThrift(row);
        FichaAtendimentoIndividualMasterTransport ficha_master = new FichaAtendimentoIndividualMasterTransport();
        ficha_master.setUuidFicha(uuid);
        ficha_master.getAtendimentosIndividuais().add(atendimentosIndividuais);
        ficha_master.setHeaderTransport(variasLotacoes);
        ficha_master.setTpCdsOrigem(3);
        return ficha_master;
    }

    public VariasLotacoesHeaderTransport variasLotacoes(ResultSet row) throws SQLException {
        LotacaoHeaderTransport headerTransport = new LotacaoHeaderTransport();
        headerTransport.setCboCodigo2002(row.getString("eai_cbo_codigo_2002"));
        headerTransport.setCnes(row.getString("eai_cnes"));
        headerTransport.setProfissionalCNS(this.validaCnsBanco(row.getString("eai_profissional_cns").trim()) ? row.getString("eai_profissional_cns").trim() : null);
        VariasLotacoesHeaderTransport variasLotacoes = new VariasLotacoesHeaderTransport();
        variasLotacoes.setCodigoIbgeMunicipio(row.getString("eai_codigo_ibge_mun"));
        variasLotacoes.setDataAtendimento(DataConvert.dateToEpoch(row.getDate("eai_dtatendimento")));
        variasLotacoes.setLotacaoFormPrincipal(headerTransport);
        return variasLotacoes;
    }

    public FichaAtendimentoIndividualChildTransport fichaAtendimentoIndividualChildThrift(ResultSet row) throws SQLException {
        FichaAtendimentoIndividualChildTransport array_atend_individual = new FichaAtendimentoIndividualChildTransport();
        array_atend_individual.setDataNascimento(DataConvert.dateToEpoch(row.getDate("eai_dtnascimento")));
        if (row.getLong("co_local_atend") <= 10L) {
            array_atend_individual.setLocalDeAtendimento(row.getLong("co_local_atend"));
        }
        array_atend_individual.setTipoAtendimento(row.getLong("eai_tipo_atendimento"));
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        array_atend_individual.getNasfs().addAll(bdAteIndividual.getNasfs(row.getInt("ate_codigo")));
        ProblemaCondicaoAvaliacaoAITransport aITransport = new ProblemaCondicaoAvaliacaoAITransport();
        array_atend_individual.setRacionalidadeSaude(row.getLong("eai_rac_saude") != 0L ? Long.valueOf(row.getLong("eai_rac_saude")) : null);
        array_atend_individual.setPerimetroCefalico(row.getDouble("eai_perimetro_cefalico") > 0.0 ? Double.valueOf(row.getDouble("eai_perimetro_cefalico")) : null);
        String vacinacao_em_dia = row.getString("eai_vacinacao_em_dia");
        if (vacinacao_em_dia != null && !vacinacao_em_dia.isEmpty()) {
            array_atend_individual.setVacinaEmDia(row.getBoolean("eai_vacinacao_em_dia"));
        }
        array_atend_individual.setAleitamentoMaterno(row.getLong("eai_aleitamento_materno") != 0L ? Long.valueOf(row.getLong("eai_aleitamento_materno")) : null);
        array_atend_individual.setPesoAcompanhamentoNutricional(row.getDouble("eai_peso") > 0.0 ? Double.valueOf(row.getDouble("eai_peso")) : null);
        array_atend_individual.setAlturaAcompanhamentoNutricional(row.getDouble("eai_altura") > 0.0 ? Double.valueOf(row.getDouble("eai_altura")) : null);
        array_atend_individual.setAtencaoDomiciliarModalidade(row.getLong("eai_ate_dom_mod") != 0L ? Long.valueOf(row.getLong("eai_ate_dom_mod")) : null);
        array_atend_individual.setStGravidezPlanejada(row.getString("eai_gravidez_planejada") != null ? Boolean.valueOf(row.getBoolean("eai_gravidez_planejada")) : null);
        array_atend_individual.setDumDaGestante(row.getString("eai_dum") != null ? DataConvert.dateToEpoch(row.getDate("eai_dum")) : null);
        array_atend_individual.setNuGestasPrevias(row.getInt("eai_gestas_previas") > 0 ? Integer.valueOf(row.getInt("eai_gestas_previas")) : null);
        array_atend_individual.setNuPartos(row.getInt("eai_partos") > 0 ? Integer.valueOf(row.getInt("eai_partos")) : null);
        array_atend_individual.setProblemaCondicaoAvaliada(this.problemaCondicaoAvaliacaoAIThrift(row.getInt("ate_codigo")));
        array_atend_individual.setTipoAtendimento(row.getLong("eai_tipo_atendimento"));
        array_atend_individual.getCondutas().addAll(this.getCondutas(row.getInt("ate_codigo")));
        for (OutrosSiaTransport outros : this.outrosSiaThrift(row.getInt("ate_codigo"))) {
            array_atend_individual.getOutrosSia().add(outros);
        }
        array_atend_individual.setCns(row.getString("eai_num_cartao_sus") != null ? row.getString("eai_num_cartao_sus").trim() : null);
        array_atend_individual.setNumeroProntuario(row.getString("eai_numprontuario"));
        array_atend_individual.setSexo(Long.valueOf(row.getString("eai_sexo").replace(" L", "")));
        array_atend_individual.setTurno(this.getTurno(row.getInt("ate_codigo")));
        return array_atend_individual;
    }

    public Long getTurno(int ateCodigo) throws SQLException {
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet dadosTurno = bdAteIndividual.getTurno(ateCodigo);
        Long turno = 1L;
        if (dadosTurno.next()) {
            turno = dadosTurno.getLong(1);
        }
        return turno;
    }

    public ProblemaCondicaoAvaliacaoAITransport problemaCondicaoAvaliacaoAIThrift(int ateCodigo) throws SQLException {
        List<String> dadosCiaps = this.getCiaps(ateCodigo);
        List<String> dadosOutroCiaps = this.getCiapsOutros(ateCodigo);
        ProblemaCondicaoAvaliacaoAITransport problemaCondicaoAvaliacaoAITransport = new ProblemaCondicaoAvaliacaoAITransport();
        if (dadosOutroCiaps.size() > 1) {
            problemaCondicaoAvaliacaoAITransport.setOutroCiap1(dadosOutroCiaps.get(0));
            problemaCondicaoAvaliacaoAITransport.setOutroCiap2(dadosOutroCiaps.get(1));
        } else if (dadosOutroCiaps.size() == 1) {
            problemaCondicaoAvaliacaoAITransport.setOutroCiap1(dadosOutroCiaps.get(0));
        }
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet rs = bdAteIndividual.getCids(ateCodigo);
        if (rs.next()) {
            if (rs.getString("cd10_codigo") != null && rs.getString("cd10_codigo").length() > 0) {
                problemaCondicaoAvaliacaoAITransport.setCid10(rs.getString("cd10_codigo").trim());
            }
            if (rs.getString("cd10_codigos") != null && rs.getString("cd10_codigos").length() > 0) {
                problemaCondicaoAvaliacaoAITransport.setCid102(rs.getString("cd10_codigos").trim());
            }
        }
        problemaCondicaoAvaliacaoAITransport.getCiaps().addAll(dadosCiaps);
        return problemaCondicaoAvaliacaoAITransport;
    }

    public List<String> getCiaps(int ateCodigo) throws SQLException {
        String[] arrayCiaps = new String[]{"ABP009", "ABP019", "ABP008", "ABP006", "ABP010", "ABP020", "ABP018", "ABP005", "ABP007", "ABP001", "ABP004", "ABP002", "ABP023", "ABP022", "ABP024", "ABP015", "ABP014", "ABP003", "ABP011", "ABP017", "ABP012", "ABP013"};
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet dadosCiaps = bdAteIndividual.getCiaps(ateCodigo);
        ArrayList<String> ciaps = new ArrayList<String>();
        while (dadosCiaps.next()) {
            for (String text : arrayCiaps) {
                if (!dadosCiaps.getString("co_ciap").contains(text)) continue;
                ciaps.add(text);
            }
        }
        return ciaps;
    }

    public List<String> getCiapsOutros(int ateCodigo) throws SQLException {
        String[] arrayCiaps = new String[]{"ABP009", "ABP019", "ABP008", "ABP006", "ABP010", "ABP020", "ABP018", "ABP005", "ABP007", "ABP001", "ABP004", "ABP002", "ABP023", "ABP022", "ABP024", "ABP015", "ABP014", "ABP003", "ABP011", "ABP017", "ABP012", "ABP013"};
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet dadosCiaps = bdAteIndividual.getCiaps(ateCodigo);
        ArrayList<String> ciaps = new ArrayList<String>();
        while (dadosCiaps.next()) {
            boolean r = false;
            for (String text : arrayCiaps) {
                if (!dadosCiaps.getString("co_ciap").contains(text)) continue;
                r = true;
            }
            if (r) continue;
            ciaps.add(dadosCiaps.getString("co_ciap"));
        }
        return ciaps;
    }

    public List<Long> getCondutas(int ateCodigo) throws SQLException {
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet dadosConduta = bdAteIndividual.getCondutas(ateCodigo);
        ArrayList<Long> conduta = new ArrayList<Long>();
        while (dadosConduta.next()) {
            conduta.add(dadosConduta.getLong("co_cds_tipo_conduta"));
        }
        return conduta;
    }

    public List<OutrosSiaTransport> outrosSiaThrift(int ateCodigo) throws SQLException {
        BancoAtendimentoIndividual bdAteIndividual = new BancoAtendimentoIndividual();
        ResultSet dadosProcedimentosSigtap = bdAteIndividual.getExames(ateCodigo);
        ArrayList<OutrosSiaTransport> arrayGeral = new ArrayList<OutrosSiaTransport>();
        while (dadosProcedimentosSigtap.next()) {
            OutrosSiaTransport ost = new OutrosSiaTransport();
            ost.setCodigoExame(dadosProcedimentosSigtap.getString("proc_codigo_sus"));
            if (dadosProcedimentosSigtap.getString("proc_solicitado") != null && dadosProcedimentosSigtap.getString("proc_solicitado").equals("S")) {
                ost.getSolicitadoAvaliado().add(dadosProcedimentosSigtap.getString("proc_solicitado"));
            }
            if (dadosProcedimentosSigtap.getString("proc_avaliado") != null && dadosProcedimentosSigtap.getString("proc_avaliado").equals("A")) {
                ost.getSolicitadoAvaliado().add(dadosProcedimentosSigtap.getString("proc_avaliado"));
            }
            arrayGeral.add(ost);
        }
        return arrayGeral;
    }

    public DadoTransporteTransportAteIndividualXml montaArrayEnvioDto(FichaAtendimentoIndividualMasterTransport ficha_master_serializado, String uuid, ResultSet row, int eehCodigo) throws SQLException {
        ResultSet dadosRO = this.getDadosOriginadoraRemetente();
        dadosRO.next();
        DadoInstalacaoTransport remetente = new DadoInstalacaoTransport();
        remetente.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        remetente.setUuidInstalacao(uuid);
        remetente.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        remetente.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        remetente.setFone(dadosRO.getString("ero_fone"));
        remetente.setEmail(dadosRO.getString("ero_email"));
        DadoInstalacaoTransport originadora = new DadoInstalacaoTransport();
        originadora.setContraChave(dadosRO.getString("ero_contra_chave") != null ? dadosRO.getString("ero_contra_chave") : "");
        originadora.setUuidInstalacao(uuid);
        originadora.setCpfOuCnpj(dadosRO.getString("ero_cpf_cnpj"));
        originadora.setNomeOuRazaoSocial(dadosRO.getString("ero_nome_razao"));
        originadora.setFone(dadosRO.getString("ero_fone"));
        originadora.setEmail(dadosRO.getString("ero_email"));
        VersaoTransport array_versao = new VersaoTransport();
        array_versao.setMajor(2);
        array_versao.setMinor(1);
        array_versao.setRevision(0);
        DadoTransporteTransportAteIndividualXml dadoTransporteTransportXml = new DadoTransporteTransportAteIndividualXml();
        dadoTransporteTransportXml.setUuidDadoSerializado(uuid);
        dadoTransporteTransportXml.setTipoDadoSerializado(Long.valueOf(row.getString("eai_tipo_dado_serializado").replace(" L", "")));
        dadoTransporteTransportXml.setCnesDadoSerializado(row.getString("eai_cnes"));
        dadoTransporteTransportXml.setCodIbge(row.getString("eai_codigo_ibge_mun"));
        dadoTransporteTransportXml.setNumLote(eehCodigo);
        dadoTransporteTransportXml.setIneDadoSerializado(row.getString("nu_ine"));
        dadoTransporteTransportXml.setRemetente(remetente);
        dadoTransporteTransportXml.setOriginadora(originadora);
        dadoTransporteTransportXml.setVersao(array_versao);
        dadoTransporteTransportXml.setFichaAtendimentoIndividualMasterTransport(ficha_master_serializado);
        return dadoTransporteTransportXml;
    }

    public ResultSet getDadosOriginadoraRemetente() throws SQLException {
        sql = "SELECT * FROM esus_remente_originadora WHERE ero_status = 't'";
        pstmt = Conexao.CONN.prepareStatement(sql);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }
}

